/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.call;

import com.huawei.mobilePartner.business.call.common.CommonConfigCallInfo;
import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.data.comm.atfactory.ATFactory;
import com.huawei.mobilePartner.data.comm.interfaces.call.CallATResponse;
import com.huawei.mobilePartner.data.comm.interfaces.call.CallInfoBean;
import com.huawei.mobilePartner.gui.ui.call.CallContentPanel;
import com.huawei.mobilePartner.gui.ui.call.ICallEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;

public class CallUILogic
implements ICallEvent {
    private static CallUILogic instance = null;
    private CallContentPanel panel = null;
    public LogConfig log = Log.getLog(CommonConfigCallInfo.class);

    public static CallUILogic getInstance() {
        if (instance == null) {
            instance = new CallUILogic();
        }
        return instance;
    }

    private CallUILogic() {
    }

    public void registerPanel(JPanel panel) {
        if (panel instanceof CallContentPanel) {
            this.panel = (CallContentPanel)panel;
        }
    }

    public void onCallInNew(CallInfoBean callInfo) {
        try {
            this.panel.refreshATStatus(callInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCallStartAudio(CallInfoBean callInfo) {
        try {
            this.panel.refreshATStatus(callInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCallOutRing(CallInfoBean callInfo) {
        try {
            this.panel.refreshATStatus(callInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCallEmergency(CallInfoBean callInfo) {
        try {
            this.panel.refreshATStatus(callInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCallHold() {
    }

    public void onCallResume() {
    }

    public void onCallClosed(CallInfoBean callInfo) {
        try {
            this.panel.refreshATStatus(callInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callNew(String number) {
        CallATResponse response = ATFactory.getATFactory().getCallServiceImpl().makeACall(number);
        if (response.getIsSuccess()) {
            return;
        }
        long errorCode = response.getErrCode();
        this.log.info("callNew() is error. errorCode:" + errorCode);
        this.panel.setErrorResponse(response.getIsSuccess());
    }

    public void callAnswer() {
        ATFactory.getATFactory().getCallServiceImpl().acceptCall();
    }

    public void callClose(CallInfoBean callInfo) {
        CallATResponse response = ATFactory.getATFactory().getCallServiceImpl().hangUpCall("");
        if (response.getIsSuccess()) {
            return;
        }
        long l = response.getErrCode();
    }

    public void sendDTMF(int callId, String strDigit) {
        CallATResponse response = ATFactory.getATFactory().getCallServiceImpl().sendDTMF(callId, strDigit);
        if (response.getIsSuccess()) {
            return;
        }
        long errorCode = response.getErrCode();
        this.panel.setErrorResponse(response.getIsSuccess());
    }

    public String[] queryCallStatus() {
        String[] response = ATFactory.getATFactory().getCallServiceImpl().makeCLCC();
        return response;
    }

    public void onCallPanel(String number) {
        if (this.panel == null) {
            return;
        }
        int type = 2;
        this.panel.onCallPanel(type, number);
    }

    public void notifyCallPanel() {
        if (this.panel == null) {
            return;
        }
        this.panel.notifyCallPanel();
    }

    public boolean addCallInfo(HashMap map) {
        boolean addFlag = true;
        String xmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/callInfo/CallInfo.xml";
        try {
            XMLTool.setImportExport(true);
            XMLTool comm = new XMLTool(xmlpath, "root");
            String id = Tools.checkNull(map.get("id"));
            String name = Tools.checkNull(map.get("name"));
            String number = Tools.checkNull(map.get("number"));
            String startTime = Tools.checkNull(map.get("startTime"));
            String duration = Tools.checkNull(map.get("duration"));
            String state = Tools.checkNull(map.get("state"));
            String type = Tools.checkNull(map.get("type"));
            String[] strPropertiesName = CommonConfigCallInfo.CALL_INFO_NAME;
            String[] strPropertiesValue = new String[]{id, name, number, startTime, duration, state, type};
            String strNodeName = "root/local";
            addFlag = comm.createNodeMultiPropertiesValue(strNodeName, strPropertiesName, strPropertiesValue);
        }
        catch (Exception ex) {
            addFlag = false;
            ex.printStackTrace();
        }
        return addFlag;
    }

    public boolean deleteLog(String id) {
        boolean deleteFlag = true;
        String xmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/callInfo/CallInfo.xml";
        try {
            XMLTool.setImportExport(true);
            XMLTool comm = new XMLTool(xmlpath, "root");
            String strNodeName = "root/local[@id='" + id + "']";
            deleteFlag = comm.deleteNode(strNodeName);
        }
        catch (Exception ex) {
            deleteFlag = false;
            ex.printStackTrace();
        }
        return deleteFlag;
    }

    public boolean updateCallInfo(String logId, String state) {
        boolean updateFlag = false;
        String xmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/callInfo/CallInfo.xml";
        try {
            XMLTool.setImportExport(true);
            String[] strPropertiesName = new String[]{"state"};
            String[] strPropertiesValue = new String[]{state};
            XMLTool comm = new XMLTool(xmlpath, "root");
            String strNodeName = "root/local[@id='" + logId + "']";
            updateFlag = comm.updateNodeMultiPropertiesValue(strNodeName, strPropertiesName, strPropertiesValue);
        }
        catch (Exception ex) {
            updateFlag = false;
            ex.printStackTrace();
        }
        return updateFlag;
    }

    public List getCallInfoList() {
        List list = new ArrayList();
        String[] proName = new String[]{"id", "name", "number", "startTime", "duration", "state", "type"};
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(true);
            this.log.info("The path of delete file: " + ParameterConfigServer.userdata_dir + "userdata/callInfo/CallInfo.xml");
            comm = new XMLTool(String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/callInfo/CallInfo.xml");
            list = comm.quertyNodePropertiesValueByPath("root/local", proName);
        }
        catch (Exception ex) {
            this.log.error("read callInfo.xml fail : [" + ex.toString() + "]");
        }
        return list;
    }
}

