/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.call;

import com.huawei.mobilePartner.gui.ui.call.CallContentPanel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CallNumberTextField
extends JTextField {
    private int cols = 0;
    private int state = 0;
    private CallContentPanel callPanel = null;

    public CallNumberTextField(int cols) {
        super(cols);
        this.cols = cols;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setPanel(JPanel panel) {
        this.callPanel = (CallContentPanel)panel;
    }

    public void delete() {
        String str = this.getSelectedText();
        if (str == null || "".equals(str)) {
            int position = this.getCaretPosition();
            this.select(position - 1, position);
            this.replaceSelection("");
        } else {
            this.replaceSelection("");
        }
        this.callPanel.setTimeAccumulate(0);
    }

    protected Document createDefaultModel() {
        return new InputTextDocument();
    }

    private boolean limitInputString(int offs, char[] upper, int length) {
        String str = this.getText();
        int i = 0;
        while (i < upper.length) {
            char chTmp = upper[i];
            if (chTmp == '+') {
                if (offs + i != 0) {
                    return false;
                }
                if (str.indexOf("+") == 0) {
                    return false;
                }
            }
            if (String.valueOf(upper[i]).matches("[^+0-9#*WwPpTt]$")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class InputTextDocument
    extends PlainDocument {
        InputTextDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            CallNumberTextField.this.callPanel.setTimeAccumulate(0);
            int length = offs + str.length();
            char[] upper = str.toCharArray();
            if (CallNumberTextField.this.state == 0) {
                if (length > CallNumberTextField.this.cols) {
                    return;
                }
                if (!CallNumberTextField.this.limitInputString(offs, upper, length)) {
                    return;
                }
            } else {
                if (CallNumberTextField.this.state == 1) {
                    return;
                }
                if (CallNumberTextField.this.state == 2 && !CallNumberTextField.this.limitInputString(offs, upper, length)) {
                    return;
                }
            }
            super.insertString(offs, str, a);
        }
    }
}

