/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.call;

import com.huawei.mobilePartner.business.call.options.CallCueEvent;
import com.huawei.mobilePartner.business.call.options.CallCueOperation;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.call.CallContentPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CallMessagePromptDialog
extends JDialog {
    private LanguageBean lb = CustomizeInit.getLanguageBean();
    private JButton answerButton = null;
    private JButton refuseButton = null;
    private JLabel textLabel = null;
    private JLabel telLabel = null;
    private String telName = "";
    private LogConfig logInfo = Log.getLog(CallMessagePromptDialog.class);
    private JPanel mainPanel = new JPanel();
    private CallContentPanel callPanel = null;
    private boolean isShow = true;

    public CallMessagePromptDialog(JPanel panel, String telName) {
        CallCueOperation.getInstance().createCallCueXml();
        CallCueOperation callCueOper = CallCueOperation.getInstance();
        CallCueEvent callCue = callCueOper.listToCueEvent();
        if ("false".equals(callCue.getVisionCue())) {
            this.isShow = false;
            return;
        }
        this.isShow = true;
        this.telName = telName;
        this.callPanel = (CallContentPanel)panel;
        this.init();
        this.setUndecorated(true);
        this.setModal(false);
        this.setResizable(false);
        this.getRootPane().setBorder(BorderFactory.createLineBorder(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDialogBorderBlackColor())));
        this.getRootPane().setWindowDecorationStyle(0);
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getAppFrame_createConnManagePanel_2()));
        this.mainPanel.add((Component)this.textLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 40, 5, -10), 0, 0));
        this.mainPanel.add((Component)this.telLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 40, 5, -35), 0, 0));
        this.mainPanel.add((Component)this.answerButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 50, 20, 0), 0, 0));
        this.mainPanel.add((Component)this.refuseButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 20, 50), 0, 0));
        this.getContentPane().add(this.mainPanel);
    }

    public boolean getShow() {
        return this.isShow;
    }

    private void init() {
        this.textLabel = new JLabel();
        this.textLabel.setText(this.lb.getNew_Call_Prompt());
        this.textLabel.setFont(Tools.setFont());
        this.textLabel.setMaximumSize(new Dimension(120, 20));
        this.textLabel.setMinimumSize(new Dimension(120, 20));
        this.textLabel.setPreferredSize(new Dimension(120, 20));
        this.telLabel = new JLabel(this.telName, 0);
        this.telLabel.setFont(Tools.setFont());
        this.telLabel.setMaximumSize(new Dimension(100, 20));
        this.telLabel.setMinimumSize(new Dimension(100, 20));
        this.telLabel.setPreferredSize(new Dimension(100, 20));
        this.answerButton = new JButton();
        GetButtonBackground.setButtonBackground(this.answerButton);
        this.answerButton.setText(this.lb.getAnswer_Call_Button());
        this.answerButton.setFont(Tools.setFont());
        this.answerButton.setMaximumSize(new Dimension(80, 20));
        this.answerButton.setMinimumSize(new Dimension(80, 20));
        this.answerButton.setPreferredSize(new Dimension(80, 20));
        this.answerButton.setFocusable(true);
        this.refuseButton = new JButton();
        GetButtonBackground.setButtonBackground(this.refuseButton);
        this.refuseButton.setText(this.lb.getRefuse_Call_Button());
        this.refuseButton.setFont(Tools.setFont());
        this.refuseButton.setMaximumSize(new Dimension(80, 20));
        this.refuseButton.setMinimumSize(new Dimension(80, 20));
        this.refuseButton.setPreferredSize(new Dimension(80, 20));
        this.answerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CallMessagePromptDialog.this.callPanel.onCallPanel(0, null);
            }
        });
        this.answerButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CallMessagePromptDialog.this.callPanel.onCallPanel(0, null);
                }
            }
        });
        this.refuseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CallMessagePromptDialog.this.callPanel.onCallPanel(1, null);
            }
        });
        this.refuseButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CallMessagePromptDialog.this.callPanel.onCallPanel(1, null);
                }
            }
        });
    }

    public void setVisible(boolean isVisible) {
        Dimension area = Toolkit.getDefaultToolkit().getScreenSize();
        double dimX = area.getWidth();
        double dimY = area.getHeight();
        double shellX = dimX - 240.0;
        double shellY = dimY;
        try {
            CallPromptThread thread = new CallPromptThread(dimX, dimY, shellX, shellY);
            thread.start();
            this.setLocation((int)shellX, (int)shellY);
            this.setSize(240, 110);
            super.setVisible(isVisible);
        }
        catch (Exception e) {
            this.logInfo.error("CallMessageTipDilog's setVisible() is error");
        }
    }

    public void close() {
        this.lb = null;
        this.logInfo = null;
        this.answerButton = null;
        this.refuseButton = null;
        this.textLabel = null;
        this.telLabel = null;
        this.telName = null;
        this.mainPanel = null;
        this.dispose();
    }

    class CallPromptThread
    extends Thread {
        private LogConfig log = Log.getLog(CallPromptThread.class);
        private double dimX = this.dimX;
        private double dimY = 0.0;
        private double shellX = 0.0;
        private double shellY = 0.0;
        private boolean flag = true;

        public CallPromptThread(double dimx, double dimY, double shellX, double shellY) {
            this.dimY = dimY;
            this.shellX = shellX;
            this.shellY = shellY;
        }

        public void run() {
            while (this.flag) {
                this.shellY -= 10.0;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    CallMessagePromptDialog.this.close();
                    this.log.info("The call prompt is error" + e.toString());
                }
                if (this.shellY <= this.dimY - 140.0) {
                    this.flag = false;
                }
                CallMessagePromptDialog.this.setLocation((int)this.shellX, (int)this.shellY);
            }
        }
    }
}

