/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.call;

import com.huawei.mobilePartner.business.call.common.CommonConfigCallInfo;
import com.huawei.mobilePartner.business.call.options.CallCueEvent;
import com.huawei.mobilePartner.business.call.options.CallCueOperation;
import com.huawei.mobilePartner.business.telephoneBook.common.commoninterface.PhonebookObserver;
import com.huawei.mobilePartner.business.telephoneBook.common.commoninterfaceimpl.PhoneBookData;
import com.huawei.mobilePartner.business.telephoneBook.commserver.CommonMethodByTelBook;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.DateFormatUtil;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.atfactory.ATFactory;
import com.huawei.mobilePartner.data.comm.interfaces.call.CallInfoBean;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import com.huawei.mobilePartner.gui.ui.call.CallMessagePromptDialog;
import com.huawei.mobilePartner.gui.ui.call.CallNumberTextField;
import com.huawei.mobilePartner.gui.ui.call.CallUILogic;
import com.huawei.mobilePartner.gui.ui.call.ICallEvent;
import com.huawei.mobilePartner.gui.ui.telbookui.SelectPhoneNumber;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class CallContentPanel
extends JPanel
implements PhonebookObserver {
    private AppFrame frame = null;
    private JPanel topPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private JScrollPane scrollPane = null;
    private CallNumberTextField inputTextField = new CallNumberTextField(24);
    private JTable phoneCodeInfoTable = new JTable();
    private PhoneCodeModel model = new PhoneCodeModel();
    private JLabel micLabel = new JLabel();
    private JLabel volumeLabel = new JLabel();
    private JLabel plusVolumeLabel = new JLabel();
    private JLabel subVolumeLabel = new JLabel();
    private JSlider volumeSlider = null;
    private JButton zeroBtn = new JButton();
    private JButton oneBtn = new JButton();
    private JButton twoBtn = new JButton();
    private JButton threeBtn = new JButton();
    private JButton fourBtn = new JButton();
    private JButton fiveBtn = new JButton();
    private JButton sixBtn = new JButton();
    private JButton sevenBtn = new JButton();
    private JButton eightBtn = new JButton();
    private JButton nineBtn = new JButton();
    private JButton starBtn = new JButton();
    private JButton poundBtn = new JButton();
    private JButton callBtn = new JButton();
    private JButton hangupBtn = new JButton();
    private JButton phoneBookBtn = new JButton();
    private JButton deleteBtn = new JButton();
    private JButton plusBtn = new JButton();
    private JButton returnBtn = new JButton();
    private GridBagLayout bagLayout = new GridBagLayout();
    private LanguageBean lb = CustomizeInit.getLanguageBean();
    private XMLTool xmltool = new XMLTool();
    private String path = "";
    private static CustomizeBean cb = null;
    private int volumeMax = 0;
    private int volumeMin = 0;
    private int defaultVolumeValue = 0;
    private JButton[] btnGroup = new JButton[]{this.oneBtn, this.twoBtn, this.threeBtn, this.fourBtn, this.fiveBtn, this.sixBtn, this.sevenBtn, this.eightBtn, this.nineBtn, this.zeroBtn, this.starBtn, this.poundBtn, this.plusBtn, this.returnBtn, this.phoneBookBtn, this.deleteBtn};
    private String[] btnStr = new String[]{"oneBtn", "twoBtn", "threeBtn", "fourBtn", "fiveBtn", "sixBtn", "sevenBtn", "eightBtn", "nineBtn", "zeroBtn", "starBtn", "poundBtn", "plusBtn", "returnBtn", "phoneBookBtn", "deleteBtn"};
    private String[] btnImage = null;
    private LogConfig log = null;
    private ICallEvent eventInstance = null;
    private LabelMouseAdapter labelAdapter = null;
    private SliderChangeListener sliderChangeListener = null;
    private String[] columnName = new String[]{"name", "status", "duration", "number", "object"};
    private String strTimer = "";
    private double m_dwSeconds = 0.0;
    private Timer timer = new Timer();
    private TimerTask timerTask = null;
    private CallInfoBean infoBean = new CallInfoBean();
    private boolean timerFlag = true;
    private boolean flag = true;
    private int callType = -1;
    private int iVoice = -1;
    private CallMessagePromptDialog tipDialog = null;
    private boolean isSuccess = true;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem callItem = new JMenuItem(CustomizeInit.getLanguageBean().getCallInfo());
    private JMenuItem deleteItem = new JMenuItem(CustomizeInit.getLanguageBean().getCallLog_del());
    private JMenuItem clearItem = new JMenuItem(CustomizeInit.getLanguageBean().getCallLog_clr());
    private boolean isCloseFrame = true;
    private CommonMethodByTelBook commonMethodByTelBook = new CommonMethodByTelBook();
    private List capabilityContainer = new ArrayList();
    private boolean isScreenProtect = false;
    private int timeAccumulate = 0;
    private int talkingID = -1;
    private String[] callStatusInfo = null;
    private String keyVoiceFileName = null;
    private CallCueOperation callCueOper = null;
    private AudioClip callAudioClip = null;
    private AudioClip keyAudioClip = null;
    private boolean isDevice = true;

    public CallContentPanel(AppFrame frame) {
        try {
            this.frame = frame;
            this.eventInstance = CallUILogic.getInstance();
            cb = CustomizeInit.getCustomizeBean();
            this.log = Log.getLog(CallContentPanel.class);
            this.path = String.valueOf(XMLTool.getClassPath()) + "/config/images/CallUIPlugin/";
            this.path = TextUtil.replaceStr1(this.path, "\\/", "/");
            this.path = TextUtil.replaceStr1(this.path, "\\", "/");
            this.keyVoiceFileName = String.valueOf(this.path) + cb.getAudition_Sound_File();
            this.callCueOper = CallCueOperation.getInstance();
            this.btnImage = new String[]{cb.getImages_one_Call(), cb.getImages_two_Call(), cb.getImages_three_Call(), cb.getImages_four_Call(), cb.getImages_five_Call(), cb.getImages_six_Call(), cb.getImages_seven_Call(), cb.getImages_eight_Call(), cb.getImages_nine_Call(), cb.getImages_zero_Call(), cb.getImages_star_Call(), cb.getImages_pound_Call(), cb.getImages_plus_Call(), cb.getImages_return_Call(), cb.getImages_phonebook_Call(), cb.getImages_delete_Call()};
            this.timerTask = new TimerTask(){

                public void run() {
                    CallContentPanel.this.startOnTime();
                }
            };
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.eventInstance.registerPanel(this);
        PhoneBookData.getInstance().registerObserver(this);
        this.initTopPanel();
        this.initCenterPanel();
        this.initBottomPanel();
        this.setName("callManage");
        this.setBackground(ChangeColor.getColor(cb.getAppFrame_createConnManagePanel_2()));
        this.setLayout(this.bagLayout);
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.centerPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.bottomPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.startScreenProtect();
    }

    private void initTopPanel() {
        this.inputTextField.setMaximumSize(new Dimension(276, 25));
        this.inputTextField.setMinimumSize(new Dimension(276, 25));
        this.inputTextField.setPreferredSize(new Dimension(276, 25));
        this.inputTextField.setHorizontalAlignment(0);
        this.inputTextField.setFont(Tools.setBoldFont());
        this.inputTextField.setState(0);
        this.inputTextField.setName("inputTextField");
        this.inputTextField.addKeyListener(new KeyTextFieldListener());
        this.inputTextField.setBorder(new LineBorder(ChangeColor.getColor(cb.getDefault_border()), 1, true));
        this.inputTextField.setPanel(this);
        this.phoneCodeInfoTable.getSelectionModel().addListSelectionListener(new SelectedListListener());
        this.phoneCodeInfoTable.addMouseListener(new TableMouseAdapter());
        this.phoneCodeInfoTable.setMaximumSize(new Dimension(276, 60));
        this.phoneCodeInfoTable.setMinimumSize(new Dimension(276, 60));
        this.phoneCodeInfoTable.setPreferredScrollableViewportSize(new Dimension(276, 60));
        this.phoneCodeInfoTable.setSelectionMode(0);
        this.phoneCodeInfoTable.setModel(this.model);
        this.model.setColumnIdentifiers(this.columnName);
        this.phoneCodeInfoTable.setShowGrid(false);
        this.phoneCodeInfoTable.getTableHeader().setPreferredSize(new Dimension(20, 0));
        String phoneColume = this.columnName[0];
        this.phoneCodeInfoTable.getColumn(phoneColume).setMaxWidth(105);
        this.phoneCodeInfoTable.getColumn(phoneColume).setMinWidth(105);
        this.phoneCodeInfoTable.getColumn(phoneColume).setPreferredWidth(105);
        String statusColume = this.columnName[1];
        this.phoneCodeInfoTable.getColumn(statusColume).setMaxWidth(93);
        this.phoneCodeInfoTable.getColumn(statusColume).setMinWidth(93);
        this.phoneCodeInfoTable.getColumn(statusColume).setPreferredWidth(93);
        this.phoneCodeInfoTable.setAutoResizeMode(1);
        String lastSecondColume = this.columnName[this.columnName.length - 2];
        this.phoneCodeInfoTable.getColumn(lastSecondColume).setMaxWidth(0);
        this.phoneCodeInfoTable.getColumn(lastSecondColume).setMinWidth(0);
        this.phoneCodeInfoTable.getColumn(lastSecondColume).setPreferredWidth(0);
        String lastColume = this.columnName[this.columnName.length - 1];
        this.phoneCodeInfoTable.getColumn(lastColume).setMaxWidth(0);
        this.phoneCodeInfoTable.getColumn(lastColume).setMinWidth(0);
        this.phoneCodeInfoTable.getColumn(lastColume).setPreferredWidth(0);
        this.callItem.setFont(Tools.setFont());
        this.callItem.setActionCommand("callItem");
        this.callItem.addActionListener(new PopupMenuItemListener());
        this.deleteItem.setFont(Tools.setFont());
        this.deleteItem.setActionCommand("deleteItem");
        this.deleteItem.addActionListener(new PopupMenuItemListener());
        this.clearItem.setFont(Tools.setFont());
        this.clearItem.setActionCommand("clearItem");
        this.clearItem.addActionListener(new PopupMenuItemListener());
        this.popup.add(this.callItem);
        this.popup.addSeparator();
        this.popup.add(this.deleteItem);
        this.popup.add(this.clearItem);
        this.phoneCodeInfoTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CallContentPanel.this.showPopupMenu(e);
            }
        });
        this.scrollPane = new JScrollPane(this.phoneCodeInfoTable);
        this.scrollPane.setMaximumSize(new Dimension(276, 70));
        this.scrollPane.setMinimumSize(new Dimension(276, 70));
        this.scrollPane.setPreferredSize(new Dimension(276, 70));
        this.scrollPane.getViewport().setBackground(this.inputTextField.getBackground());
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar hBar = this.scrollPane.getHorizontalScrollBar();
            JScrollBar vBar = this.scrollPane.getVerticalScrollBar();
            hBar.setUI(new VScrollBarUI());
            vBar.setUI(new HScrollBarUI());
        }
        this.scrollPane.setBorder(new LineBorder(ChangeColor.getColor(cb.getDefault_border()), 1, true));
        this.topPanel.setMaximumSize(new Dimension(276, 95));
        this.topPanel.setMinimumSize(new Dimension(276, 95));
        this.topPanel.setPreferredSize(new Dimension(276, 95));
        this.topPanel.setBackground(ChangeColor.getColor(cb.getAppFrame_createButtonPanel_1()));
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.add((Component)this.inputTextField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initCenterPanel() {
        this.labelAdapter = new LabelMouseAdapter();
        this.sliderChangeListener = new SliderChangeListener();
        this.micLabel.setMaximumSize(new Dimension(20, 20));
        this.micLabel.setMinimumSize(new Dimension(20, 20));
        this.micLabel.setPreferredSize(new Dimension(20, 20));
        this.micLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_Mike_Call()));
        this.micLabel.setOpaque(true);
        this.micLabel.setName("micLabelEnable");
        this.micLabel.setOpaque(false);
        this.volumeLabel.setMaximumSize(new Dimension(20, 20));
        this.volumeLabel.setMinimumSize(new Dimension(20, 20));
        this.volumeLabel.setPreferredSize(new Dimension(20, 20));
        this.volumeLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_volume_Call()));
        this.volumeLabel.setOpaque(false);
        this.subVolumeLabel.setMaximumSize(new Dimension(20, 20));
        this.subVolumeLabel.setMinimumSize(new Dimension(20, 20));
        this.subVolumeLabel.setPreferredSize(new Dimension(20, 20));
        this.subVolumeLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_subVolume_Call()));
        this.subVolumeLabel.setName("subVolumeLabel");
        this.volumeSlider = new JSlider(this.volumeMin, this.volumeMax, this.defaultVolumeValue);
        this.volumeSlider.setMaximumSize(new Dimension(100, 20));
        this.volumeSlider.setMinimumSize(new Dimension(100, 20));
        this.volumeSlider.setPreferredSize(new Dimension(100, 20));
        this.volumeSlider.setBackground(ChangeColor.getColor(cb.getAppFrame_createButtonPanel_1()));
        this.plusVolumeLabel.setMaximumSize(new Dimension(20, 20));
        this.plusVolumeLabel.setMinimumSize(new Dimension(20, 20));
        this.plusVolumeLabel.setPreferredSize(new Dimension(20, 20));
        this.plusVolumeLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_plusVolume_Call()));
        this.plusVolumeLabel.setName("plusVolumeLabel");
        this.centerPanel.setMaximumSize(new Dimension(200, 30));
        this.centerPanel.setMinimumSize(new Dimension(200, 30));
        this.centerPanel.setPreferredSize(new Dimension(200, 30));
        this.centerPanel.setBackground(ChangeColor.getColor(cb.getAppFrame_createButtonPanel_1()));
        this.centerPanel.setLayout(new GridBagLayout());
        this.centerPanel.add((Component)this.micLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, -10, 0, 35), 0, 0));
        this.centerPanel.add((Component)this.volumeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 35, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.subVolumeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.volumeSlider, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.plusVolumeLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, -10), 0, 0));
    }

    private void initBottomPanel() {
        int i = 0;
        while (i < this.btnGroup.length) {
            this.btnGroup[i].setMaximumSize(new Dimension(52, 24));
            this.btnGroup[i].setMinimumSize(new Dimension(52, 24));
            this.btnGroup[i].setPreferredSize(new Dimension(52, 24));
            this.btnGroup[i].setBackground(ChangeColor.getColor(cb.getAppFrame_createButtonPanel_1()));
            this.btnGroup[i].setVerticalAlignment(0);
            this.btnGroup[i].setIcon(new ImageIcon(String.valueOf(this.path) + this.btnImage[i]));
            this.btnGroup[i].addActionListener(new ButtonListener());
            this.btnGroup[i].addMouseListener(new ButtonMouseListener());
            this.btnGroup[i].setActionCommand(this.btnStr[i]);
            this.btnGroup[i].setBorderPainted(true);
            ++i;
        }
        this.callBtn.setMaximumSize(new Dimension(52, 52));
        this.callBtn.setMinimumSize(new Dimension(52, 52));
        this.callBtn.setPreferredSize(new Dimension(52, 52));
        this.callBtn.setActionCommand("callBtn");
        this.callBtn.setName("callBtn");
        this.callBtn.setBackground(ChangeColor.getColor(cb.getAppFrame_createButtonPanel_1()));
        this.callBtn.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_callon_Call()));
        this.callBtn.setRolloverEnabled(true);
        this.callBtn.setOpaque(true);
        this.callBtn.addActionListener(new ButtonListener());
        this.hangupBtn.setMaximumSize(new Dimension(52, 52));
        this.hangupBtn.setMinimumSize(new Dimension(52, 52));
        this.hangupBtn.setPreferredSize(new Dimension(52, 52));
        this.hangupBtn.setActionCommand("hangupBtn");
        this.hangupBtn.setName("hangupBtn");
        this.hangupBtn.setBackground(ChangeColor.getColor(cb.getAppFrame_createButtonPanel_1()));
        this.hangupBtn.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_hangup_Call()));
        this.hangupBtn.addActionListener(new ButtonListener());
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.setBackground(ChangeColor.getColor(cb.getAppFrame_createConnManagePanel_2()));
        this.bottomPanel.add((Component)this.oneBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.twoBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.threeBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.callBtn, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 10, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.hangupBtn, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 10, 2, new Insets(0, 2, 2, 0), 0, 0));
        this.bottomPanel.add((Component)this.fourBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.fiveBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.sixBtn, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.sevenBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.eightBtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.nineBtn, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.phoneBookBtn, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.bottomPanel.add((Component)this.deleteBtn, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.bottomPanel.add((Component)this.starBtn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 2), 0, 0));
        this.bottomPanel.add((Component)this.zeroBtn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 0, 2), 0, 0));
        this.bottomPanel.add((Component)this.poundBtn, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 0, 2), 0, 0));
        this.bottomPanel.add((Component)this.plusBtn, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 0, 2), 0, 0));
        this.bottomPanel.add((Component)this.returnBtn, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 0, 0), 0, 0));
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.getModifiers() == 4) {
            int row = this.phoneCodeInfoTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            String value = String.valueOf(this.phoneCodeInfoTable.getValueAt(row, 1));
            if (this.lb.getCall_Status_Cend().equalsIgnoreCase(value) || this.lb.getCall_Control_Cause().equalsIgnoreCase(value)) {
                if (this.isClosedStatus()) {
                    if (this.isDevice) {
                        this.callItem.setEnabled(true);
                    } else {
                        this.callItem.setEnabled(false);
                    }
                    this.deleteItem.setEnabled(true);
                    this.clearItem.setEnabled(true);
                } else {
                    this.callItem.setEnabled(false);
                    this.deleteItem.setEnabled(true);
                    this.clearItem.setEnabled(false);
                }
            } else {
                this.callItem.setEnabled(false);
                this.deleteItem.setEnabled(false);
                this.clearItem.setEnabled(false);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setCompontFocus(Component component) {
        int i = 0;
        while (i < this.topPanel.getComponentCount()) {
            this.topPanel.getComponent(i).setFocusable(false);
            ++i;
        }
        i = 0;
        while (i < this.centerPanel.getComponentCount()) {
            this.centerPanel.getComponent(i).setFocusable(false);
            ++i;
        }
        i = 0;
        while (i < this.bottomPanel.getComponentCount()) {
            this.bottomPanel.getComponent(i).setFocusable(false);
            ++i;
        }
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X") || System.getProperty("os.version").indexOf("10.5") <= -1) {
            if (component.getName().equals("inputTextField")) {
                component.setFocusable(true);
            }
            this.inputTextField.requestFocusInWindow();
        }
    }

    private void setLookAndFeels(Component c) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScreenProtect() {
        Timer timerScreen = new Timer();
        TimerTask screenTask = new TimerTask(){

            public void run() {
                CallContentPanel callContentPanel = CallContentPanel.this;
                callContentPanel.timeAccumulate = callContentPanel.timeAccumulate + 1;
                if (CallContentPanel.this.timeAccumulate >= 40) {
                    CallContentPanel.this.inputTextField.setVisible(false);
                    CallContentPanel.this.scrollPane.setVisible(false);
                    CallContentPanel.this.isScreenProtect = true;
                } else {
                    CallContentPanel.this.inputTextField.setVisible(true);
                    CallContentPanel.this.scrollPane.setVisible(true);
                    CallContentPanel.this.isScreenProtect = false;
                }
                CallContentPanel.this.topPanel.revalidate();
                if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X") || System.getProperty("os.version").indexOf("10.5") <= -1) {
                    CallContentPanel.this.inputTextField.requestFocusInWindow();
                }
            }
        };
        timerScreen.schedule(screenTask, 0L, 1000L);
    }

    public void setTimeAccumulate(int timeAccumulate) {
        this.timeAccumulate = timeAccumulate;
    }

    public void setComponentState(Object object) {
        if (object == null) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                CallInfoBean callInfo = (CallInfoBean)this.model.getValueAt(i, this.model.getColumnCount() - 1);
                String strDuration = String.valueOf(this.model.getValueAt(i, 2));
                if (callInfo != null) {
                    try {
                        ArrayList list = ATFactory.getATFactory().getCallServiceImpl().getListInfo();
                        int k = 0;
                        while (k < list.size()) {
                            String strCallID = ((CallInfoBean)list.get(k)).getStrCallId().trim();
                            if (callInfo.getStrCallId().trim().equals(strCallID)) {
                                callInfo = (CallInfoBean)list.get(k);
                            }
                            ++k;
                        }
                        callInfo.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CEND.ordinal());
                        callInfo.setStrEndReason("-1");
                        this.refreshATStatus(callInfo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (-1L == callInfo.getICallLogID()) {
                            callInfo.setICallLogID(Tools.getTransactionID());
                        }
                        if ("".equals(callInfo.getStrDuration())) {
                            callInfo.setStrDuration(strDuration);
                        }
                        if ("".equals(callInfo.getStrStartTime())) {
                            callInfo.setStrStartTime(DateFormatUtil.getCurrentDateByFormat("dd/MM/yyyy HH:mm:ss"));
                        }
                        ATFactory.getATFactory().getCallServiceImpl().writeCallLog(callInfo);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                ++i;
            }
            ATFactory.getATFactory().getCallServiceImpl().removeListInfo();
            this.micLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_Mike_Call()));
            this.micLabel.removeMouseListener(this.labelAdapter);
            this.plusVolumeLabel.removeMouseListener(this.labelAdapter);
            this.subVolumeLabel.removeMouseListener(this.labelAdapter);
            this.volumeSlider.removeChangeListener(this.sliderChangeListener);
            this.volumeSlider.setValue(0);
            this.volumeSlider.setValueIsAdjusting(false);
            this.callBtn.setEnabled(false);
            this.hangupBtn.setEnabled(false);
            this.returnBtn.setEnabled(false);
            this.inputTextField.setState(0);
            this.callItem.setEnabled(false);
            this.isDevice = false;
        } else {
            this.callBtn.setEnabled(true);
            this.hangupBtn.setEnabled(false);
            this.returnBtn.setEnabled(false);
            this.isDevice = true;
            this.inputTextField.setState(0);
            this.setMicVolumeStatus();
            try {
                this.executeCallStatus();
            }
            catch (Exception e) {
                this.log.info("executeCallStatus is Exception" + e.getMessage());
                e.printStackTrace();
            }
        }
        this.revalidate();
    }

    private void executeCallStatus() throws Exception {
        this.callStatusInfo = this.eventInstance.queryCallStatus();
        if (this.callStatusInfo == null || "".equals(this.callStatusInfo)) {
            return;
        }
        int i = 0;
        while (i < this.callStatusInfo.length) {
            this.log.info("AT+CLCC:" + this.callStatusInfo[i] + "...end");
            if (this.callStatusInfo[i] != null && !"".equals(this.callStatusInfo[i])) {
                String[] info = this.callStatusInfo[i].split(",");
                CallInfoBean callInfo = new CallInfoBean();
                String strCallId = info[0].toString().trim();
                callInfo.setStrCallId(strCallId);
                int direction = Integer.parseInt(info[1].toString().trim());
                callInfo.setICallDirection(direction);
                int callState = Integer.parseInt(info[2].toString().trim());
                if (callState == 0 || 1 == callState) {
                    callInfo.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONN.ordinal());
                    if (direction == 0) {
                        callInfo.setICallLogType(2);
                    } else if (1 == direction) {
                        callInfo.setICallLogType(0);
                    } else {
                        callInfo.setICallLogType(-1);
                    }
                } else if (4 == callState) {
                    callInfo.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_INCOMING.ordinal());
                    callInfo.setICallLogType(1);
                } else if (3 == callState || 2 == callState) {
                    callInfo.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONF.ordinal());
                    callInfo.setICallLogType(2);
                }
                int callMode = Integer.parseInt(info[3].toString().trim());
                if (callMode == 0) {
                    int iMpty = Integer.parseInt(info[4].toString().trim());
                    String number = info[5].toString().trim().replaceFirst("\"", "");
                    if ((number = number.replaceFirst("\"", "")) != null) {
                        callInfo.setStrPhoneNum(number);
                        int callType = Integer.parseInt(info[6].toString().trim());
                        callInfo.setICallType(callType);
                        String startTime = DateFormatUtil.getCurrentDateByFormat("dd/MM/yyyy HH:mm:ss");
                        callInfo.setStrStartTime(startTime);
                        long callLogID = Tools.getTransactionID();
                        callInfo.setICallLogID(callLogID);
                        ATFactory.getATFactory().getCallServiceImpl().addListInfo(callInfo);
                        if (callState == 0 || 1 == callState) {
                            this.addRow(callInfo);
                        }
                        this.inputTextField.setText(number);
                        this.refreshATStatus(callInfo);
                        AppFrame.frame.clickCallButton();
                        AppFrame.frame.callManage_actionPerformed();
                        this.isCloseFrame = false;
                    }
                }
            }
            ++i;
        }
    }

    private void setMicVolumeStatus() {
        String response = null;
        try {
            response = ATFactory.getATFactory().getCallServiceImpl().makeCLVL("AT+CLVL=?");
            String[] value = response.trim().split("-");
            this.volumeMin = Integer.parseInt(value[0]);
            this.volumeMax = Integer.parseInt(value[1]);
            response = ATFactory.getATFactory().getCallServiceImpl().makeCLVL("AT+CLVL?");
            this.defaultVolumeValue = Integer.parseInt(response.trim());
            response = ATFactory.getATFactory().getCallServiceImpl().makeCMUT("AT+CMUT?");
            this.iVoice = Integer.parseInt(response.trim());
        }
        catch (Exception e) {
            this.log.info("CallContentPanel->setMicVolumeStatus:" + e.getMessage());
        }
    }

    public void refreshMicVolumeStatus(int iStatus) {
        if (iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONF.ordinal() || iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONN.ordinal()) {
            if (this.micLabel.getMouseListeners().length <= 0) {
                this.micLabel.addMouseListener(this.labelAdapter);
            }
            if (this.plusVolumeLabel.getMouseListeners().length <= 0) {
                this.plusVolumeLabel.addMouseListener(this.labelAdapter);
            }
            if (this.subVolumeLabel.getMouseListeners().length <= 0) {
                this.subVolumeLabel.addMouseListener(this.labelAdapter);
            }
            this.volumeSlider.addChangeListener(this.sliderChangeListener);
            this.volumeSlider.setMaximum(this.volumeMax);
            this.volumeSlider.setMinimum(this.volumeMin);
            this.volumeSlider.setValue(this.defaultVolumeValue);
            if (this.iVoice == 0) {
                this.micLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_Mike_Call()));
            } else {
                this.micLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_Mike_Lose_Call()));
            }
        } else {
            this.micLabel.removeMouseListener(this.labelAdapter);
            this.plusVolumeLabel.removeMouseListener(this.labelAdapter);
            this.subVolumeLabel.removeMouseListener(this.labelAdapter);
            this.volumeSlider.removeChangeListener(this.sliderChangeListener);
            this.volumeSlider.setMaximum(0);
            this.volumeSlider.setMinimum(0);
            this.volumeSlider.setValue(0);
            this.micLabel.setIcon(new ImageIcon(String.valueOf(this.path) + cb.getImages_Mike_Call()));
        }
    }

    public boolean getCloseFrame() {
        return this.isCloseFrame;
    }

    public void refreshATStatus(CallInfoBean callInfo) throws Exception {
        Vector<Object> data = new Vector<Object>();
        int iStatus = callInfo.getICallState();
        if (iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_INCOMING.ordinal()) {
            String strNumber = callInfo.getStrPhoneNum();
            if (strNumber == null || "".equals(strNumber.trim())) {
                strNumber = this.lb.getCall_No_Number();
            } else {
                strNumber = strNumber.trim();
                strNumber = strNumber.replaceFirst("\"", "");
                strNumber = strNumber.replaceFirst("\"", "");
                this.inputTextField.setText("");
                this.inputTextField.setText(strNumber);
                callInfo.setStrPhoneNum(strNumber);
            }
            String time = "00:00:00";
            String name = "";
            if (!strNumber.equals(this.lb.getCall_No_Number())) {
                name = this.commonMethodByTelBook.getContactName(strNumber);
            }
            if (name == null || "".equals(name.trim())) {
                name = strNumber;
            }
            data.add(0, name);
            data.add(1, this.lb.getCall_Status_Incoming());
            data.add(2, time);
            data.add(3, strNumber);
            data.add(4, callInfo);
            this.setCapability(data);
            this.model.insertRow(0, data);
            this.phoneCodeInfoTable.setRowSelectionInterval(0, 0);
            this.callBtn.setEnabled(true);
            this.hangupBtn.setEnabled(true);
            this.isCloseFrame = false;
            this.tipDialog = new CallMessagePromptDialog(this, name);
            if (this.tipDialog.getShow()) {
                this.tipDialog.setAlwaysOnTop(true);
                this.tipDialog.setVisible(true);
            }
            this.playAuditionSound(null, false);
        } else if (iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_ORIG.ordinal()) {
            String callID = callInfo.getStrCallId().trim();
            this.callType = callInfo.getICallType();
            int row = this.phoneCodeInfoTable.getRowCount();
            int i = 0;
            while (i < row) {
                CallInfoBean info = (CallInfoBean)this.model.getValueAt(i, this.phoneCodeInfoTable.getColumnCount() - 1);
                if (info != null && !"".equals(info)) {
                    String value = String.valueOf(this.model.getValueAt(i, 1));
                    if (this.lb.getCall_Status_Calling().equals(value)) {
                        info.setStrCallId(callID);
                        info.setICallType(this.callType);
                        if (9 == this.callType) {
                            this.model.setValueAt(this.lb.getCall_Status_Emergency_Orig(), i, 1);
                        }
                        this.model.setValueAt(info, i, this.columnName.length - 1);
                    }
                }
                ++i;
            }
            this.isCloseFrame = false;
        } else if (iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONF.ordinal()) {
            String callID = callInfo.getStrCallId().trim();
            int row = this.phoneCodeInfoTable.getRowCount();
            int i = 0;
            while (i < row) {
                CallInfoBean info = (CallInfoBean)this.model.getValueAt(i, this.phoneCodeInfoTable.getColumnCount() - 1);
                if (info != null && !"".equals(info) && callInfo.getStrCallId().trim().equals(info.getStrCallId().trim())) {
                    info.setStrCallId(callInfo.getStrCallId().trim());
                    if (9 == this.callType) {
                        this.model.setValueAt(this.lb.getCall_Status_Emergency_Conf(), i, 1);
                    } else {
                        this.model.setValueAt(this.lb.getCall_Status_Conf(), i, 1);
                    }
                    this.model.setValueAt(info, i, this.columnName.length - 1);
                }
                ++i;
            }
            this.callType = -1;
            this.isCloseFrame = false;
        } else if (iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONN.ordinal()) {
            int callID;
            this.talkingID = callID = Integer.parseInt(callInfo.getStrCallId().trim());
            int row = this.phoneCodeInfoTable.getRowCount();
            int i = 0;
            while (i < row) {
                int tableCallIDValue;
                CallInfoBean info = (CallInfoBean)this.model.getValueAt(i, this.phoneCodeInfoTable.getColumnCount() - 1);
                if (info != null && !"".equals(info) && (tableCallIDValue = Integer.parseInt(info.getStrCallId().trim())) == callID) {
                    this.callBtn.setEnabled(false);
                    this.hangupBtn.setEnabled(true);
                    if (this.flag) {
                        this.flag = false;
                        this.timer.schedule(this.timerTask, 0L, 1000L);
                    }
                    this.m_dwSeconds = 0.0;
                    this.timerFlag = true;
                    this.model.setValueAt(this.lb.getCall_Status_Connection(), i, 1);
                    this.model.setValueAt(callInfo, i, this.columnName.length - 1);
                }
                ++i;
            }
            this.inputTextField.setState(2);
            this.isCloseFrame = false;
            this.inputTextField.getText();
            this.callOnPhone();
        } else if (iStatus == CommonConfigCallInfo.CALL_STATE.CALL_STATE_CEND.ordinal()) {
            int callID = Integer.parseInt(callInfo.getStrCallId().trim());
            int endReason = Integer.parseInt(callInfo.getStrEndReason());
            int callControlCause = callInfo.getICallControlCause();
            int row = this.phoneCodeInfoTable.getRowCount();
            int i = 0;
            while (i < row) {
                int tableCallIDValue;
                CallInfoBean info = (CallInfoBean)this.model.getValueAt(i, this.columnName.length - 1);
                if (!(info == null || "".equals(info) || (tableCallIDValue = Integer.parseInt(info.getStrCallId().trim())) != callID && tableCallIDValue != -1)) {
                    if (this.timer == null) {
                        return;
                    }
                    this.timerFlag = false;
                    if (28 == callControlCause) {
                        this.model.setValueAt(this.lb.getCall_Control_Cause(), 0, 1);
                    } else {
                        this.model.setValueAt(this.lb.getCall_Status_Cend(), 0, 1);
                    }
                    callInfo = null;
                    this.model.setValueAt(callInfo, 0, this.columnName.length - 1);
                }
                ++i;
            }
            this.isCloseFrame = true;
            this.callBtn.setEnabled(true);
            this.hangupBtn.setEnabled(false);
            this.inputTextField.setState(0);
            this.inputTextField.selectAll();
            if (this.tipDialog != null) {
                this.tipDialog.close();
                this.tipDialog = null;
            }
            this.stopPlay();
        }
        this.refreshMicVolumeStatus(iStatus);
    }

    private void startOnTime() {
        if (!this.timerFlag) {
            return;
        }
        this.m_dwSeconds += 1.0;
        int iSeconds = 0;
        int iMinutes = 0;
        int iHours = 0;
        iSeconds = (int)(this.m_dwSeconds % 60.0);
        iMinutes = (int)(this.m_dwSeconds / 60.0 % 60.0);
        iHours = (int)(this.m_dwSeconds / 3600.0);
        String strSeconds = Integer.toString(iSeconds);
        String strMinutes = Integer.toString(iMinutes);
        String strHours = Integer.toString(iHours);
        if (strSeconds.length() < 2) {
            strSeconds = "0" + strSeconds;
        }
        if (strMinutes.length() < 2) {
            strMinutes = "0" + strMinutes;
        }
        if (strHours.length() < 2) {
            strHours = "0" + strHours;
        }
        this.strTimer = String.valueOf(strHours) + ":" + strMinutes + ":" + strSeconds;
        int row = this.phoneCodeInfoTable.getRowCount();
        int i = 0;
        while (i < row) {
            CallInfoBean callInfo = (CallInfoBean)this.model.getValueAt(i, this.columnName.length - 1);
            if (callInfo != null) {
                String value = String.valueOf(this.model.getValueAt(i, 1));
                if (this.lb.getCall_Status_Connection().equals(value)) {
                    this.model.setValueAt(this.strTimer, i, 2);
                    break;
                }
            }
            ++i;
        }
        this.phoneCodeInfoTable.revalidate();
    }

    private void playAuditionSound(String fileName, boolean isKeySound) {
        try {
            if (isKeySound) {
                if (fileName != null) {
                    this.keyAudioClip = Applet.newAudioClip(new URL("file:///" + fileName));
                    this.keyAudioClip.play();
                }
            } else {
                CallCueOperation.getInstance().createCallCueXml();
                CallCueEvent callCue = this.callCueOper.listToCueEvent();
                String earCue = callCue.getEarCue();
                if ("false".equals(earCue.trim())) {
                    return;
                }
                fileName = callCue.getEarCuePath();
                this.callAudioClip = Applet.newAudioClip(new URL("file:///" + fileName));
                this.callAudioClip.loop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.info("playAuditionSound is wrong :" + e.getMessage());
        }
    }

    private void stopPlay() {
        try {
            if (this.callAudioClip != null) {
                this.callAudioClip.stop();
                this.callAudioClip = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void callButtonActionPerformed() {
        if (this.tipDialog != null) {
            this.tipDialog.close();
            this.tipDialog = null;
        }
        if (this.eventInstance == null) {
            return;
        }
        boolean isAnswer = this.isCallAnswer();
        if (!isAnswer) {
            Vector<Object> data = new Vector<Object>();
            String time = "00:00:00";
            String phoneNum = this.inputTextField.getText().trim();
            if (phoneNum == null || "".equals(phoneNum)) {
                return;
            }
            CallInfoBean callInfo = new CallInfoBean();
            callInfo.setStrPhoneNum(phoneNum);
            String name = this.commonMethodByTelBook.getContactName(phoneNum);
            if (name == null || "".equals(name)) {
                name = phoneNum;
            }
            data.add(0, name);
            data.add(1, this.lb.getCall_Status_Calling());
            data.add(2, time);
            data.add(3, phoneNum);
            data.add(4, callInfo);
            this.setCapability(data);
            this.model.insertRow(0, data);
            this.phoneCodeInfoTable.setRowSelectionInterval(0, 0);
            this.phoneCodeInfoTable.revalidate();
            this.eventInstance.callNew(phoneNum);
            this.callBtn.setEnabled(false);
            this.hangupBtn.setEnabled(true);
            this.inputTextField.setState(1);
            this.isCloseFrame = false;
            if (!this.isSuccess) {
                this.responseCallError();
                this.isCloseFrame = true;
            }
        } else {
            this.eventInstance.callAnswer();
            this.callBtn.setEnabled(false);
            this.hangupBtn.setEnabled(true);
            this.inputTextField.setState(1);
            this.isCloseFrame = false;
            this.stopPlay();
        }
    }

    public void setErrorResponse(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public void responseCallError() {
        Thread thre = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int row = CallContentPanel.this.phoneCodeInfoTable.getSelectedRow();
                CallContentPanel.this.model.setValueAt(CallContentPanel.this.lb.getCall_Status_Cend(), row, 1);
                CallContentPanel.this.model.setValueAt(null, row, CallContentPanel.this.columnName.length - 1);
                CallContentPanel.this.phoneCodeInfoTable.setRowSelectionInterval(row, row);
                CallContentPanel.this.callBtn.setEnabled(true);
                CallContentPanel.this.hangupBtn.setEnabled(false);
                CallContentPanel.this.inputTextField.setState(0);
            }
        });
        thre.start();
    }

    private void hangupButtonActionPerformed() {
        if (this.tipDialog != null) {
            this.tipDialog.close();
            this.tipDialog = null;
        }
        if (this.eventInstance == null) {
            return;
        }
        int row = this.phoneCodeInfoTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        CallInfoBean callInfoBean = (CallInfoBean)this.model.getValueAt(row, this.columnName.length - 1);
        this.eventInstance.callClose(callInfoBean);
        this.refreshMicVolumeStatus(-1);
    }

    private void callOnPhone() {
        AppFrame.frame.clickCallButton();
        AppFrame.frame.callManage_actionPerformed();
        this.callBtn.setEnabled(false);
        this.hangupBtn.setEnabled(true);
        if (this.tipDialog != null) {
            this.tipDialog.close();
            this.tipDialog = null;
        }
        this.stopPlay();
    }

    private boolean isCallAnswer() {
        boolean isAnswer = false;
        ArrayList list = ATFactory.getATFactory().getCallServiceImpl().getListInfo();
        isAnswer = list.size() != 0;
        return isAnswer;
    }

    private void setCapability(Vector element) {
        try {
            int size = this.capabilityContainer.size();
            this.capabilityContainer.add(size, element);
            if (size >= 20) {
                this.capabilityContainer.remove(0);
                this.model.removeRow(size - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectEvent() {
        this.phoneCodeInfoTable.setFocusable(false);
        int row = this.phoneCodeInfoTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String selectPhoneNum = (String)this.model.getValueAt(row, this.columnName.length - 2);
        if (selectPhoneNum == null || "".equals(selectPhoneNum)) {
            return;
        }
        if (this.lb.getCall_No_Number().equals(selectPhoneNum)) {
            this.inputTextField.setText("");
        } else {
            this.inputTextField.setText(selectPhoneNum);
        }
        String selectStatus = (String)this.model.getValueAt(row, 1);
        boolean isClosed = this.isClosedStatus();
        if (this.lb.getCall_Status_Cend().equals(selectStatus) || this.lb.getCall_Control_Cause().equals(selectStatus)) {
            if (isClosed) {
                if (this.isDevice) {
                    this.callBtn.setEnabled(true);
                } else {
                    this.callBtn.setEnabled(false);
                }
                this.hangupBtn.setEnabled(false);
            } else {
                this.callBtn.setEnabled(false);
                this.hangupBtn.setEnabled(false);
            }
            this.inputTextField.setState(0);
        } else if (this.lb.getCall_Status_Incoming().equals(selectStatus)) {
            this.callBtn.setEnabled(false);
            this.hangupBtn.setEnabled(true);
            this.inputTextField.setState(1);
        } else if (this.lb.getCall_Status_Connection().equals(selectStatus)) {
            this.callBtn.setEnabled(false);
            this.hangupBtn.setEnabled(true);
            this.inputTextField.setState(2);
        } else {
            this.callBtn.setEnabled(false);
            this.hangupBtn.setEnabled(true);
        }
    }

    private boolean isClosedStatus() {
        boolean isClosed = true;
        int rowCount = this.phoneCodeInfoTable.getRowCount();
        int i = 0;
        while (i < rowCount) {
            if (!this.lb.getCall_Status_Cend().equals((String)this.model.getValueAt(i, 1)) && !this.lb.getCall_Control_Cause().equals((String)this.model.getValueAt(i, 1))) {
                isClosed = false;
                break;
            }
            ++i;
        }
        return isClosed;
    }

    public boolean isTalkingStatus() {
        boolean isTalking = false;
        int rowCount = this.phoneCodeInfoTable.getRowCount();
        int i = 0;
        while (i < rowCount) {
            if (this.lb.getCall_Status_Connection().equals((String)this.model.getValueAt(i, 1))) {
                isTalking = true;
                break;
            }
            ++i;
        }
        return isTalking;
    }

    public void sendDTMF(String str) {
        try {
            if (!this.isTalkingStatus()) {
                return;
            }
            if (str.length() > 1) {
                str = str.substring(0, 1);
            }
            String strDigit = str;
            this.eventInstance.sendDTMF(this.talkingID, strDigit);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.info("sendDTMF() is failure." + e.getMessage());
        }
    }

    private void addRow(CallInfoBean callInfo) {
        Vector<Object> data = new Vector<Object>();
        String time = "00:00:00";
        String strNumber = callInfo.getStrPhoneNum().trim();
        String name = this.commonMethodByTelBook.getContactName(strNumber);
        if (name == null || "".equals(name.trim())) {
            name = strNumber;
        }
        data.add(0, name);
        data.add(1, this.lb.getCall_Status_Connection());
        data.add(2, time);
        data.add(3, strNumber);
        data.add(4, callInfo);
        this.setCapability(data);
        this.model.insertRow(0, data);
        this.inputTextField.setText(strNumber);
        this.phoneCodeInfoTable.setRowSelectionInterval(0, 0);
        this.phoneCodeInfoTable.revalidate();
    }

    public void onCallPanel(int callType, String number) {
        if (callType == 0) {
            if (AppFrame.frame != null) {
                this.callButtonActionPerformed();
            }
        } else if (1 == callType) {
            this.hangupButtonActionPerformed();
        } else if (2 == callType) {
            if (!this.isCloseFrame) {
                String message = this.lb.getNot_Idle_Call_Prompt();
                String title = CustomizeInit.getLanguageBean().getTools_5_ProfileManagement_Delete_Prompt();
                int result = Tools.showMessageDialog(this.frame, message, title, new ImageIcon(this.frame.getIconImage()), 1);
                AppFrame.frame.setDefaultCloseOperation(0);
                return;
            }
            if (number == null || "".equals(number)) {
                this.log.info("setCallPanelStatus(int type , String number):number is null");
                return;
            }
            AppFrame.frame.clickCallButton();
            AppFrame.frame.callManage_actionPerformed();
            this.inputTextField.setText(number);
            this.callButtonActionPerformed();
        }
    }

    public void changeCallLanguage() {
        String temp = "";
        int i = 0;
        while (i < this.model.getRowCount()) {
            temp = this.model.getValueAt(i, 1).toString();
            if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_INCOMING)) {
                this.model.setValueAt(this.lb.getCall_Status_Incoming(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_CONNECTION)) {
                this.model.setValueAt(this.lb.getCall_Status_Connection(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_CEND)) {
                this.model.setValueAt(this.lb.getCall_Status_Cend(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_CONTROL_CAUSE)) {
                this.model.setValueAt(this.lb.getCall_Control_Cause(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_CALLING)) {
                this.model.setValueAt(this.lb.getCall_Status_Calling(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_EMERGENCY_ORIG)) {
                this.model.setValueAt(this.lb.getCall_Status_Emergency_Orig(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_EMERGENCY_CONF)) {
                this.model.setValueAt(this.lb.getCall_Status_Emergency_Conf(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_STATUS_CONF)) {
                this.model.setValueAt(this.lb.getCall_Status_Conf(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALL_NO_NUMBER)) {
                this.model.setValueAt(this.lb.getCall_No_Number(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.DELETE_CALL_INFO_PROMPT)) {
                this.model.setValueAt(this.lb.getDelete_Call_Info_Prompt(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CLEAR_CALL_INFO_PROMPT)) {
                this.model.setValueAt(this.lb.getClear_Call_Info_Prompt(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.CALLING_NOT_CLOSING_PROMPT)) {
                this.model.setValueAt(this.lb.getCalling_Not_Closing_Prompt(), i, 1);
            } else if (temp.equalsIgnoreCase(CommonConfigCallInfo.NOT_IDLE_CALL_PROMPT)) {
                this.model.setValueAt(this.lb.getNot_Idle_Call_Prompt(), i, 1);
            }
            ++i;
        }
        this.callItem.setText(CustomizeInit.getLanguageBean().getCallInfo());
        this.deleteItem.setText(CustomizeInit.getLanguageBean().getCallLog_del());
        this.clearItem.setText(CustomizeInit.getLanguageBean().getCallLog_clr());
        this.setRource();
        this.phoneCodeInfoTable.revalidate();
    }

    private void setRource() {
        CommonConfigCallInfo.CALL_STATUS_INCOMING = this.lb.getCall_Status_Incoming();
        CommonConfigCallInfo.CALL_STATUS_CONNECTION = this.lb.getCall_Status_Connection();
        CommonConfigCallInfo.CALL_STATUS_CEND = this.lb.getCall_Status_Cend();
        CommonConfigCallInfo.CALL_CONTROL_CAUSE = this.lb.getCall_Control_Cause();
        CommonConfigCallInfo.CALL_STATUS_CALLING = this.lb.getCall_Status_Calling();
        CommonConfigCallInfo.CALL_STATUS_EMERGENCY_ORIG = this.lb.getCall_Status_Emergency_Orig();
        CommonConfigCallInfo.CALL_STATUS_EMERGENCY_CONF = this.lb.getCall_Status_Emergency_Conf();
        CommonConfigCallInfo.CALL_STATUS_CONF = this.lb.getCall_Status_Conf();
        CommonConfigCallInfo.CALL_NO_NUMBER = this.lb.getCall_No_Number();
        CommonConfigCallInfo.DELETE_CALL_INFO_PROMPT = this.lb.getDelete_Call_Info_Prompt();
        CommonConfigCallInfo.CLEAR_CALL_INFO_PROMPT = this.lb.getClear_Call_Info_Prompt();
        CommonConfigCallInfo.CALLING_NOT_CLOSING_PROMPT = this.lb.getCalling_Not_Closing_Prompt();
        CommonConfigCallInfo.NOT_IDLE_CALL_PROMPT = this.lb.getNot_Idle_Call_Prompt();
    }

    public void notifyCallPanel() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            int row = this.phoneCodeInfoTable.getRowCount();
            int i = 0;
            while (i < row) {
                String number = String.valueOf(this.model.getValueAt(i, this.phoneCodeInfoTable.getColumnCount() - 2));
                if (number != null && !"".equals(number) && !this.lb.getCall_No_Number().equals(number)) {
                    list.add(i, number);
                }
                ++i;
            }
            HashMap map = this.commonMethodByTelBook.getContactNameList(list);
            if (map == null) {
                return;
            }
            int k = 0;
            while (k < list.size()) {
                String number = String.valueOf(list.get(k));
                String name = String.valueOf(map.get(number.trim()));
                if (name != null) {
                    if ("".equals(name.trim())) {
                        name = number;
                    }
                    int j = 0;
                    while (j < row) {
                        String strNumber = String.valueOf(this.model.getValueAt(j, this.phoneCodeInfoTable.getColumnCount() - 2));
                        if (strNumber != null && !"".equals(strNumber) && !this.lb.getCall_No_Number().equals(strNumber) && number.equals(strNumber)) {
                            this.model.setValueAt(name, j, 0);
                            this.phoneCodeInfoTable.revalidate();
                        }
                        ++j;
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            this.log.info("notifyCallPanel() is exception");
            e.printStackTrace();
        }
    }

    public void update(boolean bool) {
        this.notifyCallPanel();
    }

    class PhoneCodeModel
    extends DefaultTableModel {
        PhoneCodeModel() {
        }

        public void addRow(Vector rowData) {
            this.insertRow(super.getRowCount(), rowData);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class LabelMouseAdapter
    extends MouseAdapter {
        String response = null;

        LabelMouseAdapter() {
        }

        public void mouseReleased(MouseEvent e) {
            if ("micLabelEnable".equals(e.getComponent().getName())) {
                this.response = ATFactory.getATFactory().getCallServiceImpl().makeCMUT("AT+CMUT=1");
                if (this.response == null) {
                    return;
                }
                if (this.response.trim().toUpperCase().equals("OK")) {
                    CallContentPanel.this.micLabel.setIcon(new ImageIcon(String.valueOf(CallContentPanel.this.path) + cb.getImages_Mike_Lose_Call()));
                    CallContentPanel.this.micLabel.setName("micLabelDisable");
                }
            } else if ("micLabelDisable".equals(e.getComponent().getName())) {
                this.response = ATFactory.getATFactory().getCallServiceImpl().makeCMUT("AT+CMUT=0");
                if (this.response == null) {
                    return;
                }
                if (this.response.trim().toUpperCase().equals("OK")) {
                    CallContentPanel.this.micLabel.setIcon(new ImageIcon(String.valueOf(CallContentPanel.this.path) + cb.getImages_Mike_Call()));
                    CallContentPanel.this.micLabel.setName("micLabelEnable");
                }
            } else if ("plusVolumeLabel".equals(e.getComponent().getName())) {
                if (CallContentPanel.this.volumeMax == CallContentPanel.this.volumeSlider.getValue()) {
                    return;
                }
                int value = CallContentPanel.this.volumeSlider.getValue() + 1;
                this.response = ATFactory.getATFactory().getCallServiceImpl().makeCLVL("AT+CLVL=" + value);
                if (this.response == null) {
                    return;
                }
                if (this.response.trim().toUpperCase().equals("OK")) {
                    CallContentPanel.this.volumeSlider.setValue(value);
                }
            } else if ("subVolumeLabel".equals(e.getComponent().getName())) {
                if (CallContentPanel.this.volumeMin == CallContentPanel.this.volumeSlider.getValue()) {
                    return;
                }
                int value = CallContentPanel.this.volumeSlider.getValue() - 1;
                this.response = ATFactory.getATFactory().getCallServiceImpl().makeCLVL("AT+CLVL=" + value);
                if (this.response == null) {
                    return;
                }
                if (this.response.trim().toUpperCase().equals("OK")) {
                    CallContentPanel.this.volumeSlider.setValue(value);
                }
            }
            CallContentPanel.this.setTimeAccumulate(0);
        }
    }

    class SliderChangeListener
    implements ChangeListener {
        SliderChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int value = CallContentPanel.this.volumeSlider.getValue();
            String response = ATFactory.getATFactory().getCallServiceImpl().makeCLVL("AT+CLVL=" + value);
            if (response == null) {
                return;
            }
            if (response.trim().toUpperCase().equals("OK")) {
                CallContentPanel.this.volumeSlider.setValue(value);
            }
            CallContentPanel.this.setTimeAccumulate(0);
        }
    }

    class KeyTextFieldListener
    extends KeyAdapter {
        KeyTextFieldListener() {
        }

        public void keyPressed(KeyEvent e) {
            String str = String.valueOf(e.getKeyChar());
            if (!str.matches("[^+0-9#*WwPpTt]$")) {
                CallContentPanel.this.playAuditionSound(CallContentPanel.this.keyVoiceFileName, true);
                CallContentPanel.this.sendDTMF(str);
            }
            if (e.getKeyCode() == 10) {
                if (CallContentPanel.this.callBtn.isEnabled()) {
                    CallContentPanel.this.callButtonActionPerformed();
                }
            } else if (e.isControlDown() && e.getKeyCode() == 68) {
                if (CallContentPanel.this.callBtn.isEnabled()) {
                    CallContentPanel.this.callButtonActionPerformed();
                }
            } else if (e.isControlDown() && e.getKeyCode() == 72) {
                if (CallContentPanel.this.hangupBtn.isEnabled()) {
                    CallContentPanel.this.hangupButtonActionPerformed();
                }
            } else if (e.getKeyCode() == 40) {
                CallContentPanel.this.phoneCodeInfoTable.setAutoscrolls(true);
                if (CallContentPanel.this.phoneCodeInfoTable.getSelectedRowCount() <= 0) {
                    return;
                }
                int selectRow = CallContentPanel.this.phoneCodeInfoTable.getSelectedRow();
                if (selectRow == CallContentPanel.this.phoneCodeInfoTable.getRowCount() - 1) {
                    CallContentPanel.this.phoneCodeInfoTable.setRowSelectionInterval(0, 0);
                    Rectangle rect = CallContentPanel.this.phoneCodeInfoTable.getCellRect(0, 0, true);
                    CallContentPanel.this.phoneCodeInfoTable.scrollRectToVisible(rect);
                } else {
                    CallContentPanel.this.phoneCodeInfoTable.setRowSelectionInterval(selectRow + 1, selectRow + 1);
                    Rectangle rect = CallContentPanel.this.phoneCodeInfoTable.getCellRect(selectRow + 1, 0, true);
                    CallContentPanel.this.phoneCodeInfoTable.scrollRectToVisible(rect);
                }
                CallContentPanel.this.phoneCodeInfoTable.revalidate();
            } else if (e.getKeyCode() == 38) {
                if (CallContentPanel.this.phoneCodeInfoTable.getSelectedRowCount() <= 0) {
                    return;
                }
                int selectRow = CallContentPanel.this.phoneCodeInfoTable.getSelectedRow();
                if (selectRow == 0) {
                    CallContentPanel.this.phoneCodeInfoTable.setRowSelectionInterval(CallContentPanel.this.phoneCodeInfoTable.getRowCount() - 1, CallContentPanel.this.phoneCodeInfoTable.getRowCount() - 1);
                    Rectangle rect = CallContentPanel.this.phoneCodeInfoTable.getCellRect(CallContentPanel.this.phoneCodeInfoTable.getRowCount() - 1, CallContentPanel.this.phoneCodeInfoTable.getRowCount() - 1, true);
                    CallContentPanel.this.phoneCodeInfoTable.scrollRectToVisible(rect);
                } else {
                    CallContentPanel.this.phoneCodeInfoTable.setRowSelectionInterval(selectRow - 1, selectRow - 1);
                    Rectangle rect = CallContentPanel.this.phoneCodeInfoTable.getCellRect(selectRow - 1, selectRow - 1, true);
                    CallContentPanel.this.phoneCodeInfoTable.scrollRectToVisible(rect);
                }
                CallContentPanel.this.phoneCodeInfoTable.revalidate();
            }
            CallContentPanel.this.setTimeAccumulate(0);
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CallContentPanel.this.setCompontFocus(CallContentPanel.this.inputTextField);
            CallContentPanel.this.playAuditionSound(CallContentPanel.this.keyVoiceFileName, true);
            if (e.getActionCommand().equals(CallContentPanel.this.btnStr[0])) {
                CallContentPanel.this.inputTextField.replaceSelection("1");
                CallContentPanel.this.sendDTMF("1");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[1])) {
                CallContentPanel.this.inputTextField.replaceSelection("2");
                CallContentPanel.this.sendDTMF("2");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[2])) {
                CallContentPanel.this.inputTextField.replaceSelection("3");
                CallContentPanel.this.sendDTMF("3");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[3])) {
                CallContentPanel.this.inputTextField.replaceSelection("4");
                CallContentPanel.this.sendDTMF("4");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[4])) {
                CallContentPanel.this.inputTextField.replaceSelection("5");
                CallContentPanel.this.sendDTMF("5");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[5])) {
                CallContentPanel.this.inputTextField.replaceSelection("6");
                CallContentPanel.this.sendDTMF("6");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[6])) {
                CallContentPanel.this.inputTextField.replaceSelection("7");
                CallContentPanel.this.sendDTMF("7");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[7])) {
                CallContentPanel.this.inputTextField.replaceSelection("8");
                CallContentPanel.this.sendDTMF("8");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[8])) {
                CallContentPanel.this.inputTextField.replaceSelection("9");
                CallContentPanel.this.sendDTMF("9");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[9])) {
                CallContentPanel.this.inputTextField.replaceSelection("0");
                CallContentPanel.this.sendDTMF("0");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[10])) {
                CallContentPanel.this.inputTextField.replaceSelection("*");
                CallContentPanel.this.sendDTMF("*");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[11])) {
                CallContentPanel.this.inputTextField.replaceSelection("#");
                CallContentPanel.this.sendDTMF("#");
            } else if (e.getActionCommand().equals(CallContentPanel.this.btnStr[12])) {
                CallContentPanel.this.inputTextField.replaceSelection("+");
            } else if (!e.getActionCommand().equals(CallContentPanel.this.btnStr[13])) {
                if (e.getActionCommand().equals(CallContentPanel.this.btnStr[14])) {
                    String str = "";
                    try {
                        str = SelectPhoneNumber.showConfirmDialog();
                    }
                    catch (HeadlessException ee) {
                        CallContentPanel.this.log.error(ee.getMessage());
                    }
                    if (!"".equals(str) && CallContentPanel.this.isClosedStatus()) {
                        CallContentPanel.this.inputTextField.setText(str);
                    }
                } else if (!e.getActionCommand().equals(CallContentPanel.this.btnStr[15])) {
                    if (e.getActionCommand().equals("callBtn")) {
                        CallContentPanel.this.timeAccumulate = 0;
                        if (CallContentPanel.this.isScreenProtect) {
                            CallContentPanel.this.isScreenProtect = false;
                            return;
                        }
                        CallContentPanel.this.callButtonActionPerformed();
                    } else if (e.getActionCommand().equals("hangupBtn")) {
                        CallContentPanel.this.timeAccumulate = 0;
                        if (CallContentPanel.this.isScreenProtect) {
                            CallContentPanel.this.isScreenProtect = false;
                            return;
                        }
                        CallContentPanel.this.hangupButtonActionPerformed();
                    }
                }
            }
        }
    }

    class ButtonMouseListener
    extends MouseAdapter {
        boolean isDelete = true;
        volatile int count = 0;
        Thread thread = null;

        ButtonMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.count = 0;
            if (((JButton)e.getSource()).getActionCommand().equals(CallContentPanel.this.btnStr[15])) {
                this.thread = new Thread(new Runnable(){

                    public void run() {
                        while (ButtonMouseListener.this.count < 3) {
                            try {
                                if (2 == ButtonMouseListener.this.count) {
                                    CallContentPanel.this.inputTextField.setSelectionStart(0);
                                }
                                CallContentPanel.this.inputTextField.delete();
                                Thread.sleep(500L);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            ++ButtonMouseListener.this.count;
                        }
                    }
                });
                this.thread.start();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.count = 3;
            this.thread = null;
        }
    }

    class PopupMenuItemListener
    implements ActionListener {
        PopupMenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("callItem")) {
                CallContentPanel.this.callButtonActionPerformed();
            } else if (e.getActionCommand().equals("deleteItem")) {
                String message = CallContentPanel.this.lb.getDelete_Call_Info_Prompt();
                String title = CustomizeInit.getLanguageBean().getTools_5_ProfileManagement_Delete_Prompt();
                int result = Tools.showMessageDialog(CallContentPanel.this.frame, message, title, new ImageIcon(CallContentPanel.this.frame.getIconImage()), 2);
                if (result == 0) {
                    int row = CallContentPanel.this.phoneCodeInfoTable.getSelectedRow();
                    CallContentPanel.this.model.removeRow(row);
                    CallContentPanel.this.phoneCodeInfoTable.revalidate();
                    try {
                        if (CallContentPanel.this.capabilityContainer.size() > row) {
                            CallContentPanel.this.capabilityContainer.remove(row);
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            } else if (e.getActionCommand().equals("clearItem")) {
                String message = CallContentPanel.this.lb.getClear_Call_Info_Prompt();
                String title = CustomizeInit.getLanguageBean().getTools_5_ProfileManagement_Delete_Prompt();
                int result = Tools.showMessageDialog(CallContentPanel.this.frame, message, title, new ImageIcon(CallContentPanel.this.frame.getIconImage()), 2);
                if (result == 0) {
                    int i = CallContentPanel.this.phoneCodeInfoTable.getRowCount() - 1;
                    while (i >= 0) {
                        CallContentPanel.this.model.removeRow(i);
                        if (CallContentPanel.this.capabilityContainer.get(i) != null) {
                            CallContentPanel.this.capabilityContainer.remove(i);
                        }
                        --i;
                    }
                    CallContentPanel.this.phoneCodeInfoTable.revalidate();
                }
            }
        }
    }

    class SelectedListListener
    implements ListSelectionListener {
        SelectedListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            CallContentPanel.this.timeAccumulate = 0;
            if (CallContentPanel.this.isScreenProtect) {
                CallContentPanel.this.isScreenProtect = false;
            }
            CallContentPanel.this.selectEvent();
        }
    }

    class TableMouseAdapter
    extends MouseAdapter {
        TableMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 4) {
                return;
            }
            CallContentPanel.this.phoneCodeInfoTable.setFocusable(false);
            int row = CallContentPanel.this.phoneCodeInfoTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            String selectPhoneNum = (String)CallContentPanel.this.model.getValueAt(row, CallContentPanel.this.columnName.length - 2);
            if (selectPhoneNum == null || "".equals(selectPhoneNum)) {
                return;
            }
            if (CallContentPanel.this.lb.getCall_No_Number().equals(selectPhoneNum)) {
                CallContentPanel.this.inputTextField.setText("");
            } else {
                CallContentPanel.this.inputTextField.setText(selectPhoneNum);
            }
        }
    }
}

