/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.call;

import com.huawei.mobilePartner.business.call.options.CallAuditionSoundFile;
import com.huawei.mobilePartner.business.call.options.CallBrowseSoundFile;
import com.huawei.mobilePartner.business.call.options.CallCueEvent;
import com.huawei.mobilePartner.business.call.options.CallCueOperation;
import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.business.sms.smsset.ActionExecutant;
import com.huawei.mobilePartner.business.sms.smsset.CommandButton;
import com.huawei.mobilePartner.business.sms.smsset.CommandCheckBox;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.UICommon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CallConfigMessPanel
extends JPanel {
    private CommandButton testButton;
    private CommandButton browseButton;
    private CommandCheckBox visualPromptCheckBox;
    private CommandCheckBox ringToneCheckBox;
    private JTextField soundTextField = new JTextField();
    private LanguageBean lb = CustomizeInit.getLanguageBean();

    public CallConfigMessPanel() {
        this.init();
    }

    private void init() {
        XMLTool.setImportExport(false);
        this.initPanel();
    }

    private void getResource() {
        try {
            XMLTool.setImportExport(true);
            XMLTool xmlTool = new XMLTool(String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/call/CallOptionConfig.xml");
            String strPrompt = xmlTool.getNodePropertiesValue("/root/callVisualPrompt", "visualPrompt");
            String strTone = xmlTool.getNodePropertiesValue("/root/callRingTone", "ringTone");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        mainPanel.setBorder(BorderFactory.createTitledBorder(this.lb.getCallInfoTitle()));
        this.visualPromptCheckBox = new CommandCheckBox(this.lb.getCallVisualPromptInfo(), this);
        this.visualPromptCheckBox.setFont(Tools.setFont());
        this.visualPromptCheckBox.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.ringToneCheckBox = new CommandCheckBox(this.lb.getCallRingToneInfo(), this);
        this.ringToneCheckBox.setFont(Tools.setFont());
        this.ringToneCheckBox.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.ringToneCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CallConfigMessPanel.this.ringToneCheckBox.isSelected()) {
                    CallConfigMessPanel.this.testButton.setEnabled(true);
                    CallConfigMessPanel.this.browseButton.setEnabled(true);
                    CallConfigMessPanel.this.soundTextField.setEditable(true);
                } else {
                    CallConfigMessPanel.this.testButton.setEnabled(false);
                    CallConfigMessPanel.this.browseButton.setEnabled(false);
                    CallConfigMessPanel.this.soundTextField.setEditable(false);
                }
            }
        });
        mainPanel.add((Component)this.visualPromptCheckBox, new GridBagConstraints(0, 0, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 12, 2, 2), 0, 0));
        mainPanel.add((Component)this.ringToneCheckBox, new GridBagConstraints(0, 1, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 12, 2, 2), 0, 0));
        mainPanel.add((Component)this.soundTextField, new GridBagConstraints(0, 2, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 16, 2, 12), 0, 0));
        mainPanel.add((Component)this.getCommandPanel(), new GridBagConstraints(0, 3, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 12, 2, 2), 0, 0));
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)mainPanel, "North");
        this.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.setComPro();
    }

    private JPanel getCommandPanel() {
        JPanel southPanel = new JPanel(new FlowLayout(2, 12, 12));
        southPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.testButton = new CommandButton(this.lb.getTools_5_TextMessage_Test(), this);
        GetButtonBackground.setButtonBackground(this.testButton);
        this.testButton.setFont(Tools.setFont());
        this.testButton.setName("test");
        this.testButton.setCommand(new CallAuditionSoundFile(this));
        this.testButton.addActionListener(new ActionExecutant());
        UICommon.setButtonSize(this.testButton);
        this.browseButton = new CommandButton(this.lb.getTools_5_TextMessage_Browse(), this);
        GetButtonBackground.setButtonBackground(this.browseButton);
        this.browseButton.setFont(Tools.setFont());
        this.browseButton.setCommand(new CallBrowseSoundFile(this));
        this.browseButton.addActionListener(new ActionExecutant());
        UICommon.setButtonSize(this.browseButton);
        southPanel.add(this.browseButton);
        southPanel.add(this.testButton);
        return southPanel;
    }

    public void setSoundFieldText(String filePath) {
        this.soundTextField.setText(filePath);
    }

    public String getSoundFieldText() {
        return this.soundTextField.getText().trim();
    }

    public String getTestButtonName() {
        return this.testButton.getName();
    }

    public void setTestButtonAttribute(String text, String name) {
        this.testButton.setText(text);
        this.testButton.setName(name);
    }

    public boolean isSelect_VisualPrompt() {
        return this.visualPromptCheckBox.isSelected();
    }

    public boolean isSelect_RingTone() {
        return this.ringToneCheckBox.isSelected();
    }

    private void setComPro() {
        if (PublicConfig.callCueFlag) {
            this.setPanelValue();
        } else {
            CallCueOperation callCueOper = CallCueOperation.getInstance();
            CallCueEvent callCue = callCueOper.listToCueEvent();
            this.setPanelValue(callCue);
        }
    }

    private void setPanelValue() {
        if ("true".equals(PublicConfig.visionCue)) {
            this.visualPromptCheckBox.setSelected(true);
        }
        if ("true".equals(PublicConfig.ear)) {
            this.ringToneCheckBox.setSelected(true);
            this.testButton.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.soundTextField.setEditable(true);
            this.soundTextField.setText(PublicConfig.earPath);
        } else {
            this.ringToneCheckBox.setSelected(false);
            this.testButton.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.soundTextField.setEditable(false);
            this.soundTextField.setText(PublicConfig.earPath);
        }
    }

    private void setPanelValue(CallCueEvent callCue) {
        if ("true".equals(callCue.getVisionCue())) {
            this.visualPromptCheckBox.setSelected(true);
        }
        if ("true".equals(callCue.getEarCue())) {
            this.ringToneCheckBox.setSelected(true);
            this.testButton.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.soundTextField.setEditable(true);
            this.soundTextField.setText(callCue.getEarCuePath());
        } else {
            this.ringToneCheckBox.setSelected(false);
            this.testButton.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.soundTextField.setEditable(false);
            this.soundTextField.setText(callCue.getEarCuePath());
        }
    }

    private JPanel getSetSimNotify(String simNotify) {
        return new JPanel();
    }
}

