/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private final TristateDecorator model;

    public TristateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public TristateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public TristateCheckBox(String text) {
        this(text, DONT_CARE);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean b) {
        if (b) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    public static class State {
        private State() {
        }
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return DONT_CARE;
            }
            return NOT_SELECTED;
        }

        private void nextState() {
            State current = this.getState();
            if (current == NOT_SELECTED) {
                this.setState(SELECTED);
            } else if (current == SELECTED) {
                this.setState(DONT_CARE);
            } else if (current == DONT_CARE) {
                this.setState(NOT_SELECTED);
            }
        }

        public void setArmed(boolean b) {
        }

        public void setEnabled(boolean b) {
            TristateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

