/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.business.network.NetworkThread;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageLocal;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SmsPromptPanel
extends JDialog {
    LanguageBean lb = CustomizeInit.getLanguageBean();
    public JButton viewButton;
    public JButton cancelButton;
    public JLabel textLabel;
    public static JLabel telNumLabel;
    private String telNum;
    private JPanel downPanel = new JPanel();
    private JPanel topPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private static SmsPromptPanel instance;
    private AppFrame appFrame;

    static {
        instance = null;
    }

    public static SmsPromptPanel getSmsPromptPanel(String telNum, JFrame jFrame) {
        if (instance == null) {
            instance = new SmsPromptPanel(telNum, jFrame);
        }
        return instance;
    }

    private SmsPromptPanel(String telNum, JFrame jFrame) {
        super((Frame)jFrame, false);
        this.setUndecorated(true);
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder());
        this.getRootPane().setWindowDecorationStyle(0);
        this.appFrame = (AppFrame)jFrame;
        this.setModal(false);
        this.setLayout(new BorderLayout());
        this.topPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.centerPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.downPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.downPanel, "South");
        this.telNum = telNum;
        this.init();
    }

    public void init() {
        this.topPanel.setLayout(new BorderLayout());
        this.textLabel = new JLabel();
        this.textLabel.setText(this.lb.getNew_Message_Prompt());
        this.textLabel.setFont(Tools.setFont());
        this.topPanel.add((Component)this.textLabel, "West");
        this.centerPanel.setLayout(new BorderLayout());
        telNumLabel = new JLabel("", 0);
        String temp = SmsPromptPanel.selectPhone(this.telNum);
        telNumLabel.setText(temp);
        telNumLabel.setFont(Tools.setFont());
        this.centerPanel.add((Component)telNumLabel, "Center");
        this.downPanel.setLayout(new GridBagLayout());
        JTextField label = new JTextField("         ");
        label.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        label.setBorder(null);
        label.setEnabled(false);
        this.cancelButton = new JButton();
        GetButtonBackground.setButtonBackground(this.cancelButton);
        this.cancelButton.setText(this.lb.getTools_3_Cancel());
        this.cancelButton.setFont(Tools.setFont());
        this.viewButton = new JButton();
        GetButtonBackground.setButtonBackground(this.viewButton);
        this.viewButton.setText(this.lb.getNew_Message_View());
        this.viewButton.setFont(Tools.setFont());
        this.downPanel.add(this.viewButton);
        this.downPanel.add(label);
        this.downPanel.add(this.cancelButton);
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SmsPromptPanel.this.appFrame.smsChangePanel();
            }
        });
        this.viewButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SmsPromptPanel.this.appFrame.smsChangePanel();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SmsPromptPanel.this.close();
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SmsPromptPanel.this.close();
                }
            }
        });
    }

    public void close() {
        this.dispose();
    }

    public static String selectPhone(String tel) {
        String homeNumber;
        String officeNumber;
        String mobileNumber;
        Map telMap;
        TeleManageLocal tele = new TeleManageLocal();
        List telList = tele.queryContract("root/local", "");
        ArrayList telListSim = NetworkThread.telHomeList;
        String nameNumber = "";
        boolean tempFlag = true;
        int telIndex = 0;
        while (telIndex < telList.size()) {
            telMap = (Map)telList.get(telIndex);
            mobileNumber = Tools.checkNull(telMap.get("mobileNumber").toString());
            officeNumber = Tools.checkNull(telMap.get("officeNumber").toString());
            homeNumber = Tools.checkNull(telMap.get("homeNumber").toString());
            if (Tools.getMatchString(tel, mobileNumber) || Tools.getMatchString(tel, officeNumber) || Tools.getMatchString(tel, homeNumber)) {
                nameNumber = telMap.get("name").toString();
                tempFlag = false;
                break;
            }
            ++telIndex;
        }
        if (tempFlag && telListSim != null) {
            telIndex = 0;
            while (telIndex < telListSim.size()) {
                telMap = (Map)telListSim.get(telIndex);
                mobileNumber = Tools.checkNull(telMap.get("mobileNumber"));
                officeNumber = Tools.checkNull(telMap.get("officeNumber"));
                homeNumber = Tools.checkNull(telMap.get("homeNumber"));
                if (Tools.getMatchString(tel, mobileNumber) || Tools.getMatchString(tel, officeNumber) || Tools.getMatchString(tel, homeNumber)) {
                    nameNumber = telMap.get("name").toString();
                    tempFlag = false;
                    break;
                }
                ++telIndex;
            }
        }
        if ("".equals(nameNumber)) {
            nameNumber = tel;
        }
        return nameNumber;
    }
}

