/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.Tools;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TooManyListenersException;

public class SerialComm
implements SerialPortEventListener,
Runnable {
    public static final String PORT_OWER = "MonitorApp";
    private boolean isOpen = false;
    private boolean isStart = false;
    private boolean isSave = true;
    private boolean isPrint = false;
    private Thread readThread;
    private String portName = "COM1";
    private String portAddress = "LOCAL";
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private DataInputStream inputStream;
    private OutputStream outputStream;
    private SimpleDateFormat formatter;
    private String dataProtocol = "Gooseli";
    private Object readWriteLock = new Object();
    private static LogATConfig log = Log.getATLog(SerialComm.class);

    public SerialComm() {
        this.formatter = new SimpleDateFormat("[yyyy-MM-dd hh:mm:ss,SSS]");
    }

    public void init(String port, String protocol) throws Exception {
        this.portAddress = this.portName = port;
        this.dataProtocol = protocol;
        this.init();
    }

    public void init(String port, String address, String protocol) throws Exception {
        this.portName = port;
        this.portAddress = address;
        this.dataProtocol = protocol;
        this.init();
    }

    public void init() throws IOException, Exception, Exception {
        if (this.isOpen) {
            this.close();
        }
        try {
            this.portId = CommPortIdentifier.getPortIdentifier(this.portName);
            this.serialPort = (SerialPort)this.portId.open(PORT_OWER, 2000);
            this.inputStream = new DataInputStream(this.serialPort.getInputStream());
            this.outputStream = this.serialPort.getOutputStream();
            this.isOpen = true;
        }
        catch (NoSuchPortException ex) {
            throw new Exception(ex.toString());
        }
        catch (PortInUseException ex) {
            throw new Exception(ex.toString());
        }
    }

    public void start() throws Exception {
        if (!this.isOpen) {
            throw new Exception(String.valueOf(this.portName) + " has not been opened.");
        }
        try {
            this.readThread = new Thread(this);
            this.readThread.start();
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.addEventListener(this);
            this.isStart = true;
        }
        catch (TooManyListenersException ex) {
            throw new Exception(ex.toString());
        }
    }

    public void run() {
        String at = "at^hcmgr=1\r";
        String strTemp = String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z";
        Tools.logToControl("out", "send:" + strTemp);
        this.writeComm(strTemp);
        this.isPrint = true;
    }

    public void stop() {
        if (this.isStart) {
            this.serialPort.notifyOnDataAvailable(false);
            this.serialPort.removeEventListener();
            this.isStart = false;
        }
    }

    public void close() {
        this.stop();
        if (this.isOpen) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.serialPort.close();
                this.isOpen = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                this.readComm();
                break;
            }
        }
    }

    public void readComm() {
        StringBuffer readBuffer = new StringBuffer();
        String scannedInput = "";
        Date currentTime = null;
        String TimeStamp = "";
        try {
            int c;
            InputStreamReader fis = new InputStreamReader((InputStream)this.inputStream, "utf-8");
            while ((c = fis.read()) != -1) {
                Tools.logToControl("out", "c=" + c);
                readBuffer.append((char)c);
            }
            scannedInput = readBuffer.toString().trim();
            currentTime = new Date();
            Tools.logToControl("out", "9817=\u6211");
            TimeStamp = this.formatter.format(currentTime);
            Tools.logToControl("out", String.valueOf(TimeStamp) + " - " + scannedInput);
            if (scannedInput.indexOf(">") > -1) {
                Tools.logToControl("out", "----------------------------------------");
                Tools.logToControl("out", "----------------------------------------");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeComm(String outString) {
        Object object = this.readWriteLock;
        synchronized (object) {
            try {
                this.outputStream.write(outString.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        SerialComm serialcomm = new SerialComm();
        try {
            serialcomm.init("COM3", "Air");
            serialcomm.start();
        }
        catch (Exception ex) {
            Tools.logToControl("out", ex.toString());
        }
    }
}

