/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.USSDStaticVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OnlinePromptDialog
extends JDialog {
    public JButton okButton;
    public JButton cancelButton;
    private String returnCOde;
    public static String RETURN_OK = "1";
    public static int MIN_WIDTH = 300;
    public static int MIN_HEIGHT = 135;
    private boolean btnFlag = true;
    private int imageWidth = 0;
    private ImageIcon icon = null;
    private String info;

    public OnlinePromptDialog(JFrame frame, String title, String info) {
        super(frame, title, true);
        Tools.changeDialogAppearance(this);
        this.info = info;
        this.getContentPane().add(this.getPanel());
        this.setBackground(ChangeColor.getColor(USSDStaticVariable.cb.getDialogBackground()));
        Tools.showWindowCenter(this);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OnlinePromptDialog.this.close();
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        Container c = this.getContentPane();
        int wid = this.resizeDialog(this.info) + this.imageWidth;
        int width = 0;
        int height = 0;
        if (wid <= 240) {
            width = MIN_WIDTH;
            height = MIN_HEIGHT;
        } else {
            width = wid + 100;
            height = MIN_HEIGHT;
        }
        if (c.getWidth() == width && c.getHeight() == height) {
            return;
        }
        c.setPreferredSize(new Dimension(width, height));
    }

    public OnlinePromptDialog(JFrame frame, String title, String info, boolean bool) {
        super(frame, title, true);
        this.btnFlag = bool;
        this.info = info;
        String path = String.valueOf(XMLTool.getClassPath()) + "/config/images/";
        path = TextUtil.replaceStr1(path, "\\/", "/");
        path = TextUtil.replaceStr1(path, "\\", "/");
        this.icon = new ImageIcon(String.valueOf(path) + CustomizeInit.getCustomizeBean().getSystemIcon());
        this.imageWidth = this.icon.getIconWidth();
        Tools.logToControl("err", "imageWidth***************************" + this.imageWidth);
        Container c = this.getContentPane();
        c.add(this.getPanel());
        this.setBackground(ChangeColor.getColor(USSDStaticVariable.cb.getDialogBackground()));
        Tools.showWindowCenter(this);
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OnlinePromptDialog.this.close();
            }
        });
    }

    protected JPanel getPanel() {
        JLabel imageLabel = new JLabel(this.icon);
        imageLabel.setVisible(true);
        imageLabel.setEnabled(true);
        imageLabel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 0, ChangeColor.getColor(USSDStaticVariable.cb.getDialogBackground())));
        JLabel infoLabel = new JLabel(this.info);
        infoLabel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, ChangeColor.getColor(USSDStaticVariable.cb.getDialogBackground())));
        this.okButton = new JButton(USSDStaticVariable.lb.getTools_3_OK());
        this.cancelButton = new JButton(USSDStaticVariable.lb.getTools_3_Cancel());
        this.okButton.setSize(new Dimension(80, 25));
        this.okButton.setPreferredSize(new Dimension(80, 25));
        this.cancelButton.setPreferredSize(new Dimension(80, 25));
        GetButtonBackground.setButtonBackground(this.okButton);
        GetButtonBackground.setButtonBackground(this.cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OnlinePromptDialog.this.returnCOde = "1";
                OnlinePromptDialog.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OnlinePromptDialog.this.close();
            }
        });
        JPanel p = new JPanel();
        JPanel topPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        bottomPanel.setLayout(new BorderLayout());
        JPanel okPanel = new JPanel(new FlowLayout(1, 20, 10));
        okPanel.add(this.okButton);
        if (this.btnFlag) {
            okPanel.add(this.cancelButton);
        }
        bottomPanel.add(okPanel);
        topPanel.add((Component)imageLabel, "West");
        topPanel.setBackground(ChangeColor.getColor(USSDStaticVariable.cb.getDialogBackground()));
        okPanel.setBackground(ChangeColor.getColor(USSDStaticVariable.cb.getDialogBackground()));
        topPanel.add((Component)infoLabel, "Center");
        p.setLayout(new BorderLayout());
        p.add((Component)topPanel, "Center");
        p.add((Component)bottomPanel, "South");
        return p;
    }

    protected void close() {
        this.dispose();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        new OnlinePromptDialog(frame, "Prompt", "Upgrade failed, please retry later gfdgfdg fdsfgds gre gre g!");
    }

    public String getReturnCOde() {
        return this.returnCOde;
    }

    public int resizeDialog(String message) {
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        if (message == null && message.equals("")) {
            return 0;
        }
        return fm.stringWidth(message);
    }
}

