/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.business.device.DeviceService;
import com.huawei.mobilePartner.business.network.CDMASelectNetWork;
import com.huawei.mobilePartner.business.network.ChannelBean;
import com.huawei.mobilePartner.business.network.NetworkTypeChoice;
import com.huawei.mobilePartner.business.network.RegisterFashionChoice;
import com.huawei.mobilePartner.business.sms.smsset.CommandCheckBox;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.JUTPSOptionDialog;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import com.huawei.mobilePartner.data.comm.service.NetCommService;
import com.huawei.mobilePartner.gui.model.NetworkBean;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.NetWorkPanel;
import com.huawei.mobilePartner.gui.ui.OptionPanel;
import com.huawei.mobilePartner.gui.ui.ShowInfoDialog;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import com.huawei.mobilePartner.shell.TimerCall;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class NetWorkPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton ok_button;
    private JRadioButton hide = new JRadioButton();
    private JButton cancel_button;
    private JButton application_button = new JButton();
    private JButton refresh_button = new JButton();
    private JButton register_button = new JButton();
    private JComboBox networkBox = new JComboBox();
    private JComboBox bandBox = new JComboBox();
    private JLabel networkTypeLabel;
    private JLabel bandLabel;
    private JTable boxTable;
    private ButtonGroup group;
    private JDialog dialog;
    AppFrame frame = AppFrame.getAppFrameInit();
    private JRadioButton autoSearchRadio = new JRadioButton();
    private JRadioButton manualSearchRadio = new JRadioButton();
    private JRadioButton[] networkModeRadio;
    private static final int width = 485;
    private static final int height = 400;
    NetCommService netCommService = NetCommService.getInstance();
    NetworkBean nb = null;
    static NetworkTypeChoice nt = new NetworkTypeChoice();
    RegisterFashionChoice rfc = null;
    LanguageBean lb = CustomizeInit.getLanguageBean();
    CustomizeBean cb = CustomizeInit.getCustomizeBean();
    static LogConfig log = Log.getLog(NetWorkPanel.class);
    private boolean flag = false;
    List operatorValue = new ArrayList();
    List operatorMode = new ArrayList();
    private String cdmaMode = "";
    NetCommService netComm2 = NetCommService.getInstance();
    String registerInfo = "";
    private String device = "WCDMA";
    public JCheckBox dialogControlBox = null;
    private static final String[] proName = new String[]{"name", "value"};
    public JPanel tabone = null;
    public JPanel tabtwo = null;
    String info1 = "";
    String info2 = "";
    public static List listProvider = null;

    public NetWorkPanel(JDialog dialog) {
        this.device = DeviceService.getInstance().getProductNetType();
        this.application_button = new JButton(this.lb.getTools_5_Network_NetworkType_Apply());
        this.application_button.setEnabled(false);
        GetButtonBackground.setButtonBackground(this.application_button);
        this.application_button.setFont(Tools.setFont());
        this.dialog = dialog;
        this.initPanel();
        if ("WCDMA".equalsIgnoreCase(this.device)) {
            if (MutiDeviceService.curServer == null || TextUtil.checkContainStr(PublicConfig.PinStatus, PublicConfig.pinStateFlag3)) {
                this.application_button.setEnabled(false);
                this.autoSearchRadio.setEnabled(false);
                this.manualSearchRadio.setEnabled(false);
                this.refresh_button.setEnabled(false);
                this.networkBox.setEnabled(false);
                this.bandBox.setEnabled(false);
                if (this.dialogControlBox != null) {
                    this.dialogControlBox.setEnabled(false);
                }
            } else {
                this.autoSearchRadio.setEnabled(true);
                this.manualSearchRadio.setEnabled(true);
                this.networkBox.setEnabled(true);
                this.bandBox.setEnabled(true);
                if (this.dialogControlBox != null) {
                    this.dialogControlBox.setEnabled(true);
                }
            }
            if (TimerCall.statusCall == 0 || PublicConfig.isDSFLOWRPT.equals("1")) {
                this.hide.setSelected(true);
                this.application_button.setEnabled(false);
                this.autoSearchRadio.setEnabled(false);
                this.manualSearchRadio.setEnabled(false);
                this.refresh_button.setEnabled(false);
                this.networkBox.setEnabled(false);
                this.bandBox.setEnabled(false);
            }
        } else if ("CDMA".equalsIgnoreCase(this.device)) {
            try {
                if (MutiDeviceService.curServer == null || TimerCall.statusCall == 0) {
                    int i = 0;
                    while (i < this.networkModeRadio.length) {
                        this.networkModeRadio[i].setEnabled(false);
                        ++i;
                    }
                    this.application_button.setEnabled(false);
                    GetButtonBackground.setButtonBackground(this.application_button);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public NetWorkPanel() {
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.getContextPanel());
    }

    private JPanel getContextPanel() {
        JPanel contextPanel = new JPanel(new BorderLayout());
        contextPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.setFont(Tools.setFont());
        tabbed.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        if (MutiDeviceService.curServer == null) {
            this.tabone = this.getTabbedOne();
            this.tabtwo = this.getTabbedTwo();
            if (OptionPanel.nettypevalue.equals("1")) {
                tabbed.addTab(this.lb.getTools_5_Network_NetworkType(), this.tabone);
            }
            if (OptionPanel.registrationmodevalue.equals("1")) {
                tabbed.addTab(this.lb.getTools_5_Network_RegistrationMode(), this.tabtwo);
            }
        } else if ("WCDMA".equalsIgnoreCase(DeviceService.getInstance().getProductNetType())) {
            this.tabone = this.getTabbedOne();
            this.tabtwo = this.getTabbedTwo();
            if (OptionPanel.nettypevalue.equals("1")) {
                tabbed.addTab(this.lb.getTools_5_Network_NetworkType(), this.tabone);
            }
            if (OptionPanel.registrationmodevalue.equals("1")) {
                tabbed.addTab(this.lb.getTools_5_Network_RegistrationMode(), this.tabtwo);
            }
        } else if ("CDMA".equalsIgnoreCase(DeviceService.getInstance().getProductNetType())) {
            tabbed.addTab(this.lb.getTools_5_Network_NetworkType(), this.getTabbedCDMA());
        }
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(20, 11));
        contextPanel.add((Component)label, "North");
        contextPanel.add((Component)tabbed, "Center");
        JLabel southLabel = new JLabel();
        southLabel.setPreferredSize(new Dimension(20, 8));
        contextPanel.add((Component)southLabel, "South");
        return contextPanel;
    }

    private JPanel getTabbedCDMA() {
        JPanel totalTabCDMAPanel = new JPanel(new BorderLayout(2, 2));
        totalTabCDMAPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        CDMASelectNetWork cdmaNetWork = new CDMASelectNetWork();
        List li = cdmaNetWork.getNetworkType();
        NetCommService netComm = NetCommService.getInstance();
        String networkMode = netComm.getCDMANetworkMod();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.networkModeRadio = new JRadioButton[li.size()];
        int i = 0;
        while (i < this.networkModeRadio.length) {
            String tempInfo = li.get(i).toString();
            String[] info = tempInfo.split(",");
            this.networkModeRadio[i] = new JRadioButton(info[1]);
            this.networkModeRadio[i].setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
            this.networkModeRadio[i].setActionCommand(info[0]);
            this.networkModeRadio[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NetWorkPanel.this.cdmaMode = e.getActionCommand();
                    NetWorkPanel.this.application_button.setEnabled(true);
                    GetButtonBackground.setButtonBackground(NetWorkPanel.this.application_button);
                }
            });
            contentPanel.add((Component)this.networkModeRadio[i], new GridBagConstraints(0, i, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 12, 2, 2), 0, 0));
            if (info[0].equals(networkMode)) {
                this.networkModeRadio[i].setSelected(true);
                this.cdmaMode = info[0];
            }
            buttonGroup.add(this.networkModeRadio[i]);
            ++i;
        }
        totalTabCDMAPanel.add((Component)contentPanel, "North");
        totalTabCDMAPanel.add((Component)this.getCDMAPanel(), "South");
        return totalTabCDMAPanel;
    }

    private JPanel getCDMAPanel() {
        JPanel applicPanel = new JPanel(new FlowLayout(2, 12, 12));
        applicPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.application_button.setEnabled(false);
        this.application_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetWorkPanel.this.application_button.setEnabled(false);
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.application_button);
                NetCommService netComm = NetCommService.getInstance();
                netComm.srvCDMAPrefMod(Integer.parseInt(NetWorkPanel.this.cdmaMode));
                String curCDMAMode = netComm.getCDMANetworkMod();
                if (!NetWorkPanel.this.cdmaMode.equalsIgnoreCase(curCDMAMode)) {
                    log.error("CDMA NetworkType Register failed");
                    if (!"".equals(curCDMAMode)) {
                        int i = 0;
                        while (i < NetWorkPanel.this.networkModeRadio.length) {
                            if (NetWorkPanel.this.networkModeRadio[i].getActionCommand().equals(curCDMAMode)) {
                                NetWorkPanel.this.networkModeRadio[i].setSelected(true);
                            } else {
                                NetWorkPanel.this.networkModeRadio[i].setSelected(false);
                            }
                            ++i;
                        }
                    }
                    final ShowInfoDialog enterPINDialog1 = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.this.dialog, NetWorkPanel.this.lb.getTools_5_Network_NetworkType_ApplyError());
                    Thread thr1 = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                log.info(e.toString());
                            }
                            enterPINDialog1.setVisible(false);
                            enterPINDialog1.dispose();
                        }
                    });
                    thr1.start();
                    enterPINDialog1.setVisible(true);
                }
            }
        });
        this.setButtonSize(this.application_button);
        GetButtonBackground.setButtonBackground(this.application_button);
        applicPanel.add(this.application_button);
        return applicPanel;
    }

    private JPanel getTabbedOne() {
        JPanel totalTabOnePanel = new JPanel(new BorderLayout(2, 2));
        totalTabOnePanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel tabbedOnePanel = new JPanel(new BorderLayout());
        tabbedOnePanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel contentPanel = new JPanel(new FlowLayout(0));
        contentPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel tabOne = new JPanel(new GridBagLayout());
        tabOne.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.networkTypeLabel = new JLabel(this.lb.getTools_5_Network_NetworkType2());
        this.networkTypeLabel.setFont(Tools.setFont());
        AModelA modea = new AModelA();
        this.networkBox = new JComboBox(modea);
        this.networkBox.setEditable(false);
        if (MutiDeviceService.curServer != null && nt.createOrUpdateXMLByBandAndOrderOrProvider(null, null)) {
            List listBand = nt.getOrder();
            Map tempmap = (Map)listBand.get(0);
            String name = tempmap.get("name").toString();
            String langid = tempmap.get("langid").toString();
            if ("".equals(langid.trim())) {
                if ("".equals(name.trim())) {
                    this.networkBox.addItem("");
                    this.networkBox.setSelectedItem("");
                } else {
                    this.networkBox.setSelectedItem(name);
                }
            } else if ("".equals(name.trim())) {
                this.networkBox.addItem("");
                this.networkBox.setSelectedItem("");
            } else {
                String str = CustomizeInit.languageMap.get(langid).toString();
                this.networkBox.setSelectedItem(str);
            }
        }
        this.networkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                if (NetWorkPanel.this.networkBox.getSelectedItem() != "" && NetWorkPanel.this.bandBox.getSelectedItem() != "") {
                    NetWorkPanel.this.application_button.setEnabled(true);
                }
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.application_button);
                NetWorkPanel.this.networkBox.removeItem("");
            }
        });
        this.bandLabel = new JLabel(this.lb.getTools_5_Network_NetworkType_Band());
        this.bandLabel.setFont(Tools.setFont());
        AModelB modeb = new AModelB();
        this.bandBox = new JComboBox(modeb);
        if (MutiDeviceService.curServer != null && nt.createOrUpdateXMLByBandAndOrderOrProvider(null, null)) {
            List listBand = nt.getBand();
            Map tempmap = (Map)listBand.get(0);
            String name = tempmap.get("name").toString();
            String langid = tempmap.get("langid").toString();
            if ("".equals(langid.trim())) {
                if ("".equals(name.trim())) {
                    this.bandBox.addItem("");
                    this.bandBox.setSelectedItem("");
                } else {
                    this.bandBox.setSelectedItem(name);
                }
            } else if ("".equals(name.trim())) {
                this.bandBox.addItem("");
                this.bandBox.setSelectedItem("");
            } else {
                String str = CustomizeInit.languageMap.get(langid).toString();
                this.bandBox.setSelectedItem(str);
            }
        }
        this.bandBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                if (NetWorkPanel.this.networkBox.getSelectedItem() != "" && NetWorkPanel.this.bandBox.getSelectedItem() != "") {
                    NetWorkPanel.this.application_button.setEnabled(true);
                }
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.application_button);
                NetWorkPanel.this.bandBox.removeItem("");
            }
        });
        JTextArea jTTemp = new JTextArea("");
        jTTemp.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createConnManagePanel_2()));
        jTTemp.setEnabled(false);
        jTTemp.setPreferredSize(new Dimension(400, 20));
        this.dialogControlBox = new CommandCheckBox(this.lb.getRoamig_dialog(), this);
        this.dialogControlBox.setFont(Tools.setFont());
        this.dialogControlBox.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        tabOne.add((Component)this.networkTypeLabel, new GridBagConstraints(0, 0, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 12, 6, 12), 0, 0));
        tabOne.add((Component)this.networkBox, new GridBagConstraints(0, 1, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 12, 6, 12), 0, 0));
        tabOne.add((Component)this.bandLabel, new GridBagConstraints(0, 2, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 12, 6, 12), 0, 0));
        tabOne.add((Component)this.bandBox, new GridBagConstraints(0, 3, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 12, 6, 12), 0, 0));
        if ("true".equals(Tools.getRoamingAlertControl())) {
            tabOne.add((Component)this.dialogControlBox, new GridBagConstraints(0, 4, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 12, 6, 12), 0, 0));
            this.dialogControlBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (!NetWorkPanel.this.application_button.isEnabled()) {
                        NetWorkPanel.this.application_button.setEnabled(true);
                    }
                }
            });
            if (Tools.getDialogControl().equals("true")) {
                this.dialogControlBox.setSelected(true);
            } else {
                this.dialogControlBox.setSelected(false);
            }
        }
        tabOne.add((Component)jTTemp, new GridBagConstraints(0, 4, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 12, 6, 12), 0, 0));
        contentPanel.add(tabOne);
        tabbedOnePanel.add((Component)contentPanel, "North");
        tabbedOnePanel.add((Component)this.getApplPanel(), "South");
        totalTabOnePanel.add((Component)tabbedOnePanel, "West");
        return totalTabOnePanel;
    }

    private JPanel getTabbedTwo() {
        JPanel tabTwo = new JPanel(new BorderLayout());
        tabTwo.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel searchPanel = new JPanel(new GridLayout(2, 1));
        this.autoSearchRadio = new JRadioButton(this.lb.getTools_5_Network_RegistrationMode_Auto());
        this.autoSearchRadio.setSize(200, 26);
        this.autoSearchRadio.setFont(Tools.setFont());
        this.autoSearchRadio.addActionListener(new RadioButtonAction());
        this.autoSearchRadio.setSelected(true);
        this.manualSearchRadio = new JRadioButton(this.lb.getTools_5_Network_RegistrationMode_Manual());
        this.manualSearchRadio.setSize(200, 26);
        this.manualSearchRadio.setFont(Tools.setFont());
        this.manualSearchRadio.addActionListener(new RadioButtonAction());
        this.autoSearchRadio.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.manualSearchRadio.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.group = new ButtonGroup();
        this.group.add(this.autoSearchRadio);
        this.group.add(this.manualSearchRadio);
        searchPanel.add(this.autoSearchRadio);
        searchPanel.add(this.manualSearchRadio);
        searchPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel operatorPanel = new JPanel();
        operatorPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.hide.setVisible(false);
        this.group.add(this.hide);
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        Vector<String> colNamesV = new Vector<String>();
        colNamesV.add(this.lb.getTools_5_Network_RegistrationMode_OperatorName());
        defaultTableModel.setColumnIdentifiers(colNamesV);
        this.refresh_button = new JButton(this.lb.getTools_5_Network_RegistrationMode_Refresh());
        this.refresh_button.setEnabled(false);
        GetButtonBackground.setButtonBackground(this.refresh_button);
        this.refresh_button.setFont(Tools.setFont());
        this.register_button = new JButton(this.lb.getTools_5_Network_RegistrationMode_Register());
        this.register_button.setEnabled(false);
        GetButtonBackground.setButtonBackground(this.register_button);
        this.register_button.setFont(Tools.setFont());
        this.refresh_button.setEnabled(false);
        this.register_button.setEnabled(false);
        if (MutiDeviceService.curServer != null && !TextUtil.checkContainStr(PublicConfig.PinStatus, PublicConfig.pinStateFlag3) && TimerCall.statusCall != 0) {
            String temp = this.netCommService.getRegisterInfo();
            if (!"".equals(temp)) {
                if ("1".equals(temp.substring(0, 1))) {
                    this.manualSearchRadio.setSelected(true);
                    this.refresh_button.setEnabled(true);
                    this.register_button.setEnabled(true);
                    GetButtonBackground.setButtonBackground(this.refresh_button);
                    GetButtonBackground.setButtonBackground(this.register_button);
                    try {
                        if (temp.indexOf("\"") > -1) {
                            listProvider = new ArrayList();
                            temp = temp.replace("\"", "");
                            String[] provider2 = temp.split(",");
                            listProvider.add(provider2[0]);
                            listProvider.add(provider2[1]);
                            listProvider.add(provider2[2]);
                            listProvider.add(provider2[3]);
                        }
                    }
                    catch (Exception e) {
                        log.info(e.toString());
                    }
                } else {
                    listProvider = null;
                }
            }
            if (listProvider != null) {
                Vector<String> rowDataV = new Vector<String>();
                try {
                    this.info1 = listProvider.get(0).toString();
                    this.info2 = listProvider.get(1).toString();
                    String info3 = listProvider.get(2).toString();
                    String info4 = listProvider.get(3).toString();
                    String gg = "(2G)";
                    String ggg = "(3G)";
                    String tempinfo3 = info3;
                    tempinfo3 = CustomizeInit.getOperatorNameByNumber(info3);
                    tempinfo3 = info4.equals("0") ? String.valueOf(tempinfo3) + gg : String.valueOf(tempinfo3) + ggg;
                    rowDataV.add(tempinfo3);
                    defaultTableModel.addRow(rowDataV);
                    this.operatorValue.add(info3);
                    this.operatorMode.add(info4);
                }
                catch (RuntimeException e1) {
                    log.info(e1.toString());
                }
            }
        }
        this.boxTable = new JTable(defaultTableModel);
        log.info("the search net table has select : [" + this.boxTable.getSelectedRow() + "]");
        if (this.boxTable.getSelectedRow() > -1) {
            this.register_button.setEnabled(true);
        } else {
            this.register_button.setEnabled(false);
        }
        GetButtonBackground.setButtonBackground(this.register_button);
        GetButtonBackground.setButtonBackground(this.refresh_button);
        this.boxTable.setShowGrid(false);
        this.boxTable.setAutoscrolls(false);
        this.boxTable.setColumnSelectionAllowed(false);
        this.boxTable.setShowHorizontalLines(false);
        this.boxTable.setShowVerticalLines(false);
        this.boxTable = new JTable(defaultTableModel);
        this.boxTable.setShowGrid(false);
        this.boxTable.getTableHeader().setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_border()));
        this.boxTable.getTableHeader().setForeground(Color.BLACK);
        this.boxTable.getTableHeader().setReorderingAllowed(false);
        this.boxTable.setPreferredScrollableViewportSize(new Dimension(485, 400));
        this.boxTable.setShowGrid(false);
        JScrollPane boxScrollPane = new JScrollPane(this.boxTable);
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar bar3 = boxScrollPane.getHorizontalScrollBar();
            JScrollBar bar4 = boxScrollPane.getVerticalScrollBar();
            bar3.setUI(new VScrollBarUI());
            bar4.setUI(new HScrollBarUI());
        }
        boxScrollPane.setBorder(new LineBorder(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_border()), 1, true));
        boxScrollPane.getViewport().setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_background_Color()));
        operatorPanel.add((Component)boxScrollPane, "Center");
        boxScrollPane.setViewportView(this.boxTable);
        JPanel commandPanel = new JPanel(new FlowLayout(2, 12, 12));
        commandPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.refresh_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MutiDeviceService.curServer == null) {
                    return;
                }
                final DefaultTableModel defaultTableModel = new DefaultTableModel(){

                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }
                };
                final Vector<String> colNamesV = new Vector<String>();
                colNamesV.add(NetWorkPanel.this.lb.getTools_5_Network_RegistrationMode_OperatorName());
                listProvider = null;
                final ShowInfoDialog enterPINDialog = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.this.dialog, NetWorkPanel.this.lb.getTools_5_Network_Search());
                Thread thr = new Thread(new Runnable(){

                    public void run() {
                        (this).NetWorkPanel.this.nb.setOperatorName((this).NetWorkPanel.this.rfc.searchNetworkManual(1));
                        List listAll = (this).NetWorkPanel.this.nb.getOperatorName();
                        ArrayList<String> rowDataV = new ArrayList<String>();
                        List list3 = new ArrayList();
                        List list4 = new ArrayList();
                        try {
                            list3 = (List)listAll.get(3);
                            list4 = (List)listAll.get(4);
                        }
                        catch (Exception e1) {
                            log.info(e1.toString());
                        }
                        String gg = "(2G)";
                        String ggg = "(3G)";
                        ArrayList<String> list3Temp = new ArrayList<String>();
                        ArrayList<String> list4Temp = new ArrayList<String>();
                        if (list3.size() > 0) {
                            while (list3.size() > 0) {
                                String temp = list3.get(0).toString();
                                String mode = list4.get(0).toString();
                                list3.remove(0);
                                list4.remove(0);
                                boolean flag = false;
                                int k = 0;
                                while (k < list3.size()) {
                                    if (temp.equals(list3.get(k).toString())) {
                                        list3.remove(k);
                                        list4.remove(k);
                                        list3Temp.add(temp);
                                        list4Temp.add(temp);
                                        temp = CustomizeInit.getOperatorNameByNumber(temp);
                                        rowDataV.add(String.valueOf(temp) + gg + ggg);
                                        flag = true;
                                    }
                                    ++k;
                                }
                                if (flag) continue;
                                list3Temp.add(temp);
                                list4Temp.add(temp);
                                temp = CustomizeInit.getOperatorNameByNumber(temp);
                                if (mode.equals("0")) {
                                    rowDataV.add(String.valueOf(temp) + gg);
                                    continue;
                                }
                                rowDataV.add(String.valueOf(temp) + ggg);
                            }
                        }
                        try {
                            listAll.remove(listAll.size() - 1);
                            listAll.remove(listAll.size() - 1);
                            listAll.add(list3Temp);
                            listAll.add(list4Temp);
                        }
                        catch (Exception e) {
                            log.info("the device has not sim:" + e.toString());
                        }
                        defaultTableModel.setColumnIdentifiers(colNamesV);
                        if (rowDataV != null) {
                            int j = 0;
                            while (j < rowDataV.size()) {
                                Vector<String> rowDataV1 = new Vector<String>();
                                rowDataV1.add(rowDataV.get(j).toString());
                                defaultTableModel.addRow(rowDataV1);
                                ++j;
                            }
                        }
                        NetWorkPanel.this.boxTable.setModel(defaultTableModel);
                        NetWorkPanel.this.boxTable.setSelectionMode(0);
                        NetWorkPanel.this.register_button.updateUI();
                        enterPINDialog.setVisible(false);
                        enterPINDialog.dispose();
                    }
                });
                thr.start();
                enterPINDialog.setVisible(true);
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.register_button);
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.refresh_button);
            }
        });
        ListSelectionModel selectModel = this.boxTable.getSelectionModel();
        selectModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                log.info("the search net table has select :" + NetWorkPanel.this.boxTable.getSelectedRow() + "]");
                if (NetWorkPanel.this.boxTable.getSelectedRow() > -1) {
                    NetWorkPanel.this.register_button.setEnabled(true);
                } else {
                    NetWorkPanel.this.register_button.setEnabled(false);
                }
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.register_button);
                GetButtonBackground.setButtonBackground(NetWorkPanel.this.refresh_button);
            }
        });
        this.register_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (MutiDeviceService.curServer == null) {
                    return;
                }
                if (NetWorkPanel.this.boxTable.getSelectedRow() < 0) {
                    return;
                }
                NetWorkPanel.this.registerInfo = NetWorkPanel.this.netComm2.getRegisterInfo();
                log.info("registerInfo==-----------------------------" + NetWorkPanel.this.registerInfo);
                final ShowInfoDialog enterPINDialog = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.this.dialog, NetWorkPanel.this.lb.getTools_5_Network_Regist());
                Thread thr = new Thread(new Runnable(){

                    public void run() {
                        String operatorName;
                        String temp2;
                        String temp1;
                        int w;
                        int i = 0;
                        while (i < 5) {
                            if ((this).NetWorkPanel.this.registerInfo.indexOf("\"") > -1) break;
                            try {
                                Thread.sleep(1000L);
                                (this).NetWorkPanel.this.registerInfo = (this).NetWorkPanel.this.netComm2.getRegisterInfo();
                                log.info(String.valueOf(i) + "registerInfo==-----------------------------" + (this).NetWorkPanel.this.registerInfo);
                            }
                            catch (InterruptedException e) {
                                log.info(e.toString());
                            }
                            ++i;
                        }
                        List listAll = (this).NetWorkPanel.this.nb.getOperatorName();
                        if (listProvider == null) {
                            (this).NetWorkPanel.this.operatorValue = (List)listAll.get(3);
                            (this).NetWorkPanel.this.operatorMode = (List)listAll.get(4);
                            w = NetWorkPanel.this.boxTable.getSelectedRow();
                            temp1 = (this).NetWorkPanel.this.operatorValue.get(w).toString();
                            temp2 = (this).NetWorkPanel.this.operatorMode.get(w).toString();
                            operatorName = String.valueOf(temp1) + "," + temp2;
                            (this).NetWorkPanel.this.nb.setRegisterResult((this).NetWorkPanel.this.rfc.registerResult(operatorName));
                            NetWorkPanel.this.flag = (this).NetWorkPanel.this.nb.isRegisterResult();
                            log.info("if----" + NetWorkPanel.this.flag);
                        } else {
                            w = NetWorkPanel.this.boxTable.getSelectedRow();
                            temp1 = (this).NetWorkPanel.this.operatorValue.get(w).toString();
                            if (temp1.indexOf("(2G)") > -1) {
                                temp1 = temp1.substring(0, temp1.indexOf("(2G)"));
                            }
                            if (temp1.indexOf("(3G)") > -1) {
                                temp1 = temp1.substring(0, temp1.indexOf("(3G)"));
                            }
                            temp2 = (this).NetWorkPanel.this.operatorMode.get(w).toString();
                            operatorName = String.valueOf(temp1) + "," + temp2;
                            (this).NetWorkPanel.this.nb.setRegisterResult((this).NetWorkPanel.this.rfc.registerResult(operatorName));
                            NetWorkPanel.this.flag = (this).NetWorkPanel.this.nb.isRegisterResult();
                            log.info("else----" + NetWorkPanel.this.flag);
                        }
                        enterPINDialog.setVisible(false);
                        enterPINDialog.dispose();
                        if (!NetWorkPanel.this.flag) {
                            int i2;
                            String title;
                            String message;
                            Object[] obj;
                            if (CommServerThread.currentSystem.equals("Mac OS X")) {
                                obj = new Object[]{(this).NetWorkPanel.this.lb.getTools_3_OK(), (this).NetWorkPanel.this.lb.getTools_3_Cancel()};
                                message = (this).NetWorkPanel.this.lb.getTools_5_Network_Return();
                                title = (this).NetWorkPanel.this.lb.getTools_5_ProfileManagement_Delete_Prompt();
                                i2 = JUTPSOptionDialog.showConfirmDialog(NetWorkPanel.this.dialog, message, title, 0);
                            } else {
                                obj = new Object[]{(this).NetWorkPanel.this.lb.getTools_3_OK(), (this).NetWorkPanel.this.lb.getTools_3_Cancel()};
                                message = (this).NetWorkPanel.this.lb.getTools_5_Network_Return();
                                title = (this).NetWorkPanel.this.lb.getTools_5_ProfileManagement_Delete_Prompt();
                                i2 = JUTPSOptionDialog.showConfirmDialog(NetWorkPanel.this.dialog, message, title, 0);
                            }
                            if (i2 == 0) {
                                ShowInfoDialog enterPINDialog2 = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.this.dialog, (this).NetWorkPanel.this.lb.getTools_5_Network_Regist());
                                Thread thr = new Thread(new Runnable(this, enterPINDialog2){
                                    final /* synthetic */ 1 this$2;
                                    private final /* synthetic */ ShowInfoDialog val$enterPINDialog;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$enterPINDialog = showInfoDialog;
                                    }

                                    public void run() {
                                        int i = 0;
                                        while (i < 5) {
                                            if (9.access$0(1.access$0(this.this$2)).registerInfo.indexOf("\"") > -1) break;
                                            try {
                                                Thread.sleep(2000L);
                                                9.access$0(1.access$0(this.this$2)).registerInfo = 9.access$0(1.access$0(this.this$2)).netComm2.getRegisterInfo();
                                                log.info(String.valueOf(i) + "registerInfo==-----------------------------" + 9.access$0(1.access$0(this.this$2)).registerInfo);
                                            }
                                            catch (InterruptedException e) {
                                                log.info(e.toString());
                                            }
                                            ++i;
                                        }
                                        boolean tempboolan = false;
                                        tempboolan = 9.access$0(1.access$0(this.this$2)).rfc.registerResult2(9.access$0(1.access$0(this.this$2)).registerInfo);
                                        this.val$enterPINDialog.setVisible(false);
                                        this.val$enterPINDialog.dispose();
                                        if (tempboolan) {
                                            ShowInfoDialog enterPINDialog1 = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.access$11(9.access$0(1.access$0(this.this$2))), 9.access$0(1.access$0(this.this$2)).lb.getTools_5_Network_Success());
                                            Thread thr1 = new Thread(new Runnable(this, enterPINDialog1){
                                                final /* synthetic */ 1 this$3;
                                                private final /* synthetic */ ShowInfoDialog val$enterPINDialog1;
                                                {
                                                    this.this$3 = var1_1;
                                                    this.val$enterPINDialog1 = showInfoDialog;
                                                }

                                                public void run() {
                                                    try {
                                                        Thread.sleep(3000L);
                                                    }
                                                    catch (InterruptedException e) {
                                                        log.info(e.toString());
                                                    }
                                                    NetWorkPanel.access$14(9.access$0(1.access$0(1.access$0(this.this$3))), false);
                                                    this.val$enterPINDialog1.setVisible(false);
                                                    this.val$enterPINDialog1.dispose();
                                                }
                                            });
                                            thr1.start();
                                            enterPINDialog1.setVisible(true);
                                        } else {
                                            ShowInfoDialog enterPINDialog1 = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.access$11(9.access$0(1.access$0(this.this$2))), 9.access$0(1.access$0(this.this$2)).lb.getTools_5_Network_Regist_Fail());
                                            Thread thr1 = new Thread(new Runnable(this, enterPINDialog1){
                                                final /* synthetic */ 1 this$3;
                                                private final /* synthetic */ ShowInfoDialog val$enterPINDialog1;
                                                {
                                                    this.this$3 = var1_1;
                                                    this.val$enterPINDialog1 = showInfoDialog;
                                                }

                                                public void run() {
                                                    try {
                                                        Thread.sleep(3000L);
                                                    }
                                                    catch (InterruptedException e) {
                                                        log.info(e.toString());
                                                    }
                                                    NetWorkPanel.access$14(9.access$0(1.access$0(1.access$0(this.this$3))), false);
                                                    this.val$enterPINDialog1.setVisible(false);
                                                    this.val$enterPINDialog1.dispose();
                                                }
                                            });
                                            thr1.start();
                                            enterPINDialog1.setVisible(true);
                                        }
                                    }

                                    static /* synthetic */ 1 access$0(1 var0) {
                                        return var0.this$2;
                                    }
                                });
                                thr.start();
                                enterPINDialog2.setVisible(true);
                            }
                        } else {
                            ShowInfoDialog enterPINDialog1 = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.this.dialog, (this).NetWorkPanel.this.lb.getTools_5_Network_Success());
                            Thread thr1 = new Thread(new Runnable(this, enterPINDialog1){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ ShowInfoDialog val$enterPINDialog1;
                                {
                                    this.this$2 = var1_1;
                                    this.val$enterPINDialog1 = showInfoDialog;
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(3000L);
                                    }
                                    catch (InterruptedException e) {
                                        log.info(e.toString());
                                    }
                                    this.val$enterPINDialog1.setVisible(false);
                                    this.val$enterPINDialog1.dispose();
                                }
                            });
                            thr1.start();
                            enterPINDialog1.setVisible(true);
                        }
                    }

                    static /* synthetic */ 9 access$0(1 var0) {
                        return var0.this;
                    }
                });
                thr.start();
                enterPINDialog.setVisible(true);
            }
        });
        this.setButtonSize(this.refresh_button);
        this.setButtonSize(this.register_button);
        commandPanel.add(this.refresh_button);
        commandPanel.add(this.register_button);
        commandPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        tabTwo.add((Component)searchPanel, "North");
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X") && System.getProperty("os.version").indexOf("10.5") > -1) {
            tabTwo.add((Component)operatorPanel, "West");
        } else {
            tabTwo.add((Component)operatorPanel, "Center");
        }
        tabTwo.add((Component)commandPanel, "South");
        this.boxTable.getTableHeader().setForeground(Color.BLACK);
        return tabTwo;
    }

    private JPanel getApplPanel() {
        JPanel applicPanel = new JPanel(new FlowLayout(2, 12, 12));
        applicPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.application_button.setEnabled(false);
        this.application_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetWorkPanel.this.application_button.setEnabled(false);
                if (MutiDeviceService.curServer == null) {
                    return;
                }
                int indexOrder = NetWorkPanel.this.networkBox.getSelectedIndex();
                int indexBand = NetWorkPanel.this.bandBox.getSelectedIndex();
                List list1 = NetWorkPanel.this.nb.getNetworkType();
                List list2 = NetWorkPanel.this.nb.getChannel();
                String networkType = "";
                String channel = "";
                ChannelBean mapOrder = (ChannelBean)list1.get(indexOrder);
                networkType = mapOrder.getValue();
                String[] strPropertiesValueOrder = new String[]{mapOrder.getAct(), mapOrder.getName(), mapOrder.getValue(), mapOrder.getLangid()};
                ChannelBean bandBean = (ChannelBean)list2.get(indexBand);
                channel = bandBean.getValue();
                String[] strPropertiesValueBand = new String[]{bandBean.getAct(), bandBean.getName(), bandBean.getValue(), bandBean.getLangid()};
                NetWorkPanel.this.nb.setNetworkTypeRegister(nt.networkTypeRegister(networkType, channel));
                if (NetWorkPanel.this.nb.isNetworkTypeRegister()) {
                    log.info("NetworkType Register succeed");
                } else {
                    log.info("NetworkType Register failed");
                    final ShowInfoDialog enterPINDialog1 = ShowInfoDialog.getShowInfoDialog(null, NetWorkPanel.this.dialog, NetWorkPanel.this.lb.getTools_5_Network_NetworkType_ApplyError());
                    Thread thr1 = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                log.info(e.toString());
                            }
                            NetWorkPanel.this.application_button.setEnabled(true);
                            enterPINDialog1.setVisible(false);
                            enterPINDialog1.dispose();
                            NetWorkPanel.this.application_button.setEnabled(true);
                        }
                    });
                    thr1.start();
                    enterPINDialog1.setVisible(true);
                }
                nt.createOrUpdateXMLByBandAndOrderOrProvider(strPropertiesValueBand, strPropertiesValueOrder);
                if ("true".equals(Tools.getRoamingAlertControl())) {
                    NetWorkPanel.saveRoamSetting(NetWorkPanel.this.dialogControlBox, false);
                }
            }
        });
        this.setButtonSize(this.application_button);
        applicPanel.add(this.application_button);
        return applicPanel;
    }

    public static void saveRoamSetting(JCheckBox dialogControlBox, boolean isOnAlertWindow) {
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(false);
            comm = new XMLTool("config/data/SmsCue.xml", "smscue");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String smsNodeProPath = "smscue/cue[@name=\"";
        smsNodeProPath = String.valueOf(smsNodeProPath) + "dialogcontrol\"]";
        String value = null;
        value = dialogControlBox.isSelected() ? (!isOnAlertWindow ? "true" : "false") : (!isOnAlertWindow ? "false" : "true");
        String[] proValue = new String[]{"dialogcontrol", value};
        Tools.logToControl("out", smsNodeProPath);
        comm.updateNodeMultiPropertiesValue(smsNodeProPath, proName, proValue);
    }

    private void setButtonSize(JButton button) {
        button.setPreferredSize(new Dimension(130, 25));
        button.setMaximumSize(new Dimension(130, 25));
        button.setMinimumSize(new Dimension(130, 25));
    }

    public static void setOrderAndBand(String receiveContext) {
        String str;
        String langid;
        String value2;
        String value;
        String name;
        String act;
        List list = nt.getOrderByChannelBean();
        ChannelBean channelBean = new ChannelBean();
        ArrayList<String> listChannel = new ArrayList<String>();
        ArrayList<String> listOrder = new ArrayList<String>();
        String order = "";
        String orderBand = receiveContext;
        if (!"".equals(orderBand)) {
            String[] temp = orderBand.split(",");
            order = "2".equals(temp[0]) ? temp[1] : temp[0];
        }
        String band = "";
        if (!"".equals(orderBand)) {
            String[] temp = orderBand.split(",");
            if (temp.length >= 2) {
                band = temp[2];
            } else {
                log.info("call netCommService.getcurrentOrderAndBand(),the result error");
            }
        }
        band = TextUtil.parseStr(band);
        list = nt.getOrderByDevice();
        int i = 0;
        while (i < list.size()) {
            channelBean = (ChannelBean)list.get(i);
            act = channelBean.getAct();
            name = channelBean.getName();
            value2 = value = channelBean.getValue();
            langid = channelBean.getLangid();
            Tools.logToControl("out", "order2=" + i + " act=" + act + " name=" + name + " value=" + value + " langid=" + langid);
            if ("".equals(langid.trim())) {
                listOrder.add(name);
            } else {
                str = CustomizeInit.languageMap.get(langid).toString();
                listOrder.add(str);
            }
            if (value2.indexOf("0x") > -1) {
                value2 = value2.substring(value2.indexOf("0x") + 2, value2.length());
                value2 = String.valueOf(TextUtil.stringFormat(value2, 16));
            }
            if (value2.equals(order)) {
                String[] order2 = new String[]{act, name, value, langid};
                nt.createOrUpdateXMLByBandAndOrderOrProvider(null, order2);
            }
            ++i;
        }
        list = nt.getBandByDevice();
        i = 0;
        while (i < list.size()) {
            channelBean = (ChannelBean)list.get(i);
            act = channelBean.getAct();
            name = channelBean.getName();
            value2 = value = channelBean.getValue();
            langid = channelBean.getLangid();
            Tools.logToControl("out", "band2=" + i + " act=" + act + " name=" + name + " value=" + value + " langid=" + langid);
            if ("".equals(langid.trim())) {
                listChannel.add(name);
            } else {
                str = CustomizeInit.languageMap.get(langid).toString();
                listChannel.add(str);
            }
            if (value2.indexOf("0x") > -1) {
                value2 = value2.substring(value2.indexOf("0x") + 2, value2.length());
                value2 = TextUtil.parseStr(value2);
            }
            if (value2.equals(band)) {
                String[] band2 = new String[]{act, name, value, langid};
                nt.createOrUpdateXMLByBandAndOrderOrProvider(band2, null);
            }
            ++i;
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (!event.getSource().equals(NetWorkPanel.this.ok_button)) {
                event.getSource().equals(NetWorkPanel.this.cancel_button);
            }
        }
    }

    private class RadioButtonAction
    implements ActionListener {
        private RadioButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource().equals(NetWorkPanel.this.autoSearchRadio)) {
                listProvider = null;
                NetWorkPanel.this.refresh_button.setEnabled(false);
                NetWorkPanel.this.register_button.setEnabled(false);
                DefaultTableModel defaultTableModel = new DefaultTableModel();
                Vector<String> colNamesV = new Vector<String>();
                colNamesV.add(NetWorkPanel.this.lb.getTools_5_Network_RegistrationMode_OperatorName());
                defaultTableModel.setColumnIdentifiers(colNamesV);
                NetWorkPanel.this.boxTable.setModel(defaultTableModel);
                NetWorkPanel.this.nb.searchNetworkAuto(0);
            } else if (event.getSource().equals(NetWorkPanel.this.manualSearchRadio)) {
                NetWorkPanel.this.refresh_button.setEnabled(true);
            }
            GetButtonBackground.setButtonBackground(NetWorkPanel.this.refresh_button);
            GetButtonBackground.setButtonBackground(NetWorkPanel.this.register_button);
        }
    }

    private class AModelA
    extends DefaultComboBoxModel {
        AModelA() {
            if (MutiDeviceService.curServer == null) {
                return;
            }
            NetWorkPanel.this.nb = new NetworkBean();
            NetWorkPanel.this.rfc = new RegisterFashionChoice();
            NetWorkPanel.this.nb.setNetworkType(nt.getOrderByChannelBean());
            List list = NetWorkPanel.this.nb.getNetworkType();
            ChannelBean channelBean = new ChannelBean();
            ArrayList<String> listOrder = new ArrayList<String>();
            int i = 0;
            while (i < list.size()) {
                String value;
                channelBean = (ChannelBean)list.get(i);
                String act = channelBean.getAct();
                String name = channelBean.getName();
                String value2 = value = channelBean.getValue();
                String langid = channelBean.getLangid();
                if ("".equals(langid.trim())) {
                    listOrder.add(name);
                } else {
                    String str = CustomizeInit.languageMap.get(langid).toString();
                    listOrder.add(str);
                }
                if (value2.indexOf("0x") > -1) {
                    value2 = value2.substring(value2.indexOf("0x") + 2, value2.length());
                    value2 = String.valueOf(TextUtil.stringFormat(value2, 16));
                }
                ++i;
            }
            Iterator iterator = listOrder.iterator();
            while (iterator.hasNext()) {
                this.addElement(iterator.next());
            }
        }
    }

    private class AModelB
    extends DefaultComboBoxModel {
        AModelB() {
            if (MutiDeviceService.curServer == null) {
                return;
            }
            NetWorkPanel.this.nb.setChannel(nt.getBandByChannelBean());
            List list = NetWorkPanel.this.nb.getChannel();
            ChannelBean channelBean = new ChannelBean();
            ArrayList<String> listChannel = new ArrayList<String>();
            int i = 0;
            while (i < list.size()) {
                String value;
                channelBean = (ChannelBean)list.get(i);
                String act = channelBean.getAct();
                String name = channelBean.getName();
                String value2 = value = channelBean.getValue();
                String langid = channelBean.getLangid();
                if ("".equals(langid.trim())) {
                    listChannel.add(name);
                } else {
                    String str = CustomizeInit.languageMap.get(langid).toString();
                    listChannel.add(str);
                }
                if (value2.indexOf("0x") > -1) {
                    value2 = value2.substring(value2.indexOf("0x") + 2, value2.length());
                    value2 = TextUtil.parseStr(value2);
                }
                ++i;
            }
            Iterator iterator = listChannel.iterator();
            while (iterator.hasNext()) {
                this.addElement(iterator.next());
            }
        }
    }
}

