/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class MpMenuUI
extends BasicMenuUI {
    protected Integer menuBarHeight;
    protected boolean hotTrackingOn;
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private boolean flag = false;

    public static ComponentUI createUI(JComponent x) {
        return new MpMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.menuBarHeight = UIManager.getInt("MenuBar.height");
        Object obj = UIManager.get("MenuBar.rolloverEnabled");
        this.hotTrackingOn = obj instanceof Boolean ? (Boolean)obj : true;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        JMenu menu = (JMenu)menuItem;
        ButtonModel model = menu.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menu.getWidth();
        int menuHeight = menu.getHeight();
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Color highlight = table.getColor("controlLtHighlight");
        Color shadow = table.getColor("controlShadow");
        g.setColor(menu.getBackground());
        g.fillRect(0, 0, menuWidth, menuHeight);
        if (menu.isOpaque()) {
            if (model.isArmed() || model.isSelected()) {
                g.setColor(shadow);
                g.drawLine(0, 0, menuWidth - 1, 0);
                g.drawLine(0, 0, 0, menuHeight - 2);
                g.setColor(highlight);
                g.drawLine(menuWidth - 1, 0, menuWidth - 1, menuHeight - 2);
                g.drawLine(0, menuHeight - 2, menuWidth - 1, menuHeight - 2);
            } else if (model.isRollover() && model.isEnabled()) {
                boolean otherMenuSelected = false;
                MenuElement[] menus = ((JMenuBar)menu.getParent()).getSubElements();
                int i = 0;
                while (i < menus.length) {
                    if (((JMenuItem)menus[i]).isSelected()) {
                        otherMenuSelected = true;
                        break;
                    }
                    ++i;
                }
                if (!otherMenuSelected) {
                    g.setColor(this.selectionBackground);
                    g.fillRect(0, 0, menuWidth, menuHeight);
                }
            }
        }
        g.setColor(oldColor);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        JMenu menu = (JMenu)menuItem;
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        boolean paintRollover = model.isRollover();
        if (paintRollover && menu.isTopLevelMenu()) {
            MenuElement[] menus = ((JMenuBar)menu.getParent()).getSubElements();
            int i = 0;
            while (i < menus.length) {
                if (((JMenuItem)menus[i]).isSelected()) {
                    paintRollover = false;
                    break;
                }
                ++i;
            }
        }
        if (model.isSelected() && !menu.isTopLevelMenu() || paintRollover || model.isArmed() || model.isSelected()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new GradientPaint(new Point2D.Float(0.0f, 0.0f), ChangeColor.getColor(this.cb.getAppFrame_MenuMouseOn()), new Point2D.Float(0.0f, menuItem.getHeight() / 2), ChangeColor.getColor(this.cb.getAppFrame_MenuMouseOn()), true));
            g2d.fillRoundRect(0, 0, menuItem.getWidth(), menuItem.getHeight(), 3, 3);
        }
        g.setColor(ChangeColor.getColor(this.cb.getAppFrame_menu_Foreground()));
        WindowsGraphicsUtils.paintText((Graphics)g, (AbstractButton)menuItem, (Rectangle)textRect, (String)text, (int)0);
        g.setColor(oldColor);
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new WindowsMouseInputHandler();
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension d = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (c instanceof JMenu && ((JMenu)c).isTopLevelMenu() && this.menuBarHeight != null && d.height < this.menuBarHeight) {
            d.height = this.menuBarHeight;
        }
        return d;
    }

    protected class WindowsMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected WindowsMouseInputHandler() {
            super(MpMenuUI.this);
        }

        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            JMenu menu = (JMenu)evt.getSource();
            if (MpMenuUI.this.hotTrackingOn && menu.isTopLevelMenu() && menu.isRolloverEnabled()) {
                menu.getModel().setRollover(true);
                MpMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            JMenu menu = (JMenu)evt.getSource();
            ButtonModel model = menu.getModel();
            if (menu.isRolloverEnabled()) {
                model.setRollover(false);
                MpMenuUI.this.menuItem.repaint();
            }
        }
    }
}

