/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.business.device.DeviceService;
import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.InstanceControl2;
import com.huawei.mobilePartner.common.util.JreVerControl;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import com.huawei.mobilePartner.data.comm.server.MacSignalHandler;
import com.huawei.mobilePartner.gui.ui.SystemInitializationPrompt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;

public class MobilePartner {
    private static LogConfig loggerStatic = Log.getLog(MobilePartner.class);
    static String devstr = null;
    static int threadIndex = 0;
    static DeviceService deviceService = DeviceService.getInstance();
    static FileLock runningFlag = null;

    public static void main(String[] args) {
        File mobileATFile;
        if (System.getProperty("os.name").equalsIgnoreCase("Linux") && MobilePartner.checkIsRunning()) {
            loggerStatic.error("Program is running ! ");
            System.exit(0);
            return;
        }
        if (System.getProperty("os.name").equalsIgnoreCase("Linux") && InstanceControl2.checkSocket()) {
            loggerStatic.error("Program is running ! ");
            System.exit(0);
            return;
        }
        JreVerControl verControl = new JreVerControl();
        boolean isUnderVer = verControl.isUnderVer();
        String fileStr = System.getProperty("user.dir");
        File mobileFile = new File(String.valueOf(fileStr) + "/log/mobilePartner.txt");
        if (mobileFile.exists()) {
            OutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(mobileFile);
                    output.write("".getBytes());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((mobileATFile = new File(String.valueOf(fileStr) + "/log/mobilePartnerAT.txt")).exists()) {
            OutputStream outputAT = null;
            try {
                try {
                    outputAT = new FileOutputStream(mobileATFile);
                    outputAT.write("".getBytes());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            finally {
                try {
                    outputAT.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!isUnderVer) {
            try {
                final SystemInitializationPrompt sysinitpromt = new SystemInitializationPrompt();
                Thread thr1 = new Thread(new Runnable(){

                    public void run() {
                        loggerStatic.info("start main from the MobilePartner");
                        Tools test = new Tools();
                        ConfigInterface.reportList = test.getInitiveReportCMDList();
                        CommServerThread commThread = CommServerThread.getCommServerThread(sysinitpromt);
                        if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
                            CommServerThread.checkDialStatusBeforeStartup(sysinitpromt);
                            CommServerThread.addJNotify();
                            CommServerThread.addpppdJNotify();
                            commThread.installShutdownHook();
                            commThread.startPortCheck();
                        }
                        if (System.getProperty("os.name").equals("Mac OS X") && !System.getProperty("os.version").contains("10.4")) {
                            MacSignalHandler.install("USR1");
                            MacSignalHandler.install("USR2");
                            MacSignalHandler.install("TERM");
                        }
                        commThread.start();
                    }
                });
                thr1.start();
                sysinitpromt.setVisible(true);
                InstanceControl2 ic = new InstanceControl2();
                ic.run();
            }
            catch (Exception ee) {
                loggerStatic.info(ee.toString());
            }
        }
    }

    static boolean checkIsRunning() {
        String lockFilePath = String.valueOf(System.getProperty("user.dir")) + "/config/LockFile";
        File lockFile = null;
        boolean isRunning = false;
        lockFile = new File(lockFilePath);
        if (!lockFile.exists()) {
            try {
                lockFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return isRunning;
            }
        }
        try {
            runningFlag = new FileOutputStream(lockFilePath).getChannel().tryLock();
            if (runningFlag == null) {
                isRunning = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            lockFile.delete();
        }
        return isRunning;
    }
}

