/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.business.apn.APNEvent;
import com.huawei.mobilePartner.business.apn.DeleteAPN;
import com.huawei.mobilePartner.business.apn.ImportAPN;
import com.huawei.mobilePartner.business.apn.NewAPN;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.JUTPSOptionDialog;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.CheckNode;
import com.huawei.mobilePartner.gui.ui.CheckRenderer;
import com.huawei.mobilePartner.gui.ui.CustomizeFileChooser;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.ImportDialog;
import com.huawei.mobilePartner.gui.ui.ImportNodeSelectionListener;
import com.huawei.mobilePartner.gui.ui.JAVAFileFilter;
import com.huawei.mobilePartner.gui.ui.OKButtonActionListener;
import com.huawei.mobilePartner.gui.ui.OptionPanel;
import com.huawei.mobilePartner.gui.ui.UICommon;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ImportPanel
extends JPanel {
    private LogConfig log = Log.getLog(ImportPanel.class);
    private JButton cancel;
    private ImportDialog dialog;
    private List importAPNList;
    private APNEvent apnEvent;
    private List treeSelectList;
    private ImportAPN importAPN;
    private boolean flag = false;
    private JFileChooser fileChooser = null;
    private int result;
    private String filePath;
    public JTree exportTree;
    private DefaultMutableTreeNode rootNode;
    private CheckNode[] nodes = null;
    private static boolean chickFlag = false;
    public String updateNodePath = "utpsdoc/ProfileGroup[@type=\"DialUp\"]/Profile[@name=\"";
    LanguageBean lb = CustomizeInit.getLanguageBean();

    public ImportPanel(JDialog dialog) {
        this.dialog = (ImportDialog)dialog;
        this.initPanel();
    }

    public ImportPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)this.getImportPanel(), "Center");
        this.add((Component)this.getSouthPanel(), "South");
    }

    private JPanel getImportPanel() {
        JPanel importPanel = new JPanel();
        importPanel.setPreferredSize(new Dimension(40, 90));
        importPanel.setLayout(new BorderLayout(1, 1));
        importPanel.setBorder(new LineBorder(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_border()), 1, true));
        JScrollPane treePanelScrollPane = new JScrollPane();
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar bar3 = treePanelScrollPane.getHorizontalScrollBar();
            JScrollBar bar4 = treePanelScrollPane.getVerticalScrollBar();
            bar3.setUI(new VScrollBarUI());
            bar4.setUI(new HScrollBarUI());
        }
        treePanelScrollPane.getViewport().add(this.getTree());
        treePanelScrollPane.setBorder(new LineBorder(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_border()), 1, true));
        importPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        importPanel.add((Component)treePanelScrollPane, "Center");
        return importPanel;
    }

    private JTree getTree() {
        this.treeSelectList = new ArrayList();
        TreeModel treeModel = null;
        this.exportTree = new JTree();
        this.exportTree.getSelectionModel().setSelectionMode(2);
        this.exportTree.putClientProperty("JTree.lineStyle", "None");
        treeModel = this.getAPNDefaultTreeModel();
        this.exportTree.setModel(treeModel);
        this.exportTree.setCellRenderer(new CheckRenderer());
        this.exportTree.getSelectionModel().setSelectionMode(1);
        this.exportTree.putClientProperty("JTree.lineStyle", "Angled");
        this.exportTree.addMouseListener(new ImportNodeSelectionListener(this.exportTree));
        this.exportTree.setShowsRootHandles(true);
        return this.exportTree;
    }

    private JPanel getSouthPanel() {
        JPanel southPanel = new JPanel(new FlowLayout(2, 12, 12));
        southPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JButton brower = new JButton(this.lb.getTools_5_ProfileManagement_Import_Browse());
        GetButtonBackground.setButtonBackground(brower);
        UICommon.setButtonSize(brower);
        brower.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportPanel.this.fileChooser = new CustomizeFileChooser();
                ImportPanel.this.fileChooser.addChoosableFileFilter(new JAVAFileFilter("xml"));
                TreeModel treeModel = null;
                ImportPanel.this.result = ImportPanel.this.fileChooser.showOpenDialog(ImportPanel.this.dialog);
                if (ImportPanel.this.result == 0) {
                    File xmlFile = ImportPanel.this.fileChooser.getSelectedFile();
                    if (!xmlFile.toString().endsWith(".xml")) {
                        xmlFile = new File(xmlFile + ".xml");
                    }
                    ImportPanel.this.filePath = xmlFile.getPath();
                    treeModel = ImportPanel.this.getImportTreeModel(ImportPanel.this.filePath);
                    ImportPanel.this.exportTree.setModel(treeModel);
                }
            }
        });
        brower.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ImportPanel.this.fileChooser = new JFileChooser();
                    ImportPanel.this.fileChooser.addChoosableFileFilter(new JAVAFileFilter("xml"));
                    TreeModel treeModel = null;
                    ImportPanel.this.result = ImportPanel.this.fileChooser.showOpenDialog(ImportPanel.this.dialog);
                    if (ImportPanel.this.result == 0) {
                        ImportPanel.this.filePath = ImportPanel.this.fileChooser.getSelectedFile().getPath();
                        treeModel = ImportPanel.this.getImportTreeModel(ImportPanel.this.filePath);
                        ImportPanel.this.exportTree.setModel(treeModel);
                    }
                }
            }
        });
        JButton ok = new JButton(this.lb.getTools_3_OK());
        GetButtonBackground.setButtonBackground(ok);
        UICommon.setButtonSize(ok);
        ok.addActionListener(new OKButtonActionListener(this));
        ok.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ImportPanel.this.ok_ActionListener();
                }
            }
        });
        this.cancel = new JButton(this.lb.getTools_3_Cancel());
        GetButtonBackground.setButtonBackground(this.cancel);
        UICommon.setButtonSize(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportPanel.this.dialog.dispose();
            }
        });
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ImportPanel.this.dialog.dispose();
                }
            }
        });
        southPanel.add(brower);
        Tools.macButton(southPanel, ok, this.cancel);
        return southPanel;
    }

    private TreeModel getImportTreeModel(String filePath) {
        ImportAPN importAPN = new ImportAPN();
        this.importAPNList = importAPN.getImportAPNInfo(filePath);
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.lb.getTools_5_ProfileManagement_Import_DialupProfile());
        int i = 0;
        while (i < this.importAPNList.size()) {
            this.apnEvent = (APNEvent)this.importAPNList.get(i);
            list.add(this.apnEvent.getNetworkName());
            ++i;
        }
        CheckNode[] checkNode = this.addCheckNode(list);
        return new DefaultTreeModel(checkNode[0]);
    }

    private TreeModel getAPNDefaultTreeModel() {
        Object defaultModel = null;
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.lb.getTools_5_ProfileManagement_Import_DialupProfile());
        ImportAPN importAPN = new ImportAPN();
        this.importAPNList = importAPN.getImportAPNInfo();
        int i = 0;
        while (i < this.importAPNList.size()) {
            this.apnEvent = (APNEvent)this.importAPNList.get(i);
            list.add(this.apnEvent.getNetworkName());
            ++i;
        }
        CheckNode[] checkNode = this.addCheckNode(list);
        return new DefaultTreeModel(checkNode[0]);
    }

    private CheckNode[] addCheckNode(List apnList) {
        this.nodes = null;
        this.nodes = new CheckNode[apnList.size()];
        int i = 0;
        while (i < apnList.size()) {
            this.nodes[i] = new CheckNode(apnList.get(i));
            ++i;
        }
        i = 1;
        while (i < this.nodes.length) {
            this.nodes[0].add(this.nodes[i]);
            ++i;
        }
        return this.nodes;
    }

    public void ok_ActionListener() {
        if (chickFlag) {
            return;
        }
        chickFlag = true;
        ArrayList saveImportAPN = new ArrayList();
        NewAPN newAPN = new NewAPN();
        boolean nodeFlag = false;
        ArrayList<APNEvent> apnList = new ArrayList<APNEvent>();
        Enumeration<TreeNode> enumer = this.nodes[0].breadthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            CheckNode node = (CheckNode)enumer.nextElement();
            if (!node.isSelected()) continue;
            TreeNode[] treeNodes = node.getPath();
            int i = 1;
            while (i < treeNodes.length) {
                int index = 0;
                while (index < this.importAPNList.size()) {
                    APNEvent apnEvent = (APNEvent)this.importAPNList.get(index);
                    if (treeNodes[i].toString().equals(apnEvent.getNetworkName())) {
                        apnList.add(apnEvent);
                    }
                    ++index;
                }
                ++i;
            }
        }
        boolean showFlag = true;
        DeleteAPN deleteAPN = new DeleteAPN();
        int values = -1;
        int indexImport = 0;
        while (indexImport < apnList.size()) {
            boolean updateFlag = false;
            APNEvent apnImportEvent = (APNEvent)apnList.get(indexImport);
            int apnIndex = 0;
            while (apnIndex < this.dialog.netConnList.size()) {
                APNEvent apnEvent = (APNEvent)this.dialog.netConnList.get(apnIndex);
                if (apnImportEvent.getNetworkName().toString().equals(apnEvent.getNetworkName().toString())) {
                    updateFlag = true;
                    break;
                }
                ++apnIndex;
            }
            if (!updateFlag) {
                newAPN.createAPN(apnImportEvent);
            } else {
                if (showFlag) {
                    String title;
                    String message;
                    if (CommServerThread.currentSystem.equals("Linux")) {
                        Object[] obj = new Object[]{this.lb.getTools_3_OK(), this.lb.getTools_3_Cancel()};
                        message = this.lb.getTools_5_profile_exists();
                        title = this.lb.getTools_5_ProfileManagement_Delete_Prompt();
                        values = JUTPSOptionDialog.showConfirmDialog(this.dialog, message, title, 0);
                        showFlag = false;
                    } else {
                        Object[] obj = new Object[]{this.lb.getTools_3_OK(), this.lb.getTools_3_Cancel()};
                        message = this.lb.getTools_5_profile_exists();
                        title = this.lb.getTools_5_ProfileManagement_Delete_Prompt();
                        values = JUTPSOptionDialog.showConfirmDialog(this.dialog, message, title, 0);
                        showFlag = false;
                    }
                }
                if (values == 0) {
                    String[] advanceApn = new String[]{apnImportEvent.getNetworkName(), apnImportEvent.getProfType(), APNEvent.booleanToString(apnImportEvent.isReadOnly()), apnImportEvent.getDevice(), apnImportEvent.getUsername(), apnImportEvent.getPassword(), apnImportEvent.getPhoneNumber(), APNEvent.booleanToString(apnImportEvent.isApnFlag()), apnImportEvent.getApn(), APNEvent.booleanToString(apnImportEvent.isChap()), APNEvent.booleanToString(apnImportEvent.isPap()), apnImportEvent.getIp(), apnImportEvent.getDnsPreferred(), apnImportEvent.getDnsStandby(), apnImportEvent.getWinsPreferred(), apnImportEvent.getWinsStandby(), apnImportEvent.getImsi()};
                    deleteAPN.updateAPNNode(apnImportEvent.getNetworkName(), advanceApn);
                }
            }
            ++indexImport;
        }
        if (this.dialog.optionPanel.box != null) {
            OptionPanel.AModel mode = this.dialog.optionPanel.new OptionPanel.AModel();
            this.dialog.optionPanel.box.setModel(mode);
            OptionPanel cfr_ignored_0 = this.dialog.optionPanel;
            if (this.dialog.optionPanel.box.getItemCount() > OptionPanel.number) {
                OptionPanel cfr_ignored_1 = this.dialog.optionPanel;
                this.dialog.optionPanel.box.setSelectedIndex(OptionPanel.number);
            }
            this.dialog.optionPanel.setAPNInit();
            this.dialog.optionPanel.box.setEditable(false);
        }
        try {
            AppFrame appFrame = AppFrame.getAppFrameInit();
            if (appFrame.connComboBox != null) {
                appFrame.connComboBox.setModel(appFrame.new AppFrame.AModel());
                if (appFrame.connComboBox.getItemCount() > AppFrame.number && AppFrame.number > 0) {
                    Tools.configSelectFlagTrue();
                    appFrame.connComboBox.setSelectedIndex(AppFrame.number);
                    Tools.configSelectFlagFalse();
                }
                appFrame.connButton.setEnabled(true);
                appFrame.connctMenuItem.setEnabled(true);
                appFrame.connComboBox.setEditable(false);
                GetButtonBackground.setButtonBackground(appFrame.connButton);
            }
        }
        catch (Exception ex) {
            Tools.configSelectFlagFalse();
            this.log.debug("connection manager panel : " + ex.toString());
        }
        chickFlag = false;
        this.dialog.dispose();
    }
}

