/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ImageButton {
    public static final float THIRD_TRANSPARENCY = 0.3f;
    public static final float TRANSLUCENCE = 0.5f;
    public static final float TOWPART_TRANSPARENCY = 0.8f;
    public static final float OPACITY = -1.0f;

    private ImageButton() {
    }

    public static JButton createButton(String iconName) {
        ImageIcon icon = ImageButton.getImageIcon(iconName);
        return ImageButton.createButton(icon);
    }

    public static JButton createButton(ImageIcon rolloverIcon) {
        return ImageButton.createButton(null, rolloverIcon, 0.0f);
    }

    public static JButton createButton(ImageIcon rolloverIcon, float alpha) {
        return ImageButton.createButton(null, rolloverIcon, alpha);
    }

    public static JButton createButton(ImageIcon defaultIcon, ImageIcon rolloverIcon) {
        return ImageButton.createButton(defaultIcon, rolloverIcon, null, 0.0f);
    }

    public static JButton createButton(ImageIcon defaultIcon, ImageIcon rolloverIcon, float alpha) {
        return ImageButton.createButton(defaultIcon, rolloverIcon, null, alpha);
    }

    public static JButton createButton(ImageIcon defaultIcon, ImageIcon rolloverIcon, ImageIcon pressedIcon) {
        return ImageButton.initButton(defaultIcon, rolloverIcon, pressedIcon, 0.0f, null);
    }

    public static JButton createButton(ImageIcon defaultIcon, ImageIcon rolloverIcon, ImageIcon pressedIcon, float alpha) {
        return ImageButton.initButton(defaultIcon, rolloverIcon, pressedIcon, alpha, null);
    }

    private static JButton initButton(ImageIcon defaultIcon, ImageIcon rolloverIcon, ImageIcon pressedIcon, float alpha, String text) {
        int width = rolloverIcon.getIconWidth();
        int height = rolloverIcon.getIconHeight();
        if (alpha == 0.0f) {
            alpha = 0.5f;
        }
        if (defaultIcon == null) {
            defaultIcon = ImageButton.getImageIcon(rolloverIcon, width, height, 0, 0, alpha);
        }
        if (pressedIcon == null) {
            pressedIcon = ImageButton.getImageIcon(rolloverIcon, width, height, 2, 2, -1.0f);
        }
        JButton button = text == null ? new JButton() : new JButton(text);
        button.setIgnoreRepaint(true);
        button.setBorder(null);
        button.setContentAreaFilled(false);
        button.setIcon(defaultIcon);
        button.setRolloverIcon(rolloverIcon);
        button.setPressedIcon(pressedIcon);
        return button;
    }

    private static ImageIcon getImageIcon(ImageIcon defaultIcon, int width, int height, int x, int y, float alpha) {
        JFrame frame = new JFrame();
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        BufferedImage image = gc.createCompatibleImage(width, height, 3);
        Graphics2D g2D = (Graphics2D)((Image)image).getGraphics();
        if (alpha > 0.0f) {
            AlphaComposite alphaTemp = AlphaComposite.getInstance(3, alpha);
            g2D.setComposite(alphaTemp);
        }
        g2D.drawImage(defaultIcon.getImage(), x, y, null);
        g2D.dispose();
        return new ImageIcon(image);
    }

    private static ImageIcon getImageIcon(String fileName) {
        fileName = "images/" + fileName + ".png";
        return new ImageIcon(ImageButton.class.getResource(fileName));
    }
}

