/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HtmlPanel
extends JPanel {
    private static LogConfig log = Log.getLog(XMLTool.class);
    private String filePath = "";
    private JEditorPane html = null;
    private boolean isException = false;
    private boolean isChangeLanguage = false;
    private boolean isChangDialStatus = false;
    private URL fileRefreshUrl = null;
    private int count = 0;
    private URL oldUrl = null;

    public HtmlPanel(String htmlFileName) {
        try {
            URL url = null;
            String path = null;
            try {
                path = htmlFileName;
                url = new URL(path);
            }
            catch (Exception e) {
                System.err.println("Failed to open: " + path);
                url = null;
            }
            if (url != null) {
                this.html = new JEditorPane(url);
                this.html.setContentType("text/html");
                this.html.setEditable(false);
                this.html.addHyperlinkListener(new Hyperactive());
                JScrollPane scroller = new JScrollPane();
                JViewport vp = scroller.getViewport();
                if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
                    JScrollBar bar3 = scroller.getHorizontalScrollBar();
                    JScrollBar bar4 = scroller.getVerticalScrollBar();
                    bar3.setUI(new VScrollBarUI());
                    bar4.setUI(new HScrollBarUI());
                }
                vp.add(this.html);
                this.setLayout(new BorderLayout());
                this.add((Component)scroller, "Center");
                this.isException = false;
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
            this.isException = true;
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
            this.isException = true;
        }
    }

    public boolean getExecption() {
        return this.isException;
    }

    public void refresh(boolean changeLanguage, boolean changDialStatus, String path) {
        this.isChangeLanguage = changeLanguage;
        this.isChangDialStatus = changDialStatus;
        this.filePath = path;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (HtmlPanel.this.isChangeLanguage && HtmlPanel.this.isChangDialStatus || HtmlPanel.this.isChangDialStatus) {
                        if (HtmlPanel.this.filePath.startsWith("http")) {
                            HtmlPanel.this.fileRefreshUrl = new URL(HtmlPanel.this.filePath);
                        } else {
                            String pathStr = XMLTool.getClassPath();
                            String pathFileUrl = "file:///" + pathStr + "/" + HtmlPanel.this.filePath;
                            HtmlPanel.this.fileRefreshUrl = new URL(pathFileUrl);
                        }
                    }
                    HtmlPanel.this.html.setPage(HtmlPanel.this.fileRefreshUrl);
                    HtmlPanel.this.html.revalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
        this.revalidate();
    }

    class Hyperactive
    implements HyperlinkListener {
        boolean flag = true;

        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        Timer timer = new Timer();
                        timer.schedule((TimerTask)new TimerOut(), 500L);
                        if (this.flag && HtmlPanel.this.count > 3) {
                            throw new OutOfMemoryError();
                        }
                        pane.setPage(e.getURL());
                        HtmlPanel.this.oldUrl = e.getURL();
                        this.flag = false;
                    }
                    catch (ConnectException conexe) {
                        this.flag = false;
                        HtmlPanel.this.count = 0;
                        try {
                            pane.setPage(HtmlPanel.this.oldUrl);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        log.info("Error Time out:ConnectException");
                    }
                    catch (OutOfMemoryError error) {
                        this.flag = false;
                        HtmlPanel.this.count = 0;
                        try {
                            pane.setPage(HtmlPanel.this.oldUrl);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        log.info("Error Time out:OutOfMemoryError");
                    }
                    catch (IOException ee) {
                        this.flag = false;
                        HtmlPanel.this.count = 0;
                        try {
                            pane.setPage(HtmlPanel.this.oldUrl);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        log.info("Error Time out:IOException");
                    }
                    catch (Exception ex) {
                        this.flag = false;
                        HtmlPanel.this.count = 0;
                        try {
                            pane.setPage(HtmlPanel.this.oldUrl);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        log.info("Error Time out:Exception");
                    }
                    catch (Throwable t) {
                        this.flag = false;
                        HtmlPanel.this.count = 0;
                        try {
                            pane.setPage(HtmlPanel.this.oldUrl);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        t.printStackTrace();
                        log.info("Error Time out:Throwable");
                    }
                }
            }
        }
    }

    class TimerOut
    extends TimerTask {
        TimerOut() {
        }

        public void run() {
            while (HtmlPanel.this.count < 100) {
                HtmlPanel htmlPanel = HtmlPanel.this;
                htmlPanel.count = htmlPanel.count + 1;
            }
        }
    }
}

