/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.business.apn.APNEvent;
import com.huawei.mobilePartner.business.apn.ImportAPN;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.ButtonActionListener;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.CheckNode;
import com.huawei.mobilePartner.gui.ui.CheckRenderer;
import com.huawei.mobilePartner.gui.ui.ExportDialog;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.NodeSelectionListener;
import com.huawei.mobilePartner.gui.ui.Ok_KeyListener;
import com.huawei.mobilePartner.gui.ui.UICommon;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ExportPanel
extends JPanel {
    private JButton cancel;
    private ExportDialog dialog;
    private List importAPNList;
    private APNEvent apnEvent;
    private List treeSelectList;
    private ImportAPN importAPN;
    private boolean flag = false;
    private JFileChooser fileChooser = null;
    private int result;
    private String filePath;
    public JTree importTree;
    private DefaultMutableTreeNode rootNode;
    private CheckNode[] nodes = null;
    LanguageBean lb = CustomizeInit.getLanguageBean();

    public ExportPanel(JDialog dialog) {
        this.dialog = (ExportDialog)dialog;
        this.initPanel();
    }

    public ExportPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)this.getImportPanel(), "Center");
        this.add((Component)this.getSouthPanel(), "South");
    }

    private JPanel getImportPanel() {
        JPanel importPanel = new JPanel();
        importPanel.setPreferredSize(new Dimension(40, 90));
        importPanel.setLayout(new BorderLayout(1, 1));
        importPanel.setBorder(new LineBorder(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_border()), 1, true));
        JScrollPane treePanelScrollPane = new JScrollPane();
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar bar3 = treePanelScrollPane.getHorizontalScrollBar();
            JScrollBar bar4 = treePanelScrollPane.getVerticalScrollBar();
            bar3.setUI(new VScrollBarUI());
            bar4.setUI(new HScrollBarUI());
        }
        treePanelScrollPane.getViewport().add(this.getTree());
        treePanelScrollPane.setBorder(new LineBorder(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getDefault_border()), 1, true));
        importPanel.add((Component)treePanelScrollPane, "Center");
        return importPanel;
    }

    private JTree getTree() {
        this.treeSelectList = new ArrayList();
        TreeModel treeModel = null;
        this.importTree = new JTree();
        this.importTree.getSelectionModel().setSelectionMode(2);
        this.importTree.putClientProperty("JTree.lineStyle", "None");
        treeModel = this.getAPNDefaultTreeModel();
        this.importTree.setModel(treeModel);
        this.importTree.setCellRenderer(new CheckRenderer());
        this.importTree.getSelectionModel().setSelectionMode(1);
        this.importTree.putClientProperty("JTree.lineStyle", "Angled");
        this.importTree.addMouseListener(new NodeSelectionListener(this.importTree));
        this.importTree.setShowsRootHandles(true);
        return this.importTree;
    }

    private JPanel getSouthPanel() {
        JPanel southPanel = new JPanel(new FlowLayout(2, 12, 12));
        southPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JButton ok = new JButton(this.lb.getTools_3_OK());
        GetButtonBackground.setButtonBackground(ok);
        UICommon.setButtonSize(ok);
        ok.addActionListener(new ButtonActionListener(this.nodes[0], this.dialog.netConnList, this.dialog, this.lb.getTools_5_ProfileManagement_DialUP()));
        ok.addKeyListener(new Ok_KeyListener(this.nodes[0], this.dialog.netConnList, this.dialog, this.lb.getTools_5_ProfileManagement_DialUP()));
        this.cancel = new JButton(this.lb.getTools_3_Cancel());
        GetButtonBackground.setButtonBackground(this.cancel);
        UICommon.setButtonSize(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportPanel.this.dialog.dispose();
            }
        });
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ExportPanel.this.dialog.dispose();
                }
            }
        });
        Tools.macButton(southPanel, ok, this.cancel);
        return southPanel;
    }

    private TreeModel getImportTreeModel(String filePath) {
        ImportAPN importAPN = new ImportAPN();
        this.importAPNList = importAPN.getImportAPNInfo(filePath);
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.lb.getTools_5_ProfileManagement_Import_DialupProfile());
        int i = 0;
        while (i < this.importAPNList.size()) {
            this.apnEvent = (APNEvent)this.importAPNList.get(i);
            list.add(this.apnEvent.getNetworkName());
            ++i;
        }
        CheckNode[] checkNode = this.addCheckNode(list);
        return new DefaultTreeModel(checkNode[0]);
    }

    private TreeModel getAPNDefaultTreeModel() {
        Object defaultModel = null;
        ArrayList<String> list = new ArrayList<String>();
        List netConnList = this.dialog.netConnList;
        list.add(this.lb.getTools_5_ProfileManagement_Import_DialupProfile());
        int i = 0;
        while (i < netConnList.size()) {
            this.apnEvent = (APNEvent)netConnList.get(i);
            list.add(this.apnEvent.getNetworkName());
            ++i;
        }
        CheckNode[] checkNode = this.addCheckNode(list);
        return new DefaultTreeModel(checkNode[0]);
    }

    private CheckNode[] addCheckNode(List apnList) {
        this.nodes = new CheckNode[apnList.size()];
        int i = 0;
        while (i < apnList.size()) {
            this.nodes[i] = new CheckNode(apnList.get(i));
            ++i;
        }
        i = 1;
        while (i < this.nodes.length) {
            this.nodes[0].add(this.nodes[i]);
            ++i;
        }
        return this.nodes;
    }
}

