/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui;

import com.huawei.mobilePartner.common.interfaces.SmsConfigInfo;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.service.NetCommService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.shell.TimerCall;
import com.huawei.mobilePartner.shell.shellOff;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialInfoPanel
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    private JPanel panel;
    private static final int width = 300;
    private static final int height = 140;
    private String infoContent = "";
    private Frame frame = null;
    private JLabel jbNetwork = null;
    private JButton cancel = new JButton();
    String deviceName;
    AppFrame appFrame = AppFrame.getAppFrameInit();
    Thread thr = new Thread(this);
    private LogConfig log = Log.getLog(DialInfoPanel.class);
    LanguageBean lb = CustomizeInit.getLanguageBean();
    private JDialog dialog;
    public static DialInfoPanel instance = null;

    public static DialInfoPanel getDialInfoPanel(Frame frame, String info) {
        if (instance == null) {
            instance = new DialInfoPanel(frame, info);
        }
        return instance;
    }

    public DialInfoPanel(JDialog dialog, String info) {
        super(dialog);
        Tools.changeDialogAppearance(this);
        this.dialog = dialog;
        this.infoContent = info;
        this.setModal(true);
        this.setSize(new Dimension(300, 140));
        Tools.showWindowCenter(this);
        this.setResizable(false);
        this.thr.start();
    }

    public DialInfoPanel(Frame frame, String info) {
        super(frame);
        Tools.changeDialogAppearance(this);
        this.frame = frame;
        this.infoContent = info;
        this.setModal(true);
        this.setSize(new Dimension(300, 140));
        Tools.showWindowCenter(this);
        this.setResizable(false);
        this.thr.start();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() != 201) {
            super.processWindowEvent(e);
        }
    }

    private void initPanel() {
        try {
            this.thr.setPriority(10);
            this.panel = (JPanel)this.getContentPane();
            this.panel.setLayout(new BorderLayout());
            this.panel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getShowInfoDialog_1()));
            this.jbNetwork = new JLabel("<html><body>" + this.infoContent + "<body><html>", 0);
            JPanel southPanel = new JPanel();
            southPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getShowInfoDialog_1()));
            this.cancel.setText(this.lb.getTools_3_Cancel());
            this.cancel.setEnabled(false);
            ScheduledExecutorService sch = Executors.newScheduledThreadPool(1);
            sch.schedule(new Runnable(){

                public void run() {
                    DialInfoPanel.this.cancel.setEnabled(true);
                }
            }, 4L, TimeUnit.SECONDS);
            southPanel.setLayout(new FlowLayout(2));
            String linux = "Linux";
            String mac = "Mac OS X";
            if (this.appFrame.connButton.getName().equalsIgnoreCase("ok")) {
                if (System.getProperty("os.name").equals(mac)) {
                    southPanel.add(this.cancel);
                } else {
                    southPanel.add(this.cancel);
                }
            }
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TimerCall.redialFlag = false;
                    TimerCall.checkButton = false;
                    String mac = "Mac OS X";
                    if (System.getProperty("os.name").equals(mac)) {
                        SmsConfigInfo.concalConnectionFlag = true;
                        shellOff off = new shellOff();
                        off.MacOff();
                    } else {
                        shellOff off = new shellOff();
                        DialInfoPanel.this.deviceName = DialInfoPanel.this.appFrame.deviceName;
                        off.disCall(DialInfoPanel.this.deviceName);
                        NetCommService netCommService = NetCommService.getInstance();
                        netCommService.getCGACT();
                    }
                    DialInfoPanel.this.close();
                }
            });
            this.panel.add((Component)this.jbNetwork, "Center");
            this.panel.add((Component)southPanel, "South");
            this.setSize(new Dimension(300, 140));
            Tools.showWindowCenter(this);
            this.setTitle("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent arg0) {
                }
            });
            this.setVisible(true);
        }
        catch (Exception ex) {
            this.log.error(ex.toString());
        }
    }

    public void close() {
        this.dispose();
        instance = null;
    }

    public void run() {
        this.initPanel();
    }
}

