/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.model;

import com.huawei.mobilePartner.business.statistics.RecurrenceBean;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.VolumeLimitTools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.model.ProgressBarPanel;
import com.huawei.mobilePartner.gui.model.StatisticsDialogOption;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLabelUI;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class TimeVolumeProgressBar
extends JProgressBar
implements Runnable,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private LanguageBean lb;
    private static LogConfig logger = LogConfig.getInstance(TimeVolumeProgressBar.class);
    private JLabel fluxNum;
    private RecurrenceBean bean;
    private int timeLimitValue;
    private List beforeReachingLimitList;
    private List exceededReachedLimitList;
    private ProgressBarPanel progressBarPanel;
    private int warningTip;
    private boolean isSelectedBeforeLimit;
    private boolean isSelectedExceededLimit;
    private int tempMaxValue;
    private int index;
    int count;

    public TimeVolumeProgressBar(ProgressBarPanel progressBarPanel) {
        CustomizeInit.getCustomizeInit();
        this.lb = CustomizeInit.getLanguageBean();
        this.fluxNum = null;
        this.bean = RecurrenceBean.getRecurrenceBean();
        this.timeLimitValue = 0;
        this.beforeReachingLimitList = null;
        this.exceededReachedLimitList = null;
        this.progressBarPanel = null;
        this.warningTip = 0;
        this.isSelectedBeforeLimit = false;
        this.isSelectedExceededLimit = false;
        this.tempMaxValue = 0;
        this.index = 0;
        this.count = 0;
        this.progressBarPanel = progressBarPanel;
        this.init();
    }

    private void init() {
        this.beforeReachingLimitList = this.bean.getBeforeLimitList();
        this.exceededReachedLimitList = this.bean.getExceededLimitList();
        this.fluxNum = new JLabel("0.00", 0);
        this.fluxNum.setBounds(0, 0, 200, 25);
        this.fluxNum.setUI(new MetalLabelUI());
        this.fluxNum.setForeground(Color.black);
        this.fluxNum.setFont(Tools.setFont());
        this.setBorderPainted(true);
        this.add(this.fluxNum);
        this.setStringPainted(true);
        this.setString("0.00");
        this.setForeground(Color.GREEN);
        this.setBounds(new Rectangle(20, 100, 200, 20));
        this.setValue(0);
        this.setMinimum(0);
        this.setMaxValue();
        this.setUI(new MetalProgressBarUI());
        this.setStringPainted(false);
        this.addChangeListener(this);
        new Thread(this).start();
    }

    public void setMaxValue() {
        try {
            boolean isSelectedTimeVolume;
            List timeLimitList = this.bean.getTimeVolumeLimitList();
            String timeValue = timeLimitList.get(2).toString();
            if (timeValue == null || "".equals(timeValue)) {
                timeValue = timeLimitList.get(1).toString();
            }
            if (timeValue == null || "".equals(timeValue)) {
                timeValue = String.valueOf(100);
            }
            this.timeLimitValue = (isSelectedTimeVolume = Boolean.valueOf(this.bean.getTimeVolumeLimitList().get(0).toString()).booleanValue()) ? Integer.parseInt(timeValue) * 100 : 0;
            if (this.tempMaxValue != this.timeLimitValue) {
                PublicConfig.iTimeBefore = 0;
                PublicConfig.iTimeReached = 0;
                this.tempMaxValue = this.timeLimitValue;
                this.setMaximum(this.timeLimitValue);
            }
        }
        catch (Exception e) {
            logger.warn("DataVolumeProgressBar -> setMaxValue():Warn: set max value is exception");
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.beforeReachingLimitList = this.bean.getBeforeLimitList();
                    this.exceededReachedLimitList = this.bean.getExceededLimitList();
                    List recurrenceList = this.bean.getRecurrenceValueList();
                    boolean isRecurrence = Boolean.parseBoolean(recurrenceList.get(0).toString());
                    String fluxValue = "0";
                    fluxValue = isRecurrence ? Tools.getFluxInfo(1) : Tools.getThreeMonth_FluxInfo(1);
                    if (fluxValue == null || "".equals(fluxValue.trim())) {
                        fluxValue = "0";
                    }
                    String strTimeValue = Tools.getHours(Long.parseLong(fluxValue));
                    double timeValue = Double.parseDouble(strTimeValue) * 100.0;
                    this.count = (int)timeValue;
                    boolean isSelectedTimeVolume = Boolean.valueOf(this.bean.getTimeVolumeLimitList().get(0).toString());
                    if (isSelectedTimeVolume) {
                        this.setValue(this.count);
                        this.setString(strTimeValue);
                        this.fluxNum.setText(strTimeValue);
                    } else {
                        this.setValue(2);
                        this.setMaximum(1);
                        this.setString(strTimeValue);
                        this.fluxNum.setText(strTimeValue);
                        this.setForeground(Color.GREEN);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                logger.warn("DataVolumeProgressBar -> setMaxValue():Warn: set max value is exception");
                continue;
            }
            break;
        }
    }

    public void stateChanged(ChangeEvent e) {
        boolean isSelectedTimeVolume = Boolean.valueOf(this.bean.getTimeVolumeLimitList().get(0).toString());
        if (!isSelectedTimeVolume) {
            return;
        }
        int value = this.count;
        this.isSelectedBeforeLimit = Boolean.valueOf(this.beforeReachingLimitList.get(0).toString());
        boolean isShowBeforeLimit = Boolean.valueOf(this.beforeReachingLimitList.get(3).toString());
        int iPercent = Integer.parseInt(this.beforeReachingLimitList.get(2).toString().trim());
        int differenceBefore = this.timeLimitValue * (100 - iPercent) / 100;
        this.isSelectedExceededLimit = Boolean.valueOf(this.exceededReachedLimitList.get(0).toString());
        boolean isShowExceededLimit = Boolean.valueOf(this.exceededReachedLimitList.get(1).toString());
        if (value == 0) {
            return;
        }
        int reduce = this.timeLimitValue - value;
        if (reduce <= differenceBefore && this.timeLimitValue > value) {
            this.setForeground(Color.ORANGE);
            PublicConfig.iTimeReached = 0;
            private class StartThread
            extends Thread {
                StartThread() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Object object = ((TimeVolumeProgressBar)TimeVolumeProgressBar.this).progressBarPanel.oneWarnBeforePrompt;
                    synchronized (object) {
                        try {
                            boolean isBeforeLimit;
                            if (PublicConfig.iTimeBefore == 0 && (isBeforeLimit = Boolean.valueOf(TimeVolumeProgressBar.this.bean.getBeforeLimitList().get(0).toString()).booleanValue()) && StatisticsDialogOption.showConfirmDialog(AppFrame.frame, TimeVolumeProgressBar.this.lb.getTools_operation_2_Oranage_Time_Dialog(), TimeVolumeProgressBar.this.titleMessage(), 2) == 1) {
                                PublicConfig.iTimeBefore = 1;
                                logger.warn("stateChanged():Warn: this event is orange.");
                            }
                        }
                        catch (Exception exe) {
                            logger.error("stateChanged():Warn: this event is orange.Exception");
                        }
                    }
                }
            }
            new StartThread().start();
        } else if (this.timeLimitValue <= value) {
            this.setForeground(Color.red);
            private class StartThread
            extends Thread {
                StartThread() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Object object = ((TimeVolumeProgressBar)TimeVolumeProgressBar.this).progressBarPanel.oneWarnReachedPrompt;
                    synchronized (object) {
                        try {
                            boolean isExceededLimit;
                            if (PublicConfig.iTimeReached == 0 && (isExceededLimit = Boolean.valueOf(TimeVolumeProgressBar.this.bean.getExceededLimitList().get(0).toString()).booleanValue()) && StatisticsDialogOption.showConfirmDialog(AppFrame.frame, TimeVolumeProgressBar.this.lb.getTools_operation_2_Red_Time_Dialog(), TimeVolumeProgressBar.this.titleMessage(), 2) == 1) {
                                PublicConfig.iTimeReached = 1;
                                logger.warn("stateChanged():Warn: this event is red.");
                            }
                        }
                        catch (Exception ees) {
                            logger.error("stateChanged():Warn: this event is red.Exception");
                        }
                    }
                }
            }
            new StartThread().start();
        } else {
            this.setForeground(Color.GREEN);
            PublicConfig.iTimeBefore = 0;
            PublicConfig.iTimeReached = 0;
        }
    }

    public String titleMessage() {
        VolumeLimitTools tool = VolumeLimitTools.getInstance();
        String title = "";
        title = tool.getTitleMessage().equals("0") ? this.lb.getWarn_title_message() : "";
        return title;
    }
}

