/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.eyetv;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import java.awt.event.WindowListener;
import java.io.IOException;

public class EyeTV {
    private Process process = null;
    private static EyeTV eyetv = null;
    private static boolean display = false;
    private static String processname = "EyeTV Lite";

    private EyeTV() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("mac") > -1) {
            this.addApplicationHandler();
        }
    }

    public static EyeTV getInstance() {
        if (eyetv == null) {
            eyetv = new EyeTV();
        }
        return eyetv;
    }

    public boolean isOpened(String processName) {
        try {
            Runtime run = Runtime.getRuntime();
            String[] cmd = new String[]{"/usr/bin/osascript", "-e", "tell application \"System Events\" to count (processes whose name is \"" + processName + "\")"};
            Process pro = run.exec(cmd);
            int exitvalue = pro.exitValue();
            return exitvalue == 1;
        }
        catch (IOException ex) {
            return false;
        }
        catch (SecurityException se) {
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int openEyeTV(String fullAppPath) {
        try {
            Runtime run = Runtime.getRuntime();
            String[] path = new String[]{"open", fullAppPath};
            this.process = run.exec(path);
        }
        catch (IOException ex) {
            return 1;
        }
        catch (SecurityException se) {
            return 2;
        }
        catch (NullPointerException npe) {
            return 3;
        }
        catch (IllegalArgumentException iae) {
            return 4;
        }
        catch (Exception ex) {
            return 5;
        }
        return 0;
    }

    public Process getProcess() {
        return this.process;
    }

    public int closeEyeTV(String processName) {
        try {
            Runtime run = Runtime.getRuntime();
            String[] cmd = new String[]{"/usr/bin/osascript", "-e", "tell application \"" + processName + "\" to quit"};
            run.exec(cmd);
        }
        catch (IOException ex) {
            return 1;
        }
        catch (SecurityException se) {
            return 2;
        }
        catch (NullPointerException npe) {
            return 3;
        }
        catch (IllegalArgumentException iae) {
            return 4;
        }
        catch (Exception ex) {
            return 5;
        }
        return 0;
    }

    public static void main(String[] args) {
        EyeTV eyetv = EyeTV.getInstance();
        String amd = "/Users/tinglahu/Desktop/mobilepartnerc12/source/MobilePartner/eyetv/EyeTV.app";
        Tools.logToControl("err", eyetv.openEyeTV(amd));
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        eyetv.closeEyeTV("EyeTV");
    }

    public static boolean isDisplay() {
        return display;
    }

    public static void setDisplay(boolean display) {
        EyeTV.display = display;
    }

    public void addApplicationHandler() {
        Application app = Application.getApplication();
        app.addApplicationListener(new ApplicationListener(){

            public void handleAbout(ApplicationEvent arg0) {
            }

            public void handleOpenApplication(ApplicationEvent arg0) {
            }

            public void handleOpenFile(ApplicationEvent arg0) {
            }

            public void handlePreferences(ApplicationEvent arg0) {
            }

            public void handlePrintFile(ApplicationEvent arg0) {
            }

            public void handleQuit(ApplicationEvent arg0) {
                WindowListener[] wl = AppFrame.getAppFrameInit().getWindowListeners();
                if (wl != null && wl.length > 0) {
                    wl[0].windowClosing(null);
                }
            }

            public void handleReOpenApplication(ApplicationEvent arg0) {
            }
        });
    }

    public static String getProcessname() {
        return processname;
    }

    public static void setProcessname(String processname) {
        EyeTV.processname = processname;
    }
}

