/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.service;

import com.huawei.mobilePartner.business.telephoneBook.commserver.TelHomeCode;
import com.huawei.mobilePartner.business.ussd.UssdCode;
import com.huawei.mobilePartner.business.ussd.UssdManage;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.data.comm.interfaces.ussd.AbstractUssdService;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class UssdService
extends AbstractUssdService {
    private static LogATConfig log = Log.getATLog(UssdService.class);
    public static HashMap<String, String> ussdCommands = new HashMap();
    public static volatile String cusdValue = null;
    private static String lock = "";

    static {
        UssdService.initUssdCommands();
    }

    private static void initUssdCommands() {
        try {
            XMLTool.setImportExport(false);
            XMLTool xmltool = new XMLTool("config/data/USSDConfig.xml");
            List list = xmltool.getNode("ussd/UssdCommands");
            Element ele = (Element)list.get(0);
            List childs = ele.getChildren();
            int i = 0;
            while (i < childs.size()) {
                Element child = (Element)childs.get(i);
                ussdCommands.put(child.getAttributeValue("id"), child.getAttributeValue("value"));
                ++i;
            }
            xmltool = new XMLTool("config/data/USSDPluginConfig.xml");
            Map cardSortCommandMap = xmltool.quertyNodeTextValueByPath("/USSD/PrePostDiffer/command");
            if (cardSortCommandMap.size() > 0) {
                String strCardSortCommand = cardSortCommandMap.get("command").toString();
                ussdCommands.put("cardSortCommand", strCardSortCommand);
            }
        }
        catch (Exception e) {
            log.info("initUssdCommands error");
            e.printStackTrace();
        }
    }

    public synchronized String[] sendUssdRequest(String command, String[] arg) {
        UssdCode code = new UssdCode();
        log.info("sendUssdRequest(String command, String[] arg) :command = " + command);
        String[] returnValue = null;
        CommServer server = null;
        server = MutiDeviceService.getCurrentServer();
        String cmdvalue = this.structCommand(command, arg);
        String at = "";
        if (TelHomeCode.isChinaCode(cmdvalue)) {
            if ("1".equals(Tools.getUSSDClarity())) {
                at = "AT+CUSD=1,\"" + cmdvalue + "\",72" + "\r" + (char)Integer.parseInt("1a", 16) + "z";
            } else {
                cmdvalue = code.enCodeUssd(cmdvalue);
                at = "AT+CUSD=1,\"" + cmdvalue + "\",72" + "\r" + (char)Integer.parseInt("1a", 16) + "z";
            }
        } else if ("1".equals(Tools.getUSSDClarity())) {
            at = "AT+CUSD=1,\"" + cmdvalue + "\",15" + "\r" + (char)Integer.parseInt("1a", 16) + "z";
        } else {
            cmdvalue = code.enCodeUssd(cmdvalue);
            at = "AT+CUSD=1,\"" + cmdvalue + "\",15" + "\r" + (char)Integer.parseInt("1a", 16) + "z";
        }
        OutgoingMessage outMsg = new OutgoingMessage();
        outMsg.setContent(at);
        IncomingMessage tempIn = server.send(outMsg, 30);
        String temp = tempIn.getContent();
        if (temp != null && temp.trim().indexOf("OK") <= -1) {
            returnValue = new String[]{"2"};
            return returnValue;
        }
        try {
            String receiveContext = UssdService.getCusdValue();
            log.error("sendUssdRequest receiveContext=" + receiveContext);
            if (receiveContext == null || "".equals(receiveContext)) {
                log.error("11111 sendUssdRequest receiveContext=" + receiveContext);
                int i = 0;
                while (i < 25) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    receiveContext = cusdValue;
                    if (receiveContext != null) break;
                    ++i;
                }
                if (receiveContext == null || "".equals(receiveContext)) {
                    returnValue = new String[]{"5"};
                    return returnValue;
                }
            }
            if (!Tools.isEmpty(receiveContext = TextUtil.splitStr(receiveContext, "+CUSD:")) && receiveContext.indexOf(",") > -1) {
                returnValue = receiveContext.replaceAll("\"", "").split(",");
                return returnValue;
            }
            log.error("sendUssdRequest error: receiveContext=" + receiveContext);
            try {
                int tempInt = Integer.parseInt(receiveContext);
                returnValue = new String[]{receiveContext};
                return returnValue;
            }
            catch (Exception ex) {
                returnValue = new String[]{"null"};
                return returnValue;
            }
        }
        catch (Exception ex) {
            try {
                log.error("sendUssdRequest getCusdValue error: " + ex.toString());
                returnValue = new String[]{"null"};
                return returnValue;
            }
            catch (Exception e) {
                log.error("sendUssdRequest Exception error: " + e.toString());
                returnValue = new String[]{"2"};
                return returnValue;
            }
        }
    }

    public String[] sendUssdRequest(String command) {
        log.info("sendUssdRequest(String command) :command = " + command);
        return this.sendUssdRequest(command, null);
    }

    private String structCommand(String command, String[] arg) {
        String value = ussdCommands.get(command);
        if (value != null) {
            int i = 0;
            while (value.indexOf("%s;") != -1) {
                value = value.replaceFirst("%s;", arg[i++]);
            }
            return value;
        }
        return command;
    }

    public void finishUssdDialog() {
        if ("1".equals(UssdManage.USSD_RETURN_VALUE)) {
            try {
                CommServer server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************autoReceiveSIMMessage2************server==null***************************************");
                } else {
                    OutgoingMessage outMsg = new OutgoingMessage();
                    String at = "AT+CUSD=2\r" + (char)Integer.parseInt("1a", 16) + "z";
                    outMsg.setContent(at);
                    server.send(outMsg, 30);
                }
            }
            catch (Exception e) {
                log.error("finish the ussd dialog faild");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCusdValue() {
        cusdValue = null;
        String string = lock;
        synchronized (string) {
            try {
                lock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return cusdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCusdValue(String cusdValue) {
        String string = lock;
        synchronized (string) {
            if (UssdService.cusdValue == null) {
                UssdService.cusdValue = cusdValue;
                lock.notifyAll();
            }
        }
    }
}

