/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.service;

import com.huawei.mobilePartner.business.simLock.SimLockDO;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.data.comm.interfaces.simLock.AbstractSimLockService;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;

public class SimLockCommService
extends AbstractSimLockService {
    private static LogATConfig log = Log.getATLog(SimLockCommService.class);
    private static SimLockCommService simLockCommService;

    public static SimLockCommService getInstance() {
        if (simLockCommService == null) {
            simLockCommService = new SimLockCommService();
        }
        return simLockCommService;
    }

    private SimLockCommService() {
    }

    public String getDevType() {
        IncomingMessage inMsg;
        String at;
        String receiveContext;
        block4: {
            CommServer server = null;
            receiveContext = "";
            try {
                log.debug("start the method getDevType from NetCommService");
                server = MutiDeviceService.getCurrentServer();
                at = "AT+CGMM\r";
                log.debug(at);
                OutgoingMessage outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                String at1 = "AT+CGMM\r";
                if (inMsg != null) break block4;
                log.fatal(" function[deleteSim]  failure: AT delay " + at1 + " Object return is null");
                return "";
            }
            catch (Exception e1) {
                log.info(e1.toString());
                return "";
            }
        }
        receiveContext = inMsg.getContent();
        log.info(String.valueOf(at) + " result:" + receiveContext);
        String temp = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
        if (temp.indexOf("AT+CGMM") > -1) {
            temp = temp.substring(temp.indexOf("AT+CGMM") + 7, temp.length()).trim();
        }
        log.debug("end the method getOperatorName from NetCommService");
        return temp;
    }

    public boolean testSimLock() {
        IncomingMessage inMsg;
        boolean ret;
        String receiveContext;
        block7: {
            CommServer server;
            block6: {
                server = null;
                receiveContext = "";
                ret = false;
                server = MutiDeviceService.getCurrentServer();
                if (server != null) break block6;
                log.info("*********************************testSimLock************server==null***************************************");
                return false;
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent("AT ^CARDLOCK=?\r" + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            String at1 = "AT ^CARDLOCK =?";
            if (inMsg != null) break block7;
            log.fatal(" function[testSimLock]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            receiveContext = inMsg.getContent();
            log.info("AT ^CARDLOCK=---------------[cardlock]------------------------result:" + receiveContext);
            if (receiveContext.toUpperCase().indexOf("OK") > -1) {
                ret = true;
            } else {
                log.info("send AT ^CARDLOCK=? COMMAND : [" + receiveContext + "]");
                ret = false;
            }
        }
        catch (Exception e1) {
            log.info("send AT ^CARDLOCK=? COMMAND : [" + e1.toString() + "]");
            ret = false;
        }
        log.debug("End the method testSimLock()!");
        return ret;
    }

    public boolean isUnLocked(String unlock_code) {
        IncomingMessage inMsg;
        String receiveContext;
        boolean isOk;
        block5: {
            log.debug("Begin the method isUnLocked()!");
            isOk = false;
            CommServer server = null;
            receiveContext = "";
            if ("".equals(unlock_code)) {
                return isOk;
            }
            server = MutiDeviceService.getCurrentServer();
            OutgoingMessage outMsg = new OutgoingMessage();
            log.debug("AT ^CARDLOCK =" + unlock_code);
            outMsg.setContent("AT ^CARDLOCK =" + unlock_code + "\r" + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            String at1 = "AT ^CARDLOCK =" + unlock_code;
            if (inMsg != null) break block5;
            log.fatal(" function[deleteSim]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            receiveContext = inMsg.getContent();
            log.info("AT ^CARDLOCK =" + unlock_code + " -------[cardlock]--------------------result:" + receiveContext);
            if (!"".equals(receiveContext) && receiveContext.toLowerCase().indexOf("ok") > -1) {
                isOk = true;
            }
        }
        catch (Exception e1) {
            log.info("send AT ^CARDLOCK =" + unlock_code + " COMMAND : [" + e1.toString() + "]");
        }
        log.debug("End the method isUnLocked()!");
        return isOk;
    }

    public SimLockDO setSimLockCode(String unlock_code) {
        log.debug("Begin the method setSimLockCode()!");
        CommServer server = null;
        String receiveContext = "";
        SimLockDO simLockDO = null;
        int errStatus = 0;
        String temp = "";
        if ("".equals(unlock_code)) {
            return new SimLockDO();
        }
        try {
            server = MutiDeviceService.getCurrentServer();
            OutgoingMessage outMsg = new OutgoingMessage();
            log.debug("AT ^CARDLOCK =" + unlock_code);
            outMsg.setContent("AT ^CARDLOCK =" + unlock_code + "\r" + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            String at1 = "AT ^CARDLOCK =" + unlock_code;
            if (inMsg == null) {
                log.fatal(" function[deleteSim]  failure: AT delay " + at1 + " Object return is null");
                return new SimLockDO();
            }
            receiveContext = inMsg.getContent();
            log.info("AT ^CARDLOCK =" + unlock_code + " ----------[cardlock]------------------------result:" + receiveContext);
            if (receiveContext.indexOf("ERROR") > -1 || receiveContext.indexOf("error") > -1) {
                temp = receiveContext.substring(receiveContext.indexOf(":") + 1).trim();
                "COMMAND NOT SUPPORT".equalsIgnoreCase(temp);
                if ("incorrect password".equalsIgnoreCase(temp)) {
                    errStatus = 1;
                }
                if ("SIM not inserted".equalsIgnoreCase(temp)) {
                    errStatus = 2;
                }
                if ("SIM busy".equalsIgnoreCase(temp)) {
                    errStatus = 3;
                }
                if ("memory failure".equalsIgnoreCase(temp)) {
                    errStatus = 4;
                }
                simLockDO = this.getSimLockCode();
                switch (errStatus) {
                    case 1: {
                        simLockDO.setErrPassWord(true);
                        break;
                    }
                    case 2: {
                        simLockDO.setNotCard(true);
                        break;
                    }
                    case 3: {
                        simLockDO.setBusy(true);
                        break;
                    }
                    case 4: {
                        simLockDO.setNotCard(true);
                    }
                }
            } else {
                simLockDO = new SimLockDO();
                simLockDO.setUnlocked(true);
            }
        }
        catch (Exception e1) {
            log.info("send AT ^CARDLOCK =" + unlock_code + " COMMAND : [" + e1.toString() + "]");
            return simLockDO;
        }
        log.debug("End the method setSimLockCode()!");
        return simLockDO;
    }

    public SimLockDO getSimLockCode() {
        log.debug("Begin the method getSimLockCode()!");
        SimLockDO simLockDO = null;
        String temp = "";
        simLockDO = new SimLockDO();
        CommServer server = null;
        String receiveContext = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            OutgoingMessage outMsg = new OutgoingMessage();
            log.debug("AT ^CARDLOCK?");
            outMsg.setContent("AT ^CARDLOCK?\r" + (char)Integer.parseInt("1a", 16) + "z");
            String at1 = "AT ^CARDLOCK?";
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[deleteSim]  failure: AT delay " + at1 + " Object return is null");
                return simLockDO;
            }
            receiveContext = inMsg.getContent();
            log.info("AT ^CARDLOCK? result:----------------[cardlock]----------------------------" + receiveContext);
            if (receiveContext.indexOf("ERROR") > -1 || receiveContext.indexOf("error") > -1) {
                log.info("send AT ^CARDLOCK? COMMAND : [" + receiveContext + "]");
                return simLockDO;
            }
            temp = receiveContext.substring(receiveContext.indexOf(":") + 1).trim();
            if ("".equals(temp)) {
                return simLockDO;
            }
            String[] retStr = temp.split(",");
            if ("0".equals(retStr[2])) {
                simLockDO.setUnlocked(true);
            } else {
                simLockDO.setOperator(retStr[2]);
            }
            String times = retStr[1];
            simLockDO.setSpareTimes(times);
            if (!"".equals(retStr[0])) {
                int status = Integer.parseInt(retStr[0]);
                switch (status) {
                    case 1: {
                        simLockDO.setLockstatus(1);
                        simLockDO.setHasUnlockRequest(true);
                        break;
                    }
                    case 2: {
                        simLockDO.setLockstatus(2);
                        simLockDO.setHasUnlockRequest(false);
                        simLockDO.setUnlocked(true);
                        break;
                    }
                    case 3: {
                        simLockDO.setLockstatus(3);
                        simLockDO.setForeverlocked(true);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e1) {
            log.info("send AT ^CARDLOCK? COMMAND : [" + e1.toString() + "]");
            return simLockDO;
        }
        log.debug("End the method getSimLockCode()!");
        return simLockDO;
    }

    public void onReceive(String pszData, int iDataSize) {
    }
}

