/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.service;

import com.huawei.mobilePartner.business.sms.commserver.SmsParametersBean;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.data.comm.interfaces.shortMessage.IShortMessage;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import com.huawei.mobilePartner.data.comm.service.SmsCommService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShortMessageImplByGSM
implements IShortMessage {
    private static LogATConfig log = Log.getATLog(ShortMessageImplByGSM.class);
    SmsCommService smsCommService = SmsCommService.getInstance();
    private static final String strATPostfix = "\r" + (char)Integer.parseInt("1a", 16) + "z";
    private static final String strATOK = "OK";
    private static final String strATErr = "ERROR";
    private static final String strATNotSupport = "COMMAND NOT SUPPORT";

    public boolean setSmsDomain(String value) {
        boolean bResult = false;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = "AT+CGSMS=" + value + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("AT+CGSMS=" + value + " return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        bResult = true;
                        log.info("AT+CGSMS=" + value + " return is ok...");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("AT+CGSMS=" + value + " error: " + e.toString());
        }
        return bResult;
    }

    public boolean smsGetWMSBear(SmsParametersBean smsBean) {
        boolean flag = false;
        flag = this.smsCommService.sendMessage(smsBean);
        return flag;
    }

    public boolean setSmsCenterTel(HashMap map) {
        IncomingMessage inMsg;
        boolean returnflag;
        block4: {
            returnflag = true;
            String centerTel = Tools.checkNull(map.get("centerTel"));
            CommServer server = null;
            server = MutiDeviceService.getCurrentServer();
            String at = "AT+CSCA=\"" + centerTel + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CSCA=\"" + centerTel + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block4;
            log.fatal(" function[setSmsCenterTel]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (TextUtil.checkContainStr(receiveContext, strATErr)) {
                returnflag = false;
                log.info("failure: " + receiveContext);
            }
        }
        catch (Exception e) {
            log.info("setSmsCenterTel error: " + e.toString());
            returnflag = false;
        }
        return returnflag;
    }

    public String getSmsCenterTel(HashMap map) {
        String receiveContext;
        block5: {
            IncomingMessage inMsg;
            block4: {
                receiveContext = null;
                CommServer server = null;
                try {
                    server = MutiDeviceService.getCurrentServer();
                    String at = "AT+CSCA?\r" + (char)Integer.parseInt("1a", 16) + "z";
                    String at1 = "AT+CSCA?";
                    OutgoingMessage outMsg = new OutgoingMessage();
                    outMsg.setContent(at);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg != null) break block4;
                    log.fatal(" function[setSmsCenterTel]  failure: AT delay " + at1 + " Object return is null");
                    return "";
                }
                catch (Exception e) {
                    log.info("setSmsCenterTel error: " + e.toString());
                    receiveContext = "";
                    return receiveContext;
                }
            }
            receiveContext = inMsg.getContent();
            if (!TextUtil.checkContainStr(receiveContext, strATErr)) break block5;
            log.info("failure: " + receiveContext);
            return "";
        }
        receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
        receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
        receiveContext = TextUtil.replaceStr(receiveContext, "+CSCA:", "");
        receiveContext = TextUtil.replaceStr(receiveContext, "\"", "");
        receiveContext = TextUtil.replaceStr(receiveContext, " ", "");
        String[] arr = receiveContext.split(",");
        receiveContext = Tools.checkNull(arr[0]);
        log.info("==============center TelHome=====" + receiveContext);
        return receiveContext;
    }

    public boolean setSmsDisabledDate(HashMap map) {
        IncomingMessage inMsg;
        boolean returnflag;
        block4: {
            returnflag = true;
            String disabledDate = Tools.checkNull(map.get("DisabledDate"));
            CommServer server = null;
            server = MutiDeviceService.getCurrentServer();
            String at = "AT+CSMP=53," + disabledDate + ",,0\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CSMP=53," + disabledDate + ",,0\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block4;
            log.fatal(" function[setSmsDisabledDate]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (TextUtil.checkContainStr(receiveContext, strATErr)) {
                returnflag = false;
                log.info("failure: " + receiveContext);
            }
        }
        catch (Exception e) {
            log.info("setSmsDisabledDate error: " + e.toString());
            returnflag = false;
        }
        return returnflag;
    }

    public boolean setSmsStateReport(HashMap map) {
        IncomingMessage inMsg;
        boolean returnflag;
        block4: {
            returnflag = true;
            CommServer server = null;
            server = MutiDeviceService.getCurrentServer();
            String at = "AT+CMEE=1\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CMEE=1";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block4;
            log.fatal(" function[setSmsStateReport]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (TextUtil.checkContainStr(receiveContext, strATErr)) {
                returnflag = false;
                log.info("failure: " + receiveContext);
            }
        }
        catch (Exception e) {
            log.info("setSmsStateReport error: " + e.toString());
            returnflag = false;
        }
        return returnflag;
    }

    public String getSmsStateReport() {
        IncomingMessage inMsg;
        String dd;
        block4: {
            dd = "";
            CommServer server = null;
            server = MutiDeviceService.getCurrentServer();
            String at = "AT+CNMI?\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CNMI?";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block4;
            log.fatal(" function[getSmsStateReport]  failure: AT delay " + at1 + " Object return is null");
            return "0";
        }
        try {
            String receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            receiveContext = TextUtil.replaceStr(receiveContext, strATOK, "");
            receiveContext = TextUtil.replaceStr(receiveContext, "+CNMI:", "");
            if (!Tools.isEmpty(receiveContext) && receiveContext.indexOf(",") > -1) {
                dd = receiveContext.split(",")[3];
                return dd;
            }
            log.info("getSmsStateReport error: receiveContext=" + receiveContext);
        }
        catch (Exception e) {
            log.info("getSmsStateReport error: " + e.toString());
            dd = "0";
        }
        return dd;
    }

    public boolean setSmsLevel(HashMap map) {
        return true;
    }

    public boolean deleteSim(String index) {
        String receiveContext;
        IncomingMessage inMsg;
        boolean returnflag;
        block4: {
            returnflag = true;
            CommServer server = null;
            String at = null;
            String at1 = null;
            OutgoingMessage outMsg = null;
            inMsg = null;
            receiveContext = null;
            server = MutiDeviceService.getCurrentServer();
            at = "AT+CMGD=" + index + "\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT+CMGD=" + index;
            outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block4;
            log.fatal(" function[deleteSim]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            receiveContext = inMsg.getContent();
            if (TextUtil.checkContainStr(receiveContext, strATErr)) {
                returnflag = false;
                log.info("failure: " + receiveContext);
                return returnflag;
            }
        }
        catch (Exception e) {
            log.info("delete  sim  shortMessage  index=" + index + " " + e.toString());
            returnflag = false;
        }
        return returnflag;
    }

    public HashMap readSim(String index) {
        return new HashMap();
    }

    public List readSimList(HashMap map) {
        List returnlist = null;
        CommServer server = null;
        String at = null;
        String at1 = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String receiveContext = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.fatal("==================function[readSimList]  server=null===========================================");
                PublicConfig.simReadResult = "1";
                return new ArrayList();
            }
            String readSimType = Tools.checkNull(map.get("readSimType"));
            at = "AT+CMGL=" + readSimType + "\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT+CMGL=" + readSimType;
            outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.info(" function[readSimList]  failure: AT delay " + at1 + " Object return is null");
                PublicConfig.simReadResult = "1";
            }
            if (TextUtil.checkContainStr(receiveContext = inMsg.getContent(), strATErr)) {
                PublicConfig.simReadResult = "1";
                log.info("*********************readSimList*************************************failure: " + receiveContext);
            } else {
                PublicConfig.simReadResult = "2";
            }
        }
        catch (Exception e) {
            log.info("readSimList error: " + e.toString());
            PublicConfig.simReadResult = "1";
        }
        return returnlist;
    }
}

