/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.service;

import com.huawei.mobilePartner.business.apn.APNEvent;
import com.huawei.mobilePartner.business.device.DeviceService;
import com.huawei.mobilePartner.business.network.CDMASelectNetWork;
import com.huawei.mobilePartner.business.network.DeviceDataXMlUtil;
import com.huawei.mobilePartner.business.network.NetworkThread;
import com.huawei.mobilePartner.business.sms.commserver.CommonMethodBySMS;
import com.huawei.mobilePartner.business.sms.commserver.SMSHelper;
import com.huawei.mobilePartner.business.statistics.ScheduledTask;
import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.interfaces.netService.AbstractNetCommService;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import com.huawei.mobilePartner.data.comm.service.DeviceCommService;
import com.huawei.mobilePartner.data.comm.service.DiagnosisService;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.DiagnosisPanel;
import com.huawei.mobilePartner.gui.ui.NetWorkPanel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class NetCommService
extends AbstractNetCommService {
    LanguageBean lb = null;
    private static LogATConfig log = Log.getATLog(NetCommService.class);
    private SMSHelper smsXml = new SMSHelper();
    public static String networkMode = "";
    public static String cdmaSmsCount = "";
    public static int networkCDMA = 2;
    private static NetCommService netCommService;
    DeviceService dev = DeviceService.getInstance();
    public static long repUploadSpeed;
    public static long repDownSpeed;

    static {
        repUploadSpeed = 0L;
        repDownSpeed = 0L;
    }

    public native void connectNet(APNEvent var1);

    public native void disConnectNet(APNEvent var1);

    public static NetCommService getInstance() {
        if (netCommService == null) {
            netCommService = new NetCommService();
        }
        return netCommService;
    }

    private NetCommService() {
    }

    public String connect(APNEvent apn) {
        String returnInfo = "";
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            try {
                Runtime.getRuntime().exec("shell to connect");
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        } else if (osName.toLowerCase().indexOf("mac") > -1) {
            this.connectNet(apn);
        }
        return returnInfo;
    }

    public String disConnect(APNEvent apn) {
        String returnInfo = "";
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            try {
                Runtime.getRuntime().exec("shell to disConnect");
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        } else if (osName.toLowerCase().indexOf("mac") > -1) {
            this.disConnectNet(apn);
        }
        return returnInfo;
    }

    public void OnReceive(String pszData, int dataSize) {
        if (pszData.indexOf("^RSSILVL") > -1 || pszData.indexOf("^HRSSILVL") > -1) {
            String strRssi = "";
            String strHRssi = "";
            CDMASelectNetWork cdmaSelect = new CDMASelectNetWork();
            switch (networkCDMA) {
                case 2: {
                    strRssi = pszData.substring(pszData.indexOf("^RSSILVL:") + 9, 2).trim();
                    networkMode = "CDMA";
                    cdmaSelect.initiativeChangeView(strRssi, networkMode);
                    break;
                }
                case 4: {
                    strHRssi = pszData.substring(pszData.indexOf("^HRSSILVL:") + 10, 2).trim();
                    networkMode = "EVDO";
                    cdmaSelect.initiativeChangeView(strRssi, networkMode);
                    break;
                }
                case 8: {
                    strRssi = pszData.substring(pszData.indexOf("^RSSILVL:") + 9, 2).trim();
                    strHRssi = pszData.substring(pszData.indexOf("^HRSSILVL:") + 10, 2).trim();
                    if (Integer.parseInt(strHRssi) == 0) {
                        networkMode = "CDMA";
                        cdmaSelect.initiativeChangeView(strRssi, networkMode);
                        break;
                    }
                    networkMode = "EVDO";
                    cdmaSelect.initiativeChangeView(strRssi, networkMode);
                }
            }
        }
    }

    public void srvCDMAPrefMod(int intMode) {
        CommServer server = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvCDMAPrefMod************server==null***************************************");
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent("AT ^PREFMODE=" + intMode + "\r" + (char)Integer.parseInt("1a", 16) + "z");
            networkCDMA = intMode;
            server.send(outMsg, 30, this);
        }
        catch (Exception e1) {
            log.info("send AT^PREFMODE=" + intMode + " COMMAND : [" + e1.toString() + "]");
        }
    }

    public String getCDMANetworkMod() {
        String temp;
        String receiveContext;
        block4: {
            CommServer server = null;
            receiveContext = "";
            temp = "";
            try {
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************getCDMANetworkMod************server==null***************************************");
                }
                OutgoingMessage outMsg = new OutgoingMessage();
                outMsg.setContent("AT ^PREFMODE?\r" + (char)Integer.parseInt("1a", 16) + "z");
                IncomingMessage inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                if (receiveContext.indexOf("ERROR") <= -1 && receiveContext.indexOf("error") <= -1) break block4;
                log.info("send AT ^PREFMODE? COMMAND : [" + receiveContext + "]");
                return "";
            }
            catch (Exception e1) {
                log.info("send AT ^PREFMODE? COMMAND : [" + e1.toString() + "]");
                return "";
            }
        }
        temp = receiveContext.substring(receiveContext.indexOf(":") + 1, receiveContext.indexOf("OK")).trim();
        return temp;
    }

    public int srvGetCurRSSI(String atCommand) {
        String receiveContext;
        block4: {
            CommServer server = null;
            receiveContext = "";
            try {
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************srvGetCurRSSI************server==null***************************************");
                }
                OutgoingMessage outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(atCommand) + (char)Integer.parseInt("1a", 16) + "z");
                IncomingMessage inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                if (receiveContext.indexOf("ERROR") <= -1 && receiveContext.indexOf("error") <= -1) break block4;
                log.info("send " + atCommand + " COMMAND : [" + receiveContext + "]");
                return -1;
            }
            catch (Exception e1) {
                log.info("send " + atCommand + " COMMAND : [" + e1.toString() + "]");
                return -1;
            }
        }
        String temp = "";
        temp = atCommand.indexOf("hdr") > -1 || atCommand.indexOf("HDR") > -1 ? receiveContext.substring(receiveContext.indexOf(":") + 1, receiveContext.indexOf("OK")).trim() : receiveContext.substring(receiveContext.indexOf(":") + 1, receiveContext.indexOf(",")).trim();
        return Integer.parseInt(temp);
    }

    public boolean srvSetCDMAPrefMod(int intMode) {
        boolean bolSend = true;
        CommServer server = null;
        String receiveContext = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvSetCDMAPrefMod************server==null***************************************");
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent("AT^PREFMODE=" + intMode + "\r" + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (receiveContext.indexOf("ERROR") > -1 || receiveContext.indexOf("error") > -1) {
                log.info("send AT^PREFMODE=" + intMode + " COMMAND : [" + receiveContext + "]");
                bolSend = false;
            }
        }
        catch (Exception e1) {
            log.info("send AT^PREFMODE=" + intMode + " COMMAND : [" + e1.toString() + "]");
            bolSend = false;
        }
        return bolSend;
    }

    public int srvIsInfoLVL() {
        String receiveContext;
        block10: {
            CommServer server = null;
            receiveContext = "";
            try {
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************srvIsInfoLVL************server==null***************************************");
                }
                OutgoingMessage outMsg = new OutgoingMessage();
                outMsg.setContent("AT ^PREFMODE?\r" + (char)Integer.parseInt("1a", 16) + "z");
                IncomingMessage inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                if (receiveContext.indexOf("ERROR") <= -1 && receiveContext.indexOf("error") <= -1) break block10;
                log.info("send AT^PREFMODE=? COMMAND : [" + receiveContext + "]");
                return -1;
            }
            catch (Exception e1) {
                log.info("send AT^PREFMODE=? COMMAND : [" + e1.toString() + "]");
                return -1;
            }
        }
        String tempInfo = receiveContext.substring(receiveContext.indexOf(":") + 1, receiveContext.indexOf("OK")).trim();
        int modeInt = Integer.parseInt(tempInfo);
        int tempInt = -1;
        switch (modeInt) {
            case 2: {
                tempInt = this.srvGetCurRSSI("AT ^CSQLVL\r");
                networkMode = "CDMA";
                break;
            }
            case 4: {
                tempInt = this.srvGetCurRSSI("AT ^HDRCSQLVL\r");
                networkMode = "EVDO";
                break;
            }
            case 8: {
                if (this.srvGetCurRSSI("AT ^HDRCSQLVL\r") == 0 || this.srvGetCurRSSI("AT ^HDRCSQLVL\r") == -1) {
                    tempInt = this.srvGetCurRSSI("AT ^CSQLVL\r");
                    networkMode = "CDMA";
                    break;
                }
                tempInt = this.srvGetCurRSSI("AT ^HDRCSQLVL\r");
                networkMode = "HYBRID";
            }
        }
        return tempInt;
    }

    public boolean networkTypeRegister(String networkType, String channel) {
        block13: {
            String at;
            IncomingMessage inMsg;
            OutgoingMessage outMsg;
            String receiveContext;
            CommServer server;
            block12: {
                server = null;
                receiveContext = "";
                outMsg = null;
                inMsg = null;
                at = "";
                try {
                    log.info("start the method networkTypeRegister from NetCommService");
                    server = MutiDeviceService.getCurrentServer();
                    if (server == null) {
                        log.info("*********************************networkTypeRegister************server==null***************************************");
                    }
                    at = "AT^SYSCFG?\r";
                    outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    if (!receiveContext.toString().equals("ERROR")) break block12;
                    log.info("end the method networkTypeRegister from NetCommService");
                    return false;
                }
                catch (Exception e1) {
                    log.info(e1.toString());
                    return false;
                }
            }
            String temp = receiveContext.substring(8, receiveContext.length());
            temp = temp.substring(0, temp.indexOf("OK")).trim();
            String[] result = temp.split(",");
            if (channel.toLowerCase().indexOf("0x") > -1) {
                channel = channel.substring(channel.toLowerCase().indexOf("0x") + 2, channel.length());
            }
            String mode = "";
            String acqorder = "";
            if (networkType.toLowerCase().indexOf("0x") > -1) {
                networkType = networkType.substring(networkType.toLowerCase().indexOf("0x") + 2, networkType.length());
                if ("1".equals(networkType = String.valueOf(TextUtil.stringFormat(networkType, 16))) || "2".equals(networkType)) {
                    acqorder = networkType;
                    at = "AT^SYSCFG=2," + acqorder + "," + channel + "," + result[3] + "," + result[4] + "\r";
                } else {
                    mode = networkType;
                    at = "AT^SYSCFG=" + mode + "," + result[1] + "," + channel + "," + result[3] + "," + result[4] + "\r";
                }
            } else if ("1".equals(networkType = String.valueOf(TextUtil.stringFormat(networkType, 16))) || "2".equals(networkType)) {
                acqorder = networkType;
                at = "AT^SYSCFG=2," + acqorder + "," + channel + "," + result[3] + "," + result[4] + "\r";
            } else {
                mode = networkType;
                at = "AT^SYSCFG=" + mode + "," + result[1] + "," + channel + "," + result[3] + "," + result[4] + "\r";
            }
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (receiveContext.toString().trim().toUpperCase().indexOf("OK") <= -1) break block13;
            log.info("end the method networkTypeRegister from NetCommService");
            return true;
        }
        log.info("end the method networkTypeRegister from NetCommService");
        return false;
    }

    public String getcurrentOrderAndBand() {
        String receiveContext;
        block6: {
            CommServer server = null;
            receiveContext = "";
            OutgoingMessage outMsg = null;
            IncomingMessage inMsg = null;
            String at = "";
            log.info("start the method networkTypeRegister from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getcurrentOrderAndBand************server==null***************************************");
            }
            at = "AT^SYSCFG?\r";
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (!receiveContext.toUpperCase().equals("ERROR")) break block6;
            log.info("end the method networkTypeRegister from NetCommService");
            return "";
        }
        try {
            if (receiveContext.toUpperCase().indexOf("^SYSCFG:") > -1) {
                receiveContext = receiveContext.substring(receiveContext.toUpperCase().indexOf("^SYSCFG:") + 8, receiveContext.length());
            }
            if (receiveContext.indexOf("OK") > -1) {
                receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK"));
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        return receiveContext;
    }

    public int getCurrentCSQ() {
        CommServer server = null;
        String receiveContext = "";
        String intCDMARSSI = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method getCurrentCSQ from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getCurrentCSQ************server==null***************************************");
            }
            at = "AT+CSQ\r";
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (receiveContext.indexOf("+CSQ:") > -1) {
                intCDMARSSI = receiveContext.substring(receiveContext.indexOf("+CSQ:") + 5, receiveContext.length()).trim();
                intCDMARSSI = intCDMARSSI.substring(0, intCDMARSSI.indexOf("OK"));
                intCDMARSSI = intCDMARSSI.substring(0, intCDMARSSI.indexOf(",")).trim();
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        log.info("end the method getCurrentCSQ from NetCommService");
        return Integer.parseInt(intCDMARSSI);
    }

    public String getCunrrentCSNR() {
        String intCDMARSSI;
        String receiveContext;
        block7: {
            CommServer server = null;
            receiveContext = "";
            intCDMARSSI = "";
            OutgoingMessage outMsg = null;
            IncomingMessage inMsg = null;
            String at = "";
            log.info("start the method getCurrentCSQ from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getCurrentCSQ************server==null***************************************");
            }
            at = "AT^CSNR?\r";
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (!TextUtil.checkContainStr(receiveContext, "ERROR")) break block7;
            return "";
        }
        try {
            if (receiveContext.indexOf("^CSNR:") > -1) {
                intCDMARSSI = receiveContext.substring(receiveContext.indexOf("^CSNR:") + 6, receiveContext.length()).trim();
                intCDMARSSI = intCDMARSSI.substring(0, intCDMARSSI.indexOf("OK"));
                intCDMARSSI = TextUtil.replaceStr(intCDMARSSI, "\n", "");
                intCDMARSSI = TextUtil.replaceStr(intCDMARSSI, "\r", "");
                intCDMARSSI = TextUtil.replaceStr(intCDMARSSI, " ", "");
                return intCDMARSSI;
            }
            if (TextUtil.checkContainStr(receiveContext, "COMMAND NOT SUPPORT") || TextUtil.checkContainStr(TextUtil.replaceStr(receiveContext, " ", ""), "COMMANDNOTSUPPORT")) {
                return "";
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        log.info("end the method getCurrentCSQ from NetCommService");
        return intCDMARSSI;
    }

    public List getOperatorNameList(int registerkType) {
        CommServer server = null;
        String receiveContext = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        ArrayList listAll = new ArrayList();
        try {
            log.info("satrt the method getOperatorNameList from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getOperatorNameList************server==null***************************************");
            }
            if (registerkType == 0) {
                at = "AT+COPS=0\r";
                outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                if (receiveContext.toString().trim().toUpperCase().indexOf("OK") > -1) {
                    at = "AT+COPS?\r";
                    outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                }
            } else {
                at = "AT+COPS=?\r";
                outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 120);
                receiveContext = inMsg.getContent();
                String temp = receiveContext.substring(receiveContext.indexOf("+COPS:") + 6, receiveContext.length());
                temp = temp.substring(0, temp.indexOf("OK")).trim();
                temp = temp.substring(0, temp.indexOf(",,"));
                temp = temp.replace("(2G)", "");
                temp = temp.replace("(3G)", "");
                StringTokenizer str = new StringTokenizer(temp, ")");
                boolean i = false;
                ArrayList<String> list0 = new ArrayList<String>();
                ArrayList<String> list1 = new ArrayList<String>();
                ArrayList<String> list2 = new ArrayList<String>();
                ArrayList<String> list3 = new ArrayList<String>();
                ArrayList<String> list4 = new ArrayList<String>();
                String a = "";
                String b = "";
                String c = "";
                while (str.hasMoreElements()) {
                    String[] temp1;
                    if (!i) {
                        temp1 = str.nextElement().toString().split(",");
                        a = temp1[1].replace("\"", "");
                        b = temp1[2].replace("\"", "");
                        c = temp1[3].replace("\"", "");
                        list0.add(temp1[0].replace("(", ""));
                        list1.add(a);
                        list2.add(b);
                        list3.add(c);
                        list4.add(temp1[4]);
                        i = true;
                        continue;
                    }
                    temp1 = str.nextElement().toString().split(",");
                    a = temp1[2].replace("\"", "");
                    b = temp1[3].replace("\"", "");
                    c = temp1[4].replace("\"", "");
                    list0.add(temp1[1].replace("(", ""));
                    list1.add(a);
                    list2.add(b);
                    list3.add(c);
                    list4.add(temp1[5]);
                }
                listAll.add(list0);
                listAll.add(list1);
                listAll.add(list2);
                listAll.add(list3);
                listAll.add(list4);
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        log.info("end the method getOperatorNameList from NetCommService");
        return listAll;
    }

    public boolean srvRegisterCallback(String operatorName) {
        CommServer server = null;
        String receiveContext = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method srvRegisterCallback from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvRegisterCallback************server==null***************************************");
            }
            at = "AT+cops?\r";
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (receiveContext.indexOf("OK") > -1) {
                receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                receiveContext = receiveContext.substring(receiveContext.length() - 1, receiveContext.length());
            }
        }
        catch (Exception e) {
            log.info(e.toString());
            receiveContext = "";
        }
        try {
            String[] aa = operatorName.split(",");
            at = "AT+COPS=1,2,\"" + aa[0].trim() + "\"\r";
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 120);
            receiveContext = inMsg.getContent();
        }
        catch (Exception e) {
            log.info(e.toString());
            receiveContext = "";
        }
        if (receiveContext.toString().toUpperCase().indexOf("OK") > -1) {
            log.info("network register scuess");
            return true;
        }
        log.info("network register failed");
        log.info("end the method srvRegisterCallback from NetCommService");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegisterInfo() {
        CommServer server = null;
        String receiveContext = "";
        String temp = "";
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method getRegisterInfo from NetCommService");
            Object object = CommServer.readWriteLock;
            synchronized (object) {
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************getRegisterInfo************server==null***************************************");
                }
                at = "AT+cops?\r";
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                if (receiveContext == null) {
                    temp = "";
                    return temp;
                }
                if (receiveContext.toUpperCase().indexOf("+COPS:") > -1) {
                    temp = receiveContext.substring(receiveContext.indexOf("+COPS:") + 6, receiveContext.length()).trim();
                }
                if (temp.toUpperCase().indexOf("OK") > -1) {
                    temp = temp.substring(0, temp.indexOf("OK")).trim();
                }
                if (temp.indexOf("\"") <= -1) {
                    return temp;
                }
                if (!temp.substring(2, 3).equals("2")) {
                    at = "AT+cops=3,2\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    at = "AT+cops?\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    if (receiveContext.toUpperCase().indexOf("+COPS:") > -1) {
                        temp = receiveContext.substring(receiveContext.indexOf("+COPS:") + 6, receiveContext.length()).trim();
                    }
                    if (temp.toUpperCase().indexOf("OK") > -1) {
                        temp = temp.substring(0, temp.indexOf("OK")).trim();
                    }
                }
            }
        }
        catch (Exception e) {
            log.info(e.toString());
            e.printStackTrace();
            temp = "";
        }
        log.info("end the method getRegisterInfo from NetCommService");
        return temp;
    }

    public boolean networkRegister2(String registerInfo) {
        CommServer server = null;
        String receiveContext = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method networkRegister2 from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************networkRegister2************server==null***************************************");
            }
            at = "AT+cops?\r";
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            if (receiveContext.indexOf("OK") > -1) {
                receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                receiveContext = receiveContext.substring(receiveContext.length() - 1, receiveContext.length());
            }
        }
        catch (Exception e) {
            log.info(e.toString());
            receiveContext = "";
        }
        try {
            String[] temp = registerInfo.split(",");
            at = "AT+COPS=" + temp[0] + "," + temp[1] + "," + temp[2] + "\r";
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        if (receiveContext.toString().toUpperCase().indexOf("OK") > -1) {
            log.info("network register scuess");
            return true;
        }
        log.info("network register failed");
        log.info("end the method networkRegister2 from NetCommService");
        return false;
    }

    public String getOperatorName() {
        CommServer server = null;
        String receiveContext = "";
        try {
            log.info("start the method getOperatorName from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getOperatorName************server==null***************************************");
            }
            String at = "AT+CGMM\r";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            String temp = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
            if (temp.indexOf("AT+CGMM") > -1) {
                temp = temp.substring(temp.indexOf("AT+CGMM") + 7, temp.length()).trim();
            }
            log.info("end the method getOperatorName from NetCommService");
            return temp;
        }
        catch (Exception e1) {
            log.info(e1.toString());
            return "";
        }
    }

    public String getSysinfo() {
        CommServer server = null;
        String receiveContext = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getSysinfo************server==null***************************************");
            }
            String at = "AT^SYSINFO\r";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.info("query NetworkMode error");
            }
            String temp = receiveContext = inMsg.getContent();
            if (receiveContext.indexOf("OK") > -1) {
                temp = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
            }
            if (temp.indexOf("^SYSINFO:") > -1) {
                temp = temp.substring(temp.indexOf("^SYSINFO:") + 9, temp.length()).trim();
            }
            if (temp.indexOf("^SYSINFO:") > -1) {
                temp = temp.substring(temp.indexOf("^SYSINFO:") + 9, temp.length()).trim();
            }
            return temp;
        }
        catch (Exception e1) {
            log.info(e1.toString());
            return "";
        }
    }

    public boolean setCNMI() {
        try {
            log.info("start the method setCNMI from NetCommService");
            CommServer server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************setCNMI**************server is null*******************");
            }
            log.info("setCNMI=" + MutiDeviceService.getCurrentDeviceType());
            String at = "AT+CNMI=2,1,2,2,0\r";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            String receiveContext = inMsg.getContent();
            return true;
        }
        catch (Exception ex) {
            log.info("set cnmi exception!");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sysInit(String SMMode) {
        Object object = CommServer.readWriteLock;
        synchronized (object) {
            boolean flag = false;
            try {
                try {
                    log.info("start the method sysInit from NetCommService");
                    CommServer server = MutiDeviceService.getCurrentServer();
                    if (server == null) {
                        log.info("*********************************sysInit************server==null***************************************");
                    }
                    Tools.logToControl("out", "MutiDeviceService.getCurrentDeviceType()=" + MutiDeviceService.getCurrentDeviceType());
                    String at = "AT+CNMI=2,1,2,2,0\r";
                    OutgoingMessage outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    IncomingMessage inMsg = server.send(outMsg, 30);
                    String receiveContext = inMsg.getContent();
                    at = "AT+CMGF=" + SMMode + "\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    at = "AT^BOOT=0,0\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    at = "AT+CMEE=1\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    at = "AT^HS=0,0\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    if (DeviceCommService.productType.equals("WCDMA")) {
                        at = "AT+cops=3,2\r";
                        outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                        inMsg = server.send(outMsg, 30);
                        receiveContext = inMsg.getContent();
                    }
                    if (DeviceCommService.productType.equals("WCDMA")) {
                        at = "AT^SYSCFG?\r";
                        outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                        inMsg = server.send(outMsg, 30);
                        receiveContext = inMsg.getContent();
                        if (!receiveContext.toUpperCase().equals("ERROR") && !receiveContext.toUpperCase().equals("COMMAND NOT SUPPORT")) {
                            if (receiveContext.toUpperCase().indexOf("^SYSCFG:") > -1) {
                                receiveContext = receiveContext.substring(receiveContext.toUpperCase().indexOf("^SYSCFG:") + 8, receiveContext.length());
                            }
                            if (receiveContext.indexOf("OK") > -1) {
                                receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK"));
                            }
                            NetWorkPanel.setOrderAndBand(receiveContext);
                        }
                    }
                    at = "AT^SYSINFO\r";
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    if (receiveContext.indexOf("OK") > -1) {
                        receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                    }
                    if (receiveContext.indexOf("^SYSINFO:") > -1) {
                        receiveContext = receiveContext.substring(receiveContext.indexOf("^SYSINFO:") + 9, receiveContext.length()).trim();
                    }
                    PublicConfig.serviceFlag = receiveContext.substring(0, 1).equals("2");
                    log.info("PublicConfig.serviceFlag=" + PublicConfig.serviceFlag);
                    NetworkThread.getNetworkThread().dialogInt = true;
                    NetworkThread.getNetworkThread().showInfoToUI(receiveContext);
                    flag = true;
                    log.info("end the method sysInit from NetCommService");
                }
                catch (Exception e1) {
                    log.info("NetCommService the 1183 line Exception.the method sysInit Exception" + e1.toString());
                    e1.printStackTrace();
                    flag = false;
                }
            }
            catch (Throwable throwable) {}
            log.info("sysInit the flag=" + flag);
            return flag;
        }
    }

    private String execute(CommServer server) {
        String at = "AT+CPMS=\"SM\",\"SM\",\"SM\"\r";
        OutgoingMessage outMsg = new OutgoingMessage();
        outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
        IncomingMessage inMsg = server.send(outMsg, 30);
        String receiveContext = inMsg.getContent();
        at = "at+cmgd=?\r";
        outMsg = new OutgoingMessage();
        outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
        inMsg = server.send(outMsg, 30);
        receiveContext = inMsg.getContent();
        return receiveContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] autoReceiveDeviceMessage() {
        Object object = CommServer.readWriteLock;
        synchronized (object) {
            try {
                log.info("start the method autoReceiveSIMMessage from NetCommService");
                CommServer server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************autoReceiveSIMMessage0************server==null***************************************");
                }
                OutgoingMessage outMsg = new OutgoingMessage();
                String shortMessageMemory = DeviceDataXMlUtil.getSMSMedium("ShortMessageMemory").toString();
                String[] shortMessageMemorys = shortMessageMemory.split(",");
                String at = "AT+CPMS=\"ME\",\"SM\",\"SM\"\r";
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                IncomingMessage inMsg = server.send(outMsg, 30);
                String receiveContext = inMsg.getContent();
                shortMessageMemorys = receiveContext.split(",");
                cdmaSmsCount = String.valueOf(shortMessageMemorys[0].substring(6)) + "/" + shortMessageMemorys[1];
                at = "at+cmgd=?\r";
                outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                    receiveContext = this.execute(server);
                    int i = 0;
                    while (i < 10) {
                        if (!TextUtil.checkContainStr(receiveContext, "ERROR")) break;
                        try {
                            Thread.sleep(PublicConfig.simReadThreadSleepTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        receiveContext = this.execute(server);
                        ++i;
                    }
                }
                log.info("********************NetCommService *********************receiveContext=" + receiveContext);
                if (receiveContext.indexOf("+CMGD:") > -1) {
                    receiveContext = receiveContext.substring(receiveContext.indexOf("+CMGD:") + 6);
                }
                if (receiveContext.indexOf("OK") > -1) {
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                }
                if (receiveContext.indexOf(",(") > -1) {
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf(",("));
                }
                receiveContext = receiveContext.replace("(", "");
                receiveContext = receiveContext.replace(")", "");
                receiveContext = receiveContext.replace(" ", "");
                String[] temp = receiveContext.split(",");
                log.info("*********autoReceiveSIMMessage0*****temp******************temp=" + temp);
                return temp;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                log.info("*********autoReceiveSIMMessage0****e1=" + e1.toString());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] autoReceiveSIMMessage0() {
        Object object = CommServer.readWriteLock;
        synchronized (object) {
            try {
                log.info("start the method autoReceiveSIMMessage from NetCommService");
                CommServer server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************autoReceiveSIMMessage0************server==null***************************************");
                }
                String at = "AT+CPMS=\"SM\",\"SM\",\"SM\"\r";
                OutgoingMessage outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                IncomingMessage inMsg = server.send(outMsg, 30);
                String receiveContext = inMsg.getContent();
                at = "at+cmgd=?\r";
                outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                log.info("********************NetCommService *********************receiveContext=" + receiveContext);
                if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                    receiveContext = this.execute(server);
                    int i = 0;
                    while (i < 10) {
                        if (!TextUtil.checkContainStr(receiveContext, "ERROR")) break;
                        try {
                            Thread.sleep(PublicConfig.simReadThreadSleepTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        receiveContext = this.execute(server);
                        ++i;
                    }
                }
                log.info("********************NetCommService *********************receiveContext=" + receiveContext);
                if (receiveContext.indexOf("+CMGD:") > -1) {
                    receiveContext = receiveContext.substring(receiveContext.indexOf("+CMGD:") + 6);
                }
                if (receiveContext.indexOf("OK") > -1) {
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                }
                if (receiveContext.indexOf(",(") > -1) {
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf(",("));
                }
                receiveContext = receiveContext.replace("(", "");
                receiveContext = receiveContext.replace(")", "");
                receiveContext = receiveContext.replace(" ", "");
                String[] temp = receiveContext.split(",");
                log.info("*********autoReceiveSIMMessage0*****temp******************temp=" + temp);
                return temp;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                log.info("*********autoReceiveSIMMessage0****e1=" + e1.toString());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String autoReceiveSIMMessage2(int index) {
        Object object = CommServer.readWriteLock;
        synchronized (object) {
            try {
                log.info("start the method autoReceiveSIMMessage2 from NetCommService");
                CommServer server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************autoReceiveSIMMessage2************server==null***************************************");
                }
                String at = "AT+CPMS=\"SM\",\"SM\",\"SM\"\r";
                OutgoingMessage outMsg = null;
                IncomingMessage inMsg = null;
                String receiveContext = null;
                receiveContext = "";
                if (CommonMethodBySMS.getProductNetType().equalsIgnoreCase("CDMA")) {
                    at = "AT^HCMGR=" + index + ",1\r";
                    outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    log.info("**********************autoReceiveSIMMessage2**********index=" + index + "   receiveContext=" + receiveContext);
                    Tools.logToControl("err", "**********************autoReceiveSIMMessage2**********index=" + index + "   receiveContext=" + receiveContext);
                    receiveContext = receiveContext.substring(receiveContext.indexOf("^HCMGR:") + 7);
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                } else {
                    at = "AT+CMGR=" + index + "\r";
                    outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    log.info("**********************autoReceive  SIM  shortMessage**********index=" + index + "   receiveContext=" + receiveContext);
                    receiveContext = receiveContext.substring(receiveContext.indexOf("+CMGR:") + 6);
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                }
                log.info("end the method autoReceiveSIMMessage2 from NetCommService");
                return receiveContext;
            }
            catch (Exception e1) {
                log.info(e1.toString());
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String autoReceiveDeviceMessage(int index) {
        Object object = CommServer.readWriteLock;
        synchronized (object) {
            try {
                CommServer server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************autoReceiveDeviceMessage2************server==null***************************************");
                }
                String at = "AT+CPMS=\"ME\",\"SM\",\"SM\"\r";
                OutgoingMessage outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                IncomingMessage inMsg = server.send(outMsg, 30);
                String receiveContext = inMsg.getContent();
                receiveContext = "";
                if (CommonMethodBySMS.getProductNetType().equalsIgnoreCase("CDMA")) {
                    at = this.smsXml.isSaveToLocal().equals("1") ? "AT^HCMGR=" + index + ",1\r" : "AT^HCMGR=" + index + ",0\r";
                    outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    receiveContext = receiveContext.substring(receiveContext.indexOf("^HCMGR:") + 7);
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                } else {
                    at = "AT+CMGR=" + index + "\r";
                    outMsg = new OutgoingMessage();
                    outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                    inMsg = server.send(outMsg, 30);
                    receiveContext = inMsg.getContent();
                    receiveContext = receiveContext.substring(receiveContext.indexOf("+CMGR:") + 6);
                    receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
                }
                log.info("end the method autoReceiveDeviceMessage2 from NetCommService");
                return receiveContext;
            }
            catch (Exception e1) {
                log.info(e1.toString());
                return "";
            }
        }
    }

    public HashMap queryPwdLength(HashMap m) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        CommServer server = null;
        String at = null;
        String length = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************queryPwdLength************server==null***************************************");
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            at = "AT+CPWD=?\r" + (char)Integer.parseInt("1a", 16) + "z";
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryPwdLength]  failure: AT delay AT+CPWD=?  Object return is null");
                length = PublicConfig.PinLength;
            }
            String receiveContext = inMsg.getContent();
            String[] s1 = new String[]{"\n", "\r", "(", ")", "AT+CPWD=?", "OK", "+CPWD:", "\""};
            String[] s2 = new String[]{"", "", "", "", "", "", "", ""};
            receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
            String[] arr1 = TextUtil.split(receiveContext, ",");
            if (TextUtil.checkContainStr(receiveContext, "sim puk required") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12")) {
                log.warn("+sim puk required");
                length = PublicConfig.PinLength;
            } else {
                int i = 0;
                while (i < arr1.length) {
                    if (arr1[i].equalsIgnoreCase("sc")) {
                        PublicConfig.PinLength = length = arr1[i + 1];
                    }
                    ++i;
                }
            }
            map.put("SC", length);
            PublicConfig.PinLength = length;
        }
        catch (Exception e) {
            map.put("SC", PublicConfig.PinLength);
        }
        return map;
    }

    public HashMap queryPinPukCount(HashMap m) throws Exception {
        HashMap<String, Object> map = null;
        CommServer server = null;
        String receiveContextNoSpace = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (Tools.isEmpty(server)) {
                log.fatal("***********PublicConfig.isDSFLOWRPT=" + PublicConfig.isDSFLOWRPT + "*************************function[queryPinPukCount] AT[AT^CPIN?] return  error  server==null*************************************");
                map = new HashMap();
                map.put("pin_times", "3");
                map.put("puk_times", "10");
                map.put("pin2_times", "3");
                map.put("puk2_times", "10");
                return map;
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent("AT^CPIN?\r" + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal("*****************PublicConfig.isDSFLOWRPT=" + PublicConfig.isDSFLOWRPT + "********************function[queryPinPukCount] AT[AT^CPIN?] return  error  inMsg==null*************************************");
                map = new HashMap();
                map.put("pin_times", "3");
                map.put("puk_times", "10");
                map.put("pin2_times", "3");
                map.put("puk2_times", "10");
                return map;
            }
            String receiveContext = inMsg.getContent();
            log.info("************************PublicConfig.isDSFLOWRPT=" + PublicConfig.isDSFLOWRPT + "*************function[queryPinPukCount] AT[AT^CPIN?] return  receiveContext=" + receiveContext);
            String[] s1 = new String[]{"\n", "\r", "OK"};
            String[] s2 = new String[]{"", "", ""};
            receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                log.warn("***************************queryPinPukCount**********+CME ERROR: SIM busy*************************************");
                map = new HashMap();
                map.put("pin_times", PublicConfig.usimFailure);
                map.put("puk_times", PublicConfig.usimFailure);
                map.put("pin2_times", PublicConfig.usimFailure);
                map.put("puk2_times", PublicConfig.usimFailure);
                return map;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure")) {
                log.warn("***************************queryPinPukCount**********+CME ERROR: SIM failure*************************************");
                map = new HashMap();
                map.put("pin_times", PublicConfig.usimFailure);
                map.put("puk_times", PublicConfig.usimFailure);
                map.put("pin2_times", PublicConfig.usimFailure);
                map.put("puk2_times", PublicConfig.usimFailure);
                return map;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                log.warn("****************************queryPinPukCount*********+CME ERROR: SIM wrong*************************************");
                map = new HashMap();
                map.put("pin_times", PublicConfig.usimFailure);
                map.put("puk_times", PublicConfig.usimFailure);
                map.put("pin2_times", PublicConfig.usimFailure);
                map.put("puk2_times", PublicConfig.usimFailure);
                return map;
            }
            String[] arr = receiveContext.split(",");
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                map = new HashMap();
                map.put("pin_times", 3);
                map.put("puk_times", 10);
                map.put("pin2_times", 3);
                map.put("puk2_times", 10);
                return map;
            }
            map = new HashMap();
            if (Tools.isEmpty(receiveContextNoSpace)) {
                return this.queryPinPukCount(new HashMap());
            }
            if (TextUtil.checkContainStr(receiveContextNoSpace, "SIMPIN") || TextUtil.checkContainStr(receiveContext, "SIM PIN")) {
                if (Tools.isEmpty(TextUtil.rRight(receiveContextNoSpace, "SIMPIN,").split(",")[0])) {
                    return this.queryPinPukCount(new HashMap());
                }
                map.put("pin_times", TextUtil.rRight(receiveContextNoSpace, "SIMPIN,").split(",")[2]);
                map.put("puk_times", TextUtil.rRight(receiveContextNoSpace, "SIMPIN,").split(",")[1]);
            }
            if (TextUtil.checkContainStr(receiveContextNoSpace, "CPIN:READY") || TextUtil.checkContainStr(receiveContext, "CPIN: READY")) {
                String[] divRes = TextUtil.split(receiveContextNoSpace, ",");
                if (divRes.length == 6) {
                    map.put("pin_times", divRes[3]);
                    map.put("puk_times", divRes[2]);
                } else {
                    map = new HashMap();
                    map.put("pin_times", PublicConfig.deviceFailure);
                    map.put("puk_times", PublicConfig.deviceFailure);
                    map.put("pin2_times", PublicConfig.deviceFailure);
                    map.put("puk2_times", PublicConfig.deviceFailure);
                    return map;
                }
            }
            if (TextUtil.checkContainStr(receiveContextNoSpace, "SIMPUK") || TextUtil.checkContainStr(receiveContext, "SIM PUK")) {
                if (Tools.isEmpty(TextUtil.rRight(receiveContextNoSpace, "SIMPUK,").split(",")[2])) {
                    return this.queryPinPukCount(new HashMap());
                }
                map.put("pin_times", TextUtil.rRight(receiveContextNoSpace, "SIMPUK,").split(",")[2]);
                map.put("puk_times", TextUtil.rRight(receiveContextNoSpace, "SIMPUK,").split(",")[1]);
            }
            return map;
        }
        catch (Exception e) {
            log.info("queryPinPukCount error: " + e.toString());
            map = new HashMap<String, Object>();
            map.put("pin_times", PublicConfig.deviceFailure);
            map.put("puk_times", PublicConfig.deviceFailure);
            map.put("pin2_times", PublicConfig.deviceFailure);
            map.put("puk2_times", PublicConfig.deviceFailure);
            return map;
        }
    }

    public HashMap queryPinStatus(HashMap m) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        CommServer server = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.fatal("*********************************queryPinStatus************server==null***************************************");
            }
            String at = "AT+CLCK=\"SC\",2\r";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryPinStatus]  failure: AT delay AT+CLCK=\"SC\",2 Object return is null");
                map.put("pinStatus", "3");
                return map;
            }
            String receiveContext = inMsg.getContent();
            String[] s1 = new String[]{"\n", "\r", "AT+CLCK=\"SC\",2", "+CLCK:", "OK"};
            String[] s2 = new String[]{"", "", "", "", ""};
            if (TextUtil.checkContainStr(receiveContext = TextUtil.replaceStr(receiveContext, s1, s2), "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure")) {
                log.warn("+CME ERROR: SIM failure");
                map.put("pinStatus", "3");
                return map;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy")) {
                log.warn("+CME ERROR: SIM busy");
                map.put("pinStatus", "3");
                return map;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong")) {
                log.warn("+CME ERROR: SIM wrong");
                map.put("pinStatus", "3");
                return map;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "SIM PUK required")) {
                log.warn("SIM PUK required");
                map.put("pinStatus", "2");
                return map;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 11") || TextUtil.checkContainStr(receiveContext, "SIM PIN required")) {
                log.warn("SIM PIN required");
                receiveContext = "1";
            }
            map.put("pinStatus", receiveContext);
        }
        catch (Exception e) {
            map.put("pinStatus", "3");
            log.info("queryPinStatus error: " + e.toString());
        }
        return map;
    }

    public List menuShowStatus(HashMap m) throws Exception {
        ArrayList<String> list = null;
        HashMap map = null;
        try {
            map = this.queryPinStatus(new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String statusValue = Tools.checkNull(map.get("pinStatus"));
            int pin_times = 0;
            int puk_times = 0;
            int puk2_times = 0;
            int pin2_times = 0;
            if (PublicConfig.atDelay.equals(statusValue)) {
                list = new ArrayList<String>();
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                return list;
            }
            if (PublicConfig.requirePukDecode.equals(statusValue)) {
                list = new ArrayList();
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuShowFlag);
                return list;
            }
            HashMap map1 = null;
            try {
                map1 = this.queryPinPukCount(new HashMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (PublicConfig.deviceFailure.equals(Tools.checkNull(map1.get("pin_times"))) || PublicConfig.usimFailure.equals(Tools.checkNull(map1.get("pin_times")))) {
                list = new ArrayList();
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                return list;
            }
            if (PublicConfig.requirePinEfficacy.equals(Tools.checkNull(map1.get("pin_times")))) {
                list = new ArrayList();
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuShowFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                return list;
            }
            if (!"".equals(Tools.checkNull(map1.get("pin_times")))) {
                pin_times = Integer.parseInt(Tools.checkNull(map1.get("pin_times")));
            }
            if (!"".equals(Tools.checkNull(map1.get("puk_times")))) {
                puk_times = Integer.parseInt(Tools.checkNull(map1.get("puk_times")));
            }
            if (!"".equals(Tools.checkNull(map1.get("pin2_times")))) {
                pin2_times = Integer.parseInt(Tools.checkNull(map1.get("pin2_times")));
            }
            if (!"".equals(Tools.checkNull(map1.get("puk2_times")))) {
                puk2_times = Integer.parseInt(Tools.checkNull(map1.get("puk2_times")));
            }
            if (puk_times == 0 || puk2_times == 0) {
                list = new ArrayList();
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                return list;
            }
            if (statusValue.equalsIgnoreCase(PublicConfig.pinForbid)) {
                list = new ArrayList();
                list.add(PublicConfig.menuShowFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
            } else if (puk_times == 0 || puk2_times == 0) {
                list = new ArrayList();
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuHideFlag);
                list.add(PublicConfig.menuShowFlag);
            } else {
                list = new ArrayList();
                if (this.IsPinEfficacyByWCDMA(map).equals(PublicConfig.requirePinEfficacy)) {
                    list.add(PublicConfig.menuHideFlag);
                    list.add(PublicConfig.menuHideFlag);
                    list.add(PublicConfig.menuShowFlag);
                    list.add(PublicConfig.menuHideFlag);
                    list.add(PublicConfig.menuHideFlag);
                } else {
                    list.add(PublicConfig.menuHideFlag);
                    list.add(PublicConfig.menuShowFlag);
                    list.add(PublicConfig.menuHideFlag);
                    list.add(PublicConfig.menuShowFlag);
                    list.add(PublicConfig.menuHideFlag);
                }
            }
        }
        catch (Exception ex) {
            log.info("menuShowStatus error: " + ex.toString());
            ex.printStackTrace();
        }
        return list;
    }

    public boolean srvChangePin(String pszOldPinCode, String pszNewPinCode) {
        IncomingMessage inMsg;
        boolean bolSend;
        block6: {
            CommServer server;
            block5: {
                server = null;
                bolSend = false;
                server = MutiDeviceService.getCurrentServer();
                if (server != null) break block5;
                log.info("*********************************srvChangePin************server==null***************************************");
                return false;
            }
            String at = "AT+CPWD=\"SC\",\"" + pszOldPinCode + "\",\"" + pszNewPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CPWD=\"SC\",\"" + pszOldPinCode + "\",\"" + pszNewPinCode + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block6;
            log.fatal(" function[srvChangePin]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            log.info("==function[srvChangePin]--receiveContext=" + receiveContext);
            Tools.logToControl("err", "==function[srvChangePin]--receiveContext=" + receiveContext);
            if (!TextUtil.checkContainStr(receiveContext, "ERROR")) {
                bolSend = true;
                return bolSend;
            }
            bolSend = false;
            log.info("failure: " + receiveContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            bolSend = false;
            log.info("srvChangePin error: " + e.toString());
        }
        return bolSend;
    }

    public boolean srvDisablePin(String pszPinCode) {
        IncomingMessage inMsg;
        boolean bolSend;
        block7: {
            CommServer server;
            block6: {
                server = null;
                bolSend = false;
                server = MutiDeviceService.getCurrentServer();
                if (server != null) break block6;
                log.info("*********************************srvDisablePin************server==null***************************************");
                return false;
            }
            String at = "AT+CLCK=\"SC\",0,\"" + pszPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CLCK=\"SC\",0,\"" + pszPinCode + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block7;
            log.fatal(" function[srvDisablePin]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            log.info("==function[srvDisablePin]--receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                bolSend = false;
                log.info("failure: " + receiveContext);
            } else {
                bolSend = true;
            }
        }
        catch (Exception e) {
            bolSend = false;
            log.info("srvDisablePin error: " + e.toString());
        }
        return bolSend;
    }

    public boolean srvEnablePin(String pszPinCode) {
        IncomingMessage inMsg;
        boolean bolSend;
        block6: {
            CommServer server;
            block5: {
                server = null;
                bolSend = false;
                server = MutiDeviceService.getCurrentServer();
                if (server != null) break block5;
                log.info("*********************************srvEnablePin************server==null***************************************");
                return false;
            }
            String at = "AT+CLCK=\"SC\",1,\"" + pszPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CLCK=\"SC\",1,\"" + pszPinCode + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block6;
            log.fatal(" function[srvEnablePin]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            log.info("==function[srvEnablePin]--receiveContext=" + receiveContext);
            Tools.logToControl("err", "==function[srvEnablePin]--receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (!TextUtil.checkContainStr(receiveContext, "ERROR")) {
                bolSend = true;
                return bolSend;
            }
            bolSend = false;
            log.info("failure: " + receiveContext);
        }
        catch (Exception e) {
            log.info("srvEnablePin error: " + e.toString());
            bolSend = false;
        }
        return bolSend;
    }

    public String srvUnblockPin(String pszPuk, String pszNewPinCode) {
        CommServer server = null;
        String receiveContextNoSpace = null;
        String bolSend = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvUnblockPin************server==null***************************************");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            String at = "AT+CPIN=\"" + pszPuk + "\",\"" + pszNewPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CPIN=\"" + pszPuk + "\",\"" + pszNewPinCode + "\"";
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 60);
            if (inMsg == null) {
                log.fatal(" function[srvUnblockPin]  failure: AT delay " + at1 + " Object return is null");
                return this.checkReturnNullPukState(server);
            }
            String receiveContext = inMsg.getContent();
            log.info(" function[srvUnblockPin]  receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: operation not allowed") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: 3")) {
                log.info(" sim puk  already  open");
                return PublicConfig.pukEfficacySuccess;
            }
            log.info(" function[srvUnblockPin] return receiveContext=" + receiveContext);
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 16") || TextUtil.checkContainStr(receiveContext, "+cme error: incorrect password") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:16") || TextUtil.checkContainStr(receiveContextNoSpace, "+cmeerror:incorrectpassword")) {
                    bolSend = PublicConfig.pukInputError;
                    log.info(" sim input error");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 3") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: operation not allowed")) {
                    bolSend = PublicConfig.pukEfficacySuccess;
                    log.info(" sim pin  already  efficacy");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                    log.warn("+CME ERROR: SIM failure");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                    log.warn("+CME ERROR: SIM busy");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                    log.warn("+CME ERROR: SIM wrong");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
            } else {
                if (TextUtil.checkContainStr(receiveContext, "OK")) {
                    bolSend = PublicConfig.pukEfficacySuccess;
                    return bolSend;
                }
                bolSend = PublicConfig.pukInputError;
                return bolSend;
            }
            return bolSend;
        }
        catch (Exception e) {
            log.info("srvUnblockPin error: " + e.toString());
            return PublicConfig.failure;
        }
    }

    public String srvVerifyPin(String pszPinCode) {
        CommServer server = null;
        String receiveContext = null;
        String receiveContextNoSpace = null;
        String bolSend = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvVerifyPin************server==null***************************************");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            String at = "AT+CPIN=\"" + pszPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CPIN=\"" + pszPinCode + "\"";
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 60);
            if (inMsg == null) {
                log.fatal(" function[srvVerifyPin]  failure: AT delay " + at1 + " Object return is null");
                return this.checkReturnNullPinState(server);
            }
            receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            Tools.logToControl("err", "--=======----srvVerifyPin--receiveContext--=" + receiveContext);
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 16") || TextUtil.checkContainStr(receiveContext, "+cme error: incorrect password") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:16") || TextUtil.checkContainStr(receiveContextNoSpace, "+cmeerror:incorrectpassword")) {
                    bolSend = PublicConfig.pinInputError;
                    log.info(" sim input error");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 3") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: operation not allowed")) {
                    bolSend = PublicConfig.pinEfficacySuccess;
                    log.info(" sim pin  already  efficacy");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                    log.warn("+CME ERROR: SIM failure");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                    log.warn("+CME ERROR: SIM busy");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                    log.warn("+CME ERROR: SIM wrong");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "SIM PUK required") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:12") || TextUtil.checkContainStr(receiveContextNoSpace, "SIMPUKrequired")) {
                    bolSend = PublicConfig.pinInputError;
                    return bolSend;
                }
            } else {
                if (TextUtil.checkContainStr(receiveContext, "OK")) {
                    bolSend = PublicConfig.pinEfficacySuccess;
                    return bolSend;
                }
                bolSend = PublicConfig.pinInputError;
                return bolSend;
            }
            bolSend = PublicConfig.failure;
            return bolSend;
        }
        catch (Exception e) {
            log.info("srvVerifyPin error: " + e.toString());
            bolSend = PublicConfig.failure;
            return bolSend;
        }
    }

    public HashMap queryFlowInfo(HashMap m) throws Exception {
        CommServer server = null;
        HashMap<String, Long> map = null;
        String receiveContext = null;
        String at = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************queryFlowInfo************server==null***************************************");
                map = new HashMap();
                map.put("last_ds_time", TextUtil.stringFormat("0", 16));
                map.put("uploadflux", TextUtil.stringFormat("0", 16));
                map.put("adownflux", TextUtil.stringFormat("0", 16));
                return map;
            }
            map = new HashMap<String, Long>();
            OutgoingMessage outMsg = new OutgoingMessage();
            at = "AT^DSFLOWQRY\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT^DSFLOWQRY";
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryFlowInfo]  failure: AT delay " + at1 + " Object return is null");
                map.put("last_ds_time", TextUtil.stringFormat("0", 16));
                map.put("uploadflux", TextUtil.stringFormat("0", 16));
                map.put("adownflux", TextUtil.stringFormat("0", 16));
                return map;
            }
            receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            if (Tools.isEmpty(receiveContext = TextUtil.replaceStr(receiveContext, "\r", ""))) {
                throw new Exception("AT:err return is emplty");
            }
            if (TextUtil.checkContainStr(receiveContext, "COMMAND NOT SUPPORT")) {
                log.fatal("queryFlowInfo error: AT^DSFLOWQRY:COMMAND NOT SUPPORT");
                map.put("last_ds_time", TextUtil.stringFormat("0", 16));
                map.put("uploadflux", TextUtil.stringFormat("0", 16));
                map.put("adownflux", TextUtil.stringFormat("0", 16));
                return map;
            }
            String[] arr = TextUtil.split(receiveContext = TextUtil.rRight(receiveContext, "^DSFLOWQRY:"), ",");
            if (arr.length < 2) {
                log.fatal("queryFlowInfo() AT return error :" + receiveContext);
                map.put("last_ds_time", TextUtil.stringFormat("0", 16));
                map.put("uploadflux", TextUtil.stringFormat("0", 16));
                map.put("adownflux", TextUtil.stringFormat("0", 16));
            } else if (ScheduledTask.i == 0L) {
                map.put("last_ds_time", TextUtil.stringFormat("0", 16));
                map.put("uploadflux", TextUtil.stringFormat("0", 16));
                map.put("adownflux", TextUtil.stringFormat("0", 16));
            } else {
                map.put("last_ds_time", TextUtil.stringFormat(arr[0], 16));
                map.put("uploadflux", TextUtil.stringFormat(arr[1], 16));
                map.put("adownflux", TextUtil.stringFormat(arr[2], 16));
            }
        }
        catch (Exception e) {
            log.info("queryFlowInfo error: " + e.toString());
            throw e;
        }
        return map;
    }

    public boolean flowInfoClear(HashMap m) {
        String receiveContext;
        boolean returnflag;
        block5: {
            IncomingMessage inMsg;
            block4: {
                returnflag = true;
                CommServer server = null;
                String at = null;
                server = MutiDeviceService.getCurrentServer();
                OutgoingMessage outMsg = new OutgoingMessage();
                at = "AT^DSFLOWCLR\r" + (char)Integer.parseInt("1a", 16) + "z";
                String at1 = "AT^DSFLOWCLR";
                outMsg.setContent(at);
                inMsg = server.send(outMsg, 30);
                if (inMsg != null) break block4;
                log.fatal(" function[flowInfoClear]  failure: AT delay " + at1 + " Object return is null");
                return false;
            }
            receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "").trim();
            if (!receiveContext.equalsIgnoreCase("OK")) break block5;
            return true;
        }
        try {
            log.info("flowInfoClear error: " + receiveContext);
            returnflag = false;
        }
        catch (Exception e) {
            log.info("flowInfoClear error: " + e.toString());
            returnflag = false;
        }
        return returnflag;
    }

    public HashMap queryNoDevicesNetDiagnosisInfo() throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String receiveContext = this.lb.getUnknown();
        HashMap map = new HashMap();
        String device = "WCDMA";
        try {
            device = DeviceService.getInstance().getProductNetType();
            if ("WCDMA".equalsIgnoreCase(device) && PublicConfig.showStyle.equalsIgnoreCase("new")) {
                map = (HashMap)DiagnosisService.getInstance().diagnosisPutMap(null, receiveContext);
            } else {
                map.put("simInfoCount", receiveContext);
                map.put("simManCount", receiveContext);
                map.put("IMEI", receiveContext);
                map.put("IMSI", receiveContext);
                map.put("API", "V100");
                map.put("firmwareVer", receiveContext);
                map.put("hardwareVer", receiveContext);
                map.put("SN", receiveContext);
                map.put("DEVTYPE", receiveContext);
                DiagnosisPanel.jlabel1.setText("   " + receiveContext);
                DiagnosisPanel.jlabel1.updateUI();
                DiagnosisPanel.jlabel2.setText("   " + receiveContext);
                DiagnosisPanel.jlabel2.updateUI();
                DiagnosisPanel.jlabel3.setText("   " + receiveContext);
                DiagnosisPanel.jlabel3.updateUI();
                DiagnosisPanel.jlabel4.setText("   " + receiveContext);
                DiagnosisPanel.jlabel4.updateUI();
                DiagnosisPanel.jlabel5.setText("   " + receiveContext);
                DiagnosisPanel.jlabel5.updateUI();
                DiagnosisPanel.jlabel6.setText("   " + receiveContext);
                DiagnosisPanel.jlabel6.updateUI();
                DiagnosisPanel.jlabel7.setText("   " + receiveContext);
                DiagnosisPanel.jlabel7.updateUI();
                DiagnosisPanel.jlabel8.setText("   " + receiveContext);
                DiagnosisPanel.jlabel8.updateUI();
                DiagnosisPanel.msgInDevLabel.setText("   " + receiveContext);
                DiagnosisPanel.msgInDevLabel.updateUI();
                DiagnosisPanel.conInDevLabel.setText("   " + receiveContext);
                DiagnosisPanel.conInDevLabel.updateUI();
                DiagnosisPanel.voltageLabel.setText("   " + receiveContext);
                DiagnosisPanel.voltageLabel.updateUI();
                DiagnosisPanel.prlLabel.setText("   " + receiveContext);
                DiagnosisPanel.prlLabel.updateUI();
                DiagnosisPanel.esnLabel.setText("   " + receiveContext);
                DiagnosisPanel.esnLabel.updateUI();
                DiagnosisPanel.mediLabel.setText("   " + receiveContext);
                DiagnosisPanel.mediLabel.updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public HashMap queryNetDiagnosisInfo(HashMap m) throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        Object inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap map = new HashMap();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        Object ATStr = null;
        Object ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************queryNetDiagnosisInfo************server==null***************************************");
                return null;
            }
        }
        catch (Exception ex) {
            log.info("***********************************server=null*********************************************************");
            receiveContext = this.lb.getUnknown();
            map = (HashMap)DiagnosisService.getInstance().diagnosisPutMap(null, receiveContext);
            return map;
        }
        try {
            map = (HashMap)DiagnosisService.getInstance().diagnosisPutMap(new HashMap<String, String>(), null);
        }
        catch (Exception e) {
            log.info("queryNetDiagnosisInfo error: " + e.toString());
        }
        return map;
    }

    public HashMap queryDoctorDeviceNoSim(HashMap m) throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        Object inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap map = new HashMap();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        Object ATStr = null;
        Object ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************queryDoctorDeviceNoSim************server==null***************************************");
                return null;
            }
        }
        catch (Exception ex) {
            receiveContext = this.lb.getUnknown();
            map = (HashMap)DiagnosisService.getInstance().diagnosisPutMap(null, receiveContext);
            return map;
        }
        try {
            if (PublicConfig.showStyle.equals("new")) {
                map.put("API", "V100");
                map = (HashMap)DiagnosisService.getInstance().diagnosisPutMap(null, this.lb.getUnknown());
                map.put("firmwareVer", DiagnosisService.getInstance().getFirmwareVersion());
                map.put("hardwareVer", DiagnosisService.getInstance().getHardwareVersion());
                map.put("DEVTYPE", DiagnosisService.getInstance().getDeviceName());
                map.put("IMEI", DiagnosisService.getInstance().getIMEI());
                map.put("port", DiagnosisService.getInstance().getPort());
                map.put("rscp", DiagnosisService.getInstance().getRscp()[0]);
                map.put("ecio", DiagnosisService.getInstance().getRscp()[1]);
                map.put("ecno", "not implement");
            } else {
                map.put("firmwareVer", DiagnosisService.getInstance().getFirmwareVersion());
                map.put("hardwareVer", DiagnosisService.getInstance().getHardwareVersion());
                map.put("DEVTYPE", DiagnosisService.getInstance().getDeviceName());
                map.put("IMEI", DiagnosisService.getInstance().getIMEI());
                map.put("port", DiagnosisService.getInstance().getPort());
                map.put("simInfoCount", this.lb.getUnknown());
                map.put("simManCount", this.lb.getUnknown());
                map.put("IMSI", this.lb.getUnknown());
                map.put("SN", this.lb.getUnknown());
            }
        }
        catch (Exception e) {
            log.info("queryNetDiagnosisInfo error: " + e.toString());
        }
        return map;
    }

    private HashMap getFilterStr(String[] AtStr, String receiveContext, String[] arr, LanguageBean lb) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Tools.isEmpty(receiveContext)) {
            receiveContext = lb.getUnknown();
            map.put("receiveContext", receiveContext);
            return map;
        }
        int i = 0;
        while (i < arr.length) {
            if (TextUtil.checkContainStr(receiveContext, arr[i])) {
                receiveContext = lb.getUnknown();
                map.put("receiveContext", receiveContext);
                return map;
            }
            ++i;
        }
        return map;
    }

    public HashMap queryPwdLengthByCDMA(HashMap m) throws Exception {
        return this.queryPwdLength(m);
    }

    public HashMap queryPinPukCountByCDMA(HashMap m) throws Exception {
        return this.queryPinPukCount(m);
    }

    public HashMap queryPinStatusByCDMA(HashMap m) throws Exception {
        return this.queryPinStatus(m);
    }

    public List menuShowStatusByCDMA(HashMap m) throws Exception {
        return this.menuShowStatus(m);
    }

    public boolean srvChangePinByCDMA(String pszOldPinCode, String pszNewPinCode) {
        IncomingMessage inMsg;
        boolean bolSend;
        block5: {
            CommServer server = null;
            bolSend = false;
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvChangePinByCDMA************server==null***************************************");
            }
            String at = "AT+CPWD=\"SC\",\"" + pszOldPinCode + "\",\"" + pszNewPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CPWD=\"SC\",\"" + pszOldPinCode + "\",\"" + pszNewPinCode + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block5;
            log.fatal(" function[srvChangePinByCDMA]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            log.info("==function[srvChangePinByCDMA]--receiveContext=" + receiveContext);
            Tools.logToControl("err", "==function[srvChangePinByCDMA]--receiveContext=" + receiveContext);
            if (!TextUtil.checkContainStr(receiveContext, "ERROR")) {
                bolSend = true;
                return bolSend;
            }
            bolSend = false;
            log.info("failure: " + receiveContext);
        }
        catch (Exception e) {
            bolSend = false;
            log.info("srvChangePin error: " + e.toString());
        }
        return bolSend;
    }

    public boolean srvDisablePinByCDMA(String pszPinCode) {
        IncomingMessage inMsg;
        boolean bolSend;
        block5: {
            CommServer server = null;
            bolSend = false;
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvDisablePinByCDMA************server==null***************************************");
            }
            String at = "AT+CLCK=\"SC\",0,\"" + pszPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CLCK=\"SC\",0,\"" + pszPinCode + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block5;
            log.fatal(" function[srvDisablePinByCDMA]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            log.info("==function[srvDisablePinByCDMA]--receiveContext=" + receiveContext);
            Tools.logToControl("err", "==function[srvDisablePinByCDMA]--receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (!TextUtil.checkContainStr(receiveContext, "ERROR")) {
                bolSend = true;
                return bolSend;
            }
            bolSend = false;
            log.info("failure: " + receiveContext);
        }
        catch (Exception e) {
            bolSend = false;
            log.info("srvDisablePin error: " + e.toString());
        }
        return bolSend;
    }

    public boolean srvEnablePinByCDMA(String pszPinCode) {
        IncomingMessage inMsg;
        boolean bolSend;
        block5: {
            CommServer server = null;
            bolSend = false;
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvEnablePinByCDMA************server==null***************************************");
            }
            String at = "AT+CLCK=\"SC\",1,\"" + pszPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CLCK=\"SC\",1,\"" + pszPinCode + "\"";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg != null) break block5;
            log.fatal(" function[srvEnablePinByCDMA]  failure: AT delay " + at1 + " Object return is null");
            return false;
        }
        try {
            String receiveContext = inMsg.getContent();
            log.info("==function[srvEnablePinByCDMA]--receiveContext=" + receiveContext);
            Tools.logToControl("err", "==function[srvEnablePinByCDMA]--receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (!TextUtil.checkContainStr(receiveContext, "ERROR")) {
                bolSend = true;
                return bolSend;
            }
            bolSend = false;
            log.info("failure: " + receiveContext);
        }
        catch (Exception e) {
            log.info("srvEnablePin error: " + e.toString());
            bolSend = false;
        }
        return bolSend;
    }

    public String srvUnblockPinByCDMA(String pszPuk, String pszNewPinCode) {
        CommServer server = null;
        String receiveContextNoSpace = null;
        String bolSend = "";
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvUnblockPinByCDMA************server==null***************************************");
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            String at = "AT+CPIN=\"" + pszPuk + "\",\"" + pszNewPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CPIN=\"" + pszPuk + "\",\"" + pszNewPinCode + "\"";
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 60);
            if (inMsg == null) {
                log.fatal(" function[srvUnblockPinByCDMA]  failure: AT delay " + at1 + " Object return is null");
                return this.checkReturnNullPukState(server);
            }
            String receiveContext = inMsg.getContent();
            log.info(" function[srvUnblockPinByCDMA]  receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: operation not allowed") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: 3") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:operationnotallowed") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:3")) {
                    bolSend = PublicConfig.pukEfficacySuccess;
                    log.info(" sim puk  already  open");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 16") || TextUtil.checkContainStr(receiveContext, "+cme error: incorrect password") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:16") || TextUtil.checkContainStr(receiveContextNoSpace, "+cmeerror:incorrectpassword")) {
                    bolSend = PublicConfig.pukInputError;
                    log.info(" sim input error");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                    log.warn("+CME ERROR: SIM failure");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                    log.warn("+CME ERROR: SIM busy");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                    log.warn("+CME ERROR: SIM wrong");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
            } else {
                if (TextUtil.checkContainStr(receiveContext, "OK")) {
                    bolSend = PublicConfig.pukEfficacySuccess;
                    return bolSend;
                }
                bolSend = PublicConfig.pukInputError;
                return bolSend;
            }
            return bolSend;
        }
        catch (Exception e) {
            log.info("srvUnblockPin error: " + e.toString());
            bolSend = PublicConfig.failure;
            return bolSend;
        }
    }

    public String srvVerifyPinByCDMA(String pszPinCode) {
        CommServer server = null;
        String receiveContextNoSpace = null;
        String bolSend = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************srvVerifyPinByCDMA************server==null***************************************");
            }
            OutgoingMessage outMsg = new OutgoingMessage();
            String at = "AT+CPIN=\"" + pszPinCode + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CPIN=\"" + pszPinCode + "\"";
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 60);
            if (inMsg == null) {
                log.fatal(" function[srvVerifyPinByCDMA]  failure: AT delay " + at1 + " Object return is null");
                return this.checkReturnNullPinState(server);
            }
            String receiveContext = inMsg.getContent();
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 3") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: operation not allowed")) {
                bolSend = PublicConfig.pinEfficacySuccess;
                log.info(" sim pin  already  efficacy");
                return bolSend;
            }
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            if (TextUtil.checkContainStr(receiveContext = TextUtil.replaceStr(receiveContext, "\r", ""), "ERROR")) {
                receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 16") || TextUtil.checkContainStr(receiveContext, "+cme error: incorrect password") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:16") || TextUtil.checkContainStr(receiveContextNoSpace, "+cmeerror:incorrectpassword")) {
                    bolSend = PublicConfig.pinInputError;
                    log.info(" sim input error");
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 10") || TextUtil.checkContainStr(receiveContext, "+CME ERROR:SIM not inserted") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:10") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMnotinserted")) {
                    log.warn("+CME ERROR:SIM not inserted");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR:SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                    log.warn("+CME ERROR:SIM not inserted");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                    log.warn("+CME ERROR: SIM busy");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                    log.warn("+CME ERROR: SIM wrong");
                    bolSend = PublicConfig.failure;
                    return bolSend;
                }
                if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "SIM PUK required") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:12") || TextUtil.checkContainStr(receiveContextNoSpace, "SIMPUKrequired")) {
                    bolSend = PublicConfig.pinInputError;
                    return bolSend;
                }
            } else {
                if (TextUtil.checkContainStr(receiveContext, "OK")) {
                    bolSend = PublicConfig.pinEfficacySuccess;
                    return bolSend;
                }
                bolSend = PublicConfig.pinInputError;
                return bolSend;
            }
            bolSend = PublicConfig.failure;
            return bolSend;
        }
        catch (Exception e) {
            log.info("srvVerifyPin error: " + e.toString());
            bolSend = PublicConfig.failure;
            return bolSend;
        }
    }

    public String IsPinEfficacyByWCDMA(HashMap map) {
        CommServer server = null;
        String bolSend = null;
        String receiveContext = null;
        String receiveContextNoSpace = null;
        OutgoingMessage outMsg = null;
        String at = null;
        String at1 = null;
        IncomingMessage inMsg = null;
        try {
            try {
                server = MutiDeviceService.getCurrentServer();
                if (Tools.isEmpty(server)) {
                    log.info("*********************************IsPinEfficacyByWCDMA************server==null***************************************");
                    bolSend = PublicConfig.simUsimDeviceError;
                    return bolSend;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            outMsg = new OutgoingMessage();
            receiveContext = null;
            at = "AT+CLCK=\"SC\",2\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT+CLCK=\"SC\",2";
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal("****************************function[IsPinEfficacyByWCDMA]  failure: AT delay ****************************" + at1 + " Object return is null");
                return this.returnNUllByWCDMACheck(server);
            }
            receiveContext = inMsg.getContent();
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "SIM PUK required") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:12") || TextUtil.checkContainStr(receiveContextNoSpace, "SIMPUKrequired")) {
                log.warn("+CME ERROR: SIM PUK required");
                bolSend = PublicConfig.requirePukDecode;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                log.warn("+CME ERROR: SIM failure");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                log.warn("+CME ERROR: SIM busy");
                bolSend = PublicConfig.busy;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                log.warn("+CME ERROR: SIM wrong");
                bolSend = PublicConfig.wrong;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 11") || TextUtil.checkContainStr(receiveContext, "SIM PIN required") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:11") || TextUtil.checkContainStr(receiveContextNoSpace, "SIMPINrequired")) {
                log.warn("SIM PIN required");
                bolSend = PublicConfig.requirePinEfficacy;
                return bolSend;
            }
            if (TextUtil.checkContainStr(TextUtil.replaceStr(receiveContext, " ", ""), "+CLCK:0") || TextUtil.checkContainStr(receiveContext, "+CLCK: 0")) {
                log.warn("SIM PIN Disable");
                bolSend = PublicConfig.pinForbid;
                return bolSend;
            }
            bolSend = PublicConfig.pinPukNotRequest;
            return bolSend;
        }
        catch (Exception e) {
            log.info("IsPinEfficacyByWCDMA error: " + e.toString());
            PublicConfig.PinStatus = bolSend = PublicConfig.pinPukNotRequest;
            return bolSend;
        }
    }

    private String fun(CommServer server) {
        System.err.println("333333333333333333333333333333333333333333333333333333333333333333");
        String bolSend = null;
        try {
            String receiveContext = null;
            String receiveContextNoSpace = null;
            OutgoingMessage outMsg = null;
            String at = null;
            String at1 = null;
            IncomingMessage inMsg = null;
            receiveContext = null;
            receiveContextNoSpace = null;
            at = "AT+CPIN?\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT+CPIN?";
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[IsPinEfficacyByWCDMA] failure: AT delay " + at1 + " Object return is null");
                return PublicConfig.simUsimDeviceError;
            }
            receiveContext = inMsg.getContent();
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                log.warn("+CME ERROR: SIM failure");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bolSend;
    }

    private String returnNUllByWCDMACheck(CommServer server) {
        String bolSend = null;
        String receiveContext = null;
        String receiveContextNoSpace = null;
        OutgoingMessage outMsg = null;
        String at = null;
        String at1 = null;
        IncomingMessage inMsg = null;
        try {
            outMsg = new OutgoingMessage();
            receiveContext = null;
            outMsg.setContent("AT^CPIN?\r" + (char)Integer.parseInt("1a", 16) + "z");
            at1 = "AT^CPIN?";
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal("*******************************function[returnNUllByWCDMACheck]  failure: AT delay******************************* " + at1 + " Object return is null");
                bolSend = PublicConfig.simUsimDeviceError;
                return bolSend;
            }
            receiveContext = inMsg.getContent();
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            log.warn("*******************************returnNUllByWCDMACheck*******************************************************receiveContextNoSpace=" + receiveContextNoSpace);
            if (TextUtil.checkContainStr(receiveContextNoSpace, "SIMPIN") || TextUtil.checkContainStr(receiveContext, "SIM PIN")) {
                PublicConfig.initpintimes = TextUtil.rRight(receiveContextNoSpace, "SIMPIN,").split(",")[0];
                PublicConfig.initpuktimes = TextUtil.rRight(receiveContextNoSpace, "SIMPIN,").split(",")[1];
                return PublicConfig.requirePinEfficacy;
            }
            if (TextUtil.checkContainStr(receiveContextNoSpace, "CPIN:READY") || TextUtil.checkContainStr(receiveContext, "CPIN: READY")) {
                PublicConfig.initpintimes = TextUtil.rRight(receiveContextNoSpace, "CPIN:READY,,").split(",")[1];
                PublicConfig.initpuktimes = TextUtil.rRight(receiveContextNoSpace, "CPIN:READY,,").split(",")[0];
                return PublicConfig.pinPukNotRequest;
            }
            if (TextUtil.checkContainStr(receiveContextNoSpace, "SIMPUK") || TextUtil.checkContainStr(receiveContext, "SIM PUK")) {
                PublicConfig.initpintimes = TextUtil.rRight(receiveContextNoSpace, "SIMPUK,").split(",")[2];
                PublicConfig.initpuktimes = TextUtil.rRight(receiveContextNoSpace, "SIMPUK,").split(",")[0];
                return PublicConfig.requirePukDecode;
            }
            return PublicConfig.simUsimDeviceError;
        }
        catch (Exception e) {
            log.info("IsPinEfficacyByWCDMA error: " + e.toString());
            bolSend = PublicConfig.simUsimDeviceError;
            return bolSend;
        }
    }

    public String IsPinEfficacyByCDMA(HashMap map) {
        CommServer server = null;
        String bolSend = null;
        String receiveContext = null;
        String receiveContextNoSpace = null;
        OutgoingMessage outMsg = null;
        String at = null;
        String at1 = null;
        IncomingMessage inMsg = null;
        try {
            try {
                server = MutiDeviceService.getCurrentServer();
                if (Tools.isEmpty(server)) {
                    log.info("*********************************IsPinEfficacyByCDMA************server==null***************************************");
                    bolSend = PublicConfig.simUsimDeviceError;
                    return bolSend;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            outMsg = new OutgoingMessage();
            receiveContext = null;
            at = "AT^SYSINFO\r";
            server = MutiDeviceService.getCurrentServer();
            outMsg = new OutgoingMessage();
            outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "^SYSINFO:", "");
            String[] vContent = receiveContext.split(",");
            if (vContent.length >= 5 && vContent[4].indexOf("240") > -1) {
                PublicConfig.simNeedPIN = false;
                bolSend = PublicConfig.pinPukNotRequest;
                return bolSend;
            }
            if (vContent.length >= 5) {
                PublicConfig.simNeedPIN = true;
            }
            at = "AT+CLCK=\"SC\",2\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT+CLCK=\"SC\",2";
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[IsPinEfficacyByCDMA]  failure: AT delay " + at1 + " Object return is null");
                return this.returnNUllByWCDMACheck(server);
            }
            receiveContext = inMsg.getContent();
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "SIM PUK required") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:12") || TextUtil.checkContainStr(receiveContextNoSpace, "SIMPUKrequired")) {
                log.warn("+CME ERROR: SIM PUK required");
                bolSend = PublicConfig.requirePukDecode;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 10") || TextUtil.checkContainStr(receiveContext, "+CME ERROR:SIM not inserted") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:10") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMnotinserted")) {
                log.warn("+CME ERROR:SIM not inserted");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR:SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                log.warn("+CME ERROR:SIM not inserted");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                log.warn("+CME ERROR: SIM busy");
                bolSend = PublicConfig.busy;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                log.warn("+CME ERROR: SIM wrong");
                bolSend = PublicConfig.wrong;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 11") || TextUtil.checkContainStr(receiveContext, "SIM PIN required") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:11") || TextUtil.checkContainStr(receiveContextNoSpace, "SIMPINrequired")) {
                log.warn("SIM PIN required");
                bolSend = PublicConfig.requirePinEfficacy;
                return bolSend;
            }
            if (TextUtil.checkContainStr(TextUtil.replaceStr(receiveContext, " ", ""), "+CLCK:0") || TextUtil.checkContainStr(receiveContext, "+CLCK: 0")) {
                log.warn("SIM PIN Disable");
                bolSend = PublicConfig.pinForbid;
                return bolSend;
            }
            bolSend = this.checkPINStatus();
            return bolSend;
        }
        catch (Exception e) {
            log.info("IsPinEfficacyByCDMA error: " + e.toString());
            PublicConfig.PinStatus = bolSend = PublicConfig.pinPukNotRequest;
            return bolSend;
        }
    }

    private String checkPINStatus() {
        String bolSend;
        block8: {
            bolSend = "";
            CommServer server = null;
            try {
                try {
                    OutgoingMessage outMsg = new OutgoingMessage();
                    String receiveContext = null;
                    outMsg.setContent("AT^CPIN?\r" + (char)Integer.parseInt("1a", 16) + "z");
                    server = MutiDeviceService.getCurrentServer();
                    IncomingMessage inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        bolSend = PublicConfig.simUsimDeviceError;
                        break block8;
                    }
                    receiveContext = inMsg.getContent();
                    String receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
                    if (TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:SIMPIN") || TextUtil.checkContainStr(receiveContext, "^CPIN:SIM PIN")) {
                        bolSend = PublicConfig.requirePinEfficacy;
                        break block8;
                    }
                    if (TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:READY") || TextUtil.checkContainStr(receiveContext, "^CPIN: READY")) {
                        bolSend = PublicConfig.pinPukNotRequest;
                        break block8;
                    }
                    if (TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:SIMPUK") || TextUtil.checkContainStr(receiveContext, "^CPIN:SIM PUK")) {
                        bolSend = PublicConfig.requirePukDecode;
                        break block8;
                    }
                    bolSend = PublicConfig.pinPukNotRequest;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
        }
        return bolSend;
    }

    private String checkPinFatal(CommServer server, OutgoingMessage outMsg, IncomingMessage inMsg, String receiveContext) {
        String bolSend = null;
        String at = "AT+CLCK=\"SC\",2\r" + (char)Integer.parseInt("1a", 16) + "z";
        outMsg.setContent(at);
        inMsg = server.send(outMsg, 30);
        receiveContext = inMsg.getContent();
        if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure")) {
            log.warn("+CME ERROR: SIM failure");
            bolSend = "failure";
            return bolSend;
        }
        if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy")) {
            log.warn("+CME ERROR: SIM busy");
            bolSend = PublicConfig.busy;
            return bolSend;
        }
        if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong")) {
            log.warn("+CME ERROR: SIM wrong");
            bolSend = PublicConfig.wrong;
            return bolSend;
        }
        return bolSend;
    }

    public HashMap queryFlowInfoByCDMA(HashMap m) throws Exception {
        HashMap<String, Object> map;
        block10: {
            CommServer server = null;
            map = null;
            try {
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.error("queryFlowInfoByCDMA****server==null");
                }
                map = new HashMap<String, Object>();
                byte[] bInput = new byte[65535];
                Runtime run = Runtime.getRuntime();
                String[] cmd = new String[2];
                cmd[1] = "";
                if ("Mac OS X".equals(CommServerThread.currentSystem)) {
                    String macPath = String.valueOf(XMLTool.getClassPath()) + "/lib/";
                    macPath = TextUtil.replaceStr1(macPath, "\\/", "/");
                    macPath = TextUtil.replaceStr1(macPath, "\\", "/");
                    cmd[0] = String.valueOf(macPath) + "GetFlowForCDMA";
                    Process prs = run.exec(cmd);
                    int rValue = prs.waitFor();
                    InputStream iSt = prs.getInputStream();
                    iSt.read(bInput);
                    String ddk = "";
                    int i = 0;
                    while (bInput[i] != 0) {
                        if (10 == bInput[i]) {
                            if (TextUtil.checkContainStr(ddk, ",")) break;
                            ddk = "";
                        } else {
                            ddk = String.valueOf(ddk) + (char)bInput[i];
                        }
                        ++i;
                    }
                    String[] arr = TextUtil.split(ddk, ",");
                    if (arr.length >= 2) {
                        map.put("last_ds_time", ScheduledTask.oldTime + PublicConfig.flowRefreshbewttenSeconds);
                        map.put("uploadflux", arr[1]);
                        map.put("adownflux", arr[0]);
                    }
                    break block10;
                }
                if ("Linux".equals(CommServerThread.currentSystem)) {
                    cmd[0] = PublicConfig.SHELL_GET_STATISTICS;
                    Process prs = run.exec(cmd);
                    int rValue = prs.waitFor();
                    InputStream iSt = prs.getInputStream();
                    iSt.read(bInput);
                    String ddk = "";
                    int i = 0;
                    while (bInput[i] != 10 && bInput[i] != 0) {
                        ddk = String.valueOf(ddk) + (char)bInput[i];
                        ++i;
                    }
                    String[] arr = TextUtil.split(ddk, ",");
                    map.put("last_ds_time", ScheduledTask.oldTime + PublicConfig.flowRefreshbewttenSeconds);
                    map.put("adownflux", arr[1]);
                    map.put("uploadflux", arr[2]);
                    break block10;
                }
                return map;
            }
            catch (Exception e) {
                log.info("queryFlowInfo error: " + e.toString());
                throw e;
            }
        }
        return map;
    }

    public boolean flowInfoClearByCDMA(HashMap m) {
        String receiveContext;
        boolean returnflag;
        block7: {
            IncomingMessage inMsg;
            block6: {
                returnflag = true;
                CommServer server = null;
                String ATstr = null;
                String ATstr1 = null;
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    log.info("*********************************flowInfoClearByCDMA************server==null***************************************");
                }
                OutgoingMessage outMsg = new OutgoingMessage();
                ATstr = "AT^DSFLOWCLR\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATstr1 = "AT^DSFLOWCLR";
                outMsg.setContent(ATstr);
                inMsg = server.send(outMsg, 30);
                if (inMsg != null) break block6;
                log.fatal(" function[flowInfoClearByCDMA]  failure: AT delay " + ATstr1 + " Object return is null");
                return false;
            }
            receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "").trim();
            if (TextUtil.checkContainStr(receiveContext, "COMMAND NOT SUPPORT")) {
                log.info("flowInfoClearByCDMA error: AT^DSFLOWCLR:COMMAND NOT SUPPORT");
            }
            if (!receiveContext.equalsIgnoreCase("OK")) break block7;
            return true;
        }
        try {
            log.info("flowInfoClear error: " + receiveContext);
            returnflag = false;
        }
        catch (Exception e) {
            log.info("flowInfoClear error: " + e.toString());
            returnflag = false;
        }
        return returnflag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap queryNetDiagnosisInfoByCDMA(HashMap m) throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************queryNetDiagnosisInfoByCDMA************server==null***************************************");
                return null;
            }
        }
        catch (Exception ex) {
            log.info("***********************************server=null*********************************************************");
            receiveContext = this.lb.getUnknown();
            map.put("simInfoCount", receiveContext);
            map.put("simManCount", receiveContext);
            map.put("IMEI", receiveContext);
            map.put("API", "V100");
            map.put("IMSI", receiveContext);
            map.put("firmwareVer", receiveContext);
            map.put("hardwareVer", receiveContext);
            map.put("SN", receiveContext);
            map.put("DEVTYPE", receiveContext);
            return map;
        }
        try {
            HashMap<String, String> ex = map;
            synchronized (ex) {
                String[] AtStr8;
                String[] s16;
                String[] s15;
                String[] sore;
                String[] s4;
                String[] s3;
                String[] AtStr1;
                String[] s2;
                String[] s1;
                map.put("API", "V100");
                receiveContext = null;
                ATStr = "AT+CGMR\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CGMR";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("firmwareVer", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.rLeft2(receiveContext, "OK");
                    String[] s7 = new String[]{"\n", "\r", "AT+CGMR", "+CGMR:", "OK", "\""};
                    String[] s8 = new String[]{"", "", "", "", "", ""};
                    String[] AtStr4 = new String[]{"sim pin required", "sim pin required", "AT+CGMR: sim puk required", "AT+CGMR: sim puk required", "AT+CGMR:COMMAND NOT SUPPORT", "AT+CGMR: at return error", "AT+CGMR:SIM failure", "AT+CGMR:SIM failure"};
                    filtermap = this.getFilterStr(AtStr4, receiveContext, arr0, this.lb);
                    receiveContext = TextUtil.replaceStr(receiveContext, s7, s8);
                    map.put("firmwareVer", receiveContext);
                }
                receiveContext = null;
                ATStr = "AT^HWVER\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^HWVER";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("hardwareVer", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.getBetweenString(receiveContext, "^HWVER:");
                    String[] s9 = new String[]{"\n", "\r", "AT^HWVER", "^HWVER:", "OK", "\""};
                    String[] s10 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s9, s10);
                    String[] AtStr5 = new String[]{"sim pin required", "sim pin required", "AT^HWVER: sim puk required", "AT^HWVER: sim puk required", "AT^HWVER:COMMAND NOT SUPPORT", "AT^HWVER at return error", "AT^HWVER: SIM failure", "AT^HWVER:SIM failure"};
                    filtermap = this.getFilterStr(AtStr5, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("hardwareVer", receiveContext.toUpperCase());
                    } else {
                        map.put("hardwareVer", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT+CGMM\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CGMM";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("DEVTYPE", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    String[] s13 = new String[]{"\n", "\r", "AT+CGMM", "+CGMM:", "OK", "\""};
                    String[] s14 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s13, s14);
                    String[] AtStr7 = new String[]{"sim pin required", "sim pin required", "AT+CGMM: sim puk required", "AT+CGMM: sim puk required", "AT+CGMM:COMMAND NOT SUPPORT", "AT+CGMM:at return error", "AT+CGMM:SIM failure", "AT+CGMM:SIM failure"};
                    filtermap = this.getFilterStr(AtStr7, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("DEVTYPE", receiveContext.toUpperCase());
                        PublicConfig.deviceType = receiveContext.toUpperCase();
                    } else {
                        map.put("DEVTYPE", (String)filtermap.get("receiveContext"));
                    }
                }
                ATStr = "AT+CPMS=\"SM\",\"SM\",\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPMS=\"SM\"";
                if (PublicConfig.simNeedPIN) {
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                } else {
                    inMsg = null;
                }
                if (inMsg == null) {
                    map.put("simInfoCount", receStr);
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure: AT delay " + ATStr1 + " Object return is null");
                } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT ERROR " + ATStr1);
                    map.put("simManCount", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s1 = new String[]{"\n", "\r", "AT+CPMS=\"SM\",\"SM\",\"SM\"", "+CPMS:", "OK"};
                    s2 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
                    AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"SM\",\"SM\",\"SM\": sim puk required", "AT+CPMS=\"SM\",\"SM\",\"SM\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"SM\",\"SM\",\"SM\":at return error", "AT+CPMS=\"SM\",\"SM\",\"SM\":SIM failure", "AT+CPMS=\"SM\",\"SM\",\"SM\":SIM failure"};
                    filtermap = this.getFilterStr(AtStr1, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        if (arr[1].equals("0")) {
                            map.put("simInfoCount", this.lb.getUnknown());
                            PublicConfig.IS_SHOW_SIM_CDMA = "0";
                        } else if (arr[1].matches("^[0-9]*[0-9][0-9]*$")) {
                            map.put("simInfoCount", String.valueOf(arr[0]) + "/" + arr[1]);
                            PublicConfig.IS_SHOW_SIM_CDMA = "1";
                        }
                        PublicConfig.smsNumber = arr[0];
                    } else {
                        map.put("simInfoCount", (String)filtermap.get("receiveContext"));
                        map.put("simManCount", (String)filtermap.get("receiveContext"));
                        map.put("IMSI", (String)filtermap.get("receiveContext"));
                        return map;
                    }
                }
                ATStr = "AT+CPBS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPBS=\"SM\"\r";
                if (PublicConfig.simNeedPIN) {
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                } else {
                    inMsg = null;
                }
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("simManCount", receStr);
                } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT ERROR " + ATStr1);
                    map.put("simManCount", receStr);
                } else {
                    ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS?";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                        map.put("simManCount", receStr);
                    } else {
                        String[] AtStr2;
                        receiveContext = inMsg.getContent();
                        s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                        s4 = new String[]{"", "", "", "", ""};
                        receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                        sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
                        if (TextUtil.checkContainStr(receiveContext, sore)) {
                            PublicConfig.doctureRefresh = "true";
                        }
                        if ((filtermap = this.getFilterStr(AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure"}, receiveContext, arr0, this.lb)).isEmpty()) {
                            arr = TextUtil.split(receiveContext, ",");
                            map.put("simManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                            if (arr[2].equals("0")) {
                                PublicConfig.IS_SHOW_SIM_CDMA = "0";
                            } else if (arr[1].matches("^[0-9]*[0-9][0-9]*$")) {
                                map.put("simManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                                PublicConfig.IS_SHOW_SIM_CDMA = "1";
                            }
                            PublicConfig.userAccessSize = Tools.checkNull(arr[1]);
                            PublicConfig.accessMaxSize = Tools.checkNull(arr[2]);
                        } else {
                            map.put("simManCount", (String)filtermap.get("receiveContext"));
                        }
                    }
                }
                receiveContext = null;
                ATStr = "AT+CIMI\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CIMI";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("IMSI", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+CIMI", "+CIMI:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    map.put("IMSI", receiveContext);
                    ConfigInterface.imsiString = receiveContext;
                }
                ATStr = "AT+CPMS=\"ME\",\"ME\",\"ME\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPMS=\"ME\",\"ME\",\"ME\"";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    map.put("deviceSmsCount", receStr);
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure: AT delay " + ATStr1 + " Object return is null");
                } else {
                    receiveContext = inMsg.getContent();
                    s1 = new String[]{"\n", "\r", "AT+CPMS=\"ME\",\"ME\",\"ME\"", "+CPMS:", "OK"};
                    s2 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
                    AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"ME\",\"ME\",\"ME\": sim puk required", "AT+CPMS=\"ME\",\"ME\",\"ME\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"ME\",\"ME\",\"ME\":at return error", "AT+CPMS=\"ME\",\"ME\",\"ME\":SIM failure", "AT+CPMS=\"ME\",\"ME\",\"ME\":SIM failure"};
                    filtermap = this.getFilterStr(AtStr1, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        map.put("deviceSmsCount", String.valueOf(arr[0]) + "/" + arr[1]);
                        PublicConfig.deviceNumber = arr[0];
                    } else {
                        map.put("deviceSmsCount", (String)filtermap.get("receiveContext"));
                        map.put("deviceManCount", (String)filtermap.get("receiveContext"));
                        return map;
                    }
                }
                receiveContext = null;
                if ("0".equals(PublicConfig.deviceaccessMaxSize)) {
                    ATStr = "AT+CPBS=\"ME\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS=\"ME\"\r";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                        map.put("deviceManCount", receStr);
                        System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                        log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT ERROR " + ATStr1);
                        map.put("deviceManCount", receStr);
                        System.err.println("@@@@@@@@@@@@@@@@@@@@@@");
                    } else {
                        ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                        ATStr1 = "AT+CPBS?";
                        outMsg.setContent(ATStr);
                        inMsg = server.send(outMsg, 30);
                        if (inMsg == null) {
                            log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                            map.put("deviceManCount", receStr);
                        } else {
                            receiveContext = inMsg.getContent();
                            s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                            s4 = new String[]{"", "", "", "", ""};
                            receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                            sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
                            if (TextUtil.checkContainStr(receiveContext, sore)) {
                                PublicConfig.doctureRefresh = "true";
                            }
                            arr = TextUtil.split(receiveContext, ",");
                            map.put("deviceManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                            System.err.println("1111111111======" + map.get("deviceManCount"));
                        }
                    }
                } else {
                    map.put("deviceManCount", String.valueOf(PublicConfig.deviceuserAccessSize) + "/" + PublicConfig.deviceaccessMaxSize);
                }
                receiveContext = null;
                ATStr = "AT^VOLT\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^VOLT";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("voltage", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT^VOLT", "^VOLT:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT^VOLT: sim puk required", "AT^VOLT: sim puk required", "AT^VOLT:COMMAND NOT SUPPORT", "AT^VOLT:at return error", "AT^VOLT:SIM failure", "AT^VOLT:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("voltage", receiveContext);
                    } else {
                        map.put("voltage", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT^PRLVER\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^PRLVER";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("PRL", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT^PRLVER", "^PRLVER:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT^PRLVER: sim puk required", "AT^PRLVER: sim puk required", "AT^PRLVER:COMMAND NOT SUPPORT", "AT^PRLVER:at return error", "AT^PRLVER:SIM failure", "AT^PRLVER:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("PRL", receiveContext);
                    } else {
                        map.put("PRL", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT+GSN\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+GSN";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("ESN", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+GSN", "+GSN:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+GSN: sim puk required", "AT+GSN: sim puk required", "AT+GSN:COMMAND NOT SUPPORT", "AT+GSN:at return error", "AT+GSN:SIM failure", "AT+GSN:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("ESN", receiveContext);
                        if (receiveContext.startsWith("80")) {
                            PublicConfig.showMEDI = "1";
                            String MEDI = this.queryMEIDByCDMA();
                            map.put("MEDI", MEDI);
                        }
                    } else {
                        map.put("ESN", (String)filtermap.get("receiveContext"));
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("queryNetDiagnosisInfo error: " + e.toString());
        }
        return map;
    }

    public String queryMEIDByCDMA() {
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap map = new HashMap();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            String ATStr = null;
            String ATStr1 = null;
            ATStr = "AT^MEID\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT^MEDI";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryMEIDByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                return receStr;
            }
            receiveContext = inMsg.getContent();
            String[] s15 = new String[]{"\n", "\r", "AT^MEID", "^MEID:", "OK", "\""};
            String[] s16 = new String[]{"", "", "", "", "", ""};
            if ((receiveContext = TextUtil.replaceStr(receiveContext, s15, s16)) != null) {
                return receiveContext;
            }
            return receStr;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap queryDoctorDeviceNoSimByCDMA(HashMap m) throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getAPN************server==null***************************************");
                return null;
            }
        }
        catch (Exception ex) {
            receiveContext = this.lb.getUnknown();
            map.put("simInfoCount", receiveContext);
            map.put("simManCount", receiveContext);
            map.put("IMEI", receiveContext);
            map.put("API", "V100");
            map.put("IMSI", receiveContext);
            map.put("firmwareVer", receiveContext);
            map.put("hardwareVer", receiveContext);
            map.put("SN", receiveContext);
            map.put("DEVTYPE", receiveContext);
            return map;
        }
        try {
            HashMap<String, String> ex = map;
            synchronized (ex) {
                String[] AtStr8;
                String[] s16;
                String[] s15;
                map.put("API", "V100");
                receiveContext = null;
                ATStr = "AT+CGMR\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CGMR";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("firmwareVer", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.rLeft2(receiveContext, "OK");
                    String[] s7 = new String[]{"\n", "\r", "AT+CGMR", "+CGMR:", "OK", "\""};
                    String[] s8 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s7, s8);
                    map.put("firmwareVer", receiveContext);
                }
                receiveContext = null;
                ATStr = "AT^HWVER\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^HWVER";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("hardwareVer", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.getBetweenString(receiveContext, "^HWVER:");
                    String[] s9 = new String[]{"\n", "\r", "AT^HWVER", "^HWVER:", "OK", "\""};
                    String[] s10 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s9, s10);
                    String[] AtStr5 = new String[]{"sim pin required", "sim pin required", "AT^HWVER: sim puk required", "AT^HWVER: sim puk required", "AT^HWVER:COMMAND NOT SUPPORT", "AT^HWVER at return error", "AT^HWVER: SIM failure", "AT^HWVER:SIM failure"};
                    filtermap = this.getFilterStr(AtStr5, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("hardwareVer", receiveContext.toUpperCase());
                    } else {
                        map.put("hardwareVer", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT+CGMM\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CGMM";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("DEVTYPE", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    String[] s13 = new String[]{"\n", "\r", "AT+CGMM", "+CGMM:", "OK", "\""};
                    String[] s14 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s13, s14);
                    String[] AtStr7 = new String[]{"sim pin required", "sim pin required", "AT+CGMM: sim puk required", "AT+CGMM: sim puk required", "AT+CGMM:COMMAND NOT SUPPORT", "AT+CGMM:at return error", "AT+CGMM:SIM failure", "AT+CGMM:SIM failure"};
                    filtermap = this.getFilterStr(AtStr7, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("DEVTYPE", receiveContext.toUpperCase());
                        PublicConfig.deviceType = receiveContext.toUpperCase();
                    } else {
                        map.put("DEVTYPE", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT+CIMI\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CIMI";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("IMSI", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+CIMI", "+CIMI:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    map.put("IMSI", receiveContext);
                    ConfigInterface.imsiString = receiveContext;
                }
                ATStr = "AT+CPMS=\"ME\",\"ME\",\"ME\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPMS=\"ME\",\"ME\",\"ME\"";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    map.put("deviceSmsCount", receStr);
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure: AT delay " + ATStr1 + " Object return is null");
                } else {
                    receiveContext = inMsg.getContent();
                    String[] s1 = new String[]{"\n", "\r", "AT+CPMS=\"ME\",\"ME\",\"ME\"", "+CPMS:", "OK"};
                    String[] s2 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
                    String[] AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"ME\",\"ME\",\"ME\": sim puk required", "AT+CPMS=\"ME\",\"ME\",\"ME\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"ME\",\"ME\",\"ME\":at return error", "AT+CPMS=\"ME\",\"ME\",\"ME\":SIM failure", "AT+CPMS=\"ME\",\"ME\",\"ME\":SIM failure"};
                    filtermap = this.getFilterStr(AtStr1, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        map.put("deviceSmsCount", String.valueOf(arr[0]) + "/" + arr[1]);
                        PublicConfig.deviceNumber = arr[0];
                    } else {
                        map.put("deviceSmsCount", (String)filtermap.get("receiveContext"));
                        map.put("deviceManCount", (String)filtermap.get("receiveContext"));
                        return map;
                    }
                }
                receiveContext = null;
                if ("0".equals(PublicConfig.deviceaccessMaxSize)) {
                    ATStr = "AT+CPBS=\"ME\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS=\"ME\"\r";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                        map.put("deviceManCount", receStr);
                    } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                        log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT ERROR " + ATStr1);
                        map.put("deviceManCount", receStr);
                    } else {
                        ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                        ATStr1 = "AT+CPBS?";
                        outMsg.setContent(ATStr);
                        inMsg = server.send(outMsg, 30);
                        if (inMsg == null) {
                            log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                            map.put("deviceManCount", receStr);
                        } else {
                            receiveContext = inMsg.getContent();
                            String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                            String[] s4 = new String[]{"", "", "", "", ""};
                            receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                            arr = TextUtil.split(receiveContext, ",");
                            map.put("deviceManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                        }
                    }
                } else {
                    map.put("deviceManCount", String.valueOf(PublicConfig.deviceuserAccessSize) + "/" + PublicConfig.deviceaccessMaxSize);
                }
                receiveContext = null;
                ATStr = "AT^VOLT?\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+VOLT";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("voltage", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+VOLT", "+VOLT:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+VOLT: sim puk required", "AT+VOLT: sim puk required", "AT+VOLT:COMMAND NOT SUPPORT", "AT+VOLT:at return error", "AT+VOLT:SIM failure", "AT+VOLT:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("voltage", receiveContext);
                    } else {
                        map.put("voltage", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT^PRLVER??\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+PRLVER";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("PRL", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+PRLVER", "+PRLVER:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+PRLVER: sim puk required", "AT+PRLVER: sim puk required", "AT+PRLVER:COMMAND NOT SUPPORT", "AT+PRLVER:at return error", "AT+PRLVER:SIM failure", "AT+PRLVER:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("PRL", receiveContext);
                    } else {
                        map.put("PRL", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = null;
                ATStr = "AT^GSN?\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+GSN";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("IMEI", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+GSN", "+GSN:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+GSN: sim puk required", "AT+GSN: sim puk required", "AT+GSN:COMMAND NOT SUPPORT", "AT+GSN:at return error", "AT+GSN:SIM failure", "AT+GSN:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("ESN", receiveContext);
                        if (receiveContext.startsWith("80")) {
                            PublicConfig.showMEDI = "1";
                            String MEDI = this.queryMEIDByCDMA();
                            map.put("MEDI", MEDI);
                        }
                    } else {
                        map.put("ESN", (String)filtermap.get("receiveContext"));
                    }
                }
                receiveContext = this.lb.getUnknown();
                PublicConfig.IS_SHOW_SIM_CDMA = "0";
                map.put("simInfoCount", receiveContext);
                map.put("simManCount", receiveContext);
                map.put("SN", receiveContext);
            }
        }
        catch (Exception e) {
            log.info("queryNetDiagnosisInfo error: " + e.toString());
        }
        return map;
    }

    public String getAPN(String apn) {
        CommServer server = null;
        String receiveContext = "";
        String intCDMARSSI = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method getCurrentCSQ from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getAPN************server==null***************************************");
            }
            at = "AT+CGDCONT=1,\"ip\",\"" + apn + "\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
            String temp = "AT+CGDCONT=1,\"ip\",\"" + apn + "\"";
            if (receiveContext.indexOf(temp) > -1) {
                receiveContext = receiveContext.substring(temp.length());
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        log.info("end the method getCurrentCSQ from NetCommService");
        return receiveContext;
    }

    public String getcloseAt() {
        CommServer server = null;
        String receiveContext = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method getCurrentCSQ from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.error("*********************************getcloseAt************server==null***************************************");
            }
            at = "AT+CFUN=0\r" + (char)Integer.parseInt("1a", 16) + "z";
            outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        log.info("end the method getCurrentCSQ from NetCommService");
        return receiveContext;
    }

    public void getCGACT() {
        CommServer server = null;
        String receiveContext = "";
        String intCDMARSSI = "";
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String at = "";
        try {
            log.info("start the method getCGACT from NetCommService");
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getAPN************server==null***************************************");
                return;
            }
            at = "AT+CGACT=0\r" + (char)Integer.parseInt("1a", 16) + "z";
            outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            receiveContext = inMsg.getContent();
        }
        catch (Exception e) {
            log.info("getCGACT Exception.");
        }
        log.info("start the method getCGACT from NetCommService");
    }

    public static void reportFlowSpeedInfo(String receiveContext) {
        String[] arr = null;
        try {
            receiveContext = TextUtil.replaceStr(receiveContext, "^DSFLOWRPT:", "");
            arr = TextUtil.split(receiveContext, ",");
            repUploadSpeed = TextUtil.stringFormat(arr[1], 16);
            repDownSpeed = TextUtil.stringFormat(arr[2], 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashMap reportFlowInfo(String receiveContext) throws Exception {
        HashMap<String, Long> map = null;
        map = new HashMap<String, Long>();
        String[] arr = null;
        try {
            if (Tools.isEmpty(receiveContext)) {
                throw new Exception("AT:Report return is emplty");
            }
            receiveContext = TextUtil.replaceStr(receiveContext, "^DSFLOWRPT:", "");
            arr = TextUtil.split(receiveContext, ",");
            map.put("last_ds_time", TextUtil.stringFormat(arr[0], 16));
            map.put("uploadSpeed", TextUtil.stringFormat(arr[1], 16));
            map.put("adownSpeed", TextUtil.stringFormat(arr[2], 16));
            map.put("uploadflux", TextUtil.stringFormat(arr[3], 16));
            map.put("adownflux", TextUtil.stringFormat(arr[4], 16));
            Tools.logToControl("out", "=========reportFlowInfo===map====" + map);
        }
        catch (Exception e) {
            log.info("reportFlowInfo error: " + e.toString());
            throw e;
        }
        return map;
    }

    public HashMap refreshDoctorByAddDeleteTelHome(HashMap m) throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************refreshDoctorByAddDeleteTelHome************server==null***************************************");
                return null;
            }
        }
        catch (Exception ex) {
            receiveContext = this.lb.getUnknown();
            map.put("simManCount", receiveContext);
            return map;
        }
        try {
            receiveContext = null;
            ATStr = "AT+CPBS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT+CPBS=\"SM\"\r";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[refreshDoctorByAddDeleteTelHome]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("simManCount", receStr);
            } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                log.fatal(" function[refreshDoctorByAddDeleteTelHome]  failure:  AT ERROR " + ATStr1);
                map.put("simManCount", receStr);
            } else {
                ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPBS?";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[refreshDoctorByAddDeleteTelHome]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("simManCount", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.getBetweenString(receiveContext, "+CPBS:");
                    String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                    String[] s4 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                    String[] sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
                    String[] AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure"};
                    filtermap = this.getFilterStr(AtStr2, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        map.put("simManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                    } else {
                        map.put("simManCount", (String)filtermap.get("receiveContext"));
                        PublicConfig.userAccessSize = Tools.checkNull(arr[1]);
                        PublicConfig.accessMaxSize = Tools.checkNull(arr[2]);
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("refreshDoctorByAddDeleteTelHome error: " + e.toString());
        }
        return map;
    }

    public HashMap refreshDoctorByPinPUkSimInfo(HashMap m) throws Exception {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************refreshDoctorByPinPUkSimInfo************server==null***************************************");
                return null;
            }
        }
        catch (Exception ex) {
            receiveContext = this.lb.getUnknown();
            map.put("simInfoCount", receiveContext);
            map.put("SN", receiveContext);
            map.put("IMSI", receiveContext);
            map.put("simManCount", receiveContext);
            map.put("msisdn", receiveContext);
            return map;
        }
        try {
            if (!PublicConfig.notSimAndTelFlag.equals("1")) {
                Thread.currentThread();
                Thread.sleep(12000L);
                ATStr = "AT+CPMS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPMS=\"SM\"";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    map.put("simInfoCount", receStr);
                    log.fatal(" function[refreshDoctorByAddDeleteSimInfo]  failure: AT delay " + ATStr1 + " Object return is null");
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.getBetweenString(receiveContext, "+CPMS:");
                    Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===============" + ATStr1 + "===========" + receiveContext);
                    String[] s1 = new String[]{"\n", "\r", "AT+CPMS=\"SM\"", "+CPMS:", "OK"};
                    String[] s2 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
                    String[] AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"SM\":at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                    filtermap = this.getFilterStr(AtStr1, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        map.put("simInfoCount", String.valueOf(arr[0]) + "/" + arr[1]);
                        if (arr[1].equals("0")) {
                            PublicConfig.IS_SHOW_SIM_CDMA = "0";
                        } else if (arr[1].matches("^[0-9]*[0-9][0-9]*$")) {
                            map.put("simInfoCount", String.valueOf(arr[0]) + "/" + arr[1]);
                            PublicConfig.IS_SHOW_SIM_CDMA = "1";
                        }
                        PublicConfig.smsNumber = arr[0];
                    } else {
                        map.put("simInfoCount", (String)filtermap.get("receiveContext"));
                    }
                }
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            receiveContext = null;
            ATStr = "AT+CIMI\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT+CIMI";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("IMSI", receStr);
            } else {
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.rLeft1(receiveContext, "OK");
                Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo=============AT+CIMI=============" + receiveContext);
                String[] s15 = new String[]{"\n", "\r", "AT+CIMI", "+CIMI:", "OK", "\""};
                String[] s16 = new String[]{"", "", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                String[] AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+CIMI: sim puk required", "AT+CIMI: sim puk required", "AT+CIMI:COMMAND NOT SUPPORT", "AT+CIMI:at return error", "AT+CIMI: SIM failure", "AT+CIMI:SIM failure"};
                filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    map.put("IMSI", receiveContext);
                    ConfigInterface.imsiString = receiveContext;
                } else {
                    map.put("IMSI", (String)filtermap.get("receiveContext"));
                }
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            receiveContext = null;
            ATStr = "AT^SN\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT^SN";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("SN", receStr);
            } else {
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.getBetweenString(receiveContext, "^SN:");
                Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo=========AT^SN=================" + receiveContext);
                String[] s11 = new String[]{"\n", "\r", "AT^SN", "^SN:", "OK", "\""};
                String[] s12 = new String[]{"", "", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s11, s12);
                String[] AtStr6 = new String[]{"sim pin required", "sim pin required", "AT^SN: sim puk required", "AT^SN: sim puk required", "AT^SN:COMMAND NOT SUPPORT", "AT^SN:at return error", "AT^SN:SIM failure", "AT^SN:SIM failure"};
                filtermap = this.getFilterStr(AtStr6, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    map.put("SN", receiveContext);
                } else {
                    map.put("SN", (String)filtermap.get("receiveContext"));
                }
            }
            if (!PublicConfig.notSimAndTelFlag.equals("1")) {
                Thread.currentThread();
                Thread.sleep(4000L);
                receiveContext = null;
                String refresh = "true";
                ATStr = "AT+CPBS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPBS=\"SM\"\r";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[refreshDoctorByPinPUkSimInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("simManCount", receStr);
                } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                    log.fatal(" function[refreshDoctorByPinPUkSimInfo]  failure:  AT ERROR " + ATStr1);
                    map.put("simManCount", receStr);
                } else {
                    ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS?";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[refreshDoctorByPinPUkSimInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                        map.put("simManCount", receStr);
                    } else {
                        String[] AtStr2;
                        receiveContext = inMsg.getContent();
                        receiveContext = TextUtil.getBetweenString(receiveContext, "+CPBS:");
                        Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===========AT+CPBS?===============" + receiveContext);
                        String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                        String[] s4 = new String[]{"", "", "", "", ""};
                        receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                        String[] sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
                        if (TextUtil.checkContainStr(receiveContext, sore)) {
                            PublicConfig.doctureRefresh = "true";
                        }
                        if ((filtermap = this.getFilterStr(AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure"}, receiveContext, arr0, this.lb)).isEmpty()) {
                            arr = TextUtil.split(receiveContext, ",");
                            map.put("simManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                            PublicConfig.userAccessSize = Tools.checkNull(arr[1]);
                            PublicConfig.accessMaxSize = Tools.checkNull(arr[2]);
                        } else {
                            map.put("simManCount", (String)filtermap.get("receiveContext"));
                        }
                    }
                }
            }
            if (PublicConfig.showMSISDN.equals("1")) {
                String dd = this.getMSISDN(server);
                map.put("msisdn", Tools.checkNull(dd));
            }
            return map;
        }
        catch (Exception e) {
            log.info("refreshDoctorByAddDeleteTelHome error: " + e.toString());
            return map;
        }
    }

    public HashMap refreshDoctorByAddDeleteSimInfo(HashMap m) throws Exception {
        HashMap<String, String> map;
        block8: {
            this.lb = CustomizeInit.getLanguageBean();
            String[] arr = null;
            OutgoingMessage outMsg = new OutgoingMessage();
            IncomingMessage inMsg = null;
            String receiveContext = null;
            String receStr = this.lb.getUnknown();
            map = new HashMap<String, String>();
            HashMap filtermap = new HashMap();
            CommServer server = null;
            String ATStr = null;
            String ATStr1 = null;
            String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
            try {
                server = MutiDeviceService.getCurrentServer();
                if (server == null) {
                    PublicConfig.shortMessageMaxCount = receiveContext = this.lb.getUnknown();
                    PublicConfig.shortMessageCount = receiveContext;
                    log.info("*********************************refreshDoctorByAddDeleteSimInfo************server==null***************************************");
                    return null;
                }
            }
            catch (Exception ex) {
                receiveContext = this.lb.getUnknown();
                map.put("simInfoCount", receiveContext);
                PublicConfig.shortMessageMaxCount = receiveContext;
                PublicConfig.shortMessageCount = receiveContext;
                return map;
            }
            try {
                if (PublicConfig.notSimAndTelFlag.equals("1")) break block8;
                ATStr = "AT+CPMS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPMS=\"SM\"";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    map.put("simInfoCount", receStr);
                    PublicConfig.shortMessageMaxCount = receStr;
                    PublicConfig.shortMessageCount = receStr;
                    log.fatal(" function[refreshDoctorByAddDeleteSimInfo]  failure: AT delay " + ATStr1 + " Object return is null");
                    break block8;
                }
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.getBetweenString(receiveContext, "+CPMS:");
                String[] s1 = new String[]{"\n", "\r", "AT+CPMS=\"SM\"", "+CPMS:", "OK"};
                String[] s2 = new String[]{"", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
                String[] AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"SM\":at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                filtermap = this.getFilterStr(AtStr1, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    arr = TextUtil.split(receiveContext, ",");
                    map.put("simInfoCount", String.valueOf(arr[0]) + "/" + arr[1]);
                    PublicConfig.smsNumber = arr[0];
                    PublicConfig.shortMessageCount = arr[0];
                    PublicConfig.shortMessageMaxCount = arr[1];
                    break block8;
                }
                map.put("simInfoCount", (String)filtermap.get("receiveContext"));
                return map;
            }
            catch (Exception e) {
                log.info("refreshDoctorByAddDeleteTelHome error: " + e.toString());
            }
        }
        return map;
    }

    public void checkSimTelLength() {
        HashMap map = null;
        CommServer server = null;
        map = new HashMap();
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String receiveContext = null;
        try {
            server = MutiDeviceService.getCurrentServer();
        }
        catch (Exception ex) {
            log.info("*********************************checkSimTelLength************server==null***************************************");
            return;
        }
        try {
            String at = "AT^CPBR=?\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT^CPBR=?";
            outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[querySimTelLength]  failure: AT delay " + at1 + " Object return is null");
                return;
            }
            receiveContext = inMsg.getContent();
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            if ((receiveContext = TextUtil.replaceStr(receiveContext, "\r", "")) != null && TextUtil.checkContainStr(receiveContext, "ERROR")) {
                log.info("checkSimTelLength===failure: " + receiveContext);
                Tools.logToControl("err", "failure: checkSimTelLength[receiveContext]=" + receiveContext);
                return;
            }
            receiveContext = TextUtil.replaceStr(receiveContext, "^CPBR:", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "AT^CPBR:", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "ok", "");
            String[] arr = receiveContext.split(",");
            PublicConfig.simTelMaxLength = Tools.checkNull(arr[1]);
            PublicConfig.simNameMaxLength = Tools.checkNull(arr[2]);
        }
        catch (Exception e) {
            log.info("checkSimTelLength error: " + e.toString());
        }
    }

    public void checkRefreshAccessMaxSize() {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13", "+CME ERROR: SIM busy", "+CME ERROR: 14"};
        try {
            server = MutiDeviceService.getCurrentServer();
        }
        catch (Exception ex) {
            log.info("*********************************checkRefreshAccessMaxSize************server==null***************************************");
            return;
        }
        try {
            if (PublicConfig.notSimLock.equals(PublicConfig.simLockState) && PublicConfig.accessMaxSize.equals("0") && !PublicConfig.notSimAndTelFlag.equals("1")) {
                receiveContext = null;
                String refresh = "true";
                ATStr = "AT+CPBS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPBS=\"SM\"\r";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[checkRefreshAccessMaxSize]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("simManCount", receStr);
                } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                    log.fatal(" function[checkRefreshAccessMaxSize]  failure:  AT ERROR " + ATStr1);
                    map.put("simManCount", receStr);
                } else {
                    ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS?";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[checkRefreshAccessMaxSize]  failure:  AT delay " + ATStr1 + " Object return is null");
                        return;
                    }
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.getBetweenString(receiveContext, "+CPBS:");
                    Tools.logToControl("err", "receiveContext=============checkRefreshAccessMaxSize===========AT+CPBS?===============" + receiveContext);
                    String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                    String[] s4 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                    String[] AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure", "+CME ERROR: SIM busy", "+CME ERROR: SIM busy"};
                    filtermap = this.getFilterStr(AtStr2, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        PublicConfig.userAccessSize = Tools.checkNull(arr[1]);
                        PublicConfig.accessMaxSize = Tools.checkNull(arr[2]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void checkRefreshSimAndDeviceInfo() {
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        CommServer server = null;
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************checkRefreshSimAndDeviceInfo************server==null***************************************");
            }
        }
        catch (Exception ex) {
            DiagnosisPanel.jlabel1.setText("   " + receStr);
            DiagnosisPanel.jlabel1.updateUI();
            DiagnosisPanel.jlabel2.setText("   " + receStr);
            DiagnosisPanel.jlabel2.updateUI();
            DiagnosisPanel.jlabel3.setText("   " + receStr);
            DiagnosisPanel.jlabel3.updateUI();
            DiagnosisPanel.jlabel4.setText("   " + receStr);
            DiagnosisPanel.jlabel4.updateUI();
            DiagnosisPanel.jlabel5.setText("   " + receStr);
            DiagnosisPanel.jlabel5.updateUI();
            DiagnosisPanel.jlabel6.setText("   " + receStr);
            DiagnosisPanel.jlabel6.updateUI();
            DiagnosisPanel.jlabel7.setText("   " + receStr);
            DiagnosisPanel.jlabel7.updateUI();
            DiagnosisPanel.jlabel8.setText("   " + receStr);
            DiagnosisPanel.jlabel8.updateUI();
            DiagnosisPanel.msgInDevLabel.setText("   " + receStr);
            DiagnosisPanel.msgInDevLabel.updateUI();
            DiagnosisPanel.conInDevLabel.setText("   " + receStr);
            DiagnosisPanel.conInDevLabel.updateUI();
            DiagnosisPanel.voltageLabel.setText("   " + receStr);
            DiagnosisPanel.voltageLabel.updateUI();
            DiagnosisPanel.prlLabel.setText("   " + receStr);
            DiagnosisPanel.prlLabel.updateUI();
            DiagnosisPanel.esnLabel.setText("   " + receStr);
            DiagnosisPanel.esnLabel.updateUI();
            DiagnosisPanel.mediLabel.setText("   " + receStr);
            DiagnosisPanel.mediLabel.updateUI();
            return;
        }
        try {
            if (PublicConfig.notSimLock.equals(PublicConfig.simLockState)) {
                if (!PublicConfig.notSimAndTelFlag.equals("1")) {
                    ATStr = "AT+CPMS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPMS=\"SM\"";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        map.put("simInfoCount", receStr);
                        log.fatal(" function[refreshDoctorByAddDeleteSimInfo]  failure: AT delay " + ATStr1 + " Object return is null");
                    } else {
                        receiveContext = inMsg.getContent();
                        receiveContext = TextUtil.getBetweenString(receiveContext, "+CPMS:");
                        String[] AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"SM\":at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                        String[] s1 = new String[]{"\n", "\r", "AT+CPMS=\"SM\"", "+CPMS:", "OK"};
                        String[] s2 = new String[]{"", "", "", "", ""};
                        filtermap = this.getFilterStr(AtStr1, receiveContext = TextUtil.replaceStr(receiveContext, s1, s2), arr0, this.lb);
                        if (filtermap.isEmpty()) {
                            arr = TextUtil.split(receiveContext, ",");
                            if (Tools.isDigit(arr[0]) && Tools.isDigit(arr[1])) {
                                map.put("simInfoCount", String.valueOf(arr[0]) + "/" + arr[1]);
                                if (arr[1].equals("0")) {
                                    PublicConfig.IS_SHOW_SIM_CDMA = "0";
                                } else if (arr[1].matches("^[0-9]*[0-9][0-9]*$")) {
                                    map.put("simInfoCount", String.valueOf(arr[0]) + "/" + arr[1]);
                                    PublicConfig.IS_SHOW_SIM_CDMA = "1";
                                }
                                PublicConfig.smsNumber = arr[0];
                            } else {
                                map.put("simInfoCount", receStr);
                                PublicConfig.smsNumber = "";
                            }
                        } else {
                            map.put("simInfoCount", (String)filtermap.get("receiveContext"));
                        }
                    }
                    DiagnosisPanel.jlabel1.setText("   " + Tools.checkNull(map.get("simInfoCount")));
                    DiagnosisPanel.jlabel1.updateUI();
                    AppFrame.diagnosisInfoManageMap.put("simInfoCount", Tools.checkNull(map.get("simInfoCount")));
                }
                receiveContext = null;
                ATStr = "AT+CIMI\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CIMI";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("IMSI", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    if (receiveContext.indexOf("ERROR") > 0) {
                        receiveContext = this.lb.getUnknown();
                        map.put("IMSI", receiveContext);
                    }
                    if (receiveContext.indexOf("OK") > 0) {
                        receiveContext = TextUtil.rLeft1(receiveContext, "OK");
                        Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo=============AT+CIMI=============" + receiveContext);
                        String[] s15 = new String[]{"\n", "\r", "AT+CIMI", "+CIMI:", "OK", "\""};
                        String[] s16 = new String[]{"", "", "", "", "", ""};
                        receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                        map.put("IMSI", receiveContext);
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("IMSI", Tools.checkNull(map.get("IMSI")));
                DiagnosisPanel.jlabel4.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("IMSI")));
                DiagnosisPanel.jlabel4.updateUI();
                receiveContext = null;
                ATStr = "AT^SN\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^SN";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("SN", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    receiveContext = TextUtil.getBetweenString(receiveContext, "^SN:");
                    Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo=========AT^SN=================" + receiveContext);
                    String[] s11 = new String[]{"\n", "\r", "AT^SN", "^SN:", "OK", "\""};
                    String[] s12 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s11, s12);
                    String[] AtStr6 = new String[]{"sim pin required", "sim pin required", "AT^SN: sim puk required", "AT^SN: sim puk required", "AT^SN:COMMAND NOT SUPPORT", "AT^SN:at return error", "AT^SN:SIM failure", "AT^SN:SIM failure"};
                    filtermap = this.getFilterStr(AtStr6, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("SN", receiveContext);
                    } else {
                        map.put("SN", (String)filtermap.get("receiveContext"));
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("SN", Tools.checkNull(map.get("SN")));
                DiagnosisPanel.jlabel8.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("SN")));
                DiagnosisPanel.jlabel8.updateUI();
                if (!PublicConfig.notSimAndTelFlag.equals("1")) {
                    receiveContext = null;
                    String refresh = "true";
                    ATStr = "AT+CPBS=\"SM\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS=\"SM\"\r";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[checkRefreshSimAndDeviceInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                        map.put("simManCount", receStr);
                    } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                        log.fatal(" function[checkRefreshSimAndDeviceInfo]  failure:  AT ERROR " + ATStr1);
                        map.put("simManCount", receStr);
                    } else {
                        ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                        ATStr1 = "AT+CPBS?";
                        outMsg.setContent(ATStr);
                        inMsg = server.send(outMsg, 30);
                        if (inMsg == null) {
                            log.fatal(" function[checkRefreshSimAndDeviceInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                            map.put("simManCount", receStr);
                        } else {
                            String[] AtStr2;
                            receiveContext = inMsg.getContent();
                            receiveContext = TextUtil.getBetweenString(receiveContext, "+CPBS:");
                            Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===========AT+CPBS?===============" + receiveContext);
                            String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                            String[] s4 = new String[]{"", "", "", "", ""};
                            receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                            String[] sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
                            if (TextUtil.checkContainStr(receiveContext, sore)) {
                                PublicConfig.doctureRefresh = "true";
                            }
                            if ((filtermap = this.getFilterStr(AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure"}, receiveContext, arr0, this.lb)).isEmpty()) {
                                arr = TextUtil.split(receiveContext, ",");
                                if (Tools.isDigit(arr[1]) && Tools.isDigit(arr[2])) {
                                    map.put("simManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                                    if (arr[2].equals("0")) {
                                        PublicConfig.IS_SHOW_SIM_CDMA = "0";
                                    } else if (arr[1].matches("^[0-9]*[0-9][0-9]*$")) {
                                        map.put("simManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                                        PublicConfig.IS_SHOW_SIM_CDMA = "1";
                                    }
                                    PublicConfig.userAccessSize = Tools.checkNull(arr[1]);
                                    PublicConfig.accessMaxSize = Tools.checkNull(arr[2]);
                                } else {
                                    map.put("simManCount", receStr);
                                    PublicConfig.userAccessSize = "";
                                    PublicConfig.accessMaxSize = "";
                                }
                            } else {
                                map.put("simManCount", (String)filtermap.get("receiveContext"));
                            }
                        }
                    }
                    DiagnosisPanel.jlabel2.setText("   " + Tools.changeNullToUnknown(map.get("simManCount")));
                    DiagnosisPanel.jlabel2.updateUI();
                    AppFrame.diagnosisInfoManageMap.put("simManCount", Tools.checkNull(map.get("simManCount")));
                }
                if (PublicConfig.showMSISDN.equals("1")) {
                    String dd = this.getMSISDN(server);
                    AppFrame.diagnosisInfoManageMap.put("msisdn", Tools.checkNull(dd));
                    DiagnosisPanel.jlabel9.setText("   " + Tools.changeNullToUnknown(dd));
                    DiagnosisPanel.jlabel9.updateUI();
                }
                this.checkfreshDevice(server);
                if (PublicConfig.requestSimLock.equals(PublicConfig.simLockState)) {
                    this.checkfreshDevice(server);
                }
            }
        }
        catch (Exception e) {
            log.info("checkRefreshSimInfo error: " + e.toString());
        }
    }

    private void checkfreshDevice(CommServer server) {
        CustomizeInit.getCustomizeInit();
        this.lb = CustomizeInit.getLanguageBean();
        String[] arr = null;
        OutgoingMessage outMsg = new OutgoingMessage();
        IncomingMessage inMsg = null;
        String receiveContext = null;
        String receStr = this.lb.getUnknown();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap filtermap = new HashMap();
        String ATStr = null;
        String ATStr1 = null;
        String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
        try {
            String[] s16;
            String[] s15;
            receiveContext = null;
            ATStr = "AT+CGMR\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT+CGMR";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("firmwareVer", receStr);
                AppFrame.diagnosisInfoManageMap.put("firmwareVer", receStr);
            } else {
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.rLeft2(receiveContext, "OK");
                Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===========AT+CGMR===============" + receiveContext);
                String[] s7 = new String[]{"\n", "\r", "AT+CGMR", "+CGMR:", "OK", "\""};
                String[] s8 = new String[]{"", "", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s7, s8);
                String[] AtStr4 = new String[]{"sim pin required", "sim pin required", "AT+CGMR: sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CGMR:COMMAND NOT SUPPORT", "AT+CGMR: at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                filtermap = this.getFilterStr(AtStr4, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    if (!Tools.isEmpty(receiveContext)) {
                        map.put("firmwareVer", receiveContext.toUpperCase());
                    } else {
                        map.put("firmwareVer", receStr);
                    }
                } else {
                    map.put("firmwareVer", (String)filtermap.get("receiveContext"));
                    receiveContext = receStr;
                }
            }
            DiagnosisPanel.jlabel5.setText("   " + Tools.changeNullToUnknown(receiveContext));
            DiagnosisPanel.jlabel5.updateUI();
            AppFrame.diagnosisInfoManageMap.put("firmwareVer", Tools.changeNullToUnknown(receiveContext));
            receiveContext = null;
            ATStr = "AT^HWVER\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT^HWVER";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("hardwareVer", receStr);
            } else {
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.getBetweenString(receiveContext, "^HWVER:");
                Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===========AT^HWVER==============" + receiveContext);
                String[] s9 = new String[]{"\n", "\r", "AT^HWVER", "^HWVER:", "OK", "\""};
                String[] s10 = new String[]{"", "", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s9, s10);
                String[] AtStr5 = new String[]{"sim pin required", "sim pin required", "AT^HWVER: sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT^HWVER:COMMAND NOT SUPPORT", "AT^HWVER at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                filtermap = this.getFilterStr(AtStr5, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    map.put("hardwareVer", receiveContext.toUpperCase());
                } else {
                    map.put("hardwareVer", (String)filtermap.get("receiveContext"));
                }
            }
            AppFrame.diagnosisInfoManageMap.put("hardwareVer", Tools.checkNull(map.get("hardwareVer")));
            DiagnosisPanel.jlabel6.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("hardwareVer")));
            DiagnosisPanel.jlabel6.updateUI();
            receiveContext = null;
            ATStr = "AT+CGMM\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT+CGMM";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("DEVTYPE", receStr);
            } else {
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.rLeft1(receiveContext, "OK");
                Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===========AT+CGMM==============" + receiveContext);
                String[] s13 = new String[]{"\n", "\r", "AT+CGMM", "+CGMM:", "OK", "\""};
                String[] s14 = new String[]{"", "", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s13, s14);
                String[] AtStr7 = new String[]{"sim pin required", "sim pin required", "AT+CGMM: sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CGMM:COMMAND NOT SUPPORT", "AT+CGMM:at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                filtermap = this.getFilterStr(AtStr7, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    map.put("DEVTYPE", receiveContext.toUpperCase());
                    PublicConfig.deviceType = receiveContext.toUpperCase();
                } else {
                    map.put("DEVTYPE", (String)filtermap.get("receiveContext"));
                }
            }
            AppFrame.diagnosisInfoManageMap.put("DEVTYPE", map.get("DEVTYPE"));
            DiagnosisPanel.jlabel7.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("DEVTYPE")));
            DiagnosisPanel.jlabel7.updateUI();
            receiveContext = null;
            ATStr = "AT+CGSN\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT+CGSN";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("IMEI", receStr);
            } else {
                receiveContext = inMsg.getContent();
                receiveContext = TextUtil.rLeft1(receiveContext, "OK");
                Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo===========AT+CGSN==============" + receiveContext);
                String[] s5 = new String[]{"\n", "\r", "AT+CGSN", "+CGSN:", "OK"};
                String[] s6 = new String[]{"", "", "", "", ""};
                receiveContext = TextUtil.replaceStr(receiveContext, s5, s6);
                String[] AtStr3 = new String[]{"sim pin required", "sim pin required", "AT+CGSN: sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CGSN:COMMAND NOT SUPPORT", "AT+CGSN: at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
                filtermap = this.getFilterStr(AtStr3, receiveContext, arr0, this.lb);
                if (filtermap.isEmpty()) {
                    map.put("IMEI", receiveContext);
                } else {
                    map.put("IMEI", (String)filtermap.get("receiveContext"));
                }
            }
            AppFrame.diagnosisInfoManageMap.put("IMEI", map.get("IMEI"));
            DiagnosisPanel.jlabel3.setText("   " + Tools.changeNullToUnknown(map.get("IMEI")));
            DiagnosisPanel.jlabel3.updateUI();
            receiveContext = null;
            ATStr = "AT+CIMI\r" + (char)Integer.parseInt("1a", 16) + "z";
            ATStr1 = "AT+CIMI";
            outMsg.setContent(ATStr);
            inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[queryNetDiagnosisInfo]  failure:  AT delay " + ATStr1 + " Object return is null");
                map.put("IMSI", receStr);
            } else {
                receiveContext = inMsg.getContent();
                if (receiveContext.indexOf("ERROR") > 0) {
                    receiveContext = this.lb.getUnknown();
                    map.put("IMSI", receiveContext);
                    ConfigInterface.imsiString = receiveContext;
                }
                if (receiveContext.indexOf("OK") > 0) {
                    receiveContext = TextUtil.rLeft1(receiveContext, "OK");
                    Tools.logToControl("err", "receiveContext=============refreshDoctorByPinPUkSimInfo=============AT+CIMI=============" + receiveContext);
                    s15 = new String[]{"\n", "\r", "AT+CIMI", "+CIMI:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    map.put("IMSI", receiveContext);
                    ConfigInterface.imsiString = receiveContext;
                }
            }
            AppFrame.diagnosisInfoManageMap.put("IMSI", Tools.checkNull(map.get("IMSI")));
            DiagnosisPanel.jlabel4.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("IMSI")));
            DiagnosisPanel.jlabel4.updateUI();
            map.put("port", DiagnosisService.getInstance().getPort());
            AppFrame.diagnosisInfoManageMap.put("port", map.get("port"));
            if ("CDMA".equals(this.dev.getProductNetType())) {
                String[] AtStr8;
                ATStr = "AT+CPMS=\"ME\",\"ME\",\"ME\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPMS=\"ME\",\"ME\",\"ME\"";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    map.put("deviceSmsCount", receStr);
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure: AT delay " + ATStr1 + " Object return is null");
                } else {
                    receiveContext = inMsg.getContent();
                    String[] s1 = new String[]{"\n", "\r", "AT+CPMS=\"ME\",\"ME\",\"ME\"", "+CPMS:", "OK"};
                    String[] s2 = new String[]{"", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s1, s2);
                    String[] AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"ME\",\"ME\",\"ME\": sim puk required", "AT+CPMS=\"ME\",\"ME\",\"ME\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"ME\",\"ME\",\"ME\":at return error", "AT+CPMS=\"ME\",\"ME\",\"ME\":SIM failure", "AT+CPMS=\"ME\",\"ME\",\"ME\":SIM failure"};
                    filtermap = this.getFilterStr(AtStr1, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        arr = TextUtil.split(receiveContext, ",");
                        map.put("deviceSmsCount", String.valueOf(arr[0]) + "/" + arr[1]);
                        PublicConfig.deviceNumber = arr[0];
                    } else {
                        map.put("deviceSmsCount", (String)filtermap.get("receiveContext"));
                        map.put("deviceManCount", (String)filtermap.get("receiveContext"));
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("deviceSmsCount", Tools.checkNull(map.get("deviceSmsCount")));
                DiagnosisPanel.msgInDevLabel.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("deviceSmsCount")));
                DiagnosisPanel.msgInDevLabel.updateUI();
                receiveContext = null;
                ATStr = "AT+CPBS=\"ME\"\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+CPBS=\"ME\"\r";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("deviceManCount", receStr);
                } else if (TextUtil.checkContainStr(inMsg.getContent(), "ERROR")) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT ERROR " + ATStr1);
                    map.put("deviceManCount", receStr);
                } else {
                    ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
                    ATStr1 = "AT+CPBS?";
                    outMsg.setContent(ATStr);
                    inMsg = server.send(outMsg, 30);
                    if (inMsg == null) {
                        log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                        map.put("deviceManCount", receStr);
                    } else {
                        String[] AtStr2;
                        receiveContext = inMsg.getContent();
                        String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
                        String[] s4 = new String[]{"", "", "", "", ""};
                        receiveContext = TextUtil.replaceStr(receiveContext, s3, s4);
                        String[] sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
                        if (TextUtil.checkContainStr(receiveContext, sore)) {
                            PublicConfig.doctureRefresh = "true";
                        }
                        if ((filtermap = this.getFilterStr(AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure"}, receiveContext, arr0, this.lb)).isEmpty()) {
                            arr = TextUtil.split(receiveContext, ",");
                            map.put("deviceManCount", String.valueOf(arr[1]) + "/" + arr[2]);
                        } else {
                            map.put("deviceManCount", (String)filtermap.get("receiveContext"));
                        }
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("deviceManCount", Tools.checkNull(map.get("deviceManCount")));
                DiagnosisPanel.conInDevLabel.setText("   " + Tools.changeNullToUnknown(map.get("deviceManCount")));
                DiagnosisPanel.conInDevLabel.updateUI();
                receiveContext = null;
                ATStr = "AT^VOLT\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^VOLT";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("voltage", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT^VOLT", "^VOLT:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT^VOLT: sim puk required", "AT^VOLT: sim puk required", "AT^VOLT:COMMAND NOT SUPPORT", "AT^VOLT:at return error", "AT^VOLT:SIM failure", "AT^VOLT:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("voltage", receiveContext);
                    } else {
                        map.put("voltage", (String)filtermap.get("receiveContext"));
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("voltage", Tools.checkNull(map.get("voltage")));
                DiagnosisPanel.voltageLabel.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("voltage")));
                DiagnosisPanel.voltageLabel.updateUI();
                receiveContext = null;
                ATStr = "AT^PRLVER\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT^PRLVER";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("PRL", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT^PRLVER", "^PRLVER:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT^PRLVER: sim puk required", "AT^PRLVER: sim puk required", "AT^PRLVER:COMMAND NOT SUPPORT", "AT^PRLVER:at return error", "AT^PRLVER:SIM failure", "AT^PRLVER:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("PRL", receiveContext);
                    } else {
                        map.put("PRL", (String)filtermap.get("receiveContext"));
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("PRL", Tools.checkNull(map.get("PRL")));
                DiagnosisPanel.prlLabel.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("PRL")));
                DiagnosisPanel.prlLabel.updateUI();
                receiveContext = null;
                ATStr = "AT+GSN\r" + (char)Integer.parseInt("1a", 16) + "z";
                ATStr1 = "AT+GSN";
                outMsg.setContent(ATStr);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + ATStr1 + " Object return is null");
                    map.put("ESN", receStr);
                } else {
                    receiveContext = inMsg.getContent();
                    s15 = new String[]{"\n", "\r", "AT+GSN", "+GSN:", "OK", "\""};
                    s16 = new String[]{"", "", "", "", "", ""};
                    receiveContext = TextUtil.replaceStr(receiveContext, s15, s16);
                    AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+GSN: sim puk required", "AT+GSN: sim puk required", "AT+GSN:COMMAND NOT SUPPORT", "AT+GSN:at return error", "AT+GSN:SIM failure", "AT+GSN:SIM failure"};
                    filtermap = this.getFilterStr(AtStr8, receiveContext, arr0, this.lb);
                    if (filtermap.isEmpty()) {
                        map.put("ESN", receiveContext);
                        if (receiveContext.startsWith("80")) {
                            PublicConfig.showMEDI = "1";
                            String MEDI = this.queryMEIDByCDMA();
                            map.put("MEDI", MEDI);
                        }
                    } else {
                        map.put("ESN", (String)filtermap.get("receiveContext"));
                    }
                }
                AppFrame.diagnosisInfoManageMap.put("ESN", Tools.checkNull(map.get("ESN")));
                DiagnosisPanel.esnLabel.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ESN")));
                DiagnosisPanel.esnLabel.updateUI();
                AppFrame.diagnosisInfoManageMap.put("MEDI", Tools.checkNull(map.get("MEDI")));
                DiagnosisPanel.mediLabel.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("MEDI")));
                DiagnosisPanel.mediLabel.updateUI();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void refreshDeviceinfo() {
        CommServer server = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************refreshDeviceinfo************server==null***************************************");
            }
            if (server != null) {
                this.checkfreshDevice(server);
            }
        }
        catch (Exception ex) {
            Tools.logToControl("err", "=========refreshDeviceinfo==========================server=" + server);
            return;
        }
    }

    public String checkReturnNullPinState(CommServer server) {
        String bolSend = null;
        String receiveContext = null;
        String receiveContextNoSpace = null;
        OutgoingMessage outMsg = null;
        String at = null;
        String at1 = null;
        IncomingMessage inMsg = null;
        try {
            outMsg = new OutgoingMessage();
            log.info("***********************************************checkReturnNullPinState***************************************************************************");
            receiveContext = null;
            at = "AT^CPIN?\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT^CPIN?";
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 60);
            if (inMsg == null) {
                log.fatal(" function[checkReturnNullPinState]  failure: AT delay " + at1 + " Object return is null");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            receiveContext = inMsg.getContent();
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            if (TextUtil.checkContainStr(receiveContext, "^CPIN: SIM PIN") || TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:SIMPIN")) {
                String[] s1 = new String[]{"\n", "\r", "CPIN:", "SIMPIN", "OK", "\""};
                String[] s2 = new String[]{"", "", "", "", "", ""};
                String times = "";
                times = TextUtil.rRight(receiveContextNoSpace, "SIMPIN,").split(",")[0];
                String pincount = Tools.checkNull(PublicConfig.initpintimes);
                if (!pincount.equals(times)) {
                    log.warn("============effciey   sucess=============");
                    bolSend = PublicConfig.pinInputError;
                    return bolSend;
                }
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "^CPIN: READY") || TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:READY")) {
                log.warn("============effciey   sucess=============");
                bolSend = PublicConfig.pinEfficacySuccess;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "^CPIN: SIM PUK") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:12") || TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:SIMPUK")) {
                log.warn("+CME ERROR: SIM PUK required");
                bolSend = PublicConfig.pinInputError;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                log.warn("+CME ERROR: SIM failure");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                log.warn("+CME ERROR: SIM busy");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                log.warn("+CME ERROR: SIM wrong");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            log.info("***************************checkReturnNullPinState not match*******bolSend=" + bolSend + "**************");
        }
        catch (Exception e) {
            log.info("***************************checkReturnNullPinState error*******bolSend=" + bolSend + "**************=: " + e.toString());
        }
        return bolSend;
    }

    public String checkReturnNullPukState(CommServer server) {
        String bolSend = null;
        String receiveContext = null;
        String receiveContextNoSpace = null;
        OutgoingMessage outMsg = null;
        String at = null;
        String at1 = null;
        IncomingMessage inMsg = null;
        try {
            outMsg = new OutgoingMessage();
            log.info("***********************************************checkReturnNullPukState***************************************************************************");
            receiveContext = null;
            at = "AT^CPIN?\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT^CPIN?";
            outMsg.setContent(at);
            inMsg = server.send(outMsg, 60);
            if (inMsg == null) {
                log.fatal(" function[checkReturnNullPukState]  failure: AT delay " + at1 + " Object return is null");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            receiveContext = inMsg.getContent();
            receiveContextNoSpace = TextUtil.replaceStr(receiveContext, " ", "");
            if (TextUtil.checkContainStr(receiveContext, "^CPIN: READY") || TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:READY")) {
                log.warn("============effciey   sucess=============");
                bolSend = PublicConfig.pukEfficacySuccess;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 12") || TextUtil.checkContainStr(receiveContext, "^CPIN: SIM PUK") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:12") || TextUtil.checkContainStr(receiveContextNoSpace, "^CPIN:SIMPUK")) {
                String pukcount;
                log.warn("+CME ERROR: SIM PUK required");
                String[] s1 = new String[]{"\n", "\r", "^CPIN:", "SIMPUK", "OK", "\""};
                String[] s2 = new String[]{"", "", "", "", "", ""};
                receiveContextNoSpace = TextUtil.getBetweenString1(receiveContextNoSpace, "^CPIN:SIMPUK,");
                receiveContextNoSpace = TextUtil.replaceStr(receiveContextNoSpace, s1, s2);
                String times = "";
                if (!Tools.isEmpty(receiveContextNoSpace)) {
                    times = receiveContextNoSpace.split(",")[0];
                }
                if (!(pukcount = Tools.checkNull(PublicConfig.initpuktimes)).equals(times)) {
                    bolSend = PublicConfig.pukInputError;
                    return bolSend;
                }
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 13") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM failure") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:13") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMfailure")) {
                log.warn("+CME ERROR: SIM failure");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 14") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM busy") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:14") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMbusy")) {
                log.warn("+CME ERROR: SIM busy");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            if (TextUtil.checkContainStr(receiveContext, "+CME ERROR: 15") || TextUtil.checkContainStr(receiveContext, "+CME ERROR: SIM wrong") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:15") || TextUtil.checkContainStr(receiveContextNoSpace, "+CMEERROR:SIMwrong")) {
                log.warn("+CME ERROR: SIM wrong");
                bolSend = PublicConfig.failure;
                return bolSend;
            }
            log.info("***************************checkReturnNullPukState not match*******bolSend=" + bolSend + "**************");
        }
        catch (Exception e) {
            log.info("***************************checkReturnNullPukState error***********bolSend=" + bolSend + "**********=: " + e.toString());
            bolSend = PublicConfig.failure;
        }
        return bolSend;
    }

    public String readReportSimInfo(int index) {
        try {
            log.info("start the method readReportSimInfo from NetCommService");
            CommServer server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************readReportSimInfo************server==null***************************************");
            }
            String at = "AT+CPMS=\"SM\",\"SM\",\"SM\"\r";
            OutgoingMessage outMsg = null;
            IncomingMessage inMsg = null;
            String receiveContext = null;
            receiveContext = "";
            if (CommonMethodBySMS.getProductNetType().equalsIgnoreCase("CDMA")) {
                at = "AT^HCMGR=" + index + ",1\r";
                outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                log.info("**********************readReportSimInfo**********index=" + index + "   receiveContext=" + receiveContext);
                Tools.logToControl("err", "**********************readReportSimInfo**********index=" + index + "   receiveContext=" + receiveContext);
                receiveContext = receiveContext.substring(receiveContext.indexOf("^HCMGR:") + 7);
                receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
            } else {
                at = "AT+CMGR=" + index + "\r";
                outMsg = new OutgoingMessage();
                outMsg.setContent(String.valueOf(at) + (char)Integer.parseInt("1a", 16) + "z");
                inMsg = server.send(outMsg, 30);
                receiveContext = inMsg.getContent();
                log.info("**********************readReportSimInfo**********index=" + index + "   receiveContext=" + receiveContext);
                Tools.logToControl("err", "**********************readReportSimInfo**********index=" + index + "   receiveContext=" + receiveContext);
                receiveContext = receiveContext.substring(receiveContext.indexOf("+CMGR:") + 6);
                receiveContext = receiveContext.substring(0, receiveContext.indexOf("OK")).trim();
            }
            if (receiveContext == null || receiveContext.indexOf("ERROR") > -1 || receiveContext == "") {
                throw new Exception();
            }
            log.info("end the method readReportSimInfo from NetCommService");
            return receiveContext;
        }
        catch (Exception e1) {
            log.info("readReportSimInfo=[AT]-index=" + index + " -error:" + e1.toString());
            return "";
        }
    }

    public String getMSISDN(CommServer server) {
        this.lb = CustomizeInit.getLanguageBean();
        String receiveContext = null;
        String at = null;
        String at1 = null;
        String bolSend = "";
        ArrayList<String> list = null;
        String[] arrstr = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************getMSISDN************server==null***************************************");
                return this.lb.getUnknown();
            }
            at = "AT+CNUM\r" + (char)Integer.parseInt("1a", 16) + "z";
            at1 = "AT+CNUM";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[getMSISDN]  failure: AT delay " + at1 + " Object return is null");
                return this.lb.getUnknown();
            }
            receiveContext = inMsg.getContent();
            log.info("==function[getMSISDN]--receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            receiveContext = TextUtil.replaceStr(receiveContext, " ", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\"", "");
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                log.info("failure: " + receiveContext);
                return this.lb.getUnknown();
            }
            arrstr = receiveContext.split("CNUM:");
            list = new ArrayList<String>();
            String telhome = null;
            if (arrstr != null && arrstr.length > 0) {
                int i = 1;
                while (i < arrstr.length) {
                    Tools.logToControl("err", "arrstr[i]=================================" + arrstr[i]);
                    Tools.logToControl("err", "arrstr[i].split()[1]================================" + arrstr[i].split(",")[1]);
                    telhome = Tools.checkNull(arrstr[i].split(",")[1]);
                    list.add(telhome);
                    ++i;
                }
            }
            Tools.logToControl("err", "list================================" + list);
            if (list != null && list.size() > 0) {
                int j = 0;
                while (j < list.size()) {
                    telhome = Tools.checkNull(list.get(j));
                    Tools.logToControl("err", "telhome=================================" + telhome);
                    if (!Tools.isEmpty(telhome)) {
                        bolSend = telhome;
                        return telhome;
                    }
                    ++j;
                }
            } else {
                return this.lb.getUnknown();
            }
            return bolSend;
        }
        catch (Exception e) {
            log.info("***************************getMSISDN error***********=");
            return this.lb.getUnknown();
        }
    }

    public static void checkBandIsLink() {
        CommServer server = null;
        Object bolSend = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server == null) {
                log.info("*********************************checkBandIsLink************server==null***************************************");
            }
            String at = "AT+CGACT?\r" + (char)Integer.parseInt("1a", 16) + "z";
            String at1 = "AT+CGACT?";
            OutgoingMessage outMsg = new OutgoingMessage();
            outMsg.setContent(at);
            IncomingMessage inMsg = server.send(outMsg, 30);
            if (inMsg == null) {
                log.fatal(" function[checkBandIsLink]  failure: AT delay " + at1 + " Object return is null");
            }
            String receiveContext = inMsg.getContent();
            log.info("==function[checkBandIsLink]--receiveContext=" + receiveContext);
            receiveContext = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\r", "");
            receiveContext = TextUtil.replaceStr(receiveContext, " ", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "\"", "");
            receiveContext = TextUtil.replaceStr(receiveContext, "ok", "");
            if (TextUtil.checkContainStr(receiveContext, "ERROR")) {
                PublicConfig.isDSFLOWRPT = "0";
                log.info("failure: " + receiveContext);
            } else {
                String restr = TextUtil.rRight(receiveContext, "+CGACT:");
                if ((restr = restr.substring(0, 3)).equalsIgnoreCase("1,0")) {
                    PublicConfig.isDSFLOWRPT = "0";
                }
                if (restr.equalsIgnoreCase("1,1")) {
                    PublicConfig.isDSFLOWRPT = "1";
                }
            }
        }
        catch (Exception e) {
            log.info("srvDisablePin error: " + e.toString());
        }
    }
}

