/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.service;

import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.NewDiagnosticsDialog;
import com.huawei.mobilePartner.spn.SendAtImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosisService {
    private LanguageBean lb = CustomizeInit.getLanguageBean();
    public LogATConfig log = Log.getATLog(DiagnosisService.class);
    private static DiagnosisService diagnosisService;
    private Map<String, String> map = new HashMap<String, String>();
    CommServer server = null;
    OutgoingMessage outMsg = new OutgoingMessage();
    IncomingMessage inMsg = null;
    private String receiveContext;
    private String ATStr;
    private String ATStr1;
    private HashMap filtermap = new HashMap();
    private String[] arr = null;
    private String[] arr0 = new String[]{"+CME ERROR: 11", "sim pin required", "puk", "+CME ERROR: 12", "COMMAND NOT SUPPORT", "error", "SIM failure", "+cme error: 13"};
    private String receStr = this.lb.getUnknown();

    public static DiagnosisService getInstance() {
        if (diagnosisService == null) {
            diagnosisService = new DiagnosisService();
        }
        return diagnosisService;
    }

    private DiagnosisService() {
    }

    public synchronized void updateDiagnosis(Map diagnosisInfoManageMap, String unknownStr) {
        try {
            if (diagnosisInfoManageMap != null) {
                NewDiagnosticsDialog.deviceName.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("DEVTYPE")));
                NewDiagnosticsDialog.deviceName.updateUI();
                NewDiagnosticsDialog.port.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("port")));
                NewDiagnosticsDialog.port.updateUI();
                NewDiagnosticsDialog.serialNunber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("SN")));
                NewDiagnosticsDialog.serialNunber.updateUI();
                NewDiagnosticsDialog.imeiNumber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("IMEI")));
                NewDiagnosticsDialog.imeiNumber.updateUI();
                NewDiagnosticsDialog.hardwareVersion.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("hardwareVer")));
                NewDiagnosticsDialog.hardwareVersion.updateUI();
                NewDiagnosticsDialog.firmwareVersion.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("firmwareVer")));
                NewDiagnosticsDialog.firmwareVersion.updateUI();
                NewDiagnosticsDialog.imsiNumber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("IMSI")));
                NewDiagnosticsDialog.imsiNumber.updateUI();
                NewDiagnosticsDialog.ownNumber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("msisdn")));
                NewDiagnosticsDialog.ownNumber.updateUI();
                NewDiagnosticsDialog.messagesInSIM.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("simInfoCount")));
                NewDiagnosticsDialog.messagesInSIM.updateUI();
                NewDiagnosticsDialog.contactsInSIM.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("simManCount")));
                NewDiagnosticsDialog.contactsInSIM.updateUI();
                NewDiagnosticsDialog.smsc.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("smsc")));
                NewDiagnosticsDialog.smsc.updateUI();
                NewDiagnosticsDialog.pinCodeStatus.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("pinCode")));
                NewDiagnosticsDialog.pinCodeStatus.updateUI();
                NewDiagnosticsDialog.iccid.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("iccid")));
                NewDiagnosticsDialog.iccid.updateUI();
                NewDiagnosticsDialog.networkName.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("networkName")));
                NewDiagnosticsDialog.networkName.updateUI();
                NewDiagnosticsDialog.networkType.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("networkType")));
                NewDiagnosticsDialog.networkType.updateUI();
                NewDiagnosticsDialog.signalStrength.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("singal")));
                NewDiagnosticsDialog.signalStrength.updateUI();
                NewDiagnosticsDialog.rssi.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("rssi")));
                NewDiagnosticsDialog.rssi.updateUI();
                NewDiagnosticsDialog.rxqual.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("rxqual")));
                NewDiagnosticsDialog.rxqual.updateUI();
                NewDiagnosticsDialog.rscp.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("rscp")));
                NewDiagnosticsDialog.rscp.updateUI();
                NewDiagnosticsDialog.ecio.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ecio")));
                NewDiagnosticsDialog.ecio.updateUI();
                NewDiagnosticsDialog.ecno.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ecno")));
                NewDiagnosticsDialog.ecno.updateUI();
                NewDiagnosticsDialog.cellID.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("cellId")));
                NewDiagnosticsDialog.cellID.updateUI();
                NewDiagnosticsDialog.lacCode.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("lacCode")));
                NewDiagnosticsDialog.lacCode.updateUI();
                NewDiagnosticsDialog.csNetworkRegistration.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("cs")));
                NewDiagnosticsDialog.csNetworkRegistration.updateUI();
                NewDiagnosticsDialog.psNetworkRegistration.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("pSNetworkRegistration")));
                NewDiagnosticsDialog.psNetworkRegistration.updateUI();
                NewDiagnosticsDialog.psNetworkAttachment.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("psNetworkAttachment")));
                NewDiagnosticsDialog.psNetworkAttachment.updateUI();
                NewDiagnosticsDialog.ipAddress.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ip")));
                NewDiagnosticsDialog.ipAddress.updateUI();
                NewDiagnosticsDialog.dnsServer.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("dns")));
                NewDiagnosticsDialog.dnsServer.updateUI();
                NewDiagnosticsDialog.apn.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("apn")));
                NewDiagnosticsDialog.apn.updateUI();
                NewDiagnosticsDialog.networkselectionmode.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("network selection mode")));
                NewDiagnosticsDialog.networkselectionmode.updateUI();
            } else if (unknownStr != null || !"".equals(unknownStr)) {
                NewDiagnosticsDialog.deviceName.setText("   " + unknownStr);
                NewDiagnosticsDialog.deviceName.updateUI();
                NewDiagnosticsDialog.port.setText("   " + unknownStr);
                NewDiagnosticsDialog.port.updateUI();
                NewDiagnosticsDialog.serialNunber.setText("   " + unknownStr);
                NewDiagnosticsDialog.serialNunber.updateUI();
                NewDiagnosticsDialog.imeiNumber.setText("   " + unknownStr);
                NewDiagnosticsDialog.imeiNumber.updateUI();
                NewDiagnosticsDialog.hardwareVersion.setText("   " + unknownStr);
                NewDiagnosticsDialog.hardwareVersion.updateUI();
                NewDiagnosticsDialog.firmwareVersion.setText("   " + unknownStr);
                NewDiagnosticsDialog.firmwareVersion.updateUI();
                NewDiagnosticsDialog.imsiNumber.setText("   " + unknownStr);
                NewDiagnosticsDialog.imsiNumber.updateUI();
                NewDiagnosticsDialog.ownNumber.setText("   " + unknownStr);
                NewDiagnosticsDialog.ownNumber.updateUI();
                NewDiagnosticsDialog.messagesInSIM.setText("   " + unknownStr);
                NewDiagnosticsDialog.messagesInSIM.updateUI();
                NewDiagnosticsDialog.contactsInSIM.setText("   " + unknownStr);
                NewDiagnosticsDialog.contactsInSIM.updateUI();
                NewDiagnosticsDialog.smsc.setText("   " + unknownStr);
                NewDiagnosticsDialog.smsc.updateUI();
                NewDiagnosticsDialog.pinCodeStatus.setText("   " + unknownStr);
                NewDiagnosticsDialog.pinCodeStatus.updateUI();
                NewDiagnosticsDialog.iccid.setText("   " + unknownStr);
                NewDiagnosticsDialog.iccid.updateUI();
                NewDiagnosticsDialog.networkName.setText("   " + unknownStr);
                NewDiagnosticsDialog.networkName.updateUI();
                NewDiagnosticsDialog.networkType.setText("   " + unknownStr);
                NewDiagnosticsDialog.networkType.updateUI();
                NewDiagnosticsDialog.signalStrength.setText("    " + unknownStr);
                NewDiagnosticsDialog.signalStrength.updateUI();
                NewDiagnosticsDialog.rssi.setText("   " + unknownStr);
                NewDiagnosticsDialog.rssi.updateUI();
                NewDiagnosticsDialog.rxqual.setText("   " + unknownStr);
                NewDiagnosticsDialog.rxqual.updateUI();
                NewDiagnosticsDialog.rscp.setText("   " + unknownStr);
                NewDiagnosticsDialog.rscp.updateUI();
                NewDiagnosticsDialog.ecio.setText("   " + unknownStr);
                NewDiagnosticsDialog.ecio.updateUI();
                NewDiagnosticsDialog.ecno.setText("   " + unknownStr);
                NewDiagnosticsDialog.ecno.updateUI();
                NewDiagnosticsDialog.cellID.setText("   " + unknownStr);
                NewDiagnosticsDialog.cellID.updateUI();
                NewDiagnosticsDialog.lacCode.setText("   " + unknownStr);
                NewDiagnosticsDialog.lacCode.updateUI();
                NewDiagnosticsDialog.csNetworkRegistration.setText("   " + unknownStr);
                NewDiagnosticsDialog.csNetworkRegistration.updateUI();
                NewDiagnosticsDialog.psNetworkRegistration.setText("   " + unknownStr);
                NewDiagnosticsDialog.psNetworkRegistration.updateUI();
                NewDiagnosticsDialog.psNetworkAttachment.setText("   " + unknownStr);
                NewDiagnosticsDialog.psNetworkAttachment.updateUI();
                NewDiagnosticsDialog.ipAddress.setText("   " + unknownStr);
                NewDiagnosticsDialog.ipAddress.updateUI();
                NewDiagnosticsDialog.dnsServer.setText("   " + unknownStr);
                NewDiagnosticsDialog.dnsServer.updateUI();
                NewDiagnosticsDialog.apn.setText("   " + unknownStr);
                NewDiagnosticsDialog.apn.updateUI();
                NewDiagnosticsDialog.networkselectionmode.setText("   " + unknownStr);
                NewDiagnosticsDialog.networkselectionmode.updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Map<String, String> diagnosisPutMap(Map<String, String> map1, String unknownStr) {
        try {
            if (map1 != null) {
                this.map.put("API", "V100");
                this.map.put("DEVTYPE", this.getDeviceName());
                this.map.put("port", this.getPort());
                this.map.put("SN", this.getSN());
                this.map.put("IMEI", this.getIMEI());
                this.map.put("hardwareVer", this.getHardwareVersion());
                this.map.put("firmwareVer", this.getFirmwareVersion());
                this.map.put("IMSI", this.getImsiNumber());
                this.map.put("msisdn", this.getOwnNumber());
                this.map.put("simInfoCount", this.getMessagesInSIM());
                this.map.put("simManCount", this.getContactsInSIM());
                this.map.put("smsc", this.getSmsc());
                this.map.put("pinCode", this.getPinCodeStatus());
                this.map.put("iccid", this.getIccid());
                this.map.put("networkName", this.getNetworkName());
                this.map.put("networkType", this.getNetworkType());
                this.map.put("singal", this.getSignalStrength()[2]);
                this.map.put("rssi", this.getSignalStrength()[1]);
                this.map.put("rxqual", this.getSignalStrength()[0]);
                this.map.put("rscp", this.getRscp()[0]);
                this.map.put("ecio", this.getRscp()[1]);
                this.map.put("ecno", this.getRscp()[2]);
                this.map.put("cellId", this.getCsNetworkRegistration()[2]);
                this.map.put("lacCode", this.getCsNetworkRegistration()[1]);
                this.map.put("cs", this.getCsNetworkRegistration()[0]);
                this.map.put("pSNetworkRegistration", this.getPsNetworkRegistration());
                this.map.put("psNetworkAttachment", this.getPsNetworkAttachment());
                this.map.put("ip", this.getIpAddress());
                this.map.put("dns", this.getDnsServer());
                this.map.put("apn", this.getAPN());
                this.map.put("network selection mode", this.getNetworkselectionmode());
            } else if (map1 == null || unknownStr != null || !"".equals(unknownStr)) {
                this.map.put("API", "V100");
                this.map.put("DEVTYPE", unknownStr);
                this.map.put("port", unknownStr);
                this.map.put("SN", unknownStr);
                this.map.put("IMEI", unknownStr);
                this.map.put("hardwareVer", unknownStr);
                this.map.put("firmwareVer", unknownStr);
                this.map.put("IMSI", unknownStr);
                this.map.put("msisdn", unknownStr);
                this.map.put("simInfoCount", unknownStr);
                this.map.put("simManCount", unknownStr);
                this.map.put("smsc", unknownStr);
                this.map.put("pinCode", unknownStr);
                this.map.put("iccid", unknownStr);
                this.map.put("networkName", unknownStr);
                this.map.put("networkType", unknownStr);
                this.map.put("singal", unknownStr);
                this.map.put("rssi", unknownStr);
                this.map.put("rxqual", unknownStr);
                this.map.put("rscp", unknownStr);
                this.map.put("ecio", unknownStr);
                this.map.put("ecno", unknownStr);
                this.map.put("cellId", unknownStr);
                this.map.put("lacCode", unknownStr);
                this.map.put("cs", unknownStr);
                this.map.put("pSNetworkRegistration", unknownStr);
                this.map.put("psNetworkAttachment", unknownStr);
                this.map.put("ip", unknownStr);
                this.map.put("dns", unknownStr);
                this.map.put("apn", this.getAPN());
                this.map.put("network selection mode", unknownStr);
            }
            return this.map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    public synchronized Map<String, String> diagnosisPutMapDevice(Map<String, String> map1, String unknownStr) {
        try {
            if (map1 != null) {
                this.map.put("API", "V100");
                this.map.put("DEVTYPE", this.getDeviceName());
                NewDiagnosticsDialog.deviceName.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("DEVTYPE")));
                NewDiagnosticsDialog.deviceName.updateUI();
                this.map.put("port", this.getPort());
                NewDiagnosticsDialog.port.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("port")));
                NewDiagnosticsDialog.port.updateUI();
                this.map.put("SN", this.getSN());
                NewDiagnosticsDialog.serialNunber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("SN")));
                NewDiagnosticsDialog.serialNunber.updateUI();
                this.map.put("IMEI", this.getIMEI());
                NewDiagnosticsDialog.imeiNumber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("IMEI")));
                NewDiagnosticsDialog.imeiNumber.updateUI();
                this.map.put("hardwareVer", this.getHardwareVersion());
                NewDiagnosticsDialog.hardwareVersion.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("hardwareVer")));
                NewDiagnosticsDialog.hardwareVersion.updateUI();
                this.map.put("firmwareVer", this.getFirmwareVersion());
                NewDiagnosticsDialog.firmwareVersion.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("firmwareVer")));
                NewDiagnosticsDialog.firmwareVersion.updateUI();
            } else if (map1 == null || unknownStr != null || !"".equals(unknownStr)) {
                this.map.put("API", "V100");
                this.map.put("DEVTYPE", unknownStr);
                this.map.put("port", unknownStr);
                this.map.put("SN", unknownStr);
                this.map.put("IMEI", unknownStr);
                this.map.put("hardwareVer", unknownStr);
                this.map.put("firmwareVer", unknownStr);
            }
            return this.map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    public synchronized Map<String, String> diagnosisPutMapSim(Map<String, String> map1, String unknownStr) {
        try {
            if (map1 != null) {
                this.map.put("API", "V100");
                this.map.put("IMSI", this.getImsiNumber());
                NewDiagnosticsDialog.imsiNumber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("IMSI")));
                NewDiagnosticsDialog.imsiNumber.updateUI();
                this.map.put("msisdn", this.getOwnNumber());
                NewDiagnosticsDialog.ownNumber.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("msisdn")));
                NewDiagnosticsDialog.ownNumber.updateUI();
                this.map.put("simInfoCount", this.getMessagesInSIM());
                NewDiagnosticsDialog.messagesInSIM.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("simInfoCount")));
                NewDiagnosticsDialog.messagesInSIM.updateUI();
                this.map.put("simManCount", this.getContactsInSIM());
                NewDiagnosticsDialog.contactsInSIM.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("simManCount")));
                NewDiagnosticsDialog.contactsInSIM.updateUI();
                this.map.put("smsc", this.getSmsc());
                NewDiagnosticsDialog.smsc.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("smsc")));
                NewDiagnosticsDialog.smsc.updateUI();
                this.map.put("pinCode", this.getPinCodeStatus());
                NewDiagnosticsDialog.pinCodeStatus.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("pinCode")));
                NewDiagnosticsDialog.pinCodeStatus.updateUI();
                this.map.put("iccid", this.getIccid());
                NewDiagnosticsDialog.iccid.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("iccid")));
                NewDiagnosticsDialog.iccid.updateUI();
            } else if (map1 == null || unknownStr != null || !"".equals(unknownStr)) {
                this.map.put("API", "V100");
                this.map.put("IMSI", unknownStr);
                this.map.put("msisdn", unknownStr);
                this.map.put("simInfoCount", unknownStr);
                this.map.put("simManCount", unknownStr);
                this.map.put("smsc", unknownStr);
                this.map.put("pinCode", unknownStr);
                this.map.put("iccid", unknownStr);
                this.map.put("apn", this.getAPN());
                this.map.put("network selection mode", unknownStr);
            }
            return this.map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    public synchronized Map<String, String> diagnosisPutMapNetStatus(Map<String, String> map1, String unknownStr) {
        try {
            if (map1 != null) {
                String[] tempSignal = this.getSignalStrength();
                String[] tempRscp = this.getRscp();
                String[] tempCs = this.getCsNetworkRegistration();
                this.map.put("API", "V100");
                this.map.put("networkName", this.getNetworkName());
                NewDiagnosticsDialog.networkName.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("networkName")));
                NewDiagnosticsDialog.networkName.updateUI();
                this.map.put("networkType", this.getNetworkType());
                NewDiagnosticsDialog.networkType.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("networkType")));
                NewDiagnosticsDialog.networkType.updateUI();
                this.map.put("singal", tempSignal[2]);
                NewDiagnosticsDialog.signalStrength.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("singal")));
                NewDiagnosticsDialog.signalStrength.updateUI();
                this.map.put("rssi", tempSignal[1]);
                NewDiagnosticsDialog.rssi.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("rssi")));
                NewDiagnosticsDialog.rssi.updateUI();
                this.map.put("rxqual", tempSignal[0]);
                NewDiagnosticsDialog.rxqual.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("rxqual")));
                NewDiagnosticsDialog.rxqual.updateUI();
                this.map.put("rscp", tempRscp[0]);
                NewDiagnosticsDialog.rscp.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("rscp")));
                NewDiagnosticsDialog.rscp.updateUI();
                this.map.put("ecio", tempRscp[1]);
                NewDiagnosticsDialog.ecio.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ecio")));
                NewDiagnosticsDialog.ecio.updateUI();
                this.map.put("ecno", tempRscp[2]);
                NewDiagnosticsDialog.ecno.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ecno")));
                NewDiagnosticsDialog.ecno.updateUI();
                this.map.put("cellId", tempCs[2]);
                NewDiagnosticsDialog.cellID.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("cellId")));
                NewDiagnosticsDialog.cellID.updateUI();
                this.map.put("lacCode", tempCs[1]);
                NewDiagnosticsDialog.lacCode.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("lacCode")));
                NewDiagnosticsDialog.lacCode.updateUI();
                this.map.put("cs", tempCs[0]);
                NewDiagnosticsDialog.csNetworkRegistration.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("cs")));
                NewDiagnosticsDialog.csNetworkRegistration.updateUI();
                this.map.put("pSNetworkRegistration", this.getPsNetworkRegistration());
                NewDiagnosticsDialog.psNetworkRegistration.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("pSNetworkRegistration")));
                NewDiagnosticsDialog.psNetworkRegistration.updateUI();
                this.map.put("psNetworkAttachment", this.getPsNetworkAttachment());
                NewDiagnosticsDialog.psNetworkAttachment.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("psNetworkAttachment")));
                NewDiagnosticsDialog.psNetworkAttachment.updateUI();
                this.map.put("ip", this.getIpAddress());
                NewDiagnosticsDialog.ipAddress.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("ip")));
                NewDiagnosticsDialog.ipAddress.updateUI();
                this.map.put("dns", this.getDnsServer());
                NewDiagnosticsDialog.dnsServer.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("dns")));
                NewDiagnosticsDialog.dnsServer.updateUI();
            } else if (map1 == null || unknownStr != null || !"".equals(unknownStr)) {
                this.map.put("API", "V100");
                this.map.put("networkName", unknownStr);
                this.map.put("networkType", unknownStr);
                this.map.put("singal", unknownStr);
                this.map.put("rssi", unknownStr);
                this.map.put("rxqual", unknownStr);
                this.map.put("rscp", unknownStr);
                this.map.put("ecio", unknownStr);
                this.map.put("ecno", unknownStr);
                this.map.put("cellId", unknownStr);
                this.map.put("lacCode", unknownStr);
                this.map.put("cs", unknownStr);
                this.map.put("pSNetworkRegistration", unknownStr);
                this.map.put("psNetworkAttachment", unknownStr);
                this.map.put("ip", unknownStr);
                this.map.put("dns", unknownStr);
            }
            return this.map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    public synchronized Map<String, String> diagnosisPutMapNetSettings(Map<String, String> map1, String unknownStr) {
        try {
            if (map1 != null) {
                this.map.put("API", "V100");
                this.map.put("apn", this.getAPN());
                NewDiagnosticsDialog.apn.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("apn")));
                NewDiagnosticsDialog.apn.updateUI();
                this.map.put("network selection mode", this.getNetworkselectionmode());
                NewDiagnosticsDialog.networkselectionmode.setText("   " + Tools.changeNullToUnknown(AppFrame.diagnosisInfoManageMap.get("network selection mode")));
                NewDiagnosticsDialog.networkselectionmode.updateUI();
            } else if (map1 == null || unknownStr != null || !"".equals(unknownStr)) {
                this.map.put("API", "V100");
                this.map.put("apn", this.getAPN());
                this.map.put("network selection mode", unknownStr);
            }
            return this.map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    public synchronized String getReceiveAT(String at) {
        this.receiveContext = null;
        try {
            this.server = MutiDeviceService.getCurrentServer();
            this.ATStr = String.valueOf(at) + "\r" + (char)Integer.parseInt("1a", 16) + "z";
            this.ATStr1 = at;
            this.outMsg.setContent(this.ATStr);
            this.inMsg = this.server.send(this.outMsg, 30);
            this.receiveContext = this.inMsg.getContent();
        }
        catch (Exception e) {
            this.log.error("------" + at + "----has Exception----- return ---ERROR---");
            return this.lb.getUnknown();
        }
        if (this.receiveContext.indexOf("ERROR") > -1 || this.receiveContext.indexOf("COMMAND NOT SUPPORT") > -1) {
            this.log.error("------" + at + "-------ERROR or COMMAND NOT SUPPORT---");
            return this.lb.getUnknown();
        }
        return this.receiveContext;
    }

    public String getDeviceName() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CGMM");
        this.receiveContext = TextUtil.rLeft1(this.receiveContext, "OK");
        String[] s13 = new String[]{"\n", "\r", "AT+CGMM", "+CGMM:", "OK", "\""};
        String[] s14 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s13, s14);
        String[] AtStr7 = new String[]{"sim pin required", "sim pin required", "AT+CGMM: sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CGMM:COMMAND NOT SUPPORT", "AT+CGMM:at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
        this.filtermap = this.getFilterStr(AtStr7, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            PublicConfig.deviceType = this.receiveContext.toUpperCase();
            return this.receiveContext.toUpperCase();
        }
        return (String)this.filtermap.get("receiveContext");
    }

    public String getPort() throws Exception {
        if (MutiDeviceService.curServer != null) {
            String os = System.getProperty("os.name").toLowerCase();
            this.receiveContext = MutiDeviceService.curServer.portIDStr;
            if (this.receiveContext.indexOf("/dev/") > -1) {
                this.receiveContext = this.receiveContext.substring(this.receiveContext.indexOf("/dev/") + 5, this.receiveContext.length());
            }
            if (os.indexOf("mac") > -1 && this.receiveContext.indexOf("tty.") > -1) {
                this.receiveContext = this.receiveContext.substring(this.receiveContext.indexOf("tty.") + 4, this.receiveContext.length());
            }
            return this.receiveContext;
        }
        return this.lb.getUnknown();
    }

    public String getSN() throws Exception {
        this.receiveContext = this.getReceiveAT("AT^SN");
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "^SN:");
        String[] s11 = new String[]{"\n", "\r", "AT^SN", "^SN:", "OK", "\""};
        String[] s12 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s11, s12);
        String[] AtStr6 = new String[]{"sim pin required", "sim pin required", "AT^SN: sim puk required", "AT^SN: sim puk required", "AT^SN:COMMAND NOT SUPPORT", "AT^SN:at return error", "AT^SN:SIM failure", "AT^SN:SIM failure"};
        this.filtermap = this.getFilterStr(AtStr6, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            return this.receiveContext;
        }
        return (String)this.filtermap.get("receiveContext");
    }

    public String getIMEI() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CGSN");
        this.receiveContext = TextUtil.rLeft1(this.receiveContext, "OK");
        String[] s5 = new String[]{"\n", "\r", "AT+CGSN", "+CGSN:", "OK"};
        String[] s6 = new String[]{"", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s5, s6);
        String[] AtStr3 = new String[]{"sim pin required", "sim pin required", "AT+CGSN: sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CGSN:COMMAND NOT SUPPORT", "AT+CGSN: at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
        this.filtermap = this.getFilterStr(AtStr3, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            return this.receiveContext;
        }
        return (String)this.filtermap.get("receiveContext");
    }

    public String getHardwareVersion() throws Exception {
        this.receiveContext = this.getReceiveAT("AT^HWVER");
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "^HWVER:");
        String[] s9 = new String[]{"\n", "\r", "AT^HWVER", "^HWVER:", "OK", "\""};
        String[] s10 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s9, s10);
        String[] AtStr5 = new String[]{"sim pin required", "sim pin required", "AT^HWVER: sim puk required", "AT^HWVER: sim puk required", "AT^HWVER:COMMAND NOT SUPPORT", "AT^HWVER at return error", "AT^HWVER: SIM failure", "AT^HWVER:SIM failure"};
        this.filtermap = this.getFilterStr(AtStr5, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            return this.receiveContext.toUpperCase();
        }
        return (String)this.filtermap.get("receiveContext");
    }

    public String getFirmwareVersion() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CGMR");
        this.receiveContext = TextUtil.rLeft1(this.receiveContext, "OK");
        String[] s7 = new String[]{"\n", "\r", "AT+CGMR", "+CGMR:", "OK", "\""};
        String[] s8 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s7, s8);
        String[] AtStr4 = new String[]{"sim pin required", "sim pin required", "AT+CGMR: sim puk required", "AT+CGMR: sim puk required", "AT+CGMR:COMMAND NOT SUPPORT", "AT+CGMR: at return error", "AT+CGMR:SIM failure", "AT+CGMR:SIM failure"};
        this.filtermap = this.getFilterStr(AtStr4, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, s7, s8);
            return this.receiveContext;
        }
        this.receiveContext = Tools.checkNull(this.filtermap.get("receiveContext"));
        return this.receiveContext;
    }

    public String getImsiNumber() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CIMI");
        this.receiveContext = TextUtil.rLeft1(this.receiveContext, "OK");
        String[] s15 = new String[]{"\n", "\r", "AT+CIMI", "+CIMI:", "OK", "\""};
        String[] s16 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s15, s16);
        String[] AtStr8 = new String[]{"sim pin required", "sim pin required", "AT+CIMI: sim puk required", "AT+CIMI: sim puk required", "AT+CIMI:COMMAND NOT SUPPORT", "AT+CIMI:at return error", "AT+CIMI: SIM failure", "AT+CIMI:SIM failure"};
        this.filtermap = this.getFilterStr(AtStr8, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            ConfigInterface.imsiString = this.receiveContext;
            return this.receiveContext;
        }
        return (String)this.filtermap.get("receiveContext");
    }

    public String getOwnNumber() throws Exception {
        String[] arrstr = null;
        ArrayList<String> alist = null;
        String bolSend = "";
        this.receiveContext = this.getReceiveAT("AT+CNUM");
        this.log.error("------AT+CNUM----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return this.lb.getUnknown();
        }
        arrstr = this.receiveContext.split("CNUM:");
        alist = new ArrayList<String>();
        String telhome = null;
        if (arrstr != null && arrstr.length > 0) {
            int i = 1;
            while (i < arrstr.length) {
                telhome = Tools.checkNull(arrstr[i].split(",")[1]);
                alist.add(telhome);
                ++i;
            }
        }
        if (alist != null && alist.size() > 0) {
            int j = 0;
            while (j < alist.size()) {
                telhome = Tools.checkNull(alist.get(j));
                if (!Tools.isEmpty(telhome)) {
                    bolSend = telhome = TextUtil.replaceStr(telhome, "\"", "");
                    return telhome;
                }
                ++j;
            }
        } else {
            return this.lb.getUnknown();
        }
        return bolSend;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMessagesInSIM() throws Exception {
        try {
            this.receiveContext = this.getReceiveAT("AT+CPMS=\"SM\"");
            this.log.error("------AT+CPMS=\"SM\"----- return ------" + this.receiveContext);
            if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
                return this.lb.getUnknown();
            }
            this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+CPMS:");
            String[] s1 = new String[]{"\n", "\r", "AT+CPMS=\"SM\"", "+CPMS:", "OK"};
            String[] s2 = new String[]{"", "", "", "", ""};
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, s1, s2);
            String[] AtStr1 = new String[]{"sim pin required", "sim pin required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS=\"SM\": sim puk required", "AT+CPMS:COMMAND NOT SUPPORT", "AT+CPMS=\"SM\":at return error", "AT+CPMS=\"SM\":SIM failure", "AT+CPMS=\"SM\":SIM failure"};
            this.filtermap = this.getFilterStr(AtStr1, this.receiveContext, this.arr0, this.lb);
            if (!this.filtermap.isEmpty()) return (String)this.filtermap.get("receiveContext");
            this.arr = TextUtil.split(this.receiveContext, ",");
            if (Tools.isDigit(this.arr[0]) && Tools.isDigit(this.arr[1])) {
                if (this.arr[1].equals("0")) {
                    PublicConfig.IS_SHOW_SIM_CDMA = "0";
                } else if (this.arr[1].matches("^[0-9]*[0-9][0-9]*$")) {
                    PublicConfig.IS_SHOW_SIM_CDMA = "1";
                    return this.arr[0] + "/" + this.arr[1];
                }
            } else {
                PublicConfig.smsNumber = "";
                return this.receStr;
            }
            PublicConfig.smsNumber = this.arr[0];
            return this.receiveContext;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.receiveContext;
    }

    public String getContactsInSIM() throws Exception {
        this.receiveContext = null;
        String refresh = "true";
        this.ATStr = "AT+CPBS?\r" + (char)Integer.parseInt("1a", 16) + "z";
        this.ATStr1 = "AT+CPBS?";
        this.outMsg.setContent(this.ATStr);
        this.inMsg = this.server.send(this.outMsg, 30);
        if (this.inMsg == null) {
            this.log.fatal(" function[queryNetDiagnosisInfoByCDMA]  failure:  AT delay " + this.ATStr1 + " Object return is null");
            return this.receStr;
        }
        this.receiveContext = this.inMsg.getContent();
        String[] s3 = new String[]{"\n", "\r", "AT+CPBS?", "+CPBS:", "OK"};
        String[] s4 = new String[]{"", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s3, s4);
        String[] sore = new String[]{"+CME ERROR: SIM busy", "+CMS ERROR: 500", "+CME ERROR: 12", "SIM PUK required"};
        if (TextUtil.checkContainStr(this.receiveContext, sore)) {
            PublicConfig.doctureRefresh = "true";
        }
        String[] AtStr2 = new String[]{"sim pin required", "sim pin required", "AT+CPBS?: sim puk required", "AT+CPBS?: sim puk required", "AT+CPBS?:COMMAND NOT SUPPORT", "AT+CPBS?:at return error", "AT+CPBS?:SIM failure", "AT+CPBS?:SIM failure"};
        this.filtermap = this.getFilterStr(AtStr2, this.receiveContext, this.arr0, this.lb);
        if (this.filtermap.isEmpty()) {
            this.arr = TextUtil.split(this.receiveContext, ",");
            PublicConfig.userAccessSize = Tools.checkNull(this.arr[1]);
            PublicConfig.accessMaxSize = Tools.checkNull(this.arr[2]);
            return this.arr[1] + "/" + this.arr[2];
        }
        return (String)this.filtermap.get("receiveContext");
    }

    public String getSmsc() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CSCA?");
        this.log.error("------AT+CSCA?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return this.lb.getUnknown();
        }
        try {
            String[] strRows = TextUtil.split(this.receiveContext, System.getProperty("line.separator"));
            int iRow = 0;
            while (iRow < strRows.length) {
                if (strRows[iRow].indexOf("+CSCA:") > -1) {
                    this.receiveContext = strRows[iRow];
                    break;
                }
                ++iRow;
            }
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, "\n", "");
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, "\r", "");
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, "AT+CSCA?", "");
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, "+CSCA:", "");
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, "\"", "");
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, " ", "");
            String[] arr = this.receiveContext.split(",");
            this.receiveContext = Tools.checkNull(arr[0]);
            this.log.error("------getSmsc----- return ------" + this.receiveContext);
            return this.receiveContext;
        }
        catch (Exception e) {
            return this.lb.getUnknown();
        }
    }

    public String getPinCodeStatus() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CPIN?");
        this.log.error("------AT+CPIN?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return this.lb.getUnknown();
        }
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+CPIN:");
        String[] s17 = new String[]{"\n", "\r", "AT+CPIN?", "+CPIN:", "OK", "\""};
        String[] s18 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s17, s18);
        if (this.receiveContext.indexOf("sim pin") > -1) {
            return this.lb.getIDS_LANG_PIN_REQUIRED();
        }
        if (this.receiveContext.indexOf("sim puk") > -1) {
            return this.lb.getIDS_LANG_PUK_REQUIRED();
        }
        if (this.receiveContext.indexOf("ready") > -1) {
            return this.lb.getIDS_LANG_READY();
        }
        return this.lb.getUnknown();
    }

    public String getIccid() throws Exception {
        try {
            SendAtImpl sendAt = new SendAtImpl();
            String iccidComm = "AT+CRSM=176,12258,0,0,10\r";
            String resultIccid = sendAt.atReturnResult(iccidComm);
            if (resultIccid.indexOf("ERROR") > -1) {
                return this.lb.getUnknown();
            }
            String returnIccid = resultIccid.substring(resultIccid.indexOf("\"") + 1, resultIccid.lastIndexOf("\""));
            String changeIccid = this.getPhone(returnIccid);
            this.log.error("------getIccid----- return ------" + changeIccid);
            return changeIccid;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getPhone(String iccid) {
        ArrayList<Object> iccidList = new ArrayList<Object>();
        StringBuffer strBuff = new StringBuffer();
        try {
            int index = 0;
            while (index < iccid.length()) {
                iccidList.add(Character.valueOf(iccid.charAt(index)));
                ++index;
            }
            index = 1;
            while (index < iccidList.size()) {
                String temp = iccidList.get(index).toString();
                iccidList.remove(index);
                iccidList.add(index - 1, temp);
                index += 2;
            }
            index = 0;
            while (index < iccidList.size()) {
                strBuff.append(iccidList.get(index).toString());
                ++index;
            }
            return strBuff.toString();
        }
        catch (Exception ex) {
            return iccid;
        }
    }

    public String getNetworkName() throws Exception {
        try {
            if (AppFrame.getAppFrameInit().leftStatusLabel3 != null) {
                String leftStatusLabel3 = AppFrame.getAppFrameInit().leftStatusLabel3.getText().trim();
                String leftStatus = "";
                leftStatus = leftStatusLabel3.indexOf("(") > -1 ? leftStatusLabel3.substring(0, leftStatusLabel3.indexOf("(")) : leftStatusLabel3;
                if (leftStatus.equals("")) {
                    return this.lb.getUnknown();
                }
                return leftStatus;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lb.getUnknown();
    }

    public String getNetworkType() throws Exception {
        try {
            if (AppFrame.getAppFrameInit().leftStatusLabel2 != null) {
                String leftStatusLabel2 = AppFrame.getAppFrameInit().leftStatusLabel2.getText().trim();
                if (leftStatusLabel2.equals("")) {
                    return this.lb.getUnknown();
                }
                return leftStatusLabel2;
            }
            return this.lb.getUnknown();
        }
        catch (Exception exception) {
            return this.lb.getUnknown();
        }
    }

    public String[] getSignalStrength() throws Exception {
        String rxqual;
        String[] csq = new String[3];
        this.receiveContext = this.getReceiveAT("AT+CSQ");
        this.log.error("------AT+CSQ----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return new String[]{this.lb.getUnknown(), this.lb.getUnknown(), this.lb.getUnknown()};
        }
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+CSQ:");
        String[] s15 = new String[]{"\n", "\r", "AT+CSQ", "+CSQ:", "OK", "\""};
        String[] s16 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s15, s16);
        csq[0] = rxqual = this.receiveContext.substring(this.receiveContext.indexOf(",") + 1, this.receiveContext.length());
        String strRSSI = "";
        try {
            strRSSI = this.receiveContext.substring(0, this.receiveContext.indexOf(","));
            int intRSSI = Integer.parseInt(strRSSI);
            if (intRSSI == 0) {
                strRSSI = "-113 dBm";
            } else if (intRSSI == 1) {
                strRSSI = "-111 dBm";
            } else if (intRSSI <= 30 && intRSSI >= 2) {
                intRSSI = 2 * (intRSSI - 2) - 109;
                strRSSI = intRSSI + "dBm";
            } else if (intRSSI == 31) {
                strRSSI = "-51 dBm";
            } else if (intRSSI == 99) {
                strRSSI = this.lb.getUnknown();
                this.receiveContext = this.lb.getUnknown();
                csq[0] = this.lb.getUnknown();
            }
            csq[1] = strRSSI;
        }
        catch (Exception e) {
            csq[1] = this.lb.getUnknown();
        }
        csq[2] = this.receiveContext;
        return csq;
    }

    public String[] getRscp() throws Exception {
        String temp = "";
        String rscp = "";
        String ecio = "";
        this.receiveContext = this.getReceiveAT("AT^CSNR?");
        this.log.error("------AT^CSNR?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return new String[]{this.lb.getUnknown(), this.lb.getUnknown(), this.lb.getUnknown()};
        }
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "^CSNR:");
        String[] s5 = new String[]{"\n", "\r", "AT+CSQ", "+CSQ:", "OK", "\""};
        String[] s6 = new String[]{"", "", "", "", "", ""};
        temp = TextUtil.replaceAll(this.receiveContext, s5, s6);
        rscp = String.valueOf(temp.substring(temp.indexOf(":") + 1, temp.indexOf(","))) + "dBm";
        ecio = String.valueOf(temp.substring(temp.lastIndexOf(",") + 1, temp.length())) + "dBm";
        this.log.error("------rscp----- return ------" + rscp);
        this.log.error("------ecio----- return ------" + ecio);
        return new String[]{rscp, ecio, "not implement"};
    }

    public String[] getCsNetworkRegistration() throws Exception {
        String temp1 = "";
        String temp2 = "";
        String temp3 = "";
        String cs = "";
        String lacCode = "";
        String cellId = "";
        String okStr = this.getReceiveAT("AT+CREG=2");
        this.receiveContext = this.getReceiveAT("AT+CREG?");
        this.log.error("------AT+CREG?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return new String[]{this.lb.getUnknown(), this.lb.getUnknown(), this.lb.getUnknown()};
        }
        try {
            this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
            this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+CREG:");
            temp1 = this.receiveContext.substring(this.receiveContext.indexOf(",") + 1, this.receiveContext.indexOf(",") + 2);
            int intReceiveContext = Integer.parseInt(temp1);
            cs = intReceiveContext == 0 ? this.lb.getIDS_LANG_NOT_REGISTERED() : (intReceiveContext == 1 ? this.lb.getIDS_LANG_REGISTERED() : (intReceiveContext == 2 ? this.lb.getIDS_LANG_REGISTERING() : (intReceiveContext == 3 ? this.lb.getIDS_LANG_REG_DENIED() : (intReceiveContext == 5 ? this.lb.getIDS_LANG_ROAMING() : this.lb.getUnknown()))));
            lacCode = temp2 = this.receiveContext.substring(this.receiveContext.indexOf(",") + 3, this.receiveContext.lastIndexOf(","));
            if (lacCode == null || lacCode.equals("")) {
                lacCode = this.lb.getUnknown();
            }
            this.log.error("------lacCode----- return ------" + lacCode);
            String[] s5 = new String[]{"\n", "\r", "OK"};
            String[] s6 = new String[]{"", "", ""};
            temp3 = TextUtil.replaceAll(this.receiveContext, s5, s6);
            cellId = temp3.substring(temp3.lastIndexOf(",") + 1, temp3.length());
            this.log.error("------cellId----- return ------" + cellId);
            if (cellId == null || cellId.equals(" ")) {
                cellId = this.lb.getUnknown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[]{cs, lacCode, cellId};
    }

    public String getPsNetworkRegistration() throws Exception {
        String temp = "";
        String ps = "";
        this.receiveContext = this.getReceiveAT("AT+CGREG?");
        this.log.error("------AT+CGREG?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return this.lb.getUnknown();
        }
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+CGREG:");
        String[] s15 = new String[]{"\n", "\r", "AT+CGREG?", "+CGREG:", "OK", "\""};
        String[] s16 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s15, s16);
        temp = this.receiveContext.substring(this.receiveContext.indexOf(",") + 1, this.receiveContext.indexOf(",") + 2);
        try {
            int intReceiveContext = Integer.parseInt(temp);
            ps = intReceiveContext == 0 ? this.lb.getIDS_LANG_NOT_REGISTERED() : (intReceiveContext == 1 ? this.lb.getIDS_LANG_REGISTERED() : (intReceiveContext == 2 ? this.lb.getIDS_LANG_REGISTERING() : (intReceiveContext == 3 ? this.lb.getIDS_LANG_REG_DENIED() : (intReceiveContext == 5 ? this.lb.getIDS_LANG_ROAMING() : this.lb.getUnknown()))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ps;
    }

    public String getPsNetworkAttachment() throws Exception {
        this.receiveContext = this.getReceiveAT("AT+CGATT?");
        this.log.error("------AT+CGATT?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return this.lb.getUnknown();
        }
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+CGATT:");
        String psAtta = "";
        String[] s15 = new String[]{"\n", "\r", "AT+CGATT", "+CGATT:", "OK", "\""};
        String[] s16 = new String[]{"", "", "", "", "", ""};
        this.receiveContext = TextUtil.replaceStr(this.receiveContext, s15, s16);
        try {
            int intReceiveContext = Integer.parseInt(this.receiveContext);
            psAtta = intReceiveContext == 0 ? this.lb.getIDS_LANG_NOT_ATTACHED() : (intReceiveContext == 1 ? this.lb.getIDS_LANG_ATTACHED() : this.lb.getUnknown());
        }
        catch (Exception e) {
            psAtta = this.lb.getUnknown();
        }
        return psAtta;
    }

    public String getIpAddress() throws Exception {
        try {
            String ip = AppFrame.getInstance().apnEvent.getIp();
            if ("".equals(ip) || ip == null) {
                ip = this.lb.getUnknown();
            }
            AppFrame.diagnosisInfoManageMap.put("ip", ip);
            return ip;
        }
        catch (Exception e) {
            return this.lb.getUnknown();
        }
    }

    public String getDnsServer() throws Exception {
        try {
            String dnsPreferred = AppFrame.getInstance().apnEvent.getDnsPreferred();
            if ("".equals(dnsPreferred) || dnsPreferred == null) {
                dnsPreferred = this.lb.getUnknown();
            }
            AppFrame.diagnosisInfoManageMap.put("dns", dnsPreferred);
            return dnsPreferred;
        }
        catch (Exception e) {
            return this.lb.getUnknown();
        }
    }

    public String getAPN() throws Exception {
        if (Tools.getAPN() != null && !Tools.getAPN().equals("")) {
            return Tools.getAPN();
        }
        return this.lb.getUnknown();
    }

    public String getNetworkselectionmode() throws Exception {
        String net = "";
        this.receiveContext = this.getReceiveAT("AT+COPS?");
        this.log.error("------AT+COPS?----- return ------" + this.receiveContext);
        if (this.receiveContext == null || this.receiveContext.indexOf(this.lb.getUnknown()) > -1) {
            return this.lb.getUnknown();
        }
        this.receiveContext = TextUtil.rLeft2(this.receiveContext, "OK");
        this.receiveContext = TextUtil.getBetweenString(this.receiveContext, "+COPS:");
        try {
            String[] strRows = TextUtil.split(this.receiveContext, System.getProperty("line.separator"));
            int iRow = 0;
            while (iRow < strRows.length) {
                if (strRows[iRow].indexOf("+COPS:") > -1) {
                    this.receiveContext = strRows[iRow];
                    break;
                }
                ++iRow;
            }
            this.receiveContext = TextUtil.replaceStr(this.receiveContext, "+COPS:", "");
            String[] strDivInfo = TextUtil.split(this.receiveContext, ",");
            if (strDivInfo.length >= 1) {
                net = "0".equals(strDivInfo[0].trim()) ? this.lb.getIDS_LANG_AUTOMATIC() : ("1".equals(strDivInfo[0].trim()) ? this.lb.getIDS_LANG_MANUAL() : this.lb.getUnknown());
            }
        }
        catch (Exception e) {
            return this.lb.getUnknown();
        }
        return net;
    }

    private HashMap getFilterStr(String[] AtStr, String receiveContext, String[] arr, LanguageBean lb) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Tools.isEmpty(receiveContext)) {
            receiveContext = lb.getUnknown();
            map.put("receiveContext", receiveContext);
            return map;
        }
        int i = 0;
        while (i < arr.length) {
            if (TextUtil.checkContainStr(receiveContext, arr[i])) {
                receiveContext = lb.getUnknown();
                map.put("receiveContext", receiveContext);
                return map;
            }
            ++i;
        }
        return map;
    }
}

