/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.service;

import com.huawei.mobilePartner.business.call.common.CommonConfigCallInfo;
import com.huawei.mobilePartner.business.device.DeviceService;
import com.huawei.mobilePartner.business.telephoneBook.commserver.CommonMethodByTelBook;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.DateFormatUtil;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.data.comm.interfaces.call.CallATResponse;
import com.huawei.mobilePartner.data.comm.interfaces.call.CallInfoBean;
import com.huawei.mobilePartner.data.comm.interfaces.call.ICallInter;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import com.huawei.mobilePartner.gui.ui.call.CallUILogic;
import com.huawei.mobilePartner.gui.ui.call.ICallEvent;
import com.huawei.mobilePartner.gui.ui.calllog.CallLogContentPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CallServiceImpl
implements ICallInter {
    private static ICallInter instance = new CallServiceImpl();
    private static LogATConfig log = Log.getATLog(CallServiceImpl.class);
    private List callList = null;
    private static final String strATPostfix = "\r" + (char)Integer.parseInt("1a", 16) + "z";
    private static final String strATOK = "OK";
    private static final String strATErr = "ERROR";
    private static final String strATNotSupport = "COMMAND NOT SUPPORT";
    private ICallEvent event = CallUILogic.getInstance();
    private ArrayList list = new ArrayList();
    private CallLogContentPanel logInstance = CallLogContentPanel.getCallLogPanelInstance();
    private long callLogID = -1L;
    private String startTime = "";
    private CommonMethodByTelBook commonMethodByTelBook = new CommonMethodByTelBook();

    private CallServiceImpl() {
    }

    public static ICallInter getInstance() {
        if (instance == null) {
            instance = new CallServiceImpl();
        }
        return instance;
    }

    public boolean makeCLIP() {
        boolean bFlag = false;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = "AT+CLIP=1" + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("AT+CLIP=1 return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        bFlag = true;
                        log.info("AT+CLIP=1: return is ok...");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("makeCLIP error: " + e.toString());
        }
        return bFlag;
    }

    public boolean makeCSSN() {
        boolean bFlag = false;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = "AT+CSSN=1,1" + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("AT+CSSN=1,1 return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        bFlag = true;
                        log.info("AT+CSSN=1,1: return is ok...");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("makeCSSN error: " + e.toString());
        }
        return bFlag;
    }

    public boolean makeCCWA() {
        boolean bFlag = false;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = "AT+CCWA=1" + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("AT+CCWA=1 return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        bFlag = true;
                        log.info("AT+CCWA=1: return is ok...");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("makeCCWA error: " + e.toString());
        }
        return bFlag;
    }

    public String[] makeCLCC() {
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = "AT+CLCC" + strATPostfix;
        String[] response = null;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("AT+CLCC return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        strResponse = TextUtil.replaceStr(strResponse, "+CLCC:", "");
                        strResponse = TextUtil.replaceStr(strResponse, strATOK, "");
                        response = strResponse.split(";");
                        log.info("AT+CLCC: return is ok...");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("makeCLCC error: " + e.toString());
        }
        return response;
    }

    public String makeCLVL(String strCLVL) {
        String strResponse = null;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = String.valueOf(strCLVL) + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(String.valueOf(strCLVL) + ":" + " return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        log.info(String.valueOf(strCLVL) + ":" + " return is ok...");
                    } else {
                        log.info(String.valueOf(strCLVL) + ":" + " return is wrong...");
                    }
                    if ("AT+CLVL=?".equals(strCLVL)) {
                        int index1 = strResponse.indexOf("(");
                        int index2 = strResponse.indexOf(")");
                        strResponse = strResponse.substring(index1 + 1, index2);
                    } else if ("AT+CLVL?".equals(strCLVL)) {
                        strResponse = TextUtil.replaceStr(strResponse, "ok", "");
                        strResponse = TextUtil.replaceStr(strResponse, "+CLVL:", "");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("makeCLVL error: " + e.toString());
        }
        return strResponse;
    }

    public String makeCMUT(String strCMUT) {
        String strResponse = null;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = String.valueOf(strCMUT) + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal(String.valueOf(strCMUT) + ":" + " return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        log.info(String.valueOf(strCMUT) + ":" + " return is ok...");
                    } else {
                        log.info(String.valueOf(strCMUT) + ":" + " return is wrong...");
                    }
                    if ("AT+CMUT?".equals(strCMUT)) {
                        strResponse = TextUtil.replaceStr(strResponse, strATOK, "");
                        strResponse = TextUtil.replaceStr(strResponse, "+CMUT:", "");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("makeCLVL error: " + e.toString());
        }
        return strResponse;
    }

    public CallATResponse makeACall(String strNum) {
        CallATResponse cr;
        block10: {
            cr = null;
            DeviceService dev = DeviceService.getInstance();
            String devstr = Tools.checkNull(dev.getProductNetType());
            if (Tools.isEmpty(devstr)) {
                devstr = "WCDMA";
            }
            CommServer server = null;
            OutgoingMessage outMsg = null;
            IncomingMessage inMsg = null;
            String strAT = null;
            strAT = "CDMA".equalsIgnoreCase(devstr) ? "CDV" + strNum + ";" + strATPostfix : "ATD" + strNum + ";" + strATPostfix;
            try {
                server = MutiDeviceService.getCurrentServer();
                String strATLog = "ATD/CDV" + strNum + ";";
                if (server == null) break block10;
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 60);
                if (inMsg == null) {
                    log.fatal("CallService:" + strATLog + " return is null...");
                    break block10;
                }
                cr = new CallATResponse();
                strResponse = inMsg.getContent();
                strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                    cr.setIsSuccess(true);
                    log.info(String.valueOf(strATLog) + " return is ok...");
                    CallInfoBean info = new CallInfoBean();
                    info.setStrPhoneNum(strNum);
                    this.callLogID = Tools.getTransactionID();
                    info.setICallLogID(this.callLogID);
                    this.startTime = DateFormatUtil.getCurrentDateByFormat("dd/MM/yyyy HH:mm:ss");
                    info.setStrStartTime(this.startTime);
                    info.setICallLogType(2);
                    this.list.add(info);
                    break block10;
                }
                if (!TextUtil.checkContainStr(strResponse, strATErr)) break block10;
                cr.setIsSuccess(false);
                String[] strRes = TextUtil.split(strResponse, ":");
                int len = strRes.length;
                if (len == 2) {
                    try {
                        cr.setErrCode(Long.parseLong(strRes[1]));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                log.info(String.valueOf(strATLog) + ":" + cr.getIsSuccess() + "," + cr.getErrCode());
                CallInfoBean info = new CallInfoBean();
                info.setStrPhoneNum(strNum);
                this.callLogID = Tools.getTransactionID();
                info.setICallLogID(this.callLogID);
                this.startTime = DateFormatUtil.getCurrentDateByFormat("dd/MM/yyyy HH:mm:ss");
                info.setStrStartTime(this.startTime);
                info.setStrPhoneNum(strNum);
                String duration = this.convertDuration("0");
                info.setStrDuration(duration);
                info.setICallLogType(2);
                try {
                    this.writeCallLog(info);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            catch (Exception e) {
                log.error("MakeACall error: " + e.toString());
            }
        }
        return cr;
    }

    public CallATResponse hangUpCall(String strId) {
        CallATResponse cr;
        block8: {
            cr = null;
            DeviceService dev = DeviceService.getInstance();
            String devstr = Tools.checkNull(dev.getProductNetType());
            if (Tools.isEmpty(devstr)) {
                devstr = "WCDMA";
            }
            CommServer server = null;
            OutgoingMessage outMsg = null;
            IncomingMessage inMsg = null;
            String strAT = null;
            strAT = "CDMA".equalsIgnoreCase(devstr) ? "AT+CHV" + strATPostfix : "AT+CHUP" + strATPostfix;
            try {
                server = MutiDeviceService.getCurrentServer();
                String strATLog = "CHV/CHUP:" + strId + ";";
                if (server == null) break block8;
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("CallService:" + strATLog + " return is null...");
                    break block8;
                }
                cr = new CallATResponse();
                strResponse = inMsg.getContent();
                strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                    cr.setIsSuccess(true);
                    log.info(String.valueOf(strATLog) + " return is ok...");
                    break block8;
                }
                if (!TextUtil.checkContainStr(strResponse, strATErr)) break block8;
                cr.setIsSuccess(false);
                String[] strRes = TextUtil.split(strResponse, ":");
                int len = strRes.length;
                if (len == 2) {
                    try {
                        cr.setErrCode(Long.parseLong(strRes[1]));
                    }
                    catch (NumberFormatException ee) {
                        ee.printStackTrace();
                    }
                }
                log.info(String.valueOf(strATLog) + ":" + cr.getIsSuccess() + "," + cr.getErrCode());
            }
            catch (Exception e) {
                log.error("MakeACall error: " + e.toString());
            }
        }
        return cr;
    }

    public boolean chldCall() {
        return true;
    }

    public boolean acceptCall() {
        boolean bFlag = false;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strAT = "ATA" + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            String strATLog = "ATA";
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("CallService:" + strATLog + " return is null...");
                } else {
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        bFlag = true;
                        log.info(String.valueOf(strATLog) + " return is ok...");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("MakeACall error: " + e.toString());
        }
        return bFlag;
    }

    public CallATResponse sendDTMF(int strId, String strDigit) {
        CallATResponse cr = null;
        CommServer server = null;
        OutgoingMessage outMsg = null;
        IncomingMessage inMsg = null;
        String strInfo = ",150,60";
        String strAT = "AT^DTMF=" + strId + "," + strDigit + strInfo + strATPostfix;
        try {
            server = MutiDeviceService.getCurrentServer();
            if (server != null) {
                outMsg = new OutgoingMessage();
                outMsg.setContent(strAT);
                String strResponse = null;
                inMsg = server.send(outMsg, 30);
                if (inMsg == null) {
                    log.fatal("CallService:DTMF return is null...");
                } else {
                    cr = new CallATResponse();
                    strResponse = inMsg.getContent();
                    strResponse = TextUtil.replaceStr(strResponse, "\n", "");
                    if (TextUtil.checkContainStr(strResponse = TextUtil.replaceStr(strResponse, "\r", ""), strATOK)) {
                        cr.setIsSuccess(true);
                        log.info("DTMF  return is ok...");
                    } else if (TextUtil.checkContainStr(strResponse, strATErr)) {
                        cr.setIsSuccess(false);
                        String[] strRes = TextUtil.split(strResponse, ":");
                        int len = strRes.length;
                        if (len == 2) {
                            cr.setErrCode(Long.parseLong(strRes[1]));
                        }
                        log.info("DTMF :" + cr.getIsSuccess() + "," + cr.getErrCode());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("MakeACall error: " + e.toString());
        }
        return cr;
    }

    public void writeCallLog(CallInfoBean callInfo) {
        if (-1L == callInfo.getICallLogID()) {
            callInfo.setICallLogID(Tools.getTransactionID());
        }
        String number = callInfo.getStrPhoneNum();
        String name = this.commonMethodByTelBook.getContactName(number);
        String startTimes = callInfo.getStrStartTime();
        String duration = callInfo.getStrDuration();
        String id = String.valueOf(callInfo.getICallLogID());
        String state = "0";
        String logType = String.valueOf(callInfo.getICallLogType());
        if (name == null || "".equals(name.trim())) {
            name = number;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("number", number);
        map.put("startTime", startTimes);
        map.put("duration", duration);
        map.put("id", id);
        map.put("state", state);
        map.put("type", logType);
        boolean addFlag = this.event.addCallInfo(map);
        try {
            this.logInstance.refreshCallLogInfo(logType);
        }
        catch (Exception e) {
            log.info("refreshCallLogInfo is exception" + e.getMessage());
        }
        Tools.logToControl("out", "==CallServiceImpl===writeCallLog====addFlag====" + addFlag);
    }

    public void addListInfo(CallInfoBean callInfo) {
        this.list.add(callInfo);
    }

    public ArrayList getListInfo() {
        return this.list;
    }

    public void removeListInfo() {
        int i = 0;
        while (i < this.list.size()) {
            this.list.remove(i);
            ++i;
        }
    }

    public void callUnicommEvent(int iEventId, CallInfoBean callInfo) {
        switch (iEventId) {
            case 20001: {
                boolean bHasCall = false;
                int i = 0;
                while (i < this.list.size()) {
                    CallInfoBean cb = (CallInfoBean)this.list.get(i);
                    if (CommonConfigCallInfo.CALL_STATE.CALL_STATE_INCOMING.ordinal() == cb.getICallState()) {
                        bHasCall = true;
                        break;
                    }
                    ++i;
                }
                if (bHasCall) {
                    return;
                }
                callInfo.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_INCOMING.ordinal());
                this.callLogID = Tools.getTransactionID();
                callInfo.setICallLogID(this.callLogID);
                this.startTime = DateFormatUtil.getCurrentDateByFormat("dd/MM/yyyy HH:mm:ss");
                callInfo.setStrStartTime(this.startTime);
                callInfo.setICallLogType(1);
                this.list.add(callInfo);
                this.event.onCallInNew(callInfo);
                break;
            }
            case 20002: {
                CallInfoBean info = null;
                int i = 0;
                while (i < this.list.size()) {
                    info = (CallInfoBean)this.list.get(i);
                    if (info.getStrCallId().equals("-1")) {
                        info.setStrCallId(callInfo.getStrCallId());
                        info.setICallType(callInfo.getICallType());
                        info.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_ORIG.ordinal());
                        break;
                    }
                    ++i;
                }
                this.event.onCallEmergency(info);
                break;
            }
            case 20003: {
                CallInfoBean info = null;
                int i = 0;
                while (i < this.list.size()) {
                    info = (CallInfoBean)this.list.get(i);
                    if (info.getStrCallId().equals(callInfo.getStrCallId())) {
                        info.setStrCallId(callInfo.getStrCallId());
                        info.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONF.ordinal());
                        break;
                    }
                    ++i;
                }
                this.event.onCallOutRing(info);
                break;
            }
            case 20004: {
                CallInfoBean info = null;
                int i = 0;
                while (i < this.list.size()) {
                    info = (CallInfoBean)this.list.get(i);
                    if (info.getStrCallId().equals(callInfo.getStrCallId())) {
                        info.setICallType(callInfo.getICallType());
                        info.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONN.ordinal());
                        break;
                    }
                    if (info.getStrCallId().equals("-1")) {
                        info.setStrCallId(callInfo.getStrCallId());
                        info.setICallType(callInfo.getICallType());
                        info.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CONN.ordinal());
                        break;
                    }
                    ++i;
                }
                if (2 != info.getICallLogType()) {
                    info.setICallLogType(0);
                }
                info.setICallLogID(this.callLogID);
                if (!"".equals(this.startTime)) {
                    info.setStrStartTime(this.startTime);
                }
                this.event.onCallStartAudio(info);
                break;
            }
            case 20005: {
                CallInfoBean info = null;
                int i = 0;
                while (i < this.list.size()) {
                    info = (CallInfoBean)this.list.get(i);
                    if (info.getStrCallId().equals(callInfo.getStrCallId()) || info.getStrCallId().equals("-1")) {
                        info.setStrCallId(callInfo.getStrCallId());
                        String duration = this.convertDuration(callInfo.getStrDuration());
                        info.setStrDuration(duration);
                        info.setStrEndReason(callInfo.getStrEndReason());
                        info.setICallControlCause(callInfo.getICallControlCause());
                        this.callLogID = info.getICallLogID();
                        this.startTime = info.getStrStartTime();
                        log.info("EVENT_CALL_CEND,phoneNumber:" + info.getStrPhoneNum());
                        this.list.remove(i);
                        break;
                    }
                    ++i;
                }
                if (1 == info.getICallLogType()) {
                    int reasonEnd = Integer.parseInt(info.getStrEndReason());
                    if (104 == reasonEnd) {
                        info.setICallLogType(1);
                    } else {
                        info.setICallLogType(0);
                    }
                }
                info.setICallState(CommonConfigCallInfo.CALL_STATE.CALL_STATE_CEND.ordinal());
                info.setICallLogID(this.callLogID);
                info.setStrStartTime(this.startTime);
                this.event.onCallClosed(info);
                try {
                    this.writeCallLog(info);
                    break;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    private String convertDuration(String duration) {
        int iDuration = 0;
        int iSeconds = 0;
        int iMinutes = 0;
        int iHours = 0;
        try {
            iDuration = duration == null || "".equals(duration) ? 0 : Integer.parseInt(duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        iSeconds = iDuration % 60;
        iMinutes = iDuration / 60 % 60;
        iHours = iMinutes / 60;
        String strSeconds = Integer.toString(iSeconds);
        String strMinutes = Integer.toString(iMinutes);
        String strHours = Integer.toString(iHours);
        if (strSeconds.length() < 2) {
            strSeconds = "0" + strSeconds;
        }
        if (strMinutes.length() < 2) {
            strMinutes = "0" + strMinutes;
        }
        if (strHours.length() < 2) {
            strHours = "0" + strHours;
        }
        String strTimer = String.valueOf(strHours) + ":" + strMinutes + ":" + strSeconds;
        return strTimer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ATD_ERR {

    }
}

