/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.server;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.data.comm.interfaces.IReceive;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.MessagesPool;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;

public class CommMsgHandler {
    private static LogATConfig log = Log.getATLog(CommMsgHandler.class);
    private MessagesPool msgPool = new MessagesPool();
    Thread threadRefreshTimer = null;

    public MessagesPool getMsgPool() {
        return this.msgPool;
    }

    public IncomingMessage send(OutgoingMessage outMsg, int waitTime) {
        if (this.msgPool.getOutgoingMsgQueueSize() > 0) {
            this.msgPool.clearOutgoing();
        }
        this.msgPool.putOutgoingMsg(outMsg);
        IncomingMessage inMsg = null;
        if (!this.msgPool.isIncomingEmpty()) {
            inMsg = this.msgPool.pollIncoming();
        } else {
            try {
                int time = 0;
                while (time < waitTime) {
                    time += 10;
                    if (CommServerThread.currentSystem.equals("Linux") && !CommServerThread.hasDevicefile) {
                        inMsg = null;
                    } else {
                        Thread.sleep(10L);
                        inMsg = this.msgPool.pollIncoming();
                        if (inMsg == null && (!CommServerThread.currentSystem.equals("Mac OS X") || CommServerThread.openPortIdFlag)) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                log.info(e.getMessage());
            }
        }
        return inMsg;
    }

    public boolean send(OutgoingMessage outMsg, int waitTime, IReceive iReceiver) {
        this.msgPool.putOutgoingMsg(outMsg);
        IncomingMessage inMsg = null;
        if (!this.msgPool.isIncomingEmpty()) {
            inMsg = this.msgPool.pollIncoming();
            iReceiver.onReceive(inMsg.getContent(), inMsg.getContent().getBytes().length);
        } else {
            try {
                int time = 0;
                if (time < waitTime) {
                    time += 200;
                    Thread.sleep(200L);
                    inMsg = this.msgPool.pollIncoming();
                    if (inMsg != null) {
                        iReceiver.onReceive(inMsg.getContent(), inMsg.getContent().getBytes().length);
                    }
                }
            }
            catch (InterruptedException e) {
                log.info(e.getMessage());
            }
        }
        return true;
    }
}

