/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.data.comm.messages;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.data.comm.messages.IncomingMessage;
import com.huawei.mobilePartner.data.comm.messages.OutgoingMessage;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MessagesPool {
    private ConcurrentLinkedQueue incomingMsgQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue outgoingMsgQueue = new ConcurrentLinkedQueue();
    private LogATConfig log = Log.getATLog(MessagesPool.class);

    public int getIncomingMsgQueueSize() {
        return this.incomingMsgQueue.size();
    }

    public int getOutgoingMsgQueueSize() {
        return this.outgoingMsgQueue.size();
    }

    public void putIncomingMsg(IncomingMessage incomingMessage) {
        if (incomingMessage == null) {
            this.log.info("send at incomingMessage is null ");
            return;
        }
        this.incomingMsgQueue.add(incomingMessage);
    }

    public void putOutgoingMsg(OutgoingMessage outgoingMessage) {
        if (outgoingMessage == null) {
            this.log.info("send at outgoingMessage is null ");
            return;
        }
        this.log.info("MessagesPool putOutgoingMsg : [" + outgoingMessage.getContent() + "]");
        this.outgoingMsgQueue.add(outgoingMessage);
    }

    public boolean isIncomingEmpty() {
        return this.incomingMsgQueue.isEmpty();
    }

    public boolean isOutgoingEmpty() {
        return this.outgoingMsgQueue.isEmpty();
    }

    public OutgoingMessage pollOutgoing() {
        OutgoingMessage outMsg = (OutgoingMessage)this.outgoingMsgQueue.poll();
        return outMsg;
    }

    public void clearOutgoing() {
        this.outgoingMsgQueue.clear();
    }

    public void clearIncoming() {
        this.incomingMsgQueue.clear();
    }

    public IncomingMessage pollIncoming() {
        IncomingMessage inMsg = null;
        if (this.incomingMsgQueue.size() > 0) {
            inMsg = (IncomingMessage)this.incomingMsgQueue.poll();
        }
        this.incomingMsgQueue.clear();
        return inMsg;
    }
}

