/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.config.business;

import com.huawei.mobilePartner.business.network.NetworkThread;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.LanguageTypeBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LanguageSelect {
    private static LogConfig log = Log.getLog(LanguageSelect.class);
    private static XMLTool runInfoXml = null;
    public static String LANGUAGE_PATH = "/SysConfig/language/*";
    public static String LANGUAGE_PATH2 = "SysConfig/language";
    public static String defalutLanguage_path = "/SysConfig/defaultType";
    public static final String FILE_PREFIX = "/SysConfig/fileprefix";
    private static String configXmlPath = String.valueOf(Tools.getClassPath()) + "/";

    public static void setLanguageType(CustomizeInit customize, String oldLanguageType) {
        block16: {
            try {
                if (CommServerThread.commServerThread != null) {
                    log.info("CommServerThread.commServerThread.wait(); start");
                    CommServerThread.commServerThread.wait();
                    log.info("CommServerThread.commServerThread.wait(); end");
                }
                if (NetworkThread.networkThread != null) {
                    log.info("NetworkThread.networkThread.wait(); start");
                    NetworkThread.networkThread.wait();
                    log.info("NetworkThread.networkThread.wait(); end");
                }
                XMLTool.setImportExport(false);
                runInfoXml = new XMLTool("config/data/RunInfo.xml");
            }
            catch (Exception ex) {
                log.info("read UserProfile.xml fail or Thread wait error : [" + ex.toString() + "]");
            }
            String langType = LanguageSelect.getRunInfoLanguageType2();
            List alllangType = LanguageSelect.getRunInfoAllLanguageType();
            String tempType = "";
            LanguageTypeBean languageTypeBean = null;
            boolean flag = false;
            try {
                int i = 0;
                while (i < alllangType.size()) {
                    languageTypeBean = (LanguageTypeBean)alllangType.get(i);
                    tempType = languageTypeBean.getLanguageName();
                    if (langType.trim().equals(tempType)) {
                        customize.LanguageInit(tempType);
                        PublicConfig.languageType = tempType;
                        flag = true;
                        break;
                    }
                    ++i;
                }
                if (!flag) {
                    LanguageSelect.setRunInfoLanguageType(LanguageSelect.getdefaultLanguage());
                    customize.LanguageInit(LanguageSelect.getdefaultLanguage());
                    PublicConfig.languageType = tempType;
                }
                break block16;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(e.toString());
                log.info("Init language file error");
                LanguageSelect.setRunInfoLanguageType(oldLanguageType);
                try {
                    if (!flag) {
                        customize.LanguageInit(LanguageSelect.getdefaultLanguage());
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    log.debug("read file failed");
                }
                LanguageTypeBean bean = null;
                try {
                    int i = 0;
                    while (i < alllangType.size()) {
                        bean = (LanguageTypeBean)alllangType.get(i);
                        if (oldLanguageType.equals(bean.getLanguageName())) {
                            AppFrame.getAppFrameInit().langugeMenuItem.getItem(i).setSelected(true);
                        }
                        ++i;
                    }
                }
                catch (RuntimeException e1) {
                    log.debug("create JMenu failed");
                }
            }
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        log.info(e.toString());
                    }
                }
            });
        }
    }

    public static List getRunInfoAllLanguageType() {
        try {
            XMLTool.setImportExport(false);
            runInfoXml = new XMLTool("config/data/RunInfo.xml");
        }
        catch (Exception ex) {
            log.info("read UserProfile.xml fail : [" + ex.toString() + "]");
        }
        String path = "SysConfig/language/*";
        String[] temp = new String[]{"languageName", "menuItem"};
        List list = runInfoXml.quertyNodePropertiesValueByPath(path, temp);
        ArrayList<LanguageTypeBean> listAllLanguageType = new ArrayList<LanguageTypeBean>();
        LanguageTypeBean ltb = null;
        int i = 0;
        while (i < list.size()) {
            Map map = (Map)list.get(i);
            String languageName = map.get("languageName").toString();
            String menuItem = map.get("menuItem").toString();
            ltb = new LanguageTypeBean();
            ltb.setLanguageName(languageName);
            ltb.setMenuItem(menuItem);
            listAllLanguageType.add(ltb);
            ++i;
        }
        return listAllLanguageType;
    }

    public static String getRunInfoLanguageType2() {
        String[] type = new String[]{"type"};
        String typeStr = "";
        try {
            XMLTool.setImportExport(false);
            runInfoXml = new XMLTool("config/data/RunInfo.xml");
        }
        catch (Exception ex) {
            log.info("read UserProfile.xml fail : [" + ex.toString() + "]");
        }
        List operList = runInfoXml.quertyNodePropertiesValueByPath(LANGUAGE_PATH2, type);
        int index = 0;
        while (index < operList.size()) {
            HashMap map = (HashMap)operList.get(index);
            typeStr = map.get("type").toString();
            ++index;
        }
        Map prefixMap = runInfoXml.quertyNodeTextValueByPath(FILE_PREFIX);
        String prefix = prefixMap.get("fileprefix").toString();
        Locale local = Locale.getDefault();
        if ("".equals(typeStr)) {
            typeStr = (String.valueOf(prefix) + local.getLanguage() + ".xml").toLowerCase();
            log.info("typeStr:" + typeStr);
            LanguageSelect.setRunInfoLanguageType(typeStr);
        }
        return typeStr;
    }

    public static void setRunInfoLanguageType(String langType) {
        try {
            XMLTool.setImportExport(false);
            runInfoXml = new XMLTool("config/data/RunInfo.xml");
        }
        catch (Exception ex) {
            log.info("read UserProfile.xml fail : [" + ex.toString() + "]");
        }
        try {
            runInfoXml.updateNodePropertiesValue(LANGUAGE_PATH2, "type", langType);
        }
        catch (Exception e) {
            log.info("update runInfo.xml file fail : [" + e.toString() + "]");
        }
    }

    public static String getdefaultLanguage() {
        String typeStr = "";
        try {
            XMLTool.setImportExport(false);
            runInfoXml = new XMLTool("config/data/RunInfo.xml");
        }
        catch (Exception ex) {
            log.info("read UserProfile.xml fail : [" + ex.toString() + "]");
        }
        Map map = runInfoXml.quertyNodeTextValueByPath(defalutLanguage_path);
        typeStr = map.get("defaultType").toString();
        return typeStr;
    }
}

