/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.common.util;

import com.huawei.mobilePartner.business.statistics.RecurrenceBean;
import com.huawei.mobilePartner.business.statistics.RecurrenceValue;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumeLimitTools {
    private LogConfig log = null;
    private XMLTool comm = null;
    private static VolumeLimitTools instance = null;

    private VolumeLimitTools() {
        try {
            XMLTool.setImportExport(false);
            this.comm = new XMLTool("config/fluxData/UsageLimitInfoConfig.xml");
            this.log = Log.getLog(VolumeLimitTools.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized VolumeLimitTools getInstance() {
        if (instance == null) {
            instance = new VolumeLimitTools();
        }
        return instance;
    }

    public boolean getIsVolumeList() {
        String codyPath = "root";
        boolean isVolumeList = false;
        String value = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                value = Tools.checkNull(map.get("value"));
            }
        }
        catch (Exception e) {
            this.log.info("query ShowSettingUI value error.");
        }
        if ("".equals(value)) {
            isVolumeList = false;
        } else {
            try {
                isVolumeList = Boolean.valueOf(value);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return isVolumeList;
    }

    public boolean getShowSettingUI() {
        String codyPath = "root/showSettingUI";
        boolean isShowSettingUI = false;
        String value = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                value = Tools.checkNull(map.get("value"));
            }
        }
        catch (Exception e) {
            this.log.info("query ShowSettingUI value error.");
        }
        if ("".equals(value)) {
            isShowSettingUI = false;
        } else {
            try {
                isShowSettingUI = Boolean.valueOf(value);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return isShowSettingUI;
    }

    public String getStatStartTime() {
        String codyPath = "root/startdate";
        String value = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                value = Tools.checkNull(map.get("value"));
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
        return value;
    }

    public List<String> getStatRecurrence() {
        String codyPath = "root/recurrence";
        List codeList = new ArrayList();
        ArrayList<String> setLimit = new ArrayList<String>();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value", "default", "strSelected", "weeklyDate", "monthlyDate"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                setLimit.add(Tools.checkNull(map.get("value")));
                setLimit.add(Tools.checkNull(map.get("default")));
                setLimit.add(Tools.checkNull(map.get("strSelected")));
                setLimit.add(Tools.checkNull(map.get("weeklyDate")));
                setLimit.add(Tools.checkNull(map.get("monthlyDate")));
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
        return setLimit;
    }

    public List<String> getDataVolumelimit() {
        String codyPath = "root/setDataVolumelimit";
        ArrayList<String> setLimit = new ArrayList<String>();
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value", "default", "limitValue", "isShow"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                setLimit.add(Tools.checkNull(map.get("value")));
                setLimit.add(Tools.checkNull(map.get("default")));
                setLimit.add(Tools.checkNull(map.get("limitValue")));
                setLimit.add(Tools.checkNull(map.get("isShow")));
            }
        }
        catch (Exception e) {
            this.log.info("query setDataVolumelimit value error.");
        }
        return setLimit;
    }

    public String getDataVolumeLimitRange() {
        String codyPath = "root/setDataVolumelimit/range";
        String lang = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                lang = Tools.checkNull(map.get("value"));
            }
        }
        catch (Exception e) {
            this.log.info("query getDataVolumeLimitRange range error.");
        }
        return lang;
    }

    public List<String> getTimeVolumelimit() {
        String codyPath = "root/setTimeVolumelimit";
        ArrayList<String> setLimit = new ArrayList<String>();
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value", "default", "limitValue", "isShow"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                setLimit.add(Tools.checkNull(map.get("value")));
                setLimit.add(Tools.checkNull(map.get("default")));
                setLimit.add(Tools.checkNull(map.get("limitValue")));
                setLimit.add(Tools.checkNull(map.get("isShow")));
            }
        }
        catch (Exception e) {
            this.log.info("query getTimeVolumelimit value error.");
        }
        return setLimit;
    }

    public String getTimeVolumeLimitRange() {
        String codyPath = "root/setTimeVolumelimit/range";
        String lang = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                lang = Tools.checkNull(map.get("value"));
            }
        }
        catch (Exception e) {
            this.log.info("query setTimeVolumelimit range error.");
        }
        return lang;
    }

    public List<String> getWarningsBeforeLimit() {
        String codyPath = "root/setwarnings/showBeforeLimit";
        String value = "";
        ArrayList<String> limitList = new ArrayList<String>();
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value", "difference", "percent", "isShow"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                limitList.add(Tools.checkNull(map.get("value")));
                limitList.add(Tools.checkNull(map.get("difference")));
                limitList.add(Tools.checkNull(map.get("percent")));
                limitList.add(Tools.checkNull(map.get("isShow")));
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
        return limitList;
    }

    public List<String> getWarningsExceededLimit() {
        String codyPath = "root/setwarnings/showReachedLimit";
        String value = "";
        ArrayList<String> limitList = new ArrayList<String>();
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"value", "isShow"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                limitList.add(Tools.checkNull(map.get("value")));
                limitList.add(Tools.checkNull(map.get("isShow")));
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
        return limitList;
    }

    public boolean getShowDataVolumeBarUI() {
        String codyPath = "root/showDataVolumeBarUI";
        boolean showDataVolumeBar = false;
        String value = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"isShow"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                value = Tools.checkNull(map.get("isShow"));
            }
        }
        catch (Exception e) {
            this.log.info("query getShowDataVolumeBarUI value error.");
        }
        if ("".equals(value)) {
            showDataVolumeBar = false;
        } else {
            try {
                showDataVolumeBar = Boolean.valueOf(value);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return showDataVolumeBar;
    }

    public boolean getShowTimeVolumeBarUI() {
        String codyPath = "root/showTimeVolumeBarUI";
        boolean showTimeVolumeBar = false;
        String value = "";
        List codeList = new ArrayList();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"isShow"});
            if (codeList.size() > 0) {
                HashMap map = (HashMap)codeList.get(0);
                value = Tools.checkNull(map.get("isShow"));
            }
        }
        catch (Exception e) {
            this.log.info("query getShowDataVolumeBarUI value error.");
        }
        if ("".equals(value)) {
            showTimeVolumeBar = false;
        } else {
            try {
                showTimeVolumeBar = Boolean.valueOf(value);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return showTimeVolumeBar;
    }

    public Map getTitleMessage() {
        String codyPath = "root/titleMessage/title";
        List codeList = null;
        HashMap map = new HashMap();
        try {
            codeList = this.comm.quertyNodePropertiesValueByPath(codyPath, new String[]{"dataBefore", "dataReached", "timeBefore", "timeReached"});
            if (codeList.size() > 0) {
                map = (HashMap)codeList.get(0);
            }
        }
        catch (Exception e) {
            System.out.println("!!!!!!!!!!!! titleww=");
            this.log.info("query startdate value error.");
        }
        return map;
    }

    public void setTitleMessage(RecurrenceBean bean) {
        String codyPath = "root/titleMessage/title";
        String[] state = new String[]{bean.getTitleMessage_dataBefore(), bean.getTitleMessage_dataReached(), bean.getTitleMessage_timeBefore(), bean.getTitleMessage_timeReached()};
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodeMultiPropertiesValue(codyPath, new String[]{"dataBefore", "dataReached", "timeBefore", "timeReached"}, state);
            if (!updateFlag) {
                this.log.info("query setTitleMessage value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query setTitleMessage value error.");
        }
    }

    private void setShowSettingUI(String value) {
        String codyPath = "root/showSettingUI";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodePropertiesValue(codyPath, "value", value);
            if (!updateFlag) {
                this.log.info("query startdate value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
    }

    public void setStatStartTime(String value) {
        String codyPath = "root/startdate";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodePropertiesValue(codyPath, "value", value);
            if (!updateFlag) {
                this.log.info("query startdate value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
    }

    public void setStatRecurrence(String[] value) {
        String codyPath = "root/recurrence";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodeMultiPropertiesValue(codyPath, new String[]{"value", "default", "strSelected", "weeklyDate", "monthlyDate"}, value);
            if (!updateFlag) {
                this.log.info("query startdate value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query startdate value error.");
        }
    }

    public void setStatrecurrencevalue(List recurrenceList) {
        String codyPath = "root/recurrence/recurrencevalue[@name=\"";
        boolean updateFlag = false;
        try {
            int index = 0;
            while (index < recurrenceList.size()) {
                RecurrenceValue rec = (RecurrenceValue)recurrenceList.get(index);
                String tempCodyPath = String.valueOf(codyPath) + rec.getName() + "\"]";
                Tools.logToControl("err", "codyPath:" + tempCodyPath);
                String[] str = new String[]{rec.getName(), rec.getValue(), rec.getView()};
                updateFlag = this.comm.updateNodeMultiPropertiesValue(tempCodyPath, new String[]{"name", "value", "view"}, str);
                if (!updateFlag) {
                    this.log.info("query RecurrenceValue value error.");
                }
                ++index;
            }
        }
        catch (Exception e) {
            this.log.info("query recurrencevalue value error.");
        }
    }

    public void setDataVolumeLimit(String[] stat) {
        String codyPath = "root/setDataVolumelimit";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodeMultiPropertiesValue(codyPath, new String[]{"value", "default", "limitValue", "isShow"}, stat);
            if (!updateFlag) {
                this.log.info("query setDataVolumelimit value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query setDataVolumelimit value error.");
        }
    }

    public void setTimeVolumeLimit(String[] stat) {
        String codyPath = "root/setTimeVolumelimit";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodeMultiPropertiesValue(codyPath, new String[]{"value", "default", "limitValue", "isShow"}, stat);
            if (!updateFlag) {
                this.log.info("query setTimeVolumeLimit value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query setTimeVolumeLimit value error.");
        }
    }

    public void setWarningsBeforeLimit(String value) {
        String codyPath = "root/setwarnings/showBeforeLimit";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodePropertiesValue(codyPath, "value", value);
            if (updateFlag) {
                this.log.info("query SetWarningsLimit value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query SetWarningsLimit value error.");
        }
    }

    public void setWarningsReachedExceeded(String value) {
        String codyPath = "root/setwarnings/showReachedLimit";
        boolean updateFlag = false;
        try {
            updateFlag = this.comm.updateNodePropertiesValue(codyPath, "value", value);
            if (updateFlag) {
                this.log.info("query SetWarningsLimit value error." + updateFlag);
            }
        }
        catch (Exception e) {
            this.log.info("query SetWarningsLimit value error.");
        }
    }

    public void readVolumeLimitValue() {
        RecurrenceBean recurrenceBean = RecurrenceBean.getRecurrenceBean();
        recurrenceBean.setIsVolumeList(this.getIsVolumeList());
        recurrenceBean.setShowSetUI(this.getShowSettingUI());
        if (this.getStatStartTime() == null || this.getStatStartTime().equals("")) {
            SimpleDateFormat simple = new SimpleDateFormat("yyyyMMdd");
            String currentTimeStr = simple.format(new Date());
            currentTimeStr = String.valueOf(currentTimeStr.substring(0, 6)) + "01";
            System.err.println("currentTimeStr:" + currentTimeStr);
            recurrenceBean.setStartTime(currentTimeStr);
        } else {
            System.err.println("volume.getStatStartTime():" + this.getStatStartTime());
            recurrenceBean.setStartTime(this.getStatStartTime());
        }
        recurrenceBean.setRecurrenceValueList(this.getStatRecurrence());
        recurrenceBean.setDataVolumeLimitList(this.getDataVolumelimit());
        recurrenceBean.setDataVolumeLimitListRange(this.getDataVolumeLimitRange());
        recurrenceBean.setTimeVolumeLimitList(this.getTimeVolumelimit());
        recurrenceBean.setTimeLimitListRange(this.getTimeVolumeLimitRange());
        recurrenceBean.setBeforeLimitList(this.getWarningsBeforeLimit());
        recurrenceBean.setExceededLimitList(this.getWarningsExceededLimit());
        recurrenceBean.setShowDataVolumeBar(this.getShowDataVolumeBarUI());
        recurrenceBean.setShowTimeVolumeBar(this.getShowTimeVolumeBarUI());
        recurrenceBean.setTitleMessage_dataBefore(this.getTitleMessage().get("dataBefore").toString());
        recurrenceBean.setTitleMessage_dataReached(this.getTitleMessage().get("dataReached").toString());
        recurrenceBean.setTitleMessage_timeBefore(this.getTitleMessage().get("timeBefore").toString());
        recurrenceBean.setTitleMessage_timeReached(this.getTitleMessage().get("timeReached").toString());
    }

    public void writeVolumeLimitValue() {
        try {
            List tempList;
            RecurrenceBean recurrenceBean = RecurrenceBean.getRecurrenceBean();
            this.setStatStartTime(recurrenceBean.getStartTime());
            if (recurrenceBean.getRecurrenceValueList().size() > 0) {
                tempList = recurrenceBean.getRecurrenceValueList();
                String[] recruuenceList = new String[]{tempList.get(0).toString(), tempList.get(1).toString(), tempList.get(2).toString(), tempList.get(3).toString(), tempList.get(4).toString()};
                this.setStatRecurrence(recruuenceList);
            }
            if (recurrenceBean.getDataVolumeLimitList().size() > 0) {
                tempList = recurrenceBean.getDataVolumeLimitList();
                String[] dataVolumeLimit = new String[]{tempList.get(0).toString(), tempList.get(1).toString(), tempList.get(2).toString(), tempList.get(3).toString()};
                this.setDataVolumeLimit(dataVolumeLimit);
            }
            if (recurrenceBean.getTimeVolumeLimitList().size() > 0) {
                tempList = recurrenceBean.getTimeVolumeLimitList();
                String[] timeVolumeLimit = new String[]{tempList.get(0).toString(), tempList.get(1).toString(), tempList.get(2).toString(), tempList.get(3).toString()};
                this.setTimeVolumeLimit(timeVolumeLimit);
            }
            if (recurrenceBean.getBeforeLimitList().size() > 0) {
                this.setWarningsBeforeLimit(recurrenceBean.getBeforeLimitList().get(0).toString());
            }
            if (recurrenceBean.getExceededLimitList().size() > 0) {
                this.setWarningsReachedExceeded(recurrenceBean.getExceededLimitList().get(0).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

