/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.common.util;

import com.huawei.mobilePartner.business.statistics.ScheduledTask;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Chmod;
import com.huawei.mobilePartner.common.util.DateFormatUtil;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TextWriteTools {
    private static String path = String.valueOf(XMLTool.getClassPath()) + "/config/fluxData/dataTimer.txt";
    private static String windowpath = String.valueOf(XMLTool.getClassPath()) + "/config/fluxData/clearHistoryTime.txt";
    private static String MacPath = String.valueOf(XMLTool.getClassPath()) + "/config/fluxData/clearHistoryTime.txt";
    private static String linuxpath = String.valueOf(XMLTool.getClassPath()) + "/config/fluxData/clearHistoryTime.txt";
    private static String linuxDir = "/etc";
    static long refreshValue = 0L;
    static LogConfig log = Log.getLog(TextWriteTools.class);

    static {
        File f = new File(path);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                log.info("[createNewFile] create{dataTimer.txt}  file  error");
                e.printStackTrace();
            }
            Tools.logToControl("err", String.valueOf(path) + "\u4e0d\u5b58\u5728\uff0c\u5df2\u5efa\u7acb\u3002");
        }
        String datestime = DateFormatUtil.getCurrentDateByFormat(PublicConfig.currentDateByFormat);
        if (CommServerThread.currentSystem.equalsIgnoreCase("Mac OS X")) {
            Tools.logToControl("err", "------------------macchu------------------" + XMLTool.getClassPath());
            File macf = new File(MacPath);
            if (macf.exists()) {
                if (macf.length() == 0L) {
                    TextWriteTools.WriteTxt(MacPath, datestime);
                }
                Chmod.chmodFile(MacPath, "777");
            } else {
                try {
                    macf.createNewFile();
                    Chmod.chmodFile(MacPath, "777");
                    TextWriteTools.WriteTxt(MacPath, datestime);
                }
                catch (IOException e) {
                    log.info("Mac***[createNewFile] create{clearHistoryTime88.txt}  file  error");
                    e.printStackTrace();
                }
                Tools.logToControl("err", String.valueOf(path) + "Mac***\u4e0d\u5b58\u5728\uff0c\u5df2\u5efa\u7acb\u3002");
            }
        } else if (CommServerThread.currentSystem.equalsIgnoreCase("Linux")) {
            File f1;
            File d = new File(linuxDir);
            if (!d.exists()) {
                d.mkdir();
            }
            if ((f1 = new File(linuxpath)).exists()) {
                if (f1.length() == 0L) {
                    TextWriteTools.WriteTxt(linuxpath, datestime);
                }
            } else {
                try {
                    f1.createNewFile();
                    TextWriteTools.WriteTxt(linuxpath, datestime);
                }
                catch (IOException e) {
                    log.info("linux***[createNewFile] create{clearHistoryTime.txt}  file  error");
                    e.printStackTrace();
                }
                Tools.logToControl("err", String.valueOf(linuxpath) + "\u4e0d\u5b58\u5728\uff0c\u5df2\u5efa\u7acb\u3002");
            }
        } else {
            File f1 = new File(windowpath);
            if (f1.exists()) {
                try {
                    Runtime.getRuntime().exec("attrib " + windowpath + " -R");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    f1.createNewFile();
                    TextWriteTools.WriteTxt(windowpath, datestime);
                    try {
                        Runtime.getRuntime().exec("attrib " + windowpath + " -R");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    log.info("windows***[createNewFile] create{clearHistoryTime.txt}  file  error");
                    e.printStackTrace();
                }
                Tools.logToControl("err", String.valueOf(windowpath) + "\u4e0d\u5b58\u5728\uff0c\u5df2\u5efa\u7acb\u3002");
            }
        }
    }

    public static synchronized long getTextValue(long timevalue, long oldValue) {
        String Line = null;
        try {
            path = TextUtil.replaceStr1(path, "\\/", "/");
            path = TextUtil.replaceStr1(path, "\\", "/");
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            Line = br.readLine();
            try {
                if (Tools.isEmpty(Line)) {
                    Line = "0";
                }
                refreshValue = Long.valueOf(Line) + timevalue;
                Tools.logToControl("err", "refreshValue============================" + refreshValue);
            }
            catch (Exception ex) {
                refreshValue = oldValue;
                ex.printStackTrace();
            }
            TextWriteTools.WriteTxt(path, refreshValue);
            br.close();
            fr.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info("function[getTextValue]: error return: " + ex.getMessage());
        }
        return refreshValue;
    }

    public static synchronized boolean resetTextValue() {
        boolean flag = true;
        try {
            path = TextUtil.replaceStr1(path, "\\/", "/");
            path = TextUtil.replaceStr1(path, "\\", "/");
            TextWriteTools.WriteTxt(path, 0L);
        }
        catch (Exception ex) {
            flag = false;
            ex.printStackTrace();
            log.info("function[resetTextValue]: error return: " + ex.getMessage());
        }
        return flag;
    }

    private static synchronized void WriteTxt(String path, long value) {
        try {
            FileWriter fw = new FileWriter(path);
            fw.write(String.valueOf(value));
            fw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info("function[WriteTxt(String path,long value)]: error return: " + ex.getMessage());
        }
    }

    private static synchronized void WriteTxt(String path, String value) {
        try {
            FileWriter fw = new FileWriter(path);
            fw.write(value);
            fw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info("function[WriteTxt(String path,String value)]: error path=" + path + "  return: " + ex.getMessage());
        }
    }

    public static synchronized void clearHistoryTxtStatInfo() {
        try {
            String datastr;
            ScheduledTask.clearbeforeTime = datastr = DateFormatUtil.getCurrentDateByFormat(PublicConfig.currentDateByFormat);
            if (CommServerThread.currentSystem.equalsIgnoreCase("Mac OS X")) {
                Tools.logToControl("err", "----------execute------mac---------------------");
                TextWriteTools.WriteTxt(MacPath, datastr);
            } else if (CommServerThread.currentSystem.equalsIgnoreCase("Linux")) {
                Tools.logToControl("err", "----------execute------linux---------------------");
                TextWriteTools.WriteTxt(linuxpath, datastr);
            } else {
                TextWriteTools.WriteTxt(windowpath, datastr);
            }
        }
        catch (Exception ex) {
            log.info("function[clearHistoryTxtStatInfo]: error return: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static synchronized String readclearHistoryTxtStatInfo() {
        if (CommServerThread.currentSystem.equalsIgnoreCase("Mac OS X")) {
            return TextWriteTools.readHistoryTxtStatInfoByMac();
        }
        if (CommServerThread.currentSystem.equalsIgnoreCase("Linux")) {
            return TextWriteTools.readclearHistoryTxtStatInfoLinux();
        }
        return TextWriteTools.readclearHistoryTxtStatInfoWindows();
    }

    private static synchronized String readHistoryTxtStatInfoByMac() {
        String Line = null;
        BufferedReader Macbr = null;
        FileReader Macfr = null;
        try {
            Macfr = new FileReader(MacPath);
            Macbr = new BufferedReader(Macfr);
            Line = Macbr.readLine();
            if (Tools.isEmpty(Line)) {
                Line = DateFormatUtil.getCurrentDateByFormat(PublicConfig.currentDateByFormat);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Mac***function[clearHistoryTxtStatInfoByMac]: error return: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            log.info("Mac***function[clearHistoryTxtStatInfoByMac]: error return: " + e.getMessage());
        }
        return Line;
    }

    private static synchronized String readclearHistoryTxtStatInfoLinux() {
        String Line = null;
        BufferedReader br = null;
        FileReader fr = null;
        try {
            linuxpath = TextUtil.replaceStr1(linuxpath, "\\/", "/");
            linuxpath = TextUtil.replaceStr1(linuxpath, "\\", "/");
            fr = new FileReader(linuxpath);
            br = new BufferedReader(fr);
            Line = br.readLine();
            if (Tools.isEmpty(Line)) {
                Line = DateFormatUtil.getCurrentDateByFormat(PublicConfig.currentDateByFormat);
            }
            br.close();
            fr.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info("function[readclearHistoryTxtStatInfolinux]: error return: " + ex.getMessage());
            try {
                br.close();
                fr.close();
            }
            catch (IOException e) {
                log.info("function[readclearHistoryTxtStatInfolinux]: error return: " + ex.getMessage());
                e.printStackTrace();
            }
        }
        return Line;
    }

    private static synchronized String readclearHistoryTxtStatInfoWindows() {
        String Line = null;
        BufferedReader br = null;
        FileReader fr = null;
        try {
            windowpath = TextUtil.replaceStr1(windowpath, "\\/", "/");
            windowpath = TextUtil.replaceStr1(windowpath, "\\", "/");
            fr = new FileReader(windowpath);
            br = new BufferedReader(fr);
            Line = br.readLine();
            if (Tools.isEmpty(Line)) {
                Line = DateFormatUtil.getCurrentDateByFormat(PublicConfig.currentDateByFormat);
            }
            br.close();
            fr.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info("function[readclearHistoryTxtStatInfoWindows]: error return: " + ex.getMessage());
            try {
                br.close();
                fr.close();
            }
            catch (IOException e) {
                log.info("function[readclearHistoryTxtStatInfoWindows]: error return: " + ex.getMessage());
                e.printStackTrace();
            }
        }
        return Line;
    }

    public static void main(String[] asrgs) {
    }
}

