/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.common.util;

import com.huawei.mobilePartner.business.statistics.FluxUnitBean;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextUtil {
    static LogConfig log = Log.getLog(TextUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] split(String source, String div) {
        int div_length;
        int intIdex;
        int intIdx;
        int arynum;
        block9: {
            arynum = 0;
            intIdx = 0;
            intIdex = 0;
            div_length = div.length();
            if (source.compareTo("") != 0) {
                if (source.indexOf(div) != -1) {
                    intIdx = source.indexOf(div);
                    int intCount = 1;
                    while (true) {
                        if (source.indexOf(div, intIdx + div_length) == -1) {
                            arynum += 2;
                            break block9;
                        }
                        intIdx = source.indexOf(div, intIdx + div_length);
                        arynum = intCount++;
                    }
                }
                arynum = 1;
            } else {
                arynum = 0;
            }
        }
        intIdx = 0;
        intIdex = 0;
        String[] returnStr = new String[arynum];
        if (source.compareTo("") == 0) return returnStr;
        if (source.indexOf(div) != -1) {
            intIdx = source.indexOf(div);
            returnStr[0] = source.substring(0, intIdx);
            int intCount = 1;
            while (true) {
                if (source.indexOf(div, intIdx + div_length) != -1) {
                    intIdex = source.indexOf(div, intIdx + div_length);
                    returnStr[intCount] = source.substring(intIdx + div_length, intIdex);
                    intIdx = source.indexOf(div, intIdx + div_length);
                    ++intCount;
                    continue;
                }
                break;
            }
        } else {
            returnStr[0] = source.substring(0, source.length());
            return returnStr;
        }
        returnStr[intCount] = source.substring(intIdx + div_length, source.length());
        return returnStr;
    }

    public static String rRight(String source, String sep) {
        source = source.toLowerCase();
        sep = sep.toLowerCase();
        String retstr = "";
        int len = source.length();
        int len1 = sep.length();
        int len2 = len - len1;
        int i = len2 - 1;
        while (i >= 0) {
            if (source.substring(i, i + len1).equals(sep)) {
                retstr = source.substring(i + len1, len);
                break;
            }
            --i;
        }
        return retstr;
    }

    public static String rLeft(String source, String sep) {
        source = source.toLowerCase();
        sep = sep.toLowerCase();
        String retstr = "";
        int len = source.length();
        int len1 = sep.length();
        int len2 = len - len1;
        int i = len2 - 1;
        while (i >= 0) {
            if (source.substring(i, i + len1).equals(sep)) {
                retstr = source.substring(0, i);
                break;
            }
            --i;
        }
        return retstr;
    }

    public static String rLeftXMLTool(String source, String sep) {
        source = source.toLowerCase();
        sep = sep.toLowerCase();
        String retstr = "";
        int len = source.length();
        int len1 = sep.length();
        int len2 = len - len1;
        int i = 0;
        while (i <= len2 - 1) {
            if (source.substring(i, i + len1).equals(sep)) {
                retstr = source.substring(0, i);
                break;
            }
            ++i;
        }
        return retstr;
    }

    public static final String replaceStr1(String sourceStr, String oldString, String newString) {
        if (sourceStr == null) {
            return null;
        }
        int i = 0;
        if ((i = sourceStr.indexOf(oldString, i)) >= 0) {
            char[] line2 = sourceStr.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = sourceStr.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return sourceStr;
    }

    public static final String replaceAll(String sourceStr, String[] oldString, String[] newString) {
        String sourceReturn = null;
        sourceReturn = sourceStr;
        int i = 0;
        while (i < oldString.length) {
            sourceReturn = TextUtil.replaceStr1(sourceReturn, oldString[i], newString[i]);
            ++i;
        }
        return sourceReturn;
    }

    public static final String replaceStr(String sourceStr, String oldString, String newString) {
        if (sourceStr == null) {
            return null;
        }
        sourceStr = sourceStr.toLowerCase();
        oldString = oldString.toLowerCase();
        newString = newString.toLowerCase();
        int i = 0;
        if ((i = sourceStr.indexOf(oldString, i)) >= 0) {
            char[] line2 = sourceStr.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = sourceStr.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return sourceStr;
    }

    public static final String replaceStrWithCase(String sourceStr, String oldString, String newString) {
        if (sourceStr == null) {
            return null;
        }
        int i = 0;
        if ((i = sourceStr.indexOf(oldString, i)) >= 0) {
            char[] line2 = sourceStr.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = sourceStr.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return sourceStr;
    }

    public static final String replaceStr2(String sourceStr, String oldString, String newString) {
        if (sourceStr == null) {
            return null;
        }
        int i = 0;
        if ((i = sourceStr.indexOf(oldString, i)) >= 0) {
            char[] line2 = sourceStr.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = sourceStr.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return sourceStr;
    }

    public static final String replaceStr(String sourceStr, String[] oldString, String[] newString) {
        String returnstr = null;
        if (sourceStr == null || oldString == null || newString == null || oldString.length == 0 || newString.length == 0) {
            return null;
        }
        if (oldString.length != newString.length) {
            return null;
        }
        int i = 0;
        while (i < oldString.length) {
            returnstr = TextUtil.replaceStr(sourceStr, oldString[i], newString[i]);
            sourceStr = returnstr.trim();
            ++i;
        }
        return returnstr;
    }

    public static int lengthOfChineseChar(String s) {
        int len = 0;
        if (s == null) {
            return 0;
        }
        int i = 0;
        while (i < s.length()) {
            len = s.charAt(i) >= '\u0080' ? (len += 2) : ++len;
            ++i;
        }
        return len;
    }

    public static String getFileExtName(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."), fileName.length());
    }

    public static String strAppendChr(String str, int strLen, String ch) {
        if (Tools.isEmpty(str) || Tools.isEmpty(ch) || strLen == 0) {
            return str;
        }
        if (str.length() >= strLen) {
            return str;
        }
        int j = strLen - str.length();
        int i = 0;
        while (i < j) {
            str = String.valueOf(str) + ch;
            ++i;
        }
        return str;
    }

    public static String strInsertChr(String str, int strLen, String ch) {
        if (Tools.isEmpty(str) || Tools.isEmpty(ch) || strLen == 0) {
            return str;
        }
        if (str.length() >= strLen) {
            return str;
        }
        int j = strLen - str.length();
        int i = 0;
        while (i < j) {
            str = String.valueOf(ch) + str;
            ++i;
        }
        return str;
    }

    public static String numberFormat(double parameter, int digit) {
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < digit) {
            temp.append("0");
            ++i;
        }
        DecimalFormat df2 = new DecimalFormat("###0." + temp.toString());
        String replaceFormat = df2.format(parameter);
        String afterReplaceFormat = "";
        try {
            afterReplaceFormat = replaceFormat.replaceAll(",", "\\.");
        }
        catch (Exception ex) {
            afterReplaceFormat = replaceFormat;
        }
        return afterReplaceFormat;
    }

    public static String numberFormat(String parameter, int digit) {
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < digit) {
            temp.append("0");
            ++i;
        }
        DecimalFormat df2 = new DecimalFormat("###0." + temp.toString());
        if (parameter != null && !"".equals(parameter.trim()) && !"null".equals(parameter)) {
            String replaceFormat = df2.format(Double.parseDouble(parameter));
            String afterReplaceFormat = "";
            try {
                afterReplaceFormat = replaceFormat.replaceAll(",", "\\.");
            }
            catch (Exception ex) {
                afterReplaceFormat = replaceFormat;
            }
            return afterReplaceFormat;
        }
        return "";
    }

    public String replaceAll(String text, char c, String str) {
        String temp = text;
        int leng = 0;
        int index = text.indexOf(c);
        while (index != -1) {
            leng = text.length();
            temp = String.valueOf(text.substring(0, index)) + str;
            if (index + 1 <= leng) {
                temp = String.valueOf(temp) + text.substring(index + 1, leng);
            }
            text = temp;
            index = text.indexOf(c);
        }
        return temp;
    }

    public static long stringFormat(String s, int radix) {
        return Long.parseLong(s, radix);
    }

    public static String strFlowFormat(Double i) {
        FluxUnitBean fluxInstance = FluxUnitBean.getInstance();
        double kb = 1024.0;
        double mb = 1048576.0;
        double gb = 1.073741824E9;
        double kbValue = 1024.0;
        double mbValue = 1048576.0;
        double gbValue = 1.073741824E9;
        try {
            kb = Double.parseDouble(fluxInstance.getFluxKBThreshold());
            mb = Double.parseDouble(fluxInstance.getFluxMBThreshold());
            gb = Double.parseDouble(fluxInstance.getFluxGBThreshold());
            kbValue = Double.parseDouble(fluxInstance.getFluxKBValue());
            mbValue = Double.parseDouble(fluxInstance.getFluxMBValue());
            gbValue = Double.parseDouble(fluxInstance.getFluxGBValue());
        }
        catch (Exception e) {
            log.error("srFlowFormat getflux value error......");
        }
        String returnint = "";
        LanguageBean lb = CustomizeInit.getLanguageBean();
        if (i / mb < 1.0) {
            returnint = Tools.numberFormat(i / kbValue, 2);
            returnint = String.valueOf(returnint) + " " + fluxInstance.getFluxKBLang();
            return returnint;
        }
        if (i / mb >= 1.0 && i / gb < 1.0) {
            returnint = Tools.numberFormat(i / mbValue, 2);
            returnint = String.valueOf(returnint) + " " + fluxInstance.getFluxMBLang();
            return returnint;
        }
        if (i / gb >= 1.0) {
            returnint = String.valueOf(Tools.numberFormat(i / gbValue, 2)) + " " + fluxInstance.getFluxGBLang();
            return returnint;
        }
        return returnint;
    }

    public static String strFlowFormat(String m) {
        Double kb = 1024.0;
        Double mb = 1048576.0;
        Double gb = 1.073741824E9;
        String returnint = "";
        LanguageBean lb = CustomizeInit.getLanguageBean();
        Double i = (double)Double.valueOf(m);
        returnint = TextUtil.strFlowFormat(i);
        return returnint;
    }

    public static String strFlowFormat(Float i) {
        Float kb = Float.valueOf(1024.0f);
        Float mb = Float.valueOf(1048576.0f);
        Float gb = Float.valueOf(1.0737418E9f);
        String returnint = "";
        LanguageBean lb = CustomizeInit.getLanguageBean();
        if (i.floatValue() / kb.floatValue() < 1.0f || i.floatValue() / kb.floatValue() >= 1.0f && i.floatValue() / mb.floatValue() < 1.0f) {
            returnint = String.valueOf(Tools.numberFormat(i.floatValue() / kb.floatValue(), 2)) + " " + lb.getOperation_2_MouseRighKeytMenu_KB();
            if (returnint.equals("1024.00 " + lb.getOperation_2_MouseRighKeytMenu_KB())) {
                returnint = "1.00 " + lb.getOperation_2_MouseRighKeytMenu_MB();
            }
            return returnint;
        }
        if (i.floatValue() / mb.floatValue() >= 1.0f && i.floatValue() / gb.floatValue() < 1.0f) {
            returnint = String.valueOf(Tools.numberFormat(i.floatValue() / mb.floatValue(), 2)) + " " + lb.getOperation_2_MouseRighKeytMenu_MB();
            if (returnint.equals("1024.00 " + lb.getOperation_2_MouseRighKeytMenu_MB())) {
                returnint = "1.00 " + lb.getOperation_2_MouseRighKeytMenu_GB();
            }
            return returnint;
        }
        if (i.floatValue() / gb.floatValue() >= 1.0f) {
            returnint = String.valueOf(Tools.numberFormat(i.floatValue() / gb.floatValue(), 2)) + " " + lb.getOperation_2_MouseRighKeytMenu_GB();
            return returnint;
        }
        return returnint;
    }

    public static String strFlowFormatSpeed(double i) {
        FluxUnitBean fluxInstance = FluxUnitBean.getInstance();
        double kb = 125.0;
        double mb = 125000.0;
        double kbValue = 125.0;
        double mbValue = 125000.0;
        try {
            kb = Double.parseDouble(fluxInstance.getFluxSpeedkbpsThreshold());
            mb = Double.parseDouble(fluxInstance.getFluxSpeedMbpsThreshold());
            kbValue = Double.parseDouble(fluxInstance.getFluxSpeedkbpsValue());
            mbValue = Double.parseDouble(fluxInstance.getFluxSpeedMbpsValue());
        }
        catch (Exception e) {
            log.error("srFlowFormat getfluxSpeed value error......");
        }
        String returnint = "";
        LanguageBean lb = CustomizeInit.getLanguageBean();
        if (i / mb < 1.0) {
            returnint = String.valueOf(Tools.numberFormat(i / kbValue, 2)) + " " + fluxInstance.getFluxSpeedkbpsLang();
        }
        if (i / mb >= 1.0) {
            returnint = String.valueOf(Tools.numberFormat(i / mbValue, 2)) + " " + fluxInstance.getFluxSpeedMbpsLang();
        }
        return returnint;
    }

    public static boolean checkContainStr(String src, String desc) {
        if (src != null && desc != null) {
            src = src.toLowerCase();
            desc = desc.toLowerCase();
        }
        return src.indexOf(desc) > -1;
    }

    public static boolean checkContainStr2(String src, String desc) {
        return src != null && src.indexOf(desc) > -1;
    }

    public static boolean checkContainStr(String src, String[] desc) {
        boolean flag = false;
        int i = 0;
        while (i < desc.length) {
            if (TextUtil.checkContainStr(Tools.checkNull(src), desc[i])) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    public static String parseStr(String str) {
        if (str.length() > 0) {
            int i = 0;
            while (i < str.length()) {
                if (!"0".equals(str.substring(i, i + 1))) {
                    return str.substring(i);
                }
                ++i;
            }
        }
        return str;
    }

    public static String add(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).toString();
    }

    public static String div(String v1, String v2, int scale) {
        BigDecimal b1 = null;
        BigDecimal b2 = null;
        try {
            b1 = new BigDecimal(v1);
            b2 = new BigDecimal(v2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b1.divide(b2, scale, 5).toString();
    }

    public static String round(String v, int scale) {
        BigDecimal b = new BigDecimal(v);
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).toString();
    }

    public static String getBetweenString(String receiveContext, String par1) {
        String returnstr = "";
        try {
            String receiveContext1 = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext1 = TextUtil.replaceStr(receiveContext1, "\r", "");
            receiveContext1 = TextUtil.rRight(receiveContext1, par1);
            returnstr = TextUtil.replaceStr(receiveContext1, "OK", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnstr;
    }

    public static String getBetweenString1(String receiveContext, String par1) {
        String returnstr = "";
        try {
            String receiveContext1 = TextUtil.replaceStr(receiveContext, "\n", "");
            receiveContext1 = TextUtil.replaceStr(receiveContext, "\r", "");
            receiveContext1 = TextUtil.replaceStr(receiveContext, " ", "");
            par1 = TextUtil.replaceStr(par1, " ", "");
            receiveContext1 = TextUtil.rRight(receiveContext1, par1);
            returnstr = TextUtil.replaceStr(receiveContext1, "OK", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnstr;
    }

    public static String rLeft1(String source, String sep) {
        String retstr = "";
        try {
            if (!Tools.isEmpty(source)) {
                source = TextUtil.replaceStr(source, "\n", "");
                source = TextUtil.replaceStr(source, "\r", "");
                int i = (source = source.toLowerCase()).indexOf(sep = sep.toLowerCase());
                if (i > 0) {
                    retstr = source.substring(0, i);
                }
                String[] sore = new String[]{"e"};
                if (retstr != null && TextUtil.checkContainStr(retstr, sore)) {
                    retstr = retstr.substring(retstr.indexOf("e"), retstr.length());
                    return retstr;
                }
                if (retstr != null && retstr.length() >= 15) {
                    String dd = "";
                    if (retstr.lastIndexOf(".") > -1) {
                        dd = retstr.substring(retstr.lastIndexOf("."));
                    }
                    retstr = dd.length() == 4 ? retstr.substring(retstr.length() - 16, retstr.length()) : retstr.substring(retstr.length() - 15, retstr.length());
                    return retstr;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retstr;
    }

    public static String rLeft2(String source, String sep) {
        String retstr;
        block6: {
            retstr = "";
            try {
                if (Tools.isEmpty(source)) break block6;
                String[] bufArray = source.replaceAll("\r", "").split("\n");
                int length = bufArray.length;
                int i = 0;
                while (i < length) {
                    if (!"".equals(bufArray[i]) && "OK".equals(bufArray[i]) && i - 1 >= 0) {
                        if (!"".equals(bufArray[i - 1])) {
                            retstr = bufArray[i - 1];
                            break;
                        }
                        if (i - 2 >= 0) {
                            retstr = bufArray[i - 2];
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retstr;
    }

    public static String splitMatch(String source, String sep1) {
        String retstr = "";
        try {
            if (!Tools.isEmpty(source) && !Tools.isEmpty(sep1)) {
                String[] bufArray = source.replaceAll("\r", "").split("\n");
                int length = bufArray.length;
                int i = 0;
                while (i < length) {
                    if (!"".equals(bufArray[i]) && bufArray[i].startsWith(sep1)) {
                        int len = sep1.length();
                        bufArray[i] = bufArray[i].substring(len).trim();
                        return bufArray[i];
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retstr;
    }

    public static String splitStr(String source, String sep1) {
        try {
            if (!Tools.isEmpty(source)) {
                String bufArray = source.replaceAll("\r", "");
                int len = sep1.length();
                bufArray = bufArray.substring(len).trim();
                return bufArray;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static List grouping(List list) {
        ArrayList returnSordList = null;
        if (list != null && list.size() > 0) {
            HashSet set = new HashSet();
            set.addAll(list);
            list.clear();
            list.addAll(set);
            Collections.sort(list);
            String dd = "";
            ArrayList<String> tempList = null;
            ArrayList returnList = null;
            HashSet<HashSet> all = new HashSet<HashSet>();
            HashSet group = new HashSet();
            all.add(group);
            boolean newflag = false;
            int i = 0;
            while (i < list.size()) {
                if (newflag) {
                    group = new HashSet();
                    all.add(group);
                    newflag = false;
                }
                group.add(list.get(i));
                if (i < list.size() - 1) {
                    String m1 = Tools.checkNull(list.get(i + 1));
                    String m2 = Tools.checkNull(list.get(i));
                    if (Integer.parseInt(m1.substring(m1.length() - 2)) - Integer.parseInt(m2.substring(m2.length() - 2)) != 1) {
                        newflag = true;
                    }
                }
                ++i;
            }
            TreeSet ts1 = new TreeSet(group);
            ts1.comparator();
            Iterator itAll = all.iterator();
            returnList = new ArrayList();
            while (itAll.hasNext()) {
                tempList = new ArrayList<String>();
                group = (HashSet)itAll.next();
                TreeSet ts = new TreeSet(group);
                ts.comparator();
                Iterator itG = ts.iterator();
                boolean i2 = false;
                while (itG.hasNext()) {
                    dd = Tools.checkNull(itG.next());
                    tempList.add(dd);
                }
                returnList.add(tempList);
            }
            returnSordList = new ArrayList();
            if (returnList != null && returnList.size() > 0) {
                int i3 = 0;
                while (i3 < returnList.size()) {
                    returnSordList.add(returnList.get(returnList.size() - i3 - 1));
                    ++i3;
                }
            }
        }
        return returnSordList;
    }

    public static <T> int[] reduplicateIndex(List<T> list, T str) throws Exception {
        List<Object> tmp = new ArrayList<T>(list);
        int[] index = new int[Collections.frequency(list, str)];
        int start = tmp.indexOf(str);
        int end = tmp.lastIndexOf(str);
        int i = 0;
        if (start < 0) {
            throw new Exception("\u6570\u7ec4\u4e2d\u4e0d\u5b58\u5728   " + str + "   \u5143\u7d20\uff01 ");
        }
        index[i] = start;
        while (start != end) {
            index[++i] = end;
            tmp = tmp.subList(0, end);
            end = tmp.lastIndexOf(str);
        }
        Arrays.sort(index);
        return index;
    }

    public static List searchdupData(List list, String dupDate) {
        int[] indexArray = null;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        if (list != null) {
            try {
                int[] nArray = indexArray = TextUtil.reduplicateIndex(list, dupDate);
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int index = nArray[n];
                    Tools.logToControl("err", list.get(index).toString());
                    ++n;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (indexArray != null && indexArray.length > 0) {
            int i = 0;
            while (i < indexArray.length) {
                list1.add(indexArray[i]);
                ++i;
            }
        }
        return list1;
    }

    public static List removeDuplicateWithOrder(ArrayList arlList) {
        HashSet set = new HashSet();
        ArrayList newList = new ArrayList();
        for (Object element : arlList) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        arlList.clear();
        arlList.addAll(newList);
        return arlList;
    }

    public static void removeDuplicate(ArrayList arlList) {
        HashSet h = new HashSet(arlList);
        arlList.clear();
        arlList.addAll(h);
    }

    public static List searchDuplicate(List list) {
        ArrayList<Integer> returnlist = new ArrayList<Integer>();
        try {
            int i = 0;
            while (i < list.size() - 1) {
                int j = list.size() - 1;
                while (j > i) {
                    if (list.get(j).equals(list.get(i))) {
                        returnlist.add(j);
                    }
                    --j;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Tools.logToControl("err", "returnlist=" + returnlist);
        return TextUtil.removeDuplicateWithOrder(returnlist);
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("050003C90201");
        list.add("050003C90201");
        list.add("050003C90202");
        list.add("050003CA0201");
        list.add("050003C90202");
        Tools.logToControl("err", TextUtil.searchDuplicate(list));
    }
}

