/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.common.util;

import com.huawei.mobilePartner.business.sms.smsset.CommandCheckBox;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.NetWorkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;

public class JUTPSCheckBoxDialog
extends JDialog {
    public Component parentComponent = null;
    protected transient String message;
    String title;
    static String path;
    public static int buttonId;
    JDialog dialog;
    private static final int height = 150;
    LanguageBean lb = CustomizeInit.getLanguageBean();
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private JCheckBox checkBox = null;
    static boolean hasCancelButton;

    static {
        buttonId = 0;
        hasCancelButton = false;
    }

    public JUTPSCheckBoxDialog() {
        super(AppFrame.getAppFrameInit());
        Tools.changeDialogAppearance(this);
        this.setModal(true);
        this.dialog = this;
        this.setAlwaysOnTop(true);
        this.pack();
        this.init(false);
        XMLTool.setImportExport(true);
        XMLTool xmltool = new XMLTool();
        path = String.valueOf(XMLTool.getClassPath()) + "/config/images/";
        path = TextUtil.replaceStr1(path, "\\/", "/");
        path = TextUtil.replaceStr1(path, "\\", "/");
    }

    public JUTPSCheckBoxDialog(Component parentComponent, String message, String title, boolean hasCancelButton) {
        super(AppFrame.getAppFrameInit());
        JUTPSCheckBoxDialog.hasCancelButton = hasCancelButton;
        Tools.changeDialogAppearance(this);
        if (path == null) {
            XMLTool.setImportExport(true);
            XMLTool xmltool = new XMLTool();
            path = String.valueOf(XMLTool.getClassPath()) + "/config/images/";
            path = TextUtil.replaceStr1(path, "\\/", "/");
            path = TextUtil.replaceStr1(path, "\\", "/");
        }
        this.setModal(true);
        this.dialog = this;
        this.setAlwaysOnTop(true);
        this.pack();
        this.message = message;
        this.setTitle(title);
        this.parentComponent = parentComponent;
        this.init(hasCancelButton);
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            buttonId = 1;
            this.dispose();
        } else {
            super.processWindowEvent(e);
        }
    }

    public void init(boolean hasCancelButton) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getSouthPanel(hasCancelButton), "South");
        String[] messageArr = this.message.split("<br>");
        if (messageArr.length > 0) {
            this.setSize(125 + this.message.getBytes().length * 6 / messageArr.length, 150);
        } else {
            this.setSize(85 + this.message.getBytes().length * 6, 150);
        }
        Tools.showWindowCenter(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.pack();
            super.setVisible(true);
            Graphics g = this.getOwner().getGraphics();
            FontMetrics fm = g.getFontMetrics();
            int wordWid = 0;
            if (this.message != null) {
                wordWid = fm.stringWidth(this.message);
            }
            int wid = wordWid + 200;
            this.setSize(new Dimension(wid, 150));
            this.setPreferredSize(new Dimension(wid, 150));
            this.pack();
        } else {
            super.setVisible(false);
        }
    }

    private JPanel getCenterPanel() {
        JPanel CenterPanel = new JPanel(new BorderLayout());
        JLabel jtextArea = new JLabel(this.message);
        jtextArea.setBackground(CenterPanel.getBackground());
        jtextArea.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 50, ChangeColor.getColor(CustomizeInit.getCustomizeBean().getAppFrame_createConnManagePanel_2())));
        jtextArea.setAlignmentX(0.75f);
        jtextArea.setFocusable(false);
        jtextArea.setFont(Tools.setFont());
        JButton newContactButton = new JButton();
        GetButtonBackground.setButtonBackground(newContactButton);
        newContactButton.setIcon(new ImageIcon(String.valueOf(path) + this.cb.getImages_mobile()));
        newContactButton.setMaximumSize(new Dimension(29, 28));
        newContactButton.setBorder(BorderFactory.createMatteBorder(10, 20, 0, 10, ChangeColor.getColor(CustomizeInit.getCustomizeBean().getAppFrame_createConnManagePanel_2())));
        newContactButton.setOpaque(false);
        newContactButton.setContentAreaFilled(false);
        newContactButton.setFocusable(false);
        newContactButton.setFont(Tools.setFont());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(0);
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setResizeWeight(0.3);
        splitPane.setLeftComponent(newContactButton);
        splitPane.setRightComponent(jtextArea);
        splitPane.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getAppFrame_createConnManagePanel_2()));
        CenterPanel.add((Component)splitPane, "Center");
        return CenterPanel;
    }

    public static void showWindowCenter(JDialog dailog) {
        Dimension screenSize = AppFrame.getAppFrameInit().getSize();
        Dimension frameSize = dailog.getSize();
        if (AppFrame.getAppFrameInit().getExtendedState() == 6) {
            dailog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        } else {
            dailog.setLocation(AppFrame.getAppFrameInit().getX() + (screenSize.width - frameSize.width) / 2, AppFrame.getAppFrameInit().getY() + (screenSize.height - frameSize.height) / 2);
        }
    }

    private JPanel getSouthPanel(boolean hasCancelButton) {
        JPanel southPanel = new JPanel(new GridBagLayout());
        southPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getAppFrame_createConnManagePanel_2()));
        JButton okButton = new JButton(this.lb.getTools_3_OK());
        okButton.setMaximumSize(new Dimension(100, 25));
        okButton.setMinimumSize(new Dimension(100, 25));
        okButton.setPreferredSize(new Dimension(100, 25));
        okButton.setFont(Tools.setFont());
        GetButtonBackground.setButtonBackground(okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                buttonId = 0;
                JUTPSCheckBoxDialog.this.dialog.dispose();
            }
        });
        okButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    buttonId = 0;
                    JUTPSCheckBoxDialog.this.dialog.dispose();
                }
            }
        });
        JButton cancel = new JButton(this.lb.getTools_3_Cancel());
        cancel.setMaximumSize(new Dimension(100, 25));
        cancel.setMinimumSize(new Dimension(100, 25));
        cancel.setPreferredSize(new Dimension(100, 25));
        cancel.setFont(Tools.setFont());
        GetButtonBackground.setButtonBackground(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                buttonId = 1;
                JUTPSCheckBoxDialog.this.dialog.dispose();
            }
        });
        cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    buttonId = 1;
                    JUTPSCheckBoxDialog.this.dialog.dispose();
                }
            }
        });
        this.checkBox = new CommandCheckBox(this.lb.getRoaming_dialog_no_prompt(), southPanel);
        this.checkBox.setFont(Tools.setFont());
        this.checkBox.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NetWorkPanel.saveRoamSetting(JUTPSCheckBoxDialog.this.checkBox, true);
            }
        });
        if ("true".equals(Tools.getRoamingAlertControl())) {
            southPanel.add((Component)this.checkBox, new GridBagConstraints(0, 0, 1, 1, 12.0, 12.0, 10, 2, new Insets(6, 70, 6, 12), 0, 0));
        }
        if (!hasCancelButton) {
            southPanel.add((Component)okButton, new GridBagConstraints(0, 1, 1, 1, 12.0, 12.0, 13, 2, new Insets(6, 150, 6, 150), 0, 0));
        } else {
            southPanel.add((Component)okButton, new GridBagConstraints(0, 1, 1, 1, 12.0, 12.0, 17, 2, new Insets(6, 170, 6, 290), 0, 0));
            southPanel.add((Component)cancel, new GridBagConstraints(0, 1, 1, 1, 12.0, 12.0, 13, 2, new Insets(6, 290, 6, 170), 0, 0));
        }
        return southPanel;
    }

    public static int showConfirmDialog(Component parentComponent, String message, String title, boolean hasCancelButton) throws HeadlessException {
        new JUTPSCheckBoxDialog(parentComponent, message, title, hasCancelButton);
        return buttonId;
    }
}

