/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.common.log;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class LogConfig {
    private static Layout layout = null;
    private static String key = "mobilePartner";
    private static HashMap para = null;
    private static Logger logger = null;
    private static String sLevel = Log.sLevel;
    private static RollingFileAppender appender = null;
    private static LogConfig log = null;
    private String charSet = "UTF-8";
    private String flag = "0";
    private static String classpath = null;

    public static LogConfig getInstance(Class clazz) {
        classpath = clazz.toString();
        if (log == null) {
            log = new LogConfig(clazz);
        }
        return log;
    }

    private LogConfig(Class clazz) {
        para = new HashMap();
        logger = Logger.getLogger(clazz);
    }

    private static void setLevel(String msg, int m) {
        if (Tools.isEmpty(sLevel)) {
            sLevel = "ERROR";
        }
        if ("FATAL".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.FATAL);
            if (m != 0 && m == 1) {
                logger.fatal("[" + classpath + "] message: " + msg);
            }
        }
        if ("ERROR".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.ERROR);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal("[" + classpath + "] message: " + msg);
                } else if (m == 2) {
                    logger.error("[" + classpath + "] message: " + msg);
                }
            }
        }
        if ("WARN".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.WARN);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal("[" + classpath + "] message: " + msg);
                } else if (m == 2) {
                    logger.error("[" + classpath + "] message: " + msg);
                } else if (m == 3) {
                    logger.warn("[" + classpath + "] message: " + msg);
                }
            }
        }
        if ("info".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.INFO);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal("[" + classpath + "] message: " + msg);
                } else if (m == 2) {
                    logger.error("[" + classpath + "] message: " + msg);
                } else if (m == 3) {
                    logger.warn("[" + classpath + "] message: " + msg);
                } else if (m == 4) {
                    logger.debug("[" + classpath + "] message: " + msg);
                } else if (m == 5) {
                    logger.info("[" + classpath + "] message: " + msg);
                }
            }
        }
        if ("DEBUG".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.DEBUG);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal("[" + classpath + "] message: " + msg);
                } else if (m == 2) {
                    logger.error("[" + classpath + "] message: " + msg);
                } else if (m == 3) {
                    logger.warn("[" + classpath + "] message: " + msg);
                } else if (m == 4) {
                    logger.debug("[" + classpath + "] message: " + msg);
                }
            }
        }
        if ("all".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.INFO);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal("[" + classpath + "] message: " + msg);
                } else if (m == 2) {
                    logger.error("[" + classpath + "] message: " + msg);
                } else if (m == 3) {
                    logger.warn("[" + classpath + "] message: " + msg);
                } else if (m == 4) {
                    logger.debug("[" + classpath + "] message: " + msg);
                } else if (m == 5) {
                    logger.info("[" + classpath + "] message: " + msg);
                }
            }
        }
    }

    private void setPath(String key) {
        try {
            if (para.size() > 0) {
                appender.setFile((String)para.get(key));
            } else {
                appender.setFile(null);
            }
            appender.activateOptions();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void createFileName(String key, String fileName) {
        block15: {
            try {
                File file = null;
                String name = (String)para.get(key);
                if (name == null && !(file = new File(fileName)).exists()) {
                    para.put(key, fileName);
                }
                if (appender == null) {
                    if (file.exists()) {
                        try {
                            FileOutputStream output = new FileOutputStream(file, false);
                            ((OutputStream)output).close();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (layout == null) {
                        layout = new PatternLayout(Log.filelayoutConversionPattern);
                    }
                    appender = new RollingFileAppender(layout, fileName);
                    appender.setMaxBackupIndex(Log.log4jappenderfileMaxBackupIndex);
                    appender.setMaxFileSize(Log.log4jappenderfileMaxFileSize);
                    appender.setEncoding(this.charSet);
                    ConsoleAppender capp = new ConsoleAppender(new PatternLayout(Log.consolelayoutConversionPattern));
                    String[] arr = Log.sLevelarr;
                    if (arr != null) {
                        int i = 0;
                        while (i < arr.length) {
                            if (TextUtil.checkContainStr(Tools.checkNull(arr[i]), "console")) {
                                logger.addAppender(capp);
                            }
                            if (TextUtil.checkContainStr(Tools.checkNull(arr[i]), "file")) {
                                logger.addAppender(appender);
                            }
                            ++i;
                        }
                    }
                    break block15;
                }
                appender.setAppend(true);
                appender.setFile(fileName);
                String[] arr = Log.sLevelarr;
                if (arr != null) {
                    int i = 0;
                    while (i < arr.length) {
                        if (TextUtil.checkContainStr(Tools.checkNull(arr[i]), "file")) {
                            logger.addAppender(appender);
                        }
                        ++i;
                    }
                }
                appender.activateOptions();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setParam(String key, String msg, int m) {
        LogConfig.setLevel(msg, m);
        this.setPath(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg) {
        LogConfig logConfig = log;
        synchronized (logConfig) {
            try {
                this.setParam(key, msg, 5);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogConfig Error(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatal(String msg) {
        LogConfig logConfig = log;
        synchronized (logConfig) {
            try {
                this.setParam(key, msg, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogConfig fatal(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg) {
        LogConfig logConfig = log;
        synchronized (logConfig) {
            try {
                this.setParam(key, msg, 4);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogConfig debug(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg) {
        LogConfig logConfig = log;
        synchronized (logConfig) {
            try {
                this.setParam(key, msg, 3);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogConfig warn(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg) {
        LogConfig logConfig = log;
        synchronized (logConfig) {
            try {
                this.setParam(key, msg, 2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogConfig Error(String msg) Upload Error.");
            }
        }
    }
}

