/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.common.log;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class LogATConfig {
    private static Layout layout = null;
    private static String key = "mobilePartnerAT";
    private static HashMap para = null;
    private static Logger logger = null;
    private static String sLevel = Log.sLevelAt;
    private static RollingFileAppender appender = null;
    private static LogATConfig log = null;
    private String charSet = "UTF-8";
    private static String classpath = null;

    public static LogATConfig getLogATInstance(Class clazz) {
        classpath = clazz.toString();
        if (log == null) {
            log = new LogATConfig(clazz);
        }
        return log;
    }

    private LogATConfig(Class clazz) {
        para = new HashMap();
        logger = Logger.getLogger(clazz);
    }

    private static void setLevel(String msg, int m) {
        if (Tools.isEmpty(sLevel)) {
            sLevel = "ERROR";
        }
        if ("FATAL".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.FATAL);
            if (m != 0 && m == 1) {
                logger.fatal(" message: " + msg);
            }
        }
        if ("ERROR".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.ERROR);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal(" message: " + msg);
                } else if (m == 2) {
                    logger.error(" message: " + msg);
                }
            }
        }
        if ("WARN".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.WARN);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal(" message: " + msg);
                } else if (m == 2) {
                    logger.error(" message: " + msg);
                } else if (m == 3) {
                    logger.warn(" message: " + msg);
                }
            }
        }
        if ("info".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.INFO);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal(" message: " + msg);
                } else if (m == 2) {
                    logger.error(" message: " + msg);
                } else if (m == 3) {
                    logger.warn(" message: " + msg);
                } else if (m == 4) {
                    logger.debug(" message: " + msg);
                } else if (m == 5) {
                    logger.info(" message: " + msg);
                }
            }
        }
        if ("DEBUG".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.DEBUG);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal(" message: " + msg);
                } else if (m == 2) {
                    logger.error(" message: " + msg);
                } else if (m == 3) {
                    logger.warn(" message: " + msg);
                } else if (m == 4) {
                    logger.debug(" message: " + msg);
                }
            }
        }
        if ("all".equalsIgnoreCase(sLevel)) {
            logger.setLevel(Level.INFO);
            if (m != 0) {
                if (m == 1) {
                    logger.fatal(" message: " + msg);
                } else if (m == 2) {
                    logger.error(" message: " + msg);
                } else if (m == 3) {
                    logger.warn(" message: " + msg);
                } else if (m == 4) {
                    logger.debug(" message: " + msg);
                } else if (m == 5) {
                    logger.info(" message: " + msg);
                }
            }
        }
    }

    private void setPath(String key) {
        try {
            if (para.size() > 0) {
                appender.setFile((String)para.get(key));
            } else {
                appender.setFile(null);
            }
            appender.activateOptions();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void createFileName(String key, String fileName) {
        block12: {
            try {
                File file = null;
                String name = (String)para.get(key);
                if (name == null && !(file = new File(fileName)).exists()) {
                    para.put(key, fileName);
                }
                if (appender == null) {
                    if (file.exists()) {
                        try {
                            FileOutputStream output = new FileOutputStream(file, false);
                            ((OutputStream)output).close();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (layout == null) {
                        layout = new PatternLayout(Log.filelayoutConversionPatternAT);
                    }
                    String[] arr = Log.sLevelAtarr;
                    appender = new RollingFileAppender(layout, fileName);
                    appender.setMaxBackupIndex(Log.log4jappenderfileMaxBackupIndexAT);
                    appender.setMaxFileSize(Log.log4jappenderfileMaxFileSizeAT);
                    appender.setEncoding(this.charSet);
                    ConsoleAppender capp = new ConsoleAppender(new PatternLayout(Log.consolelayoutConversionPatternAT));
                    if (arr != null) {
                        int i = 0;
                        while (i < arr.length) {
                            if (TextUtil.checkContainStr(Tools.checkNull(arr[i]), "console")) {
                                logger.addAppender(capp);
                            }
                            if (TextUtil.checkContainStr(Tools.checkNull(arr[i]), "file")) {
                                logger.addAppender(appender);
                            }
                            ++i;
                        }
                    }
                    break block12;
                }
                appender.setAppend(true);
                appender.setFile(fileName);
                appender.activateOptions();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setParam(String key, String msg, int m) {
        LogATConfig.setLevel(msg, m);
        this.setPath(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg) {
        LogATConfig logATConfig = log;
        synchronized (logATConfig) {
            try {
                this.setParam(key, msg, 5);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogATConfig info(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatal(String msg) {
        LogATConfig logATConfig = log;
        synchronized (logATConfig) {
            try {
                this.setParam(key, msg, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogATConfig fatal(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg) {
        LogATConfig logATConfig = log;
        synchronized (logATConfig) {
            try {
                this.setParam(key, msg, 4);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogATConfig debug(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg) {
        LogATConfig logATConfig = log;
        synchronized (logATConfig) {
            try {
                this.setParam(key, msg, 3);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogATConfig warn(String msg) Upload Error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg) {
        LogATConfig logATConfig = log;
        synchronized (logATConfig) {
            try {
                this.setParam(key, msg, 2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Tools.logToControl("err", "LogATConfig error(String msg) Upload Error.");
            }
        }
    }
}

