/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.ussd;

import com.huawei.mobilePartner.business.telephoneBook.commserver.TelHomeCode;
import com.huawei.mobilePartner.common.util.GFString;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;

public class UssdCode {
    public String enCodeUssd(String str) {
        String encode = "";
        if (str == null || str == "") {
            return encode;
        }
        encode = TelHomeCode.isChinaCode(encode) ? TelHomeCode.gb2unicode(encode) : this.encode7bit(str);
        return encode;
    }

    public String getDecode(String str, String type) {
        String decode = "";
        str = Tools.checkNull(str);
        if ((str = TextUtil.replaceStr2(str, "\"", "")) == null || str == "" || type == null || type == "") {
            return "";
        }
        if (type.equals("15")) {
            decode = this.decode7bit(str);
        } else if (type.equals("72")) {
            decode = TelHomeCode.unicode2gb(str);
        } else {
            return "";
        }
        return decode;
    }

    public String encode7bit(String src) {
        String result = null;
        String hex = null;
        if (src != null || src != "") {
            result = "";
            byte left = 0;
            byte[] b = src.getBytes();
            int i = 0;
            int j = 0;
            while (i < b.length) {
                j = i & 7;
                if (j == 0) {
                    left = b[i];
                } else {
                    byte value = (byte)(b[i] << 8 - j | left);
                    left = (byte)(b[i] >> j);
                    hex = GFString.byte2hex(value);
                    result = String.valueOf(result) + hex;
                    if (i == b.length - 1) {
                        result = String.valueOf(result) + GFString.byte2hex(left);
                    }
                }
                ++i;
            }
            if (src.length() % 8 == 0) {
                result = result.substring(0, result.length() - 2);
            }
            if (src.length() % 9 == 0) {
                String temp = Integer.toBinaryString(b[b.length - 1]);
                int i2 = 0;
                while (i2 < 8) {
                    if (temp.length() >= 8) break;
                    temp = "0" + temp;
                    ++i2;
                }
                temp = Integer.toHexString(Integer.parseInt(temp, 2));
                result = String.valueOf(result) + temp;
            }
            if ((result = result.toUpperCase()) == "") {
                char[] data = src.toCharArray();
                int dataChar = 0;
                int i3 = 0;
                while (i3 < data.length) {
                    dataChar = data[i3];
                    ++i3;
                }
                result = Integer.toHexString(dataChar);
                result = result.toUpperCase();
            }
        }
        return result;
    }

    public String decode7bit(String src) {
        String result = null;
        String temp = null;
        int left = 0;
        if (src != null && src.length() % 2 == 0) {
            result = "";
            int[] b = new int[src.length() / 2];
            temp = String.valueOf(src) + "0";
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < temp.length() - 2) {
                b[j] = Integer.parseInt(temp.substring(i, i + 2), 16);
                k = j % 7;
                byte srcAscii = (byte)(b[j] << k & 0x7F | left);
                result = String.valueOf(result) + (char)srcAscii;
                left = (byte)(b[j] >>> 7 - k);
                if (k == 6) {
                    result = String.valueOf(result) + (char)left;
                    left = 0;
                }
                if (j == src.length() / 2) {
                    result = String.valueOf(result) + (char)left;
                }
                i += 2;
                ++j;
            }
        }
        return result.trim();
    }

    public static void main(String[] args) {
        UssdCode ussd = new UssdCode();
        String str = "#*11##!01*";
        Tools.logToControl("err", "source= " + str);
        Tools.logToControl("err", "encode= " + ussd.encode7bit(str));
        Tools.logToControl("err", "decode= " + ussd.decode7bit("23552C361A85603115"));
    }
}

