/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update.tool;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipBean {
    private static LogConfig log = Log.getLog(ZipBean.class);

    public void zip(String zipFileName, String inputFile) throws Exception {
        log.info("zip(String zipFileName, String inputFile)");
        this.zip(zipFileName, new File(inputFile));
    }

    public void zip(String zipFileName, File inputFile) throws Exception {
        log.info("zip(String zipFileName, File inputFile)");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        this.zip(out, inputFile, "");
        Tools.logToControl("err", "zip done");
        out.close();
    }

    public void unzip(String zipFileName, String outputDirectory) throws Exception {
        ZipEntry z;
        log.info("unzip(String zipFileName, String outputDirectory)");
        ZipInputStream in = new ZipInputStream(new FileInputStream(zipFileName));
        while ((z = in.getNextEntry()) != null) {
            int b;
            Tools.logToControl("err", "unziping " + z.getName());
            if (z.isDirectory()) {
                String name = z.getName();
                name = name.substring(0, name.length() - 1);
                File f = new File(String.valueOf(outputDirectory) + File.separator + name);
                f.mkdir();
                Tools.logToControl("err", "mkdir " + outputDirectory + File.separator + name);
                continue;
            }
            File f = new File(String.valueOf(outputDirectory) + File.separator + z.getName());
            f.createNewFile();
            FileOutputStream out = new FileOutputStream(f);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            out.close();
        }
        in.close();
    }

    public void zip(ZipOutputStream out, File f, String base) throws Exception {
        log.info("zip(ZipOutputStream out, File f, String base)");
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            out.putNextEntry(new ZipEntry(String.valueOf(base) + "/"));
            base = base.length() == 0 ? "" : String.valueOf(base) + "/";
            int i = 0;
            while (i < fl.length) {
                this.zip(out, fl[i], String.valueOf(base) + f.getName());
                ++i;
            }
        } else {
            int b;
            out.putNextEntry(new ZipEntry(base));
            FileInputStream in = new FileInputStream(f);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
        }
    }

    public static void main(String[] args) {
        try {
            ZipBean t = new ZipBean();
            t.zip("c:\\test.zip", "c:\\test");
            t.unzip("c:\\test.zip", "c:\\test2");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

