/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update.https;

import com.huawei.mobilePartner.business.update.DownloadFileState;
import com.huawei.mobilePartner.business.update.https.CustomSecureProtocolSocketFactory;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransfer {
    private static LogConfig log = Log.getLog(HttpTransfer.class);
    private static final HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());
    private static HttpTransfer httpTransfer = new HttpTransfer();
    private static int WAIT_TIMEOUT = 20000;

    public static HttpTransfer getInstant() {
        return httpTransfer;
    }

    private HttpTransfer() {
        this.init();
    }

    private void init() {
        httpClient.getParams().setSoTimeout(WAIT_TIMEOUT);
    }

    public void setPort(int logon_port, int logon_sslport) {
        this.setPort(logon_port, false);
        this.setPort(logon_sslport, true);
    }

    public void setPort(int logon_port, boolean isSSL) {
        if (isSSL) {
            Protocol myhttps = new Protocol("https", new CustomSecureProtocolSocketFactory(), logon_port);
            Protocol.registerProtocol("https", myhttps);
        } else {
            Protocol http = Protocol.getProtocol("http");
            Protocol myhttp = new Protocol("http", http.getSocketFactory(), logon_port);
            Protocol.registerProtocol("http", myhttp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testConnection(String ip, String port) {
        HttpMethodBase getMethod = null;
        try {
            getMethod = new GetMethod(this.convertURL("http://" + ip + ":" + port));
            getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            httpClient.executeMethod(getMethod);
            return true;
        }
        catch (HttpException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public byte[] login(String logon_site, String username, String pwd) throws HttpException, IOException {
        httpClient.getState().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, pwd));
        GetMethod get = new GetMethod(this.convertURL(logon_site));
        get.setDoAuthentication(true);
        int status = httpClient.executeMethod(get);
        if (status == 200) {
            return get.getResponseBody();
        }
        return null;
    }

    public byte[] getMethodRequest(String url) throws HttpException, IOException {
        HttpMethodBase getMethod = null;
        try {
            getMethod = new GetMethod(this.convertURL(url));
            getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            int statusCode = httpClient.executeMethod(getMethod);
            if (statusCode == 200) {
                byte[] byArray = getMethod.getResponseBody();
                return byArray;
            }
            return null;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public void downlandFile(String url, List<DownloadFileState> fileList, String savePath) throws HttpException, IOException, InterruptedException {
        int i = 0;
        while (i < fileList.size()) {
            DownloadFileState downloadFileState = fileList.get(i);
            String downlandurl = String.valueOf(url) + downloadFileState.getFilename();
            String file = String.valueOf(savePath) + downloadFileState.getFilename();
            this.downlandFile(downlandurl, file);
            ++i;
        }
    }

    public void downlandFile(String url, String filename) throws HttpException, IOException, InterruptedException {
        GetMethod getMethod = null;
        getMethod = new GetMethod(this.convertURL(url));
        getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
        getMethod.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
        int statusCode = httpClient.executeMethod(getMethod);
        if (statusCode != 200) {
            Tools.logToControl("err", "Method failed: " + getMethod.getStatusLine());
        }
        InputStream instream = getMethod.getResponseBodyAsStream();
        FileOutputStream outstream = new FileOutputStream(new File(filename));
        long contentlength = getMethod.getResponseContentLength();
        long downlength = 0L;
        byte[] buffer = new byte[4096];
        while (true) {
            int len;
            if ((len = instream.available()) != -1) {
                if (len > 4096) {
                    len = 4096;
                }
                len = instream.read(buffer);
                ((OutputStream)outstream).write(buffer, 0, len);
                if (contentlength == (downlength += (long)len)) break;
            }
            Thread.sleep(1L);
        }
        ((OutputStream)outstream).close();
        instream.close();
        getMethod.releaseConnection();
    }

    public byte[] postMethodRequest(String url, NameValuePair[] nameValuePairs) throws HttpException, IOException {
        HttpMethodBase postMethod = null;
        try {
            postMethod = new PostMethod(this.convertURL(url));
            postMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            ((PostMethod)postMethod).setRequestBody(nameValuePairs);
            int statusCode = httpClient.executeMethod(postMethod);
            if (statusCode == 200) {
                byte[] byArray = postMethod.getResponseBody();
                return byArray;
            }
            return null;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private String convertURL(String url) {
        if (url == null) {
            return null;
        }
        return url.trim().replaceAll(" ", "%20");
    }

    public byte[] postMethodRequest(String url, String input, String contentType) throws HttpException, IOException {
        if (url == null) {
            throw new HttpException();
        }
        HttpMethodBase postMethod = null;
        try {
            postMethod = new PostMethod(this.convertURL(url));
            postMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            byte[] bytes = input.getBytes();
            int length = bytes.length;
            InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(bytes), length);
            ((EntityEnclosingMethod)postMethod).setRequestEntity(entity);
            int statusCode = httpClient.executeMethod(postMethod);
            if (statusCode == 200) {
                byte[] byArray = postMethod.getResponseBody();
                return byArray;
            }
            return null;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public byte[] postXMLRequest(String uri, String input) throws HttpException, IOException {
        String contentType = "text/xml; charset=UTF-8";
        return this.postMethodRequest(uri, input, contentType);
    }

    public void test() {
        String logon_site = "https://172.18.3.89/apache2-default/";
        int logon_port = 443;
        boolean isSSL = true;
        HttpTransfer transfer = HttpTransfer.getInstant();
        transfer.setPort(logon_port, isSSL);
        try {
            Tools.logToControl("err", new String(transfer.login(logon_site, "jiang", "worksoft")));
            File file = new File("/home/zhangquan/sd.gif");
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write(transfer.getMethodRequest("https://172.18.3.89/apache2-default/apache_pb22.gif"));
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int logon_port = 443;
        boolean isSSL = true;
        HttpTransfer transfer = HttpTransfer.getInstant();
        transfer.setPort(logon_port, isSSL);
        try {
            Tools.logToControl("err", new String(transfer.getMethodRequest("https://58.213.167.143/VER/UTPS/MAC/UTPS%2011.002.04.05.55/filelist.xml"), "UTF-8"));
        }
        catch (HttpException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<root>").append("<Products>").append("<Product Version=\"UTPS 11.002.04.05.55\" SubVersion=\"T-Mobile_C55\" OS=\"MAC\"/>").append("<Product Version = \"E170UTPS-V100R001B002D04SP03C55\" SubVersion=\"T-Mobile_C54\" OS=\"WINDOWS\"/>").append("</Products>").append("<ClientUser>460000130946160</ClientUser>").append("<ClientPwd>946160</ClientPwd>").append("</root>");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<root><Products><Product Version=\"UTPS 11.002.03.03.55\" OS=\"MAC\" SubVersion=\"T-Mobile_C55\"/><Product Version=\"TCPU E170 11.306.07.01.55\" OS=\"MAC\" SubVersion=\"T-Mobile_C55\"/></Products><ClientUser>123456</ClientUser><ClientPwd>123456</ClientPwd></root>");
        try {
            String site = "https://update-test.huaweimobile.com/checkupdate.aspx ";
            Tools.logToControl("err", new String(transfer.postXMLRequest(site, buffer.toString())));
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

