/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update.https;

import com.huawei.mobilePartner.business.update.https.CustomX509TrustManager;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class CustomSecureProtocolSocketFactory
implements ProtocolSocketFactory {
    private SSLContext sslContext = null;
    private static LogConfig log = Log.getLog(CustomSecureProtocolSocketFactory.class);

    private static SSLContext createEasySSLContext() {
        log.info("createEasySSLContext");
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new CustomX509TrustManager()}, null);
            return context;
        }
        catch (Exception e) {
            throw new HttpClientError(e.toString());
        }
    }

    private SSLContext getSSLContext() {
        log.info("getSSLContext");
        if (this.sslContext == null) {
            this.sslContext = CustomSecureProtocolSocketFactory.createEasySSLContext();
        }
        return this.sslContext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        log.info("createSocket");
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        log.info("createSocket(final String host, final int port,final InetAddress localAddress, final int localPort,final HttpConnectionParams params)");
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        return ControllerThreadSocketFactory.createSocket(this, host, port, localAddress, localPort, timeout);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        log.info("createSocket(String host, int port)");
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        log.info("createSocket(Socket socket, String host, int port,boolean autoClose)");
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

