/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.XMLTool;

public class TestConfig {
    private static LogConfig log = Log.getLog(TestConfig.class);
    public static final String TEST_MODE = "2";
    private String test = null;
    private String utpsVersion = null;
    private String utpsSubVersion = null;
    private String OS = null;
    private String mtVersion = null;
    private String mtSubVersion = null;
    private String userName = null;
    private String passWord = null;
    private String updateDate = null;

    public TestConfig(String filepath) {
        this.readDataFromXML(filepath);
    }

    public void readDataFromXML(String path) {
        log.info("readDataFromXML(String path)");
        XMLTool.setImportExport(true);
        try {
            XMLTool tools = new XMLTool(path, "TestConfig");
            this.test = tools.getNodeValue("TestConfig/Test");
            this.utpsVersion = tools.getNodeValue("TestConfig/UtpsVersion");
            this.utpsSubVersion = tools.getNodeValue("TestConfig/UtpsSubVersion");
            this.OS = tools.getNodeValue("TestConfig/OS");
            this.mtVersion = tools.getNodeValue("TestConfig/MtVersion");
            this.mtSubVersion = tools.getNodeValue("TestConfig/MtSubVersion");
            this.userName = tools.getNodeValue("TestConfig/UserName");
            this.passWord = tools.getNodeValue("TestConfig/PassWord");
            this.updateDate = tools.getNodeValue("TestConfig/UpdateDate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeDataFromXML(String path) {
        log.info("writeDataFromXML(String path)");
        XMLTool.setImportExport(true);
        try {
            XMLTool tools = new XMLTool(path, "Version");
            tools.setNodeValue("Version/Test", this.test);
            tools.setNodeValue("TestConfig/UtpsVersion", this.utpsVersion);
            tools.setNodeValue("TestConfig/UtpsSubVersion", this.utpsSubVersion);
            tools.setNodeValue("TestConfig/MtVersion", this.mtVersion);
            tools.setNodeValue("TestConfig/MtSubVersion", this.mtSubVersion);
            tools.setNodeValue("TestConfig/OS", this.OS);
            tools.setNodeValue("TestConfig/UserName", this.userName);
            tools.setNodeValue("TestConfig/PassWord", this.passWord);
            tools.setNodeValue("Version/UpdateDate", this.updateDate);
            tools.write(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMtSubVersion() {
        return this.mtSubVersion;
    }

    public void setMtSubVersion(String mtSubVersion) {
        this.mtSubVersion = mtSubVersion;
    }

    public String getMtVersion() {
        return this.mtVersion;
    }

    public void setMtVersion(String mtVersion) {
        this.mtVersion = mtVersion;
    }

    public String getUtpsSubVersion() {
        return this.utpsSubVersion;
    }

    public void setUtpsSubVersion(String utpsSubVersion) {
        this.utpsSubVersion = utpsSubVersion;
    }

    public String getUtpsVersion() {
        return this.utpsVersion;
    }

    public void setUtpsVersion(String utpsVersion) {
        this.utpsVersion = utpsVersion;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOS() {
        return this.OS;
    }

    public void setOS(String os) {
        this.OS = os;
    }
}

