/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.XMLTool;
import java.util.List;
import org.jdom.Element;

public class ResponseXML {
    private static LogConfig log = Log.getLog(ResponseXML.class);
    String returnCode = null;
    String utpsVersion = null;
    String utpsSubVersion = null;
    String utpsNewVersion = null;
    String utpsPath = null;
    String utpsOS = null;
    String mtVersion = null;
    String mtNewVersion = null;
    String mtSubVersion = null;
    String mtPath = null;
    String mtOS = null;

    public ResponseXML(byte[] source) {
        log.info("ResponseXML(byte[] source)");
        try {
            XMLTool tools = new XMLTool(source);
            this.returnCode = tools.getNodeValue("root/return");
            if (this.returnCode.equals("200")) {
                List list = tools.getNode("root/Products/Product");
                int i = 0;
                while (i < list.size()) {
                    Element elem = (Element)list.get(i);
                    String version = elem.getAttributeValue("Version");
                    if (version.toLowerCase().startsWith("flash")) {
                        this.utpsVersion = version;
                        this.utpsNewVersion = elem.getAttributeValue("NewVersion");
                        this.utpsSubVersion = elem.getAttributeValue("SubVersion");
                        this.utpsPath = elem.getAttributeValue("Path");
                        this.utpsOS = elem.getAttributeValue("OS");
                    } else if (version.toLowerCase().startsWith("tcpu")) {
                        this.mtVersion = version;
                        this.mtNewVersion = elem.getAttributeValue("NewVersion");
                        this.mtSubVersion = elem.getAttributeValue("SubVersion");
                        this.mtPath = elem.getAttributeValue("Path");
                        this.mtOS = elem.getAttributeValue("OS");
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMtNewVersion() {
        return this.mtNewVersion;
    }

    public String getMtPath() {
        return this.mtPath;
    }

    public String getMtVersion() {
        return this.mtVersion;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getUtpsNewVersion() {
        return this.utpsNewVersion;
    }

    public String getUtpsPath() {
        return this.utpsPath;
    }

    public String getUtpsSubVersion() {
        return this.utpsSubVersion;
    }

    public String getUtpsVersion() {
        return this.utpsVersion;
    }

    public String getMtOS() {
        return this.mtOS;
    }

    public String getMtSubVersion() {
        return this.mtSubVersion;
    }

    public String getUtpsOS() {
        return this.utpsOS;
    }
}

