/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update;

import com.huawei.mobilePartner.business.update.DownloadFileList;
import com.huawei.mobilePartner.business.update.DownloadFileState;
import com.huawei.mobilePartner.business.update.RequestXML;
import com.huawei.mobilePartner.business.update.ResponseXML;
import com.huawei.mobilePartner.business.update.TestConfig;
import com.huawei.mobilePartner.business.update.UpdateConfig;
import com.huawei.mobilePartner.business.update.https.HttpTransfer;
import com.huawei.mobilePartner.business.update.tool.Chmod;
import com.huawei.mobilePartner.business.update.tool.MD5;
import com.huawei.mobilePartner.business.update.tool.ZipBean;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.data.comm.server.CommServer;
import com.huawei.mobilePartner.data.comm.server.CommServerThread;
import com.huawei.mobilePartner.data.comm.server.DriveEvulsionSearch;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.OnlinePromptDialog;
import com.huawei.mobilePartner.gui.ui.ussd.USSDStaticVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.HttpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineUpdate {
    private static LogConfig log = Log.getLog(OnlineUpdate.class);
    public static final String RETURNCODE_UPDATED = "200";
    public static final String UNZIP_STATE_SUCESS = "1";
    public static final String UNZIP_STATE_NOSUCESS = "0";
    public static final String UPDATEPACKAGE_FILE = "filelist.xml";
    public static final String UPDATECONFIG_FILEPATH = "/config/data/update/UpdateConfig.xml";
    public static final String TESTCONFIG_FILEPATH = "/config/data/update/TestConfig.xml";
    public static final String SYSCONFIGFILE = "SysConfig.dat";
    public static final String MAC_OS = "MAC";
    private UpdateConfig updateConfig = null;
    private TestConfig testConfig = null;
    private HttpTransfer httpTransfer = null;
    private String serverAddress = null;
    AppFrame appFrame;

    public OnlineUpdate() {
        log.info("OnlineUpdate()");
        this.appFrame = AppFrame.getAppFrameInit();
    }

    public void initConfig() throws Exception {
        log.info("initConfig()");
        String updatefilepath = String.valueOf(System.getProperty("user.dir")) + UPDATECONFIG_FILEPATH;
        this.updateConfig = new UpdateConfig(updatefilepath);
        String testfilepath = String.valueOf(System.getProperty("user.dir")) + TESTCONFIG_FILEPATH;
        this.testConfig = new TestConfig(testfilepath);
        this.httpTransfer = HttpTransfer.getInstant();
        this.configHttpTransfer(this.updateConfig);
    }

    public boolean isUpdatePermission() {
        return false;
    }

    private void configHttpTransfer(UpdateConfig updateConfig) throws Exception {
        log.info("configHttpTransfer(UpdateConfig updateConfig)");
        if (this.httpTransfer == null) {
            throw new Exception();
        }
        this.configServerInfo(updateConfig);
    }

    private void configServerInfo(UpdateConfig updateConfig) throws Exception {
        log.info("configServerInfo(UpdateConfig updateConfig)");
        boolean isConnection = false;
        String port = "";
        String sslport = "";
        int i = 0;
        while (i < 3) {
            if (i == 0) {
                port = updateConfig.getServerPort();
                this.serverAddress = updateConfig.getServerAddress();
            } else if (i == 1) {
                port = updateConfig.getServerPort1();
                this.serverAddress = updateConfig.getServerAddress1();
            } else {
                port = updateConfig.getServerPort2();
                this.serverAddress = updateConfig.getServerAddress2();
            }
            if (this.httpTransfer.testConnection(this.serverAddress, port)) {
                sslport = updateConfig.getServerSSLPort();
                this.httpTransfer.setPort(Integer.parseInt(port), Integer.parseInt(sslport));
                isConnection = true;
                break;
            }
            ++i;
        }
        if (!isConnection) {
            throw new Exception();
        }
    }

    private void refreshUpdateDate() {
        log.info("refreshUpdateDate()");
        if (this.updateConfig == null) {
            return;
        }
        String updatefilepath = String.valueOf(System.getProperty("user.dir")) + UPDATECONFIG_FILEPATH;
        this.updateConfig.setUpdateDate(new Date(System.currentTimeMillis()).toString());
        this.updateConfig.writeDataFromXML(updatefilepath);
    }

    private boolean isUnzip() {
        log.info("isUnzip()");
        if (this.updateConfig == null) {
            return false;
        }
        return this.updateConfig.getIsUnzip().equals(UNZIP_STATE_SUCESS);
    }

    private void refreshUnzipState(boolean isunzip) {
        log.info("isUnzip()");
        if (this.updateConfig == null) {
            return;
        }
        String updatefilepath = String.valueOf(System.getProperty("user.dir")) + UPDATECONFIG_FILEPATH;
        if (isunzip) {
            this.updateConfig.setIsUnzip(UNZIP_STATE_SUCESS);
        } else {
            this.updateConfig.setIsUnzip(UNZIP_STATE_NOSUCESS);
        }
        this.updateConfig.writeDataFromXML(updatefilepath);
    }

    private ResponseXML sendUpdateRequest(RequestXML request) throws Exception {
        log.info("sendUpdateRequest(RequestXML request)");
        String requestXML = request.getRequestXML();
        return new ResponseXML(this.httpTransfer.postXMLRequest(this.getCheckDataURI(), requestXML));
    }

    private String getCheckDataURI() {
        return "https://" + this.serverAddress + "/checkupdate.aspx";
    }

    private DownloadFileList getUpdatePackageInfo(String url) throws HttpException, IOException {
        log.info("DownloadFileList getUpdatePackageInfo(String url)");
        String updatefileurl = String.valueOf(url) + UPDATEPACKAGE_FILE;
        byte[] source = this.httpTransfer.getMethodRequest(updatefileurl);
        if (source == null) {
            throw new IOException();
        }
        return new DownloadFileList(source);
    }

    private void noticeUpdateSuccess(ResponseXML responseXML, String username, String password) throws Exception {
        log.info("noticeUpdateSuccess(ResponseXML responseXML, String username,String password)");
        if (this.updateConfig != null) {
            String date = new Date(System.currentTimeMillis()).toString();
            this.updateConfig.setUpdateDate(date);
            String updatefilepath = String.valueOf(System.getProperty("user.dir")) + UPDATECONFIG_FILEPATH;
            this.updateConfig.writeDataFromXML(updatefilepath);
        }
        RequestXML requestXML = new RequestXML();
        requestXML.setUtpsVersion(responseXML.getUtpsVersion());
        requestXML.setUtpsVersion(responseXML.getUtpsSubVersion());
        requestXML.setOs(responseXML.getUtpsOS() != null ? responseXML.getUtpsOS() : responseXML.getMtOS());
        requestXML.setMtVersion(responseXML.getMtVersion());
        requestXML.setMtSubVersion(responseXML.getMtSubVersion());
        requestXML.setUserName(username);
        requestXML.setPassWord(password);
        this.httpTransfer.postXMLRequest(this.getUpdateDoneURI(), requestXML.getRequestXML());
    }

    private String getUpdateDoneURI() {
        return "https://" + this.serverAddress + "/updatedone.aspx";
    }

    private void downlandUpdatePackage(String url, DownloadFileList downloadFileList, String path) throws HttpException, IOException, InterruptedException {
        log.info("downlandUpdatePackage(String url,DownloadFileList downloadFileList, String path)");
        this.downlandUpdatePackage(url, downloadFileList.getDownloadFileList(), path);
    }

    private void downlandUpdatePackage(String url, List<DownloadFileState> list, String path) throws HttpException, IOException, InterruptedException {
        log.info("downlandUpdatePackage(String url,List<DownloadFileState> list, String path)");
        this.httpTransfer.downlandFile(url, list, path);
        Chmod.chmodFile(path, "777");
    }

    private boolean checkFileState(String path, String filename, String md5) {
        log.info("checkFileState(String path, String filename, String md5)");
        String filepath = String.valueOf(path) + filename;
        File file = null;
        try {
            String tempMD5;
            file = new File(filepath);
            return file.exists() && (tempMD5 = MD5.getMD5(file)).toUpperCase().equals(md5);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getTargetdir() {
        log.info("getTargetdir()");
        String userdir = System.getProperty("user.dir");
        if (userdir.endsWith("/") || userdir.endsWith("\\")) {
            return String.valueOf(userdir) + "UpdateDownload/";
        }
        return String.valueOf(userdir) + File.separator + "UpdateDownload/";
    }

    private boolean checkFileExists(DownloadFileList downloadFileList, String path) {
        log.info("checkFileExists(DownloadFileList downloadFileList,String path)");
        if (downloadFileList == null) {
            return false;
        }
        String filepath = this.getTargetdir();
        File dir = new File(filepath);
        String[] names = dir.list();
        return names != null || names.length != 0;
    }

    private String getCDPath() throws Exception {
        File[] tempFileArray;
        log.info("getCDPath()");
        String cdPath = null;
        File file = null;
        String operaterSystem = System.getProperty("os.name").toUpperCase();
        boolean flag = false;
        if (operaterSystem.indexOf(MAC_OS) >= 0 && (file = new File("/Volumes")).exists() && (tempFileArray = file.listFiles()) != null && tempFileArray.length >= 1) {
            int i = 0;
            while (i < tempFileArray.length) {
                if (tempFileArray[i].isDirectory() && !tempFileArray[i].isFile()) {
                    String[] tempPathArray = tempFileArray[i].list();
                    int j = 0;
                    while (j < tempPathArray.length) {
                        if (tempPathArray[j].equals(SYSCONFIGFILE)) {
                            cdPath = tempFileArray[i].getPath();
                            flag = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (flag) break;
                ++i;
            }
        }
        if (cdPath == null) {
            throw new Exception();
        }
        return cdPath;
    }

    private List<DownloadFileState> getErrorDownlandFile(DownloadFileList downloadFileList) {
        log.info("List<DownloadFileState> getErrorDownlandFile(DownloadFileList downloadFileList)");
        if (downloadFileList == null) {
            return null;
        }
        String filepath = this.getTargetdir();
        List<DownloadFileState> filelist = downloadFileList.getDownloadFileList();
        return this.getErrorDownlandFile(filelist, filepath);
    }

    private List<DownloadFileState> getErrorDownlandFile(List<DownloadFileState> filelist, String saveFilePath) {
        log.info("List<DownloadFileState> getErrorDownlandFile(List<DownloadFileState> filelist, String saveFilePath)");
        if (filelist == null || saveFilePath == null) {
            return null;
        }
        ArrayList<DownloadFileState> errorFileList = null;
        int i = 0;
        while (i < filelist.size()) {
            DownloadFileState downloadFileState = filelist.get(i);
            if (!this.checkFileState(saveFilePath, downloadFileState.getFilename(), downloadFileState.getMd5())) {
                if (errorFileList == null) {
                    errorFileList = new ArrayList<DownloadFileState>();
                }
                errorFileList.add(downloadFileState);
            }
            ++i;
        }
        return errorFileList;
    }

    private void unzipInstallPackage(DownloadFileList downloadFileList, String saveFilePath) throws Exception {
        log.info("unzipInstallPackage(List<DownloadFileState> fileList,String saveFilePath)");
        if (downloadFileList == null || downloadFileList.getDownloadFileList() == null || saveFilePath == null) {
            return;
        }
        List<DownloadFileState> fileList = downloadFileList.getDownloadFileList();
        ZipBean zip = new ZipBean();
        int i = 0;
        while (i < fileList.size()) {
            DownloadFileState downloadFileState = fileList.get(i);
            zip.unzip(String.valueOf(saveFilePath) + downloadFileState.getFilename(), saveFilePath);
            ++i;
        }
        Chmod.chmodFile(saveFilePath, "777");
    }

    private void installUpdatePackage(DownloadFileList mtFileList, DownloadFileList utpsFileList) throws Exception {
        log.info("installUpdatePackage(DownloadFileList downloadFileList)");
        if (mtFileList == null && utpsFileList == null) {
            return;
        }
        String saveFilePath = this.getTargetdir();
        Object fileList = null;
        this.execInstall(mtFileList, utpsFileList);
    }

    private void execInstall(DownloadFileList mtFileList, DownloadFileList utpsFileList) throws Exception {
        String targetdir = this.getTargetdir();
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add("java");
        cmdlist.add("-classpath");
        String userdir = System.getProperty("user.dir");
        if (new File(String.valueOf(userdir) + "/MobilePartner.jar").exists()) {
            cmdlist.add(String.valueOf(userdir) + "/MobilePartner.jar");
        } else {
            cmdlist.add(String.valueOf(userdir) + "/MobilePartner");
        }
        cmdlist.add("com.huawei.mobilePartner.business.update.tool.Install");
        if (mtFileList != null) {
            cmdlist.add(this.buildPara(mtFileList));
        }
        if (utpsFileList != null) {
            cmdlist.add(this.buildPara(utpsFileList));
        }
        Runtime run = Runtime.getRuntime();
        String[] commands = new String[cmdlist.size()];
        System.arraycopy(cmdlist.toArray(), 0, commands, 0, cmdlist.size());
        Process process = run.exec(commands);
        int rtn = 0;
        try {
            rtn = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (rtn == 1) {
            throw new Exception();
        }
    }

    private String buildPara(DownloadFileList filelist) {
        String limitcondition = filelist.getLimitcondition();
        String targetdir = this.getTargetdir();
        String maxreplaceauto = filelist.getMaxreplaceauto();
        String sep = ",";
        StringBuffer buf = new StringBuffer();
        buf.append(limitcondition).append(sep).append(targetdir).append(sep).append(maxreplaceauto).append(sep);
        List<DownloadFileState> list = filelist.getDownloadFileList();
        int i = 0;
        while (i < list.size()) {
            DownloadFileState state = list.get(i);
            buf.append(state.getFilename()).append(sep);
            ++i;
        }
        return buf.toString();
    }

    private boolean limitcondition_fullUpdate(List<DownloadFileState> fileList, String filePath) throws Exception {
        log.info("limitcondition_fullUpdate(List<DownloadFileState> fileList,String filePath)");
        if (fileList == null || fileList.size() != 1) {
            throw new Exception();
        }
        String filename = String.valueOf(filePath) + fileList.get(0).getFilename();
        File fl = new File(filename = String.valueOf(filename.substring(0, filename.length() - 4)) + ".app");
        if (!fl.exists()) {
            throw new Exception();
        }
        if (fl.isDirectory()) {
            if (!new File(filename = String.valueOf(filename) + "/Contents/MacOS/UpdateWizard").exists()) {
                throw new Exception();
            }
            String[] command = new String[]{filename};
            Runtime run = Runtime.getRuntime();
            Process process = run.exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean isSucess = false;
            String currline = null;
            while ((currline = reader.readLine()) != null) {
                Thread.sleep(100L);
                if (!"Download Programs finished!".equals(currline)) continue;
                isSucess = true;
            }
            return isSucess;
        }
        return false;
    }

    private void releaseDownloadFile(String saveFilePath) {
        log.info("releaseDownloadFile(String saveFilePath)");
        if (saveFilePath == null) {
            return;
        }
        File folder = new File(saveFilePath);
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File fl = files[i];
            if (fl.isDirectory()) {
                this.deleteFolder(fl);
            } else {
                this.deleteFile(fl);
            }
            ++i;
        }
    }

    private void deleteFolder(File folder) {
        log.info("deleteFolder(File folder)");
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File fl = files[i];
            if (fl.isDirectory()) {
                this.deleteFolder(fl);
            } else {
                this.deleteFile(fl);
            }
            ++i;
        }
        folder.delete();
    }

    private void deleteFile(File file) {
        log.info("deleteFile(File file)");
        file.delete();
    }

    private void setUtpsVersion(RequestXML requestXML) {
        HashMap<String, String> contentMap;
        block13: {
            log.info("setUtpsVersion(RequestXML requestXML)");
            contentMap = new HashMap<String, String>();
            File file = null;
            FileReader inputContent = null;
            BufferedReader reader = null;
            String content = null;
            try {
                file = new File(String.valueOf(this.getCDPath()) + File.separator + SYSCONFIGFILE);
                if (!file.exists()) break block13;
                inputContent = new FileReader(file);
                reader = new BufferedReader(inputContent);
                content = reader.readLine();
                boolean isStart = false;
                while (content != null) {
                    String key = null;
                    String value = null;
                    if (content.indexOf("[EHIDS_PRODUCT_VERSION]") != -1) {
                        isStart = true;
                    } else if (isStart) {
                        if (content.indexOf("=") >= 0) {
                            String[] temp = content.split("=");
                            if (temp.length == 2) {
                                key = temp[0];
                                value = temp[1];
                            } else {
                                key = temp[0];
                                value = null;
                            }
                            contentMap.put(key, value);
                        } else if (content.indexOf("[") != -1) break;
                    }
                    content = reader.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String utpsVersion = null;
        String utpsSubVersion = null;
        if (contentMap != null) {
            utpsVersion = (String)contentMap.get("VALUE");
            utpsSubVersion = (String)contentMap.get("SUBVERSION");
        }
        requestXML.setUtpsVersion(utpsVersion != null ? "FLASH UTPS " + utpsVersion : utpsVersion);
        if (utpsSubVersion == null) {
            utpsSubVersion = "T-Mobile_C55";
        }
        requestXML.setUtpsSubVersion(utpsSubVersion);
        requestXML.setMtSubVersion(utpsSubVersion);
    }

    private void setMTVersion(RequestXML requestXML) throws InterruptedException {
        log.info("setMTVersion(RequestXML requestXML)");
        String mtVersion = "TCPU " + this.getDevName() + " " + this.getMtVersion();
        requestXML.setMtVersion(mtVersion);
    }

    private String getDevName() throws InterruptedException {
        log.info("getDevName()");
        String devType = (String)AppFrame.diagnosisInfoManageMap.get("DEVTYPE");
        while (devType == null || devType.equals("")) {
            Thread.sleep(1000L);
            devType = (String)AppFrame.diagnosisInfoManageMap.get("DEVTYPE");
        }
        return devType;
    }

    private String getMtVersion() throws InterruptedException {
        log.info("getMtVersion()");
        String firmwareVer = (String)AppFrame.diagnosisInfoManageMap.get("firmwareVer");
        while (firmwareVer == null || firmwareVer.equals("")) {
            Thread.sleep(1000L);
            firmwareVer = (String)AppFrame.diagnosisInfoManageMap.get("firmwareVer");
        }
        return firmwareVer;
    }

    private void setUsernameAndPwd(RequestXML requestXML) throws InterruptedException {
        log.info("setUsernameAndPwd(RequestXML requestXML)");
        String userName = this.getIMEI();
        String password = userName.substring(userName.length() - 6);
        requestXML.setUserName(userName);
        requestXML.setPassWord(password);
    }

    private String getIMEI() throws InterruptedException {
        log.info("getIMEI()");
        String imei = (String)AppFrame.diagnosisInfoManageMap.get("IMEI");
        while (imei == null || imei.equals("")) {
            Thread.sleep(1000L);
            imei = (String)AppFrame.diagnosisInfoManageMap.get("IMEI");
        }
        return imei;
    }

    public boolean isUpdateCycle() {
        log.info("isUpdateCycle()");
        if (this.updateConfig == null) {
            return false;
        }
        String updateDate = null;
        long cycletime = Integer.parseInt(this.updateConfig.getCycle()) * 86400000;
        updateDate = this.testConfig != null && "2".equals(this.testConfig.getTest()) ? this.testConfig.getUpdateDate() : this.updateConfig.getUpdateDate();
        try {
            Date date = Date.valueOf(updateDate);
            long updatetime = date.getTime();
            return System.currentTimeMillis() > updatetime + cycletime || System.currentTimeMillis() < updatetime;
        }
        catch (Exception e) {
            return false;
        }
    }

    private RequestXML getRequestXML() throws Exception {
        log.info("getRequestXML()");
        RequestXML requestXML = new RequestXML();
        if (this.testConfig != null && "2".equals(this.testConfig.getTest())) {
            requestXML.setUtpsVersion(this.testConfig.getUtpsVersion());
            requestXML.setUtpsSubVersion(this.testConfig.getUtpsSubVersion());
            requestXML.setMtVersion(this.testConfig.getMtVersion());
            requestXML.setMtSubVersion(this.testConfig.getMtSubVersion());
            requestXML.setUserName(this.testConfig.getUserName());
            requestXML.setPassWord(this.testConfig.getPassWord());
            requestXML.setOs(this.testConfig.getOS());
            return requestXML;
        }
        requestXML.setOs(MAC_OS);
        this.setUtpsVersion(requestXML);
        this.setMTVersion(requestXML);
        this.setUsernameAndPwd(requestXML);
        if (requestXML.getUtpsVersion() == null || requestXML.getUtpsSubVersion() == null || requestXML.getMtVersion() == null || requestXML.getUserName() == null || requestXML.getPassWord() == null) {
            throw new Exception();
        }
        return requestXML;
    }

    public void updateT_Moblie(boolean isAutoRun) throws Exception {
        log.info("updateT_Moblie(boolean isAutoRun)");
        if (this.updateConfig == null || this.httpTransfer == null) {
            throw new Exception();
        }
        RequestXML requestXML = this.getRequestXML();
        ResponseXML responseXML = this.sendUpdateRequest(requestXML);
        if (!responseXML.returnCode.equals(RETURNCODE_UPDATED)) {
            this.releaseDownloadFile(this.getTargetdir());
            this.refreshUpdateDate();
            if (isAutoRun) {
                return;
            }
            this.showMessage(USSDStaticVariable.lb.getOnline_no_available_upgrage_produce(), false);
            return;
        }
        boolean isUpdateUtps = false;
        boolean isUpdateMT = false;
        if (responseXML.getUtpsVersion() != null && !responseXML.getUtpsVersion().equals(responseXML.getUtpsNewVersion())) {
            isUpdateUtps = true;
        }
        if (responseXML.getMtVersion() != null && !responseXML.getMtVersion().equals(responseXML.getMtNewVersion())) {
            isUpdateMT = true;
        }
        boolean isUpdatefail = false;
        DownloadFileList mtfilelist = null;
        List<DownloadFileState> mtlist = null;
        String mtSaveFilePath = null;
        if (isUpdateMT) {
            String mturl = responseXML.getMtPath();
            mtfilelist = this.getUpdatePackageInfo(mturl);
            mtSaveFilePath = this.getTargetdir();
            mtlist = this.getErrorDownlandFile(mtfilelist);
            if (mtlist != null && mtlist.size() > 0 && !this.showMessage(USSDStaticVariable.lb.getOnline_download_now(), true)) {
                return;
            }
            try {
                if (mtlist != null && mtlist.size() > 0) {
                    this.downlandUpdatePackage(mturl, mtlist, mtSaveFilePath);
                }
            }
            catch (Exception e) {
                isUpdatefail = true;
            }
        }
        DownloadFileList utpsfilelist = null;
        List<DownloadFileState> utpslist = null;
        String utpsSaveFilePath = null;
        if (!isUpdatefail && isUpdateUtps) {
            String utpsurl = responseXML.getUtpsPath();
            utpsfilelist = this.getUpdatePackageInfo(utpsurl);
            utpsSaveFilePath = this.getTargetdir();
            utpslist = this.getErrorDownlandFile(utpsfilelist);
            if (utpslist != null && utpslist.size() > 0 && !this.showMessage(USSDStaticVariable.lb.getOnline_new_dashboard_download(), true)) {
                return;
            }
            try {
                if (utpslist != null && utpslist.size() > 0) {
                    this.downlandUpdatePackage(utpsurl, utpslist, utpsSaveFilePath);
                }
            }
            catch (Exception e) {
                isUpdatefail = true;
            }
        }
        if (isUpdateMT && isUpdateUtps && isUpdatefail ? !this.showMessage(USSDStaticVariable.lb.getOnline_firmware_dashboard_not_download_failed(), false) : (isUpdateMT && !isUpdateUtps && isUpdatefail ? !this.showMessage(USSDStaticVariable.lb.getOnline_firmware_not_download_faile(), false) : isUpdateMT && !isUpdateUtps && isUpdatefail && !this.showMessage(USSDStaticVariable.lb.getOnline_dashboard_not_download_failed(), false))) {
            return;
        }
        if (mtlist != null || utpslist != null) {
            List<DownloadFileState> mtErrorDownloadlist = null;
            if (isUpdateMT) {
                mtErrorDownloadlist = this.getErrorDownlandFile(mtlist, this.getTargetdir());
            }
            List<DownloadFileState> utpsErrorDownloadlist = null;
            if (isUpdateUtps) {
                utpsErrorDownloadlist = this.getErrorDownlandFile(utpslist, this.getTargetdir());
            }
            if (mtErrorDownloadlist != null && mtErrorDownloadlist.size() > 0 || utpsErrorDownloadlist != null && utpsErrorDownloadlist.size() > 0) {
                this.showMessage(USSDStaticVariable.lb.getOnline_firmware_dashboard_failed(), false);
                return;
            }
            this.noticeUpdateSuccess(responseXML, requestXML.getUserName(), requestXML.getPassWord());
            this.refreshUnzipState(false);
        }
        if (!this.isUnzip()) {
            this.unzipInstallPackage(mtfilelist, mtSaveFilePath);
            this.unzipInstallPackage(utpsfilelist, utpsSaveFilePath);
            this.refreshUnzipState(true);
        }
        if (isUpdateMT && isUpdateUtps) {
            this.showMessage(USSDStaticVariable.lb.getOnline_close_dashboard_dashboard_firmware_chose_now(), true);
        } else if (isUpdateMT) {
            this.showMessage(USSDStaticVariable.lb.getOnline_close_dashboard_firmware_chose_now(), true);
        } else {
            this.showMessage(USSDStaticVariable.lb.getOnline_close_dashboard_dashboard_chose_now(), true);
        }
        this.installUpdatePackage(mtfilelist, utpsfilelist);
        this.releaseDownloadFile(this.getTargetdir());
    }

    private void interruptprocedures() throws InterruptedException {
        log.info("interruptprocedures()");
        CommServer.atThreadFlag = true;
        CommServerThread.queryDriverFlag = true;
        DriveEvulsionSearch drive = new DriveEvulsionSearch();
        String operaterSystem = System.getProperty("os.name").toUpperCase();
        if (operaterSystem.indexOf(MAC_OS) >= 0) {
            drive.portIdClose("/dev/tty.HUAWEIMobile-Pcui");
        }
        Thread.sleep(5000L);
    }

    private void rebootProcedures() {
        log.info("rebootProcedures()");
        CommServer.atThreadFlag = false;
        CommServerThread.queryDriverFlag = false;
    }

    private boolean showMessage(String message, boolean isOkAndCancel) {
        log.info("showMessage(String message, boolean isOkAndCancel)");
        OnlinePromptDialog onlineDialog = new OnlinePromptDialog(this.appFrame, USSDStaticVariable.lb.getOnline_prompt(), message, isOkAndCancel);
        return OnlinePromptDialog.RETURN_OK.equals(onlineDialog.getReturnCOde());
    }

    public void showUpdateFail() {
        log.info("showUpdateFail()");
        this.showMessage(USSDStaticVariable.lb.getOnline_upgrade_failed(), false);
    }

    public static void main(String[] args) {
        try {
            OnlineUpdate onlineUpdate = new OnlineUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

