/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.update;

import com.huawei.mobilePartner.business.update.DownloadFileState;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.XMLTool;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadFileList {
    private static LogConfig log = Log.getLog(DownloadFileList.class);
    public static final String LIMITCONDITION_WEIGHT = "0";
    public static final String LIMITCONDITION_ADD = "1";
    public static final String LIMITCONDITION_FULL = "2";
    private String upgradeversionid = null;
    private String limitcondition = null;
    private String targetdir = null;
    private String maxreplaceauto = null;
    private List<DownloadFileState> downloadFileList = null;

    public DownloadFileList(byte[] source) {
        log.info("DownloadFileList(byte[] source)");
        this.initData(source);
    }

    public List<DownloadFileState> getDownloadFileList() {
        return this.downloadFileList;
    }

    public void addDownloadFileList(DownloadFileState downloadFileState) {
        log.info("addDownloadFileList(DownloadFileState downloadFileState)");
        if (this.downloadFileList == null) {
            this.downloadFileList = new ArrayList<DownloadFileState>();
        }
        this.downloadFileList.add(downloadFileState);
    }

    public String getLimitcondition() {
        return this.limitcondition;
    }

    public void setLimitcondition(String limitcondition) {
        this.limitcondition = limitcondition;
    }

    public String getUpgradeversionid() {
        return this.upgradeversionid;
    }

    public void setUpgradeversionid(String upgradeversionid) {
        this.upgradeversionid = upgradeversionid;
    }

    public String getMaxreplaceauto() {
        return this.maxreplaceauto;
    }

    public void setMaxreplaceauto(String maxreplaceauto) {
        this.maxreplaceauto = maxreplaceauto;
    }

    public void setTargetdir(String targetdir) {
        this.targetdir = targetdir;
    }

    public void initData(byte[] source) {
        log.info("initData(byte[] source)");
        try {
            XMLTool tools = new XMLTool(source);
            this.upgradeversionid = tools.getNodeValue("UPGRADE/UPGRADEVERSIONID");
            this.limitcondition = tools.getNodeValue("UPGRADE/LIMITCONDITION");
            this.targetdir = tools.getNodeValue("UPGRADE/SETTING/TARGETDIR");
            this.maxreplaceauto = tools.getNodeValue("UPGRADE/SETTING/MAXREPLACEAUTO");
            if (this.downloadFileList != null) {
                this.downloadFileList.clear();
                this.downloadFileList = null;
            }
            List list = tools.getNode("UPGRADE/UPFILENAME");
            int i = 0;
            while (i < list.size()) {
                Element ele = (Element)list.get(i);
                List childlist = ele.getChildren();
                int j = 0;
                while (j < childlist.size()) {
                    Element child = (Element)childlist.get(i);
                    if (child.getName().equals("FOLDER")) {
                        this.readFolder(child);
                    } else if (child.getName().equals("FILE")) {
                        this.readFile(child);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readFolder(Element ele) {
        log.info("readFolder(Element ele)");
        List list = ele.getChildren();
        int i = 0;
        while (i < list.size()) {
            Element element = (Element)list.get(i);
            if (element.getName().equals("FOLDER")) {
                this.readFolder(element);
            } else if (element.getName().equals("FILE")) {
                this.readFile(element);
            }
            ++i;
        }
    }

    public void readFile(Element element) {
        log.info("readFile(Element element)");
        DownloadFileState downloadFileState = new DownloadFileState();
        List list = element.getChildren();
        int i = 0;
        while (i < list.size()) {
            Element child = (Element)list.get(i);
            if (child.getName().equals("FILENAME")) {
                downloadFileState.setFilename(child.getText());
            } else if (child.getName().equals("FILEVERSIONID")) {
                downloadFileState.setFileversionid(child.getText());
            } else if (child.getName().equals("FILESIZE")) {
                downloadFileState.setFilesize(child.getText());
            } else if (child.getName().equals("FILEMODIFYTIME")) {
                downloadFileState.setFilemodifytime(child.getText());
            } else if (child.getName().equals("MD5")) {
                downloadFileState.setMd5(child.getText());
            }
            ++i;
        }
        this.addDownloadFileList(downloadFileState);
    }
}

