/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.telephoneBook;

import com.huawei.mobilePartner.business.network.NetworkThread;
import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.business.telephoneBook.TelBookEvent;
import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TelBookInfoTreeList {
    private static String configXmlPath = String.valueOf(XMLTool.getClassPath()) + "/";
    public static final String TEL_BOOK_INFO_PATH = "userdata/telbook/LocalTelBook.xml";
    public static final String TEL_BOOK_INFO_NODE_PATH = "root/local";
    public static final String TEL_BOOK_INFO_NODE_GROUP_PATH = "root/group";
    public LogConfig log = null;
    LanguageBean lb = CustomizeInit.getLanguageBean();

    public TelBookInfoTreeList() {
        this.log = Log.getLog(TelBookInfoTreeList.class);
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
    }

    public List getTelBookInfo() {
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(true);
            this.log.info("The path of delete file: " + ParameterConfigServer.userdata_dir + TEL_BOOK_INFO_PATH);
            comm = new XMLTool(String.valueOf(ParameterConfigServer.userdata_dir) + TEL_BOOK_INFO_PATH);
        }
        catch (Exception ex) {
            this.log.info("read LocalTelBook.xml fail : [" + ex.toString() + "]");
        }
        List telBookList = this.getTelBookGroupInfo(comm);
        List telGroupNameList = this.getGroupNameList(comm);
        List localGroupList = this.getLocalGroupList("Local", telBookList, telGroupNameList);
        return localGroupList;
    }

    public List getSimList() {
        List telBookList = this.getSimTelBookInfo();
        List simList = this.getSimList(this.lb.getOperation_3_Sim(), telBookList);
        return simList;
    }

    public List getDeviceList() {
        List telBookList = this.getDeviceTelBookInfo();
        List deviceList = this.getDeviceList(this.lb.getOperation_3_Device(), telBookList);
        return deviceList;
    }

    private List getSimList(String nodeName, List telBookList) {
        ArrayList<Object> simList = new ArrayList<Object>();
        simList.add(nodeName);
        int telIndex = 0;
        while (telIndex < telBookList.size()) {
            TelBookEvent telBook = (TelBookEvent)telBookList.get(telIndex);
            ArrayList<String> simNodeList = new ArrayList<String>();
            simNodeList.add(telBook.getName());
            if (!"".equals(telBook.getMobileNumber().toString().trim())) {
                simNodeList.add(telBook.getMobileNumber());
            }
            if (!"".equals(telBook.getOfficeNumber().toString().trim())) {
                simNodeList.add(telBook.getOfficeNumber());
            }
            simList.add(simNodeList);
            ++telIndex;
        }
        return simList;
    }

    private List getDeviceList(String nodeName, List telBookList) {
        ArrayList<Object> deviceList = new ArrayList<Object>();
        deviceList.add(nodeName);
        int telIndex = 0;
        while (telIndex < telBookList.size()) {
            TelBookEvent telBook = (TelBookEvent)telBookList.get(telIndex);
            ArrayList<String> deviceNodeList = new ArrayList<String>();
            deviceNodeList.add(telBook.getName());
            if (!"".equals(telBook.getMobileNumber().toString().trim())) {
                deviceNodeList.add(telBook.getMobileNumber());
            }
            if (!"".equals(telBook.getOfficeNumber().toString().trim())) {
                deviceNodeList.add(telBook.getOfficeNumber());
            }
            deviceList.add(deviceNodeList);
            ++telIndex;
        }
        return deviceList;
    }

    private List getLocalGroupList(String nodeName, List telBookList, List telGroupNameList) {
        ArrayList<Object> localList = new ArrayList<Object>();
        localList.add(nodeName);
        Tools.logToControl("err", "telGroupNameList.size():" + telGroupNameList.size());
        if (telGroupNameList.size() == 0) {
            boolean groupFlag = false;
            ArrayList addGroupList = new ArrayList();
            int telBookIndex = 0;
            while (telBookIndex < telBookList.size()) {
                TelBookEvent telBookEvent = (TelBookEvent)telBookList.get(telBookIndex);
                ArrayList<String> addNameList = new ArrayList<String>();
                addNameList.add(telBookEvent.getName());
                if (!"".equals(telBookEvent.getMobileNumber().toString().trim())) {
                    addNameList.add(telBookEvent.getMobileNumber());
                }
                if (!"".equals(telBookEvent.getOfficeNumber().toString().trim())) {
                    addNameList.add(telBookEvent.getOfficeNumber());
                }
                if (!"".equals(telBookEvent.getHomeNumber().toString().trim())) {
                    addNameList.add(telBookEvent.getHomeNumber());
                }
                localList.add(addNameList);
                ++telBookIndex;
            }
        } else {
            ArrayList<Integer> addGroupAfterList = new ArrayList<Integer>();
            int groupIndex = 0;
            while (groupIndex < telGroupNameList.size()) {
                boolean groupFlag = false;
                ArrayList addGroupList = new ArrayList();
                addGroupList.add(telGroupNameList.get(groupIndex));
                int telBookIndex = 0;
                while (telBookIndex < telBookList.size()) {
                    String tempGroup;
                    int groupLength;
                    int tempSize;
                    TelBookEvent telBookEvent = (TelBookEvent)telBookList.get(telBookIndex);
                    ArrayList<String> addNameList = new ArrayList<String>();
                    addNameList.add(telBookEvent.getName());
                    if (!"".equals(telBookEvent.getMobileNumber().toString().trim())) {
                        addNameList.add(telBookEvent.getMobileNumber());
                    }
                    if (!"".equals(telBookEvent.getOfficeNumber().toString().trim())) {
                        addNameList.add(telBookEvent.getOfficeNumber());
                    }
                    if (!"".equals(telBookEvent.getHomeNumber().toString().trim())) {
                        addNameList.add(telBookEvent.getHomeNumber());
                    }
                    if ((tempSize = (groupLength = (tempGroup = telBookEvent.getGroup()).length()) / PublicConfig.groupLen) > tempSize) {
                        ++tempSize;
                    }
                    String tempGroupName = "";
                    ArrayList<String> listGroup = new ArrayList<String>();
                    int i = 0;
                    while (i < tempSize) {
                        if (i == 0) {
                            tempGroupName = tempGroup.substring(0, PublicConfig.groupLen * (i + 1));
                            listGroup.add(tempGroupName);
                        } else if (i + 1 == tempSize) {
                            tempGroupName = tempGroup.substring(PublicConfig.groupLen * i);
                            listGroup.add(tempGroupName);
                        } else {
                            tempGroupName = tempGroup.substring(PublicConfig.groupLen * i, PublicConfig.groupLen * (i + 1));
                            listGroup.add(tempGroupName);
                        }
                        ++i;
                    }
                    int groupNameIndex = 0;
                    while (groupNameIndex < listGroup.size()) {
                        if (telGroupNameList.get(groupIndex).toString().equals(listGroup.get(groupNameIndex))) {
                            addGroupList.add(addNameList);
                            addGroupAfterList.add(telBookIndex);
                            groupFlag = true;
                        } else if ("".equals(telBookEvent.getGroup()) && groupIndex == 0) {
                            localList.add(addNameList);
                            addGroupAfterList.add(telBookIndex);
                        }
                        ++groupNameIndex;
                    }
                    ++telBookIndex;
                }
                localList.add(addGroupList);
                ++groupIndex;
            }
            int telBookIndex = 0;
            while (telBookIndex < telBookList.size()) {
                boolean flag = false;
                int addGroupIndex = 0;
                while (addGroupIndex < addGroupAfterList.size()) {
                    int addIndex = Integer.parseInt(addGroupAfterList.get(addGroupIndex).toString());
                    if (telBookIndex == addIndex) {
                        flag = true;
                        break;
                    }
                    ++addGroupIndex;
                }
                if (!flag) {
                    TelBookEvent telBookEvent = (TelBookEvent)telBookList.get(telBookIndex);
                    ArrayList<String> addNameList = new ArrayList<String>();
                    addNameList.add(telBookEvent.getName());
                    if (!"".equals(telBookEvent.getMobileNumber().toString().trim())) {
                        addNameList.add(telBookEvent.getMobileNumber());
                    }
                    if (!"".equals(telBookEvent.getOfficeNumber().toString().trim())) {
                        addNameList.add(telBookEvent.getOfficeNumber());
                    }
                    if (!"".equals(telBookEvent.getHomeNumber().toString().trim())) {
                        addNameList.add(telBookEvent.getHomeNumber());
                    }
                    localList.add(addNameList);
                }
                ++telBookIndex;
            }
        }
        Tools.logToControl("err", "============================:[" + localList + "]");
        return localList;
    }

    private List getGroupNameList(XMLTool comm) {
        String[] proName = ConfigInterface.TEL_BOOK_INFO_GROUP_NODE;
        List telGroupList = comm.quertyNodePropertiesValueByPath(TEL_BOOK_INFO_NODE_GROUP_PATH, ConfigInterface.TEL_BOOK_INFO_GROUP_NODE);
        ArrayList<String> groupNameList = new ArrayList<String>();
        int telIndex = 0;
        while (telIndex < telGroupList.size()) {
            HashMap map = (HashMap)telGroupList.get(telIndex);
            int localIndex = 0;
            while (localIndex < map.size()) {
                String strProValue;
                String string = strProValue = map.get(proName[localIndex]) == null ? "" : map.get(proName[localIndex]).toString();
                if ("name".equals(proName[localIndex].toString().trim())) {
                    groupNameList.add(strProValue);
                }
                ++localIndex;
            }
            ++telIndex;
        }
        return groupNameList;
    }

    private List getTelBookGroupInfo(XMLTool comm) {
        String[] proName = ConfigInterface.TEL_BOOK_INFO_LOCAL_NODE;
        List telList = comm.quertyNodePropertiesValueByPath(TEL_BOOK_INFO_NODE_PATH, ConfigInterface.TEL_BOOK_INFO_LOCAL_NODE);
        ArrayList<TelBookEvent> telBookList = new ArrayList<TelBookEvent>();
        int telIndex = 0;
        while (telIndex < telList.size()) {
            HashMap map = (HashMap)telList.get(telIndex);
            TelBookEvent telBookEvent = new TelBookEvent();
            int localIndex = 0;
            while (localIndex < proName.length) {
                String strProValue;
                String string = strProValue = map.get(proName[localIndex]) == null ? "" : map.get(proName[localIndex]).toString();
                if (proName[localIndex].toString().trim().equals("group")) {
                    telBookEvent.setGroup(strProValue);
                }
                if (proName[localIndex].toString().trim().equals("name")) {
                    telBookEvent.setName(strProValue);
                }
                if (!"".equals(strProValue)) {
                    if ("mobileNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setMobileNumber(String.valueOf(this.lb.getOperation_4_SmsMessage_Mobile_Num()) + "  " + strProValue);
                    }
                    if ("officeNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setOfficeNumber(String.valueOf(this.lb.getOperation_4_SmsMessage_Office_Num()) + "  " + strProValue);
                    }
                    if ("homeNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setHomeNumber(String.valueOf(this.lb.getOperation_4_SmsMessage_Home_Num()) + "  " + strProValue);
                    }
                }
                ++localIndex;
            }
            telBookList.add(telBookEvent);
            ++telIndex;
        }
        return telBookList;
    }

    private List getDeviceTelBookInfo() {
        String[] proName = ParameterConfigServer.simTelBookPropertiesName;
        ArrayList telList = NetworkThread.telDeviceHomeList;
        ArrayList<TelBookEvent> telBookList = new ArrayList<TelBookEvent>();
        if (telList == null) {
            return telBookList;
        }
        int telIndex = 0;
        while (telIndex < telList.size()) {
            HashMap map = (HashMap)telList.get(telIndex);
            TelBookEvent telBookEvent = new TelBookEvent();
            int localIndex = 0;
            while (localIndex < proName.length) {
                String strProValue;
                String string = strProValue = map.get(proName[localIndex]) == null ? "" : map.get(proName[localIndex]).toString().trim();
                if (proName[localIndex].toString().trim().equals("name")) {
                    telBookEvent.setName(strProValue);
                }
                if (!"".equals(strProValue)) {
                    if ("mobileNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setMobileNumber(String.valueOf(this.lb.getOperation_4_SmsMessage_Mobile_Num()) + "  " + strProValue);
                    }
                    if ("officeNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setOfficeNumber(String.valueOf(this.lb.getOperation_4_OfficeNumber()) + "  " + strProValue);
                    }
                }
                ++localIndex;
            }
            telBookList.add(telBookEvent);
            ++telIndex;
        }
        return telBookList;
    }

    private List getSimTelBookInfo() {
        String[] proName = ParameterConfigServer.simTelBookPropertiesName;
        ArrayList telList = NetworkThread.telHomeList;
        ArrayList<TelBookEvent> telBookList = new ArrayList<TelBookEvent>();
        if (telList == null) {
            return telBookList;
        }
        int telIndex = 0;
        while (telIndex < telList.size()) {
            HashMap map = (HashMap)telList.get(telIndex);
            TelBookEvent telBookEvent = new TelBookEvent();
            int localIndex = 0;
            while (localIndex < proName.length) {
                String strProValue;
                String string = strProValue = map.get(proName[localIndex]) == null ? "" : map.get(proName[localIndex]).toString().trim();
                if (proName[localIndex].toString().trim().equals("name")) {
                    telBookEvent.setName(strProValue);
                }
                if (!"".equals(strProValue)) {
                    if ("mobileNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setMobileNumber(String.valueOf(this.lb.getOperation_4_SmsMessage_Mobile_Num()) + "  " + strProValue);
                    }
                    if ("officeNumber".equals(proName[localIndex].toString().trim())) {
                        telBookEvent.setOfficeNumber(String.valueOf(this.lb.getOperation_4_OfficeNumber()) + "  " + strProValue);
                    }
                }
                ++localIndex;
            }
            telBookList.add(telBookEvent);
            ++telIndex;
        }
        return telBookList;
    }

    public static void main(String[] args) {
        TelBookInfoTreeList telBook = new TelBookInfoTreeList();
        List list = telBook.getSimList();
        Tools.logToControl("out", list);
    }
}

