/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.sms.smsset;

import com.huawei.mobilePartner.business.sms.smsset.SmsCueEvent;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import java.util.HashMap;
import java.util.List;

public class SoundFileInit {
    private static String configXmlPath = String.valueOf(Tools.getClassPath()) + "/";
    public static String sendFileURL = "config/SoundFile/SMSVoice.wav";
    public LogConfig log = Log.getLog(SoundFileInit.class);

    public SoundFileInit() {
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
    }

    public void setSoundFile() {
        String file = String.valueOf(configXmlPath) + sendFileURL;
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(false);
            this.log.info("---ParameterConfigServer.simCuexpath==config/data/SmsCue.xml");
            comm = new XMLTool("config/data/SmsCue.xml");
            this.log.info("---comm==" + comm);
            this.updateCueNodeContent(comm, file);
        }
        catch (Exception ex) {
            this.log.info("read config/data/SmsCue.xml fail : [" + ex.toString() + "]");
        }
    }

    private void updateCueNodeContent(XMLTool comm, String value) {
        String[] proValue = new String[]{value};
        String[] proName = new String[]{"value"};
        comm.updateNodeMultiPropertiesValue("smscue/cue[@name=\"earpath\"]", proName, proValue);
    }

    public void setCueNodeContent() {
        String file = String.valueOf(configXmlPath) + sendFileURL;
        String[] proValue = new String[]{file};
        String[] proName = new String[]{"value"};
        String[] proNameValue = new String[]{"name", "value"};
        SmsCueEvent smsCue = new SmsCueEvent();
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(false);
            this.log.info("---ParameterConfigServer.simCuexpath==config/data/SmsCue.xml");
            comm = new XMLTool("config/data/SmsCue.xml", "smscue");
            this.log.info("---comm==" + comm);
            List smsCueList = comm.quertyNodePropertiesValueByPath("smscue/cue", proNameValue);
            int index = 0;
            while (index < smsCueList.size()) {
                HashMap cueMap = (HashMap)smsCueList.get(index);
                if ("earpath".equals(cueMap.get("name"))) {
                    smsCue.setEarCuePath(cueMap.get("value").toString());
                }
                if ("vision".equals(cueMap.get("name"))) {
                    smsCue.setVisionCue(cueMap.get("value").toString());
                }
                if ("ear".equals(cueMap.get("name"))) {
                    smsCue.setEarCue(cueMap.get("value").toString());
                }
                ++index;
            }
            if (smsCue.getEarCue() == null || "".equalsIgnoreCase(smsCue.getEarCue())) {
                String[] strProperties = new String[]{"ear", "true"};
                comm.createNodeMultiPropertiesValue("smscue/cue", proNameValue, strProperties);
            }
            if (smsCue.getVisionCue() == null || "".equalsIgnoreCase(smsCue.getVisionCue())) {
                String[] strProperties = new String[]{"vision", "true"};
                comm.createNodeMultiPropertiesValue("smscue/cue", proNameValue, strProperties);
            }
            if (smsCue.getEarCuePath() == null || "".equals(smsCue.getEarCuePath())) {
                String strPath = String.valueOf(configXmlPath) + sendFileURL;
                String[] strProperties = new String[]{"earpath", strPath};
                comm.createNodeMultiPropertiesValue("smscue/cue", proNameValue, strProperties);
            }
        }
        catch (Exception ex) {
            this.log.error("read config/data/SmsCue.xml fail : [" + ex.toString() + "]");
        }
    }
}

