/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.sms.smsset;

import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.business.sms.smsset.SmsCueEvent;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SmsCueOperation {
    private static final String SMS_FILE_PATH = "config/data/SmsCue.xml";
    private static final String SMS_NODE_PATH = "smscue/cue";
    private static final String[] proName = new String[]{"name", "value"};
    private static String configXmlPath = String.valueOf(XMLTool.getClassPath()) + "/";
    public static String sendFileURL = "config/SoundFile/SMSVoice.wav";
    public LogConfig log = Log.getLog(SmsCueOperation.class);

    public SmsCueOperation() {
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
    }

    public void saveSmsFlage(String saveToSim) {
        XMLTool.setImportExport(true);
        String nodePath = "root/saveToLocal";
        boolean flag = false;
        try {
            XMLTool comm = new XMLTool(String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/sim/SimInfoConfig.xml");
            String[] strPropertiesValue = new String[]{saveToSim};
            String[] temp = new String[]{"save"};
            flag = comm.updateNodeMultiPropertiesValue(nodePath, temp, strPropertiesValue);
            if (flag) {
                this.log.info("SmsCueOperation.saveSmsFlage(): save sms falge success.");
            } else {
                this.log.info("SmsCueOperation.saveSmsFlage(): save sms falge faile.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("SmsCueOperation.saveSmsFlage(): save sms falge error.");
        }
    }

    public void saveSmsCueMode(SmsCueEvent smsCue) {
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(false);
            this.log.info("The path of delete file: " + configXmlPath + SMS_FILE_PATH);
            comm = new XMLTool(SMS_FILE_PATH, "smscue");
        }
        catch (Exception ex) {
            this.log.error("read config/data/SmsCue.xml fail : [" + ex.toString() + "]");
        }
        List smsCueList = this.getSmsCueMode();
        String visionValue = "";
        String earValue = "";
        String pathValue = "";
        int index = 0;
        while (index < smsCueList.size()) {
            HashMap cueMap = (HashMap)smsCueList.get(index);
            if ("vision".equals(cueMap.get("name"))) {
                visionValue = cueMap.get("value").toString();
            }
            if ("ear".equals(cueMap.get("name"))) {
                earValue = cueMap.get("value").toString();
            }
            if ("earpath".equals(cueMap.get("name"))) {
                pathValue = cueMap.get("value").toString();
            }
            ++index;
        }
        if ("".equalsIgnoreCase(visionValue)) {
            String[] strProperties = new String[]{"vision", smsCue.getVisionCue()};
            comm.createNodeMultiPropertiesValue(SMS_NODE_PATH, proName, strProperties);
        } else {
            this.updateCueNodeContent(comm, smsCue.getVisionCue(), "vision");
        }
        if ("".equalsIgnoreCase(earValue)) {
            String[] strProperties = new String[]{"ear", smsCue.getEarCue()};
            comm.createNodeMultiPropertiesValue(SMS_NODE_PATH, proName, strProperties);
        } else {
            this.updateCueNodeContent(comm, smsCue.getEarCue(), "ear");
        }
        if ("".equalsIgnoreCase(pathValue)) {
            String[] strProperties = new String[]{"earpath", smsCue.getEarCuePath()};
            comm.createNodeMultiPropertiesValue(SMS_NODE_PATH, proName, strProperties);
        } else {
            this.updateCueNodeContent(comm, smsCue.getEarCuePath(), "earpath");
        }
    }

    private void updateCueNodeContent(XMLTool comm, String value, String name) {
        String smsNodeProPath = "smscue/cue[@name=\"";
        smsNodeProPath = String.valueOf(smsNodeProPath) + name + "\"]";
        String[] proValue = new String[]{name, value};
        Tools.logToControl("out", smsNodeProPath);
        comm.updateNodeMultiPropertiesValue(smsNodeProPath, proName, proValue);
    }

    private List getSmsCueMode() {
        List list = new ArrayList();
        String[] proName = new String[]{"name", "value"};
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(false);
            this.log.info("The path of delete file: " + configXmlPath + SMS_FILE_PATH);
            comm = new XMLTool(SMS_FILE_PATH);
            list = comm.quertyNodePropertiesValueByPath(SMS_NODE_PATH, proName);
        }
        catch (Exception ex) {
            this.log.info("read SmsCue.xml fail : [" + ex.toString() + "]");
        }
        return list;
    }

    public SmsCueEvent listToSmsCueEvent() {
        SmsCueEvent smsCue = new SmsCueEvent();
        List smsCueList = this.getSmsCueMode();
        int index = 0;
        while (index < smsCueList.size()) {
            HashMap cueMap = (HashMap)smsCueList.get(index);
            if ("vision".equals(cueMap.get("name"))) {
                smsCue.setVisionCue(cueMap.get("value").toString());
            }
            if ("ear".equals(cueMap.get("name"))) {
                smsCue.setEarCue(cueMap.get("value").toString());
            }
            if ("earpath".equals(cueMap.get("name"))) {
                smsCue.setEarCuePath(cueMap.get("value").toString());
            }
            ++index;
        }
        try {
            String[] strProperties;
            XMLTool comm = new XMLTool(SMS_FILE_PATH, "smscue");
            if (smsCue.getEarCue() == null || "".equalsIgnoreCase(smsCue.getEarCue())) {
                strProperties = new String[]{"ear", "true"};
                comm.createNodeMultiPropertiesValue(SMS_NODE_PATH, proName, strProperties);
                smsCue.setEarCue("true");
            }
            if (smsCue.getVisionCue() == null || "".equalsIgnoreCase(smsCue.getVisionCue())) {
                strProperties = new String[]{"vision", "true"};
                comm.createNodeMultiPropertiesValue(SMS_NODE_PATH, proName, strProperties);
                smsCue.setVisionCue("true");
            }
            if (smsCue.getEarCuePath() == null || "".equals(smsCue.getEarCuePath())) {
                String strPath = String.valueOf(configXmlPath) + sendFileURL;
                String[] strProperties2 = new String[]{"earpath", strPath};
                comm.createNodeMultiPropertiesValue(SMS_NODE_PATH, proName, strProperties2);
                smsCue.setEarCuePath(strPath);
            }
        }
        catch (Exception e) {
            this.log.error("listToSmsEvent error:" + e.getMessage());
        }
        return smsCue;
    }

    public static void main(String[] args) {
        SmsCueEvent smsCue = new SmsCueEvent();
        SmsCueOperation smsCueOper = new SmsCueOperation();
        smsCue = smsCueOper.listToSmsCueEvent();
        Tools.logToControl("out", smsCue.getVisionCue());
        Tools.logToControl("out", smsCue.getEarCue());
        Tools.logToControl("out", smsCue.getEarCuePath());
        smsCue.setVisionCue("false");
        smsCue.setEarCue("true");
        smsCue.setEarCuePath("c://SMSVoice.wav");
        smsCueOper.saveSmsCueMode(smsCue);
        smsCue = smsCueOper.listToSmsCueEvent();
        Tools.logToControl("out", smsCue.getVisionCue());
        Tools.logToControl("out", smsCue.getEarCue());
        Tools.logToControl("out", smsCue.getEarCuePath());
    }
}

