/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.sms.commserver;

import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.business.sms.showsmsinfo.SmsFactory;
import com.huawei.mobilePartner.business.sms.smsinterface.ISmsContentInter;
import com.huawei.mobilePartner.common.interfaces.SmsConfigInfo;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.gui.ui.smsui.SmsContentPanel;
import com.huawei.mobilePartner.gui.ui.smsui.SmsTableModel;
import java.util.List;
import java.util.Vector;

public class UpdateSmsStateInfo {
    private SmsContentPanel smsCont = null;
    private String stateValue = "";
    public LogConfig log = null;
    private static String configXmlPath = String.valueOf(Tools.getClassPath()) + "/";

    public UpdateSmsStateInfo(SmsContentPanel smsCont, String stateValue) {
        this.smsCont = smsCont;
        this.stateValue = stateValue;
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
        this.log = Log.getLog(UpdateSmsStateInfo.class);
    }

    public boolean getUpdateLocalStateInfo(String boxType, int[] rows) {
        String filePath = "";
        if (boxType.equals("3")) {
            filePath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/sim/LocalInbox.xml";
        }
        if (boxType.equals("4")) {
            filePath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/sim/LocalReport.xml";
        }
        if (filePath.equals("")) {
            return false;
        }
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(true);
            comm = new XMLTool(filePath, "root");
            boolean flag = this.updateSmsState(comm);
            this.setLocalSmsTableModel(rows);
            return flag;
        }
        catch (Exception ex) {
            this.log.info("read [" + filePath + "] fail : [" + ex.toString() + "]");
            return false;
        }
    }

    public boolean getUpdateStateInfo() {
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(true);
            Tools.logToControl("out", "============[" + SmsConfigInfo.SaveSelectNodePath);
            comm = new XMLTool(SmsConfigInfo.SaveSelectNodePath, "root");
            boolean flag = this.updateSmsState(comm);
            this.setSmsTableModel("local", SmsConfigInfo.SaveSelectNodePath);
        }
        catch (Exception ex) {
            this.log.info("read UserProfile.xml fail : [" + ex.toString() + "]");
        }
        return false;
    }

    public boolean updateSmsState(XMLTool comm) throws Exception {
        return comm.updateNodeMultiPropertiesValue("root/local[@id=\"" + this.stateValue + "\"]", new String[]{"state"}, new String[]{"1"});
    }

    private void setLocalSmsTableModel(int[] rows) {
        Vector<Vector> sumRowContent;
        SmsFactory smsFactory = new SmsFactory();
        ISmsContentInter iSms = smsFactory.getSmsContent("localAll");
        Vector localAll = iSms.getLocalAllContent();
        this.smsCont.rowContent = sumRowContent = Tools.sortSimContent(localAll);
        this.smsCont.tableHeader = this.smsCont.getTableHeader();
        List temp = Tools.getTableWidth(this.smsCont.boxTable);
        SmsTableModel defaultTableModel = new SmsTableModel(this.smsCont.rowContent, this.smsCont.tableHeader);
        this.smsCont.boxTable.setModel(defaultTableModel);
        Tools.setTableWidth(this.smsCont.boxTable, temp);
        Tools.setTableColumn(this.smsCont.rowContent, this.smsCont.boxTable);
        this.smsCont.boxTable.updateUI();
    }

    private void setSmsTableModel(String smsType, String filePath) {
        Vector<Vector> sumRowContent;
        int[] rows = this.smsCont.boxTable.getSelectedRows();
        SmsFactory smsFactory = new SmsFactory();
        ISmsContentInter iSms = smsFactory.getSmsContent(smsType);
        Vector localAll = iSms.getSmsContent(filePath);
        this.smsCont.rowContent = sumRowContent = Tools.sortSimContent(localAll);
        this.smsCont.tableHeader = this.smsCont.getTableHeader();
        List temp = Tools.getTableWidth(this.smsCont.boxTable);
        SmsTableModel defaultTableModel = new SmsTableModel(this.smsCont.rowContent, this.smsCont.tableHeader);
        this.smsCont.boxTable.setModel(defaultTableModel);
        Tools.setTableWidth(this.smsCont.boxTable, temp);
        int i = 0;
        while (i < rows.length) {
            this.smsCont.boxTable.addRowSelectionInterval(rows[i], rows[i]);
            ++i;
        }
        Tools.setTableColumn(this.smsCont.rowContent, this.smsCont.boxTable);
        this.smsCont.boxTable.updateUI();
    }
}

