/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.sms.commserver;

import com.huawei.mobilePartner.business.sms.commserver.PDUdecoding;
import com.huawei.mobilePartner.business.sms.commserver.SMSHelper;
import com.huawei.mobilePartner.business.sms.commserver.SevenBitAlphabet;
import com.huawei.mobilePartner.common.util.GFString;
import com.huawei.mobilePartner.common.util.Tools;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PduPack {
    private String smscLen;
    private String smscFormat;
    private String smsc;
    private int addrLen;
    private String addrFormat;
    private String addr;
    private String msgCoding;
    private int msgLen;
    private String msgContent;
    private int sendSMSLen;
    public boolean isLongFlag;
    public int isLastSMS = 0;
    private static Object object;
    public static long alha;

    static {
        alha = 0L;
    }

    public PduPack() {
        this.smscFormat = "91";
        this.addrFormat = "91";
        this.isLongFlag = false;
        this.msgCoding = "00";
    }

    public PduPack(String src) {
        if (src != null && src.length() > 44) {
            String temp = src.substring(4, 18);
            this.smsc = GFString.interChange(temp);
            if (this.smsc != null && this.smsc.length() > 1) {
                this.smsc = this.smsc.substring(0, this.smsc.length() - 1);
                if (this.smsc.length() == 13) {
                    this.smsc = this.smsc.substring(2);
                }
            }
            temp = src.substring(20, 22);
            this.addrLen = Integer.parseInt(temp, 16);
            temp = this.addrLen % 2 == 0 ? src.substring(24, 24 + this.addrLen) : src.substring(24, 24 + this.addrLen + 1);
            this.addr = GFString.interChange(temp);
            if (this.addr != null && this.addr.length() % 2 == 0) {
                this.addr = this.addr.substring(0, this.addr.length() - 1);
                if (this.addr.length() == 13) {
                    this.addr = this.addr.substring(2);
                }
            }
            if (this.addrLen % 2 == 0) {
                this.msgCoding = src.substring(24 + this.addrLen + 2, 24 + this.addrLen + 4);
                temp = src.substring(24 + this.addrLen + 4 + 16);
            } else {
                this.msgCoding = src.substring(24 + this.addrLen + 3, 24 + this.addrLen + 5);
                temp = src.substring(24 + this.addrLen + 5 + 16);
            }
            this.msgContent = this.msgCoding.equals("08") ? GFString.unicode2gb(temp) : GFString.decode7bit(temp);
        }
    }

    public void setSmsc(String s) {
        if (s != null) {
            String centerNo = s;
            if (s.length() >= 1) {
                if (s.substring(0, 1).equals("+")) {
                    centerNo = s.substring(1);
                    this.smscFormat = "91";
                } else {
                    this.smscFormat = "81";
                }
            }
            this.smsc = GFString.interChange(centerNo);
            this.smscLen = this.smsc.length() % 2 > 0 ? Integer.toHexString(this.smsc.length() / 2 + 2).toUpperCase() : Integer.toHexString(this.smsc.length() / 2 + 1).toUpperCase();
            if (this.smscLen.length() < 2) {
                this.smscLen = "0" + this.smscLen;
            }
            Tools.logToControl("out", "smscLen=" + this.smscLen);
        }
    }

    public void setAddr(String ad) {
        if (ad != null) {
            ad = ad.replace("*", "A");
            String centerNo = ad = ad.replace("#", "B");
            if (ad.length() >= 1) {
                if (ad.substring(0, 1).equals("+")) {
                    centerNo = ad.substring(1);
                    this.addrFormat = "91";
                } else {
                    this.addrFormat = "81";
                }
            }
            this.addr = GFString.interChange(centerNo);
            this.addrLen = centerNo.length();
        }
    }

    public void setMsgCoding(int encoding) {
        this.msgCoding = encoding == 8 ? "08" : (encoding == 4 ? "04" : "00");
    }

    public String getServentBitContent(String content) {
        String temp = "";
        String result = "";
        if (content != null) {
            char[] c = content.toCharArray();
            int i = 0;
            while (i < c.length) {
                temp = PduPack.gb2unicode(String.valueOf(c[i]));
                temp = PduPack.specialCoding(temp);
                result = String.valueOf(result) + temp;
                ++i;
            }
        }
        return result;
    }

    public String msgContentJudgment(String content) {
        if (content != null) {
            char[] c = content.toCharArray();
            String temp = "";
            int i = 0;
            while (i < c.length) {
                temp = PduPack.gb2unicode(String.valueOf(c[i]));
                if ("".equals(temp = PduPack.specialCoding(temp))) {
                    this.msgCoding = "08";
                    break;
                }
                ++i;
            }
            return this.msgCoding;
        }
        return "";
    }

    public void setMsgContent(String content) {
        if (content != null) {
            char[] c = content.toCharArray();
            String temp = "";
            this.msgContent = "";
            int i = 0;
            while (i < c.length) {
                if (this.isLongFlag && this.msgCoding.equals("00")) {
                    this.msgContent = content;
                    break;
                }
                if (this.isLongFlag && this.msgCoding.equals("08")) {
                    this.msgContent = GFString.gb2unicode(content);
                    this.msgLen = this.msgContent.length() / 2;
                    break;
                }
                temp = PduPack.gb2unicode(String.valueOf(c[i]));
                Tools.logToControl("out", String.valueOf(i) + "=" + temp);
                temp = PduPack.specialCoding(temp);
                if ("".equals(temp)) {
                    this.msgCoding = "08";
                    this.msgContent = GFString.gb2unicode(content);
                    this.msgLen = this.msgContent.length() / 2;
                    break;
                }
                this.msgContent = String.valueOf(this.msgContent) + temp;
                ++i;
            }
            if (this.msgCoding.equals("00")) {
                this.msgLen = this.msgContent.length() / 2;
                Tools.logToControl("out", "msgContent===========" + this.msgContent);
                Tools.logToControl("out", "msgLen=" + this.msgLen);
                if (this.isLongFlag) {
                    String str = this.msgContent.substring(0, 2);
                    str = Integer.toBinaryString(Integer.parseInt(str, 16));
                    str = String.valueOf(str) + "0";
                    str = Integer.toHexString(Integer.parseInt(str, 2));
                    str = str.toUpperCase();
                    Tools.logToControl("out", "str==" + str);
                    this.msgContent = this.msgContent.substring(2);
                    byte[] b = GFString.hexstr2bytes(this.msgContent);
                    this.msgContent = PduPack.encode7bit2(b);
                    this.msgContent = String.valueOf(str) + this.msgContent;
                } else {
                    byte[] b = GFString.hexstr2bytes(this.msgContent);
                    this.msgContent = PduPack.encode7bit2(b);
                }
            }
            if (this.msgContent != null) {
                this.msgContent = this.msgContent.toUpperCase();
                Tools.logToControl("out", "msgContent=" + this.msgContent);
                this.sendSMSLen = this.addrLen % 2 > 0 ? this.msgContent.length() / 2 + this.addrLen / 2 + 1 + 8 : this.msgContent.length() / 2 + this.addrLen / 2 + 8;
                if (this.msgContent.length() % 2 > 0) {
                    this.msgContent = "0" + this.msgContent;
                    ++this.sendSMSLen;
                }
            }
        }
    }

    public void setMsgContentByCDMA(String content) {
        if (content != null) {
            if (content.getBytes().length == 1) {
                this.msgCoding = "01";
                this.msgContent = content;
                return;
            }
            char j = '\u0000';
            boolean flag = false;
            int i = 0;
            while (i < content.length()) {
                char[] c = content.toCharArray();
                j = c[i];
                if (j > '\u00ff') {
                    flag = true;
                    break;
                }
                ++i;
            }
            if (flag) {
                this.msgCoding = "08";
                this.msgContent = GFString.unicode2gbText(GFString.gb2unicodeText(content));
            } else if (content.length() == content.getBytes().length) {
                this.msgCoding = "01";
                this.msgContent = content;
            } else {
                this.msgCoding = "08";
                this.msgContent = GFString.unicode2gb(GFString.gb2unicodeText(content));
            }
        }
    }

    public String msgContentJudgmentByCDMA(String content) {
        if (content != null) {
            if (content.getBytes().length == 1) {
                this.msgCoding = "01";
                return this.msgCoding;
            }
            char j = '\u0000';
            boolean flag = false;
            int i = 0;
            while (i < content.length()) {
                char[] c = content.toCharArray();
                j = c[i];
                if (j > '\u00ff') {
                    flag = true;
                    break;
                }
                ++i;
            }
            this.msgCoding = flag ? "08" : (content.length() == content.getBytes().length ? "01" : "08");
        }
        return this.msgCoding;
    }

    public int getCMGS() {
        return this.sendSMSLen;
    }

    public String getCodedResult() {
        String result = null;
        String tp_mti = "11";
        String tp_mr = "00";
        String tp_pid = "00";
        String tp_vp = "FF";
        if (this.smsc != null && this.addr != null && this.msgContent != null) {
            List list = SMSHelper.gettp_vpANDtp_srr();
            if (!list.get(1).toString().equals("0")) {
                tp_mti = "31";
                if (this.isLongFlag) {
                    tp_mti = "51";
                    if (this.isLastSMS == 1) {
                        tp_mti = "71";
                    }
                }
            } else if (this.isLongFlag) {
                tp_mti = "51";
            }
            if (list.get(0).toString().equals("12")) {
                tp_vp = "8F";
            } else if (list.get(0).toString().equals("24")) {
                tp_vp = "A7";
            } else if (list.get(0).toString().equals("30")) {
                tp_vp = "C4";
            }
            if (this.isLongFlag) {
                Tools.logToControl("out", "SMSHelper.getLongSMSFlag().length=" + SMSHelper.getLongSMSFlag().length());
                Tools.logToControl("out", "msgLen=" + this.msgLen);
                int strlen = SMSHelper.getLongSMSFlag().length() / 2;
                if (this.msgCoding.equals("00")) {
                    ++strlen;
                }
                result = String.valueOf(this.smscLen) + this.smscFormat + this.smsc + tp_mti + tp_mr + GFString.byte2hex((byte)this.addrLen) + this.addrFormat + this.addr + tp_pid + this.msgCoding + tp_vp + GFString.byte2hex((byte)(this.msgLen + strlen)) + SMSHelper.getLongSMSFlag() + this.msgContent;
            } else {
                result = String.valueOf(this.smscLen) + this.smscFormat + this.smsc + tp_mti + tp_mr + GFString.byte2hex((byte)this.addrLen) + this.addrFormat + this.addr + tp_pid + this.msgCoding + tp_vp + GFString.byte2hex((byte)this.msgLen) + this.msgContent;
            }
            result = result.toUpperCase();
        }
        return result;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getMsgCoding() {
        return this.msgCoding;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public String getSmsc() {
        return this.smsc;
    }

    public static String encode7bit2(byte[] src) {
        String result = null;
        String hex = null;
        result = "";
        byte left = 0;
        byte[] b = src;
        int i = 0;
        int j = 0;
        while (i < b.length) {
            j = i & 7;
            if (j == 0) {
                left = b[i];
            } else {
                byte value = (byte)(b[i] << 8 - j | left);
                left = (byte)(b[i] >> j);
                hex = GFString.byte2hex(value);
                result = String.valueOf(result) + hex;
            }
            if (i == b.length - 1) {
                result = String.valueOf(result) + GFString.byte2hex(left);
            }
            ++i;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String encode7bit(String src) {
        String result = null;
        String hex = null;
        if (src != null && src.length() == src.toCharArray().length) {
            result = "";
            byte left = 0;
            byte[] b = src.getBytes();
            char[] c = src.toCharArray();
            int i = 0;
            int j = 0;
            while (i < c.length) {
                j = i & 7;
                if (j == 0) {
                    left = b[i];
                    if (c.length == 1) {
                        hex = c[i] > '\u007f' ? PduPack.specialCoding(String.valueOf(c[i])).toString() : ("".equals(PduPack.specialCoding(String.valueOf(c[i]))) ? GFString.byte2hex(left) : PduPack.specialCoding(String.valueOf(c[i])));
                        result = String.valueOf(result) + hex;
                    }
                } else {
                    byte value = (byte)(b[i] << 8 - j | left);
                    left = (byte)(b[i] >> j);
                    hex = c[i] > '\u007f' ? PduPack.specialCoding(String.valueOf(c[i])).toString() : ("".equals(PduPack.specialCoding(String.valueOf(c[i]))) ? GFString.byte2hex(left) : PduPack.specialCoding(String.valueOf(c[i])));
                    result = String.valueOf(result) + hex;
                    if (i == c.length - 1) {
                        result = c[i] > '\u007f' ? String.valueOf(result) + PduPack.specialCoding(String.valueOf(c[i])).toString() : ("".equals(PduPack.specialCoding(String.valueOf(c[i]))) ? String.valueOf(result) + GFString.byte2hex(left) : String.valueOf(result) + PduPack.specialCoding(String.valueOf(c[i])));
                    }
                }
                ++i;
            }
            result = result.toUpperCase();
        }
        return result;
    }

    public static String specialCoding(String result) {
        object = SevenBitAlphabet.getSevenBitAlphabet().get(result);
        if (object == null) {
            Tools.logToControl("out", "SevenBitAlphabet.getSevenBitAlphabet().get(" + result + ") is null");
            return "";
        }
        return object.toString();
    }

    public static boolean isSpecialCoding(String reString) {
        String hexString = (String)SevenBitAlphabet.getSevenBitAlphabet().get(reString);
        Tools.logToControl("err", "alhaalhaalhaalhaalha=========" + hexString);
        int assic = 0;
        long[] hexLong = new long[2];
        if (hexString == null) {
            return false;
        }
        int i = 0;
        while (i < hexString.length()) {
            if (PDUdecoding.isData(String.valueOf(hexString.charAt(i)))) {
                assic = hexString.charAt(i) - 48;
                hexLong[i] = assic;
            } else {
                assic = hexString.charAt(i) - 55;
                hexLong[i] = assic;
            }
            ++i;
        }
        alha = hexLong[0] + hexLong[1] << 4;
        return true;
    }

    public static String specialCoding2(String result) {
        Tools.logToControl("out", "specialCoding2 result=" + result);
        Map map = SevenBitAlphabet.getSevenBitAlphabet();
        for (Map.Entry entry2 : map.entrySet()) {
            Object key2 = entry2.getKey();
            Object value2 = entry2.getValue();
            String tt = value2.toString();
            if (!tt.equals(result)) continue;
            return key2.toString();
        }
        return "";
    }

    public static String decode7bit(String src) {
        src = src.replace("\r", "");
        src = src.replace("\n", "");
        src = src.substring(58);
        String result = null;
        String temp = null;
        String change = "";
        String test = "";
        byte left = 0;
        if (src != null && src.length() % 2 == 0) {
            result = "";
            int[] b = new int[src.length() / 2];
            temp = String.valueOf(src) + "0";
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < temp.length() - 2) {
                b[j] = Integer.parseInt(temp.substring(i, i + 2), 16);
                k = j % 7;
                byte srcAscii = (byte)(b[j] << k & 0x7F | left);
                String byte2hex = GFString.byte2hex(srcAscii);
                Tools.logToControl("out", "byte=" + byte2hex);
                if (byte2hex.equals("1B")) {
                    test = "1B";
                } else {
                    if (test.equals("1B")) {
                        change = PDUdecoding.getPduPackSpecialCoding2(String.valueOf(test) + byte2hex);
                        test = "";
                    } else {
                        change = PDUdecoding.getPduPackSpecialCoding2(byte2hex);
                    }
                    Tools.logToControl("out", change);
                    result = String.valueOf(result) + change;
                }
                left = (byte)(b[j] >>> 7 - k);
                if (k == 6) {
                    byte2hex = GFString.byte2hex(left);
                    Tools.logToControl("out", "byte2=" + byte2hex);
                    if (byte2hex.equals("1B")) {
                        test = "1B";
                    } else {
                        if (test.equals("1B")) {
                            change = PDUdecoding.getPduPackSpecialCoding2(String.valueOf(test) + byte2hex);
                            test = "";
                        } else {
                            change = PDUdecoding.getPduPackSpecialCoding2(byte2hex);
                        }
                        Tools.logToControl("out", change);
                        result = String.valueOf(result) + change;
                        left = 0;
                    }
                }
                if (j == src.length() / 2) {
                    byte2hex = GFString.byte2hex(left);
                    Tools.logToControl("out", "byte3=" + byte2hex);
                    if (byte2hex.equals("1B")) {
                        test = "1B";
                    } else {
                        if (test.equals("1B")) {
                            change = PDUdecoding.getPduPackSpecialCoding2(String.valueOf(test) + byte2hex);
                            test = "";
                        } else {
                            change = PDUdecoding.getPduPackSpecialCoding2(byte2hex);
                        }
                        Tools.logToControl("out", change);
                        result = String.valueOf(result) + change;
                    }
                }
                i += 2;
                ++j;
            }
        }
        return result;
    }

    public static String unicode2gb(String hexString) {
        StringBuffer sb = new StringBuffer();
        if (hexString == null) {
            return null;
        }
        int i = 0;
        while (i + 4 <= hexString.length()) {
            try {
                int j = Integer.parseInt(hexString.substring(i, i + 4), 16);
                sb.append((char)j);
            }
            catch (NumberFormatException e) {
                return hexString;
            }
            i += 4;
        }
        return sb.toString();
    }

    public static String gb2unicode(String gbString) {
        String result = "";
        if (gbString == null) {
            return null;
        }
        String temp = null;
        char[] c = gbString.toCharArray();
        int i = 0;
        while (i < c.length) {
            char value = c[i];
            temp = Integer.toHexString(value);
            result = String.valueOf(result) + GFString.fill(temp, 4);
            ++i;
        }
        return result.toUpperCase();
    }

    public static boolean isContainData(String str) {
        boolean falge = false;
        if (str == "" || str == null) {
            falge = true;
        }
        int i = 0;
        while (i < str.length()) {
            falge = !Pattern.matches("\\d", String.valueOf(str.charAt(i)));
            ++i;
        }
        return falge;
    }
}

