/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.sms.commserver;

import com.huawei.mobilePartner.business.sms.commserver.ParsePduString;
import com.huawei.mobilePartner.business.sms.commserver.PduPack;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogATConfig;
import com.huawei.mobilePartner.common.util.GFString;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;

public class PDUdecoding {
    static final String unicode = "08";
    static final String sevenBit = "00";
    static final String smsResult = "01";
    private static LogATConfig logger = Log.getATLog(PDUdecoding.class);
    private static LanguageBean lb = CustomizeInit.getLanguageBean();
    public static boolean isLongSMS;

    public static String isPDU(String sms) {
        String temp = sms.substring(40, 42);
        if (temp.equals(unicode)) {
            return unicode;
        }
        if (temp.equals(sevenBit)) {
            return sevenBit;
        }
        if ((Integer.parseInt(sms.substring(18, 20)) & 2) > 0) {
            return smsResult;
        }
        return unicode;
    }

    public static boolean isReportSMS(String sms) {
        try {
            return (Integer.parseInt(sms.substring(18, 20)) & 2) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String[] getEverysms(String sms) {
        String[] temp = sms.split("\n");
        return temp;
    }

    public static String getTelphone(String sms) {
        String tel = sms;
        String temp = sms.substring(0, 2);
        String s = "";
        try {
            if (tel.toUpperCase().indexOf("F") > -1) {
                int i = 0;
                while (i < tel.length() - 2) {
                    s = String.valueOf(s) + tel.substring(i + 1, i + 2);
                    s = String.valueOf(s) + tel.substring(i, i + 1);
                    i += 2;
                }
                s = String.valueOf(s) + tel.substring(tel.length() - 1, tel.length());
            } else {
                int i = 0;
                while (i < tel.length()) {
                    s = String.valueOf(s) + tel.substring(i + 1, i + 2);
                    s = String.valueOf(s) + tel.substring(i, i + 1);
                    i += 2;
                }
            }
            if (s.length() >= 2) {
                if (ParsePduString.isInternationalTel(temp)) {
                    s = s.substring(2, s.length());
                    s = "+" + s;
                } else {
                    s = s.substring(2, s.length());
                }
            }
        }
        catch (Exception e) {
            logger.info("PDUdecoding.getTelphone():decodeing telephoe error.");
        }
        return s;
    }

    public static String getTelphoneBySmsResult(String sms) {
        String tel = sms.substring(26, 40);
        String s = "";
        int i = 0;
        while (i < 12) {
            s = String.valueOf(s) + tel.substring(i + 1, i + 2);
            s = String.valueOf(s) + tel.substring(i, i + 1);
            i += 2;
        }
        if ((s = String.valueOf(s) + tel.substring(tel.length() - 1, tel.length())).indexOf("86") > -1 && s.indexOf("+") <= -1) {
            s = "+" + s;
        }
        return s;
    }

    public static String getDataTime(String sms) {
        String t = "";
        try {
            String time = sms;
            String s = "";
            int i = 0;
            while (i < 12) {
                s = String.valueOf(s) + time.substring(i + 1, i + 2);
                s = String.valueOf(s) + time.substring(i, i + 1);
                i += 2;
            }
            t = String.valueOf(s.substring(4, 6)) + "/" + s.substring(2, 4) + "/" + "20" + s.substring(0, 2) + " " + s.substring(6, 8) + ":" + s.substring(8, 10) + ":" + s.substring(10, 12);
        }
        catch (Exception ex) {
            logger.info("parse time error.");
            t = PDUdecoding.getCurrentTime();
        }
        return t;
    }

    public static String getDataTimeBySmsResult(String sms) {
        String time = sms.substring(54, 66);
        String s = "";
        int i = 0;
        while (i < 12) {
            s = String.valueOf(s) + time.substring(i + 1, i + 2);
            s = String.valueOf(s) + time.substring(i, i + 1);
            i += 2;
        }
        String t = String.valueOf(s.substring(4, 6)) + "/" + s.substring(2, 4) + "/" + "20" + s.substring(0, 2) + " " + s.substring(6, 8) + ":" + s.substring(8, 10) + ":" + s.substring(10, 12);
        return t;
    }

    public static String getContent(String sms) {
        String c = "";
        String len = sms.substring(56, 58);
        int length = Integer.parseInt(len, 16);
        String content = sms.substring(58, 58 + (length *= 2));
        int i = 0;
        while (i < length) {
            String temp = content.substring(i, i + 4);
            int by = Integer.parseInt(temp, 16);
            char ascii = (char)by;
            c = String.valueOf(c) + String.valueOf(ascii);
            i += 4;
        }
        return c;
    }

    public static String unicode2gb(String sms) {
        StringBuffer sb;
        String hexString;
        block6: {
            sms = sms.replace("\r", "");
            hexString = sms = sms.replace("\n", "");
            sb = new StringBuffer();
            if (hexString != null) break block6;
            return null;
        }
        try {
            int i = 0;
            while (i + 4 <= hexString.length()) {
                try {
                    int j = Integer.parseInt(hexString.substring(i, i + 4), 16);
                    sb.append((char)j);
                }
                catch (NumberFormatException e) {
                    return hexString;
                }
                i += 4;
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.info("PDUdecoding.unicode2gb():this is a long message ,not cut.");
            e.printStackTrace();
            return "";
        }
    }

    public static String decode7bit(String src, int smsLength, String testByReceive) {
        src = src.replace("\r", "");
        src = src.replace("\n", "");
        String result = null;
        String temp = null;
        String change = "";
        String test = testByReceive;
        int testTime = 0;
        boolean flag = false;
        byte left = 0;
        if (src != null && src.length() % 2 == 0) {
            result = "";
            int[] b = new int[src.length() / 2];
            temp = String.valueOf(src) + "0";
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < temp.length() - 2) {
                flag = false;
                b[j] = Integer.parseInt(temp.substring(i, i + 2), 16);
                k = j % 7;
                byte srcAscii = (byte)(b[j] << k & 0x7F | left);
                String byte2hex = GFString.byte2hex(srcAscii);
                if (byte2hex.equals("1B")) {
                    test = "1B";
                    ++testTime;
                } else {
                    if (test.equals("1B")) {
                        change = PDUdecoding.getPduPackSpecialCoding2(String.valueOf(test) + byte2hex);
                        test = "";
                    } else {
                        change = PDUdecoding.getPduPackSpecialCoding2(byte2hex);
                    }
                    if (change.equals("")) {
                        try {
                            logger.info("PDUdecoding.decode7bit():decode 7 bit error.");
                        }
                        catch (Exception e) {
                            logger.info("PDUdecoding.decode7bit():decode 7 bit error.");
                            e.printStackTrace();
                        }
                    }
                    result = String.valueOf(result) + change;
                }
                left = (byte)(b[j] >>> 7 - k);
                if (k == 6) {
                    flag = true;
                    byte2hex = GFString.byte2hex(left);
                    if (byte2hex.equals("1B")) {
                        left = 0;
                        test = "1B";
                        ++testTime;
                    } else {
                        if (test.equals("1B")) {
                            change = PDUdecoding.getPduPackSpecialCoding2(String.valueOf(test) + byte2hex);
                            test = "";
                        } else {
                            change = PDUdecoding.getPduPackSpecialCoding2(byte2hex);
                        }
                        if (change.equals("")) {
                            try {
                                logger.info("PDUdecoding.decode7bit():decode 7 bit error.");
                                throw new Exception("\u89e3\u7801\u51fa\u9519------jiemachucuo");
                            }
                            catch (Exception e) {
                                logger.info("PDUdecoding.decode7bit():decode 7 bit error.");
                                e.printStackTrace();
                            }
                        }
                        result = String.valueOf(result) + change;
                        left = 0;
                    }
                }
                if (j == src.length() / 2) {
                    byte2hex = GFString.byte2hex(left);
                    if (byte2hex.equals("1B")) {
                        left = 0;
                        test = "1B";
                        ++testTime;
                    } else {
                        if (test.equals("1B")) {
                            change = PDUdecoding.getPduPackSpecialCoding2(String.valueOf(test) + byte2hex);
                            test = "";
                        } else {
                            change = PDUdecoding.getPduPackSpecialCoding2(byte2hex);
                        }
                        if (change.equals("")) {
                            try {
                                logger.info("PDUdecoding.decode7bit():decode 7 bit error.");
                                throw new Exception("\u89e3\u7801\u51fa\u9519------jiemachucuo");
                            }
                            catch (Exception e) {
                                logger.info("PDUdecoding.decode7bit():decode 7 bit error.");
                                e.printStackTrace();
                            }
                        }
                        result = String.valueOf(result) + change;
                    }
                }
                i += 2;
                ++j;
            }
        }
        Tools.logToControl("out", "testTime=" + testTime);
        if (smsLength - testTime == 7 && flag) {
            Tools.logToControl("out", "---smsLength-testTime==7&&flag==true");
            if (result.substring(result.length() - 1, result.length()).equals("@")) {
                System.err.println("---result.substring(result.length()-1,result.length()).equals('@')");
                result = result.substring(0, result.length() - 1);
            }
        }
        if (smsLength - testTime < result.length()) {
            Tools.logToControl("out", "---smsLength-testTime<result.length()");
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String getPduPackSpecialCoding2(String str) {
        String flag = PduPack.specialCoding2(str);
        flag = PduPack.unicode2gb(flag);
        return flag;
    }

    public static String decode7bit200(String sms) {
        sms = sms.replace("\r", "");
        sms = sms.replace("\n", "");
        String src = sms.substring(60);
        String result = null;
        String temp = null;
        int left = 0;
        if (src != null && src.length() % 2 == 0) {
            result = "";
            int[] b = new int[src.length() / 2];
            temp = String.valueOf(src) + "0";
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < temp.length() - 2) {
                b[j] = Integer.parseInt(temp.substring(i, i + 2), 16);
                k = j % 7;
                byte srcAscii = (byte)(b[j] << k & 0x7F | left);
                result = String.valueOf(result) + (char)srcAscii;
                left = (byte)(b[j] >>> 7 - k);
                if (k == 6) {
                    result = String.valueOf(result) + (char)left;
                    left = 0;
                }
                if (j == src.length() / 2) {
                    result = String.valueOf(result) + (char)left;
                }
                i += 2;
                ++j;
            }
        }
        return result;
    }

    public static String getTextContent(String sms) {
        byte by;
        String str = "";
        String c = "";
        sms = sms.replace("\r", "");
        sms = sms.replace("\n", "");
        String content = sms.substring(58);
        int i = content.length() - 2;
        while (i >= 0) {
            by = Byte.parseByte(content.substring(i, i + 2), 16);
            i -= 2;
        }
        i = str.length() - 7;
        while (i >= 0) {
            by = Byte.parseByte(str.substring(i, 7), 2);
            char ascii = (char)by;
            c = String.valueOf(c) + String.valueOf(ascii);
            i -= 7;
        }
        return c;
    }

    private static String getCurrentTime() {
        String time = "";
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        try {
            time = format.format(new Date());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return time;
    }

    public static boolean isData(String str) {
        boolean falge = false;
        if (str == null || "".equals(str)) {
            falge = false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Pattern.matches("\\d", String.valueOf(str.charAt(i)))) {
                falge = false;
                break;
            }
            falge = true;
            ++i;
        }
        return falge;
    }

    public static Vector getResult(String sms) {
        logger.info("sms pdu string=" + sms);
        Vector vector = new Vector();
        try {
            Map map = PDUdecoding.analyticSMS(sms);
            if (map.isEmpty()) {
                logger.info("the method getResult by PDUdecoding error");
                logger.info("SMS parse error, parse the content :" + sms);
            }
            if (map.get("longSMS") != null) {
                vector.add(map.get("longSMS"));
                isLongSMS = true;
            } else {
                isLongSMS = false;
            }
            vector.add(map.get("tpra"));
            vector.add(map.get("tpudl"));
            vector.add(map.get("tpdsc"));
            vector.add(map.get("report"));
        }
        catch (Exception ex) {
            logger.info("--------------------getResult() Message Return Error-------------------");
        }
        return vector;
    }

    public static String parseTextModeUnicode(String smsText) {
        StringBuilder sms = new StringBuilder();
        if (smsText == null || "".equals(smsText)) {
            return "";
        }
        String header = smsText.substring(0, 8);
        if ("000D000A".equalsIgnoreCase(header)) {
            smsText = smsText.substring(8, smsText.length());
        }
        if (Integer.parseInt(smsText.substring(4, 8), 16) == 0) {
            smsText = "0000" + smsText;
        }
        String temp = "";
        if (smsText.length() <= 4) {
            temp = String.valueOf(smsText.substring(2, 4)) + sevenBit;
            sms.append(temp);
        } else {
            int i = 0;
            while (i < smsText.length()) {
                temp = smsText.substring(i + 2, i + 4);
                sms.append(temp);
                i += 4;
            }
        }
        return sms.toString();
    }

    public static String smsModeTextParse(String smsSrc, String report) {
        String smsDes = "";
        try {
            if (report.contains("0")) {
                smsDes = PDUdecoding.unicode2gb(PDUdecoding.parseTextModeUnicode(PduPack.gb2unicode(smsSrc)));
                System.err.println("123report=" + report + "  smsSrc=" + smsSrc);
            } else {
                smsDes = "The message you sent to 8613312129306 has been delivered successfully.";
            }
        }
        catch (Exception ex) {
            logger.error("PDUdecoding.smsModeTextParse():Decode sms error. ");
        }
        return smsDes;
    }

    public static Vector getResultByCDMA(String telphone, String context, String dataTime, String format, String report) {
        String temp = "";
        Vector<String> vector = new Vector<String>();
        vector.add(telphone);
        if (format.equals("6")) {
            temp = PDUdecoding.smsModeTextParse(context, report);
            logger.info("short message Unicode content:" + temp);
            vector.add(temp);
        } else if (format.equals("0")) {
            temp = PduPack.decode7bit(context);
            logger.info("short message 7 bit content:" + temp);
            vector.add(temp);
        } else {
            logger.info("short message other encode content:" + context);
            vector.add(context);
        }
        vector.add(dataTime);
        return vector;
    }

    private static Map pudParse2(String sms) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            int j = 0;
            int a = Integer.parseInt(sms.substring(0, 2));
            j = a * 2 + 2;
            String temp = sms.substring(4, j);
            if (sms.substring(22, 24).equals(sevenBit)) {
                int pos = 22;
                temp = sms.substring(22, 24);
                pos = 28;
                if (temp.equals(sevenBit)) {
                    map.put("tpra", "");
                    temp = sms.substring(pos, pos + 2);
                    temp = ParsePduString.getDateCode(temp);
                    map.put("tppid", temp);
                    temp = sms.substring(pos += 2, pos + 2);
                    if (PDUdecoding.isData(temp)) {
                        temp = sms.substring(pos, pos + 14);
                        temp = PDUdecoding.getDataTime(temp);
                        pos += 14;
                    } else {
                        temp = PDUdecoding.getCurrentTime();
                        pos += 2;
                    }
                    map.put("tpdsc", temp);
                    temp = sms.substring(pos, pos + 2);
                    a = Integer.parseInt(temp, 16);
                    pos += 2;
                    if (map.get("tppid").equals(sevenBit)) {
                        if (a == 0) {
                            map.put("tpudl", "");
                        } else {
                            temp = sms.substring(pos, sms.length());
                            temp = PDUdecoding.decode7bit(temp, a, "");
                            map.put("tpudl", temp);
                        }
                    } else if (map.get("tppid").equals(unicode)) {
                        if (a == 0) {
                            map.put("tpudl", "");
                        } else {
                            temp = sms.substring(pos, sms.length());
                            temp = PDUdecoding.unicode2gb(temp);
                            map.put("tpudl", temp);
                        }
                    } else {
                        map.put("tpudl", "");
                    }
                }
            } else if ((Integer.parseInt(sms.substring(j, j + 2), 16) & 2) > 0) {
                int b = Integer.parseInt(sms.substring(j += 2, j + 2), 16);
                j += 4;
                if (b % 2 != 0) {
                    ++b;
                }
                temp = sms.substring(j, j + b);
                temp = PDUdecoding.getTelphone(temp);
                map.put("tpra", temp);
                temp = sms.substring(j += b, j + 14);
                temp = PDUdecoding.getDataTime(temp);
                map.put("tpdsc", temp);
                temp = sms.substring(sms.length() - 2).equals(sevenBit) ? "Success" : "Failed";
                map.put("tpudl", temp);
            } else {
                if ((Integer.parseInt(sms.substring(j, j + 2), 16) & 0x40) > 0) {
                    map.put("longSMS", "0");
                }
                temp = sms.substring(j += 4, j + 2);
                int b = Integer.parseInt(temp, 16);
                j += 4;
                if (b % 2 != 0) {
                    ++b;
                }
                temp = sms.substring(j, j + b);
                temp = PDUdecoding.getTelphone(temp);
                Tools.logToControl("out", "!!!!!!!!!!!!!!!!!!!!! temp=" + temp + " J=" + j + " B=" + b);
                map.put("tpra", temp);
                j += b;
                temp = sms.substring(j += 2, j + 2);
                map.put("tppid", temp);
                temp = sms.substring(j += 2, j + 2);
                if (PDUdecoding.isData(temp)) {
                    temp = PDUdecoding.getDataTime(temp);
                    j += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    j += 2;
                }
                map.put("tpdsc", temp);
                temp = sms.substring(j, j + 2);
                int c = Integer.parseInt(temp, 16);
                Tools.logToControl("out", "@!#!#!###!$    temp=" + temp);
                Tools.logToControl("out", " + c + temp:" + temp + " j=" + j);
                temp = sms.substring(j += 2);
                if (map.get("longSMS") != null) {
                    temp = sms.substring(j, j + 2);
                    if ("05".equals(temp)) {
                        temp = sms.substring(j, j + 12);
                        map.put("longSMS", temp);
                        temp = sms.substring(j += 12);
                    } else {
                        temp = sms.substring(j, j + 14);
                        map.put("longSMS", temp);
                        temp = sms.substring(j += 14);
                    }
                }
                if (map.get("tppid").equals(unicode)) {
                    temp = PDUdecoding.unicode2gb(temp);
                    map.put("tpudl", temp);
                } else if (map.get("longSMS") != null) {
                    String str = temp.substring(0, 2);
                    if (!sevenBit.equals(str)) {
                        str = Integer.toBinaryString(Integer.parseInt(str, 16));
                        str = str.substring(0, str.length() - 1);
                        if ((str = Integer.toHexString(Integer.parseInt(str, 2))).length() < 2) {
                            str = "0" + str;
                        }
                        if ("".equals(str = PDUdecoding.decode7bit(str, 1, ""))) {
                            temp = temp.substring(2);
                            temp = PDUdecoding.decode7bit(temp, c - 6 - 1 - 1, "1B");
                        } else {
                            temp = temp.substring(2);
                            temp = PDUdecoding.decode7bit(temp, c - 1 - 6 - 1, "");
                            temp = String.valueOf(str) + temp;
                        }
                    } else {
                        logger.info(sevenBit);
                        str = "@";
                        temp = temp.substring(2);
                        temp = PDUdecoding.decode7bit(temp, c - 1 - 6 - 1, "");
                        temp = String.valueOf(str) + temp;
                    }
                    map.put("tpudl", temp);
                } else {
                    temp = PDUdecoding.decode7bit(temp, c, "");
                    System.err.println("GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG");
                    map.put("tpudl", temp);
                }
            }
            return map;
        }
        catch (Exception e) {
            logger.info("abc by catch analytic SMS error, the sms:" + sms);
            return new HashMap();
        }
    }

    private static Map pudCode2(String sms) {
        Map<String, String> map = new HashMap();
        String telTemp = "";
        try {
            int b;
            int j = 0;
            int a = Integer.parseInt(sms.substring(0, 2));
            j = a * 2 + 2;
            Tools.logToControl("out", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa a=" + Integer.parseInt(unicode, 16));
            String temp = sms.substring(4, j);
            j = ParsePduString.isSubmitSms(sms.substring(j, j + 2)) ? (j += 4) : (j += 2);
            Tools.logToControl("out", "OOOOOOOOOOOOOOOOOOOOOOO =" + sms.substring(j, j + 2));
            if (sms.substring(22, 24).equals(sevenBit)) {
                int pos = 22;
                temp = sms.substring(22, 24);
                pos = 28;
                if (temp.equals(sevenBit)) {
                    map.put("tpra", "");
                    temp = sms.substring(pos, pos + 2);
                    temp = ParsePduString.getDateCode(temp);
                    map.put("tppid", temp);
                    temp = sms.substring(pos += 2, pos + 2);
                    Tools.logToControl("out", "temp>>>>>>>>>>>>" + pos + "  temp=" + temp);
                    if (PDUdecoding.isData(temp)) {
                        temp = sms.substring(pos, pos + 14);
                        temp = PDUdecoding.getDataTime(temp);
                        pos += 14;
                    } else {
                        temp = PDUdecoding.getCurrentTime();
                        pos += 2;
                    }
                    map.put("tpdsc", temp);
                    if (map.get("tppid").equals(sevenBit)) {
                        temp = sms.substring(pos, pos + 2);
                        a = Integer.parseInt(temp, 16);
                        Tools.logToControl("out", "---------------------------------" + (pos += 2) + " temp=" + a);
                        temp = sms.substring(pos, sms.length());
                        temp = PDUdecoding.decode7bit(temp, a, "");
                        map.put("tpudl", temp);
                    } else if (map.get("tppid").equals(unicode)) {
                        temp = sms.substring(pos + 2, sms.length());
                        temp = PDUdecoding.unicode2gb(temp);
                        map.put("tpudl", temp);
                    } else {
                        logger.info("PDUdecoding:pduCode2(): pro ID is not 00 or not 08 by usc2 decode.");
                        temp = sms.substring(pos + 2, sms.length());
                        temp = PDUdecoding.unicode2gb(temp);
                        map.put("tpudl", temp);
                    }
                }
            }
            if (ParsePduString.reportstatus == 1) {
                b = Integer.parseInt(sms.substring(j, j + 2), 16);
                telTemp = sms.substring(j + 2, j + 4);
                j += 4;
                if (b % 2 != 0) {
                    ++b;
                }
                temp = sms.substring(j - 2, j + b);
                temp = PDUdecoding.getTelphone(temp);
                map.put("tpra", temp);
                temp = sms.substring(j += b, j + 4);
                if (PDUdecoding.isData(temp)) {
                    temp = sms.substring(j, j + 14);
                    Tools.logToControl("err", "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ temp=" + temp);
                    temp = PDUdecoding.getDataTime(temp);
                } else {
                    temp = PDUdecoding.getCurrentTime();
                }
                map.put("tpdsc", temp);
                temp = sms.substring(sms.length() - 2).equals(sevenBit) ? lb.getSms_report_success() : lb.getSms_report_failure();
                map.put("tpudl", temp);
                ParsePduString.reportstatus = 0;
            } else {
                b = Integer.parseInt(sms.substring(j, j + 2), 16);
                telTemp = sms.substring(j + 2, j + 4);
                j += 4;
                if (b % 2 != 0) {
                    ++b;
                }
                String telNum = "";
                temp = ParsePduString.isInternationalTel(telTemp) ? sms.substring(j - 2, j + b) : sms.substring(j, j + b);
                if (temp.length() != b + 2) {
                    temp = sms.substring(j - 2, j + b);
                }
                telNum = temp;
                temp = PDUdecoding.getTelphone(temp);
                map.put("tpra", temp);
                j += b;
                temp = sms.substring(j += 2, j + 2);
                temp = ParsePduString.getDateCode(temp);
                map.put("tppid", temp);
                temp = sms.substring(j += 2, j + 2);
                if (PDUdecoding.isData(temp)) {
                    temp = sms.substring(j, j + 14);
                    temp = PDUdecoding.getDataTime(temp);
                    j += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    j += 2;
                }
                map.put("tpdsc", temp);
                temp = sms.substring(j, j + 2);
                int c = Integer.parseInt(temp, 16);
                temp = sms.substring(j += 2);
                if (c != 0 && ParsePduString.longMessage == 1) {
                    map.put("longSMS", "0");
                }
                if (map.get("longSMS") != null) {
                    temp = sms.substring(j, j + 2);
                    if ("05".equals(temp)) {
                        temp = sms.substring(j, j + 12);
                        map.put("longSMS", temp);
                        temp = sms.substring(j += 12);
                    } else {
                        temp = sms.substring(j, j + 14);
                        map.put("longSMS", temp);
                        temp = sms.substring(j += 14);
                    }
                }
                if (map.get("tppid").equals(unicode)) {
                    temp = PDUdecoding.unicode2gb(temp);
                    map.put("tpudl", temp);
                } else if (map.get("longSMS") != null) {
                    String str = temp.substring(0, 2);
                    if (!sevenBit.equals(str)) {
                        str = Integer.toBinaryString(Integer.parseInt(str, 16));
                        str = str.substring(0, str.length() - 1);
                        if ((str = Integer.toHexString(Integer.parseInt(str, 2))).length() < 2) {
                            str = "0" + str;
                        }
                        if ("".equals(str = PDUdecoding.decode7bit(str, 1, ""))) {
                            temp = temp.substring(2);
                            temp = PDUdecoding.decode7bit(temp, c - 6 - 1 - 1, "1B");
                        } else {
                            temp = temp.substring(2);
                            temp = PDUdecoding.decode7bit(temp, c - 1 - 6 - 1, "");
                            System.err.println("^^^^^^^^^^^^^^##########^^^^^^^^^^^ temp=" + temp);
                            temp = String.valueOf(str) + temp;
                        }
                    } else {
                        logger.info(sevenBit);
                        str = "@";
                        temp = temp.substring(2);
                        temp = PDUdecoding.decode7bit(temp, c - 1 - 6 - 1, "");
                        temp = String.valueOf(str) + temp;
                    }
                    map.put("tpudl", temp);
                } else if (c == 0) {
                    map.put("tpudl", "");
                } else {
                    temp = PDUdecoding.decode7bit(temp, c, "");
                    map.put("tpudl", temp);
                }
            }
            temp = map.get("tpra").toString();
            Tools.logToControl("out", "111111^^^^^^^^^^^^^^^^^^^^^^^^^^ " + temp);
        }
        catch (Exception e) {
            logger.info("abc by catch analytic SMS error, the sms:" + sms);
            map = PDUdecoding.pudParse2(sms);
        }
        return map;
    }

    public static Map pduStringParse(String sms) {
        HashMap<String, String> map = new HashMap<String, String>();
        String temp = "";
        int pos = 0;
        int state = 0;
        pos = 2;
        try {
            temp = sms.substring(0, pos);
            state = Integer.parseInt(temp, 16) * 2;
            pos = ParsePduString.isSubmitSms(sms.substring(pos + state, state + pos + 2)) ? pos + state + 4 : pos + state + 2;
            if (state == 0) {
                temp = sms.substring(pos, pos + 2);
                pos += 2;
            } else {
                temp = sms.substring(pos, pos + 2);
                pos += 2;
            }
            state = Integer.parseInt(temp, 16);
            if (state == 0) {
                int udlLength = 0;
                map.put("tpra", "");
                temp = sms.substring(pos += 4, pos + 2);
                temp = ParsePduString.getDateCode(temp);
                map.put("tppid", temp);
                temp = sms.substring(pos += 2, pos + 4);
                if (PDUdecoding.isData(temp)) {
                    temp = sms.substring(pos, pos + 14);
                    temp = PDUdecoding.getDataTime(temp);
                    pos += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    pos += 2;
                }
                map.put("tpdsc", temp);
                temp = sms.substring(pos, pos + 2);
                udlLength = Integer.parseInt(temp, 16);
                pos += 2;
                if (map.get("tppid").equals(sevenBit)) {
                    if (udlLength == 0) {
                        map.put("tpudl", "");
                    } else {
                        temp = sms.substring(pos, sms.length());
                        temp = PDUdecoding.decode7bit(temp, udlLength, "");
                        map.put("tpudl", temp);
                    }
                } else if (map.get("tppid").equals(unicode)) {
                    if (udlLength == 0) {
                        map.put("tpudl", "");
                    } else {
                        temp = sms.substring(pos, sms.length());
                        temp = PDUdecoding.unicode2gb(temp);
                        map.put("tpudl", temp);
                    }
                } else {
                    map.put("tpudl", "");
                }
                map.put("reprot", "0");
            } else {
                if (state % 2 != 0) {
                    ++state;
                }
                temp = sms.substring(pos, pos + state + 2);
                int tel = pos + state + 2;
                int pos2 = pos;
                pos = pos + 2 + state;
                temp = PDUdecoding.getTelphone(temp);
                map.put("tpra", temp);
                if (!PDUdecoding.isData("" + map.get("tpra")) && !("" + map.get("tpra")).substring(0, 1).equals("+")) {
                    temp = sms.substring(pos2 + 2, tel);
                    temp = PDUdecoding.decode7bit(temp, tel, "");
                    map.put("tpra", temp);
                }
                if (ParsePduString.reportstatus == 1) {
                    temp = sms.substring(pos, pos + 4);
                    if (PDUdecoding.isData(temp)) {
                        temp = sms.substring(pos, pos + 14);
                        temp = PDUdecoding.getDataTime(temp);
                        pos += 14;
                    } else {
                        temp = PDUdecoding.getCurrentTime();
                        pos += 2;
                    }
                    map.put("tpdsc", temp);
                    temp = sms.substring(sms.length() - 2).equals(sevenBit) ? lb.getSms_report_success() : lb.getSms_report_failure();
                    map.put("tpudl", temp);
                    ParsePduString.reportstatus = 0;
                    map.put("report", "1");
                } else {
                    temp = sms.substring(pos += 2, pos + 2);
                    temp = ParsePduString.getDateCode(temp);
                    map.put("tppid", temp);
                    temp = sms.substring(pos += 2, pos + 4);
                    if (PDUdecoding.isData(temp)) {
                        temp = sms.substring(pos, pos + 14);
                        temp = PDUdecoding.getDataTime(temp);
                        pos += 14;
                    } else {
                        temp = PDUdecoding.getCurrentTime();
                        pos += 2;
                    }
                    map.put("tpdsc", temp);
                    temp = sms.substring(pos, pos + 2);
                    pos += 2;
                    state = Integer.parseInt(temp, 16);
                    if (state != 0 && ParsePduString.longMessage == 1) {
                        map.put("longSMS", "0");
                    }
                    if (map.get("longSMS") != null) {
                        temp = sms.substring(pos, pos + 2);
                        if ("05".equals(temp)) {
                            temp = sms.substring(pos, pos + 12);
                            map.put("longSMS", temp);
                            temp = sms.substring(pos += 12);
                        } else {
                            temp = sms.substring(pos, pos + 14);
                            map.put("longSMS", temp);
                            temp = sms.substring(pos += 14);
                        }
                    }
                    if (map.get("tppid").equals(sevenBit)) {
                        if (map.get("longSMS") != null) {
                            String str = temp.substring(0, 2);
                            if (!sevenBit.equals(str)) {
                                str = Integer.toBinaryString(Integer.parseInt(str, 16));
                                str = str.substring(0, str.length() - 1);
                                if ((str = Integer.toHexString(Integer.parseInt(str, 2))).length() < 2) {
                                    str = "0" + str;
                                }
                                if ("".equals(str = PDUdecoding.decode7bit(str, 1, ""))) {
                                    temp = temp.substring(2);
                                    temp = PDUdecoding.decode7bit(temp, state - 6 - 1 - 1, "1B");
                                } else {
                                    temp = temp.substring(2);
                                    temp = PDUdecoding.decode7bit(temp, state - 1 - 6 - 1, "");
                                    temp = String.valueOf(str) + temp;
                                }
                            } else {
                                logger.info(sevenBit);
                                str = "@";
                                temp = temp.substring(2);
                                temp = PDUdecoding.decode7bit(temp, state - 1 - 6 - 1, "");
                                temp = String.valueOf(str) + temp;
                            }
                            map.put("tpudl", temp);
                        } else if (state == 0) {
                            map.put("tpudl", "");
                        } else {
                            temp = sms.substring(pos, sms.length());
                            temp = PDUdecoding.decode7bit(temp, state, "");
                            map.put("tpudl", temp);
                        }
                    } else if (map.get("tppid").equals(unicode)) {
                        if (state == 0) {
                            map.put("tpudl", "");
                        } else {
                            temp = sms.substring(pos, sms.length());
                            temp = PDUdecoding.unicode2gb(temp);
                            map.put("tpudl", temp);
                        }
                    } else {
                        map.put("tpra", "D888888");
                        logger.info(" pduStringParse():this message is 8Bit encode.");
                    }
                    map.put("report", "0");
                }
            }
        }
        catch (Exception ex) {
            map.put("tpra", "D888888");
            logger.info("pduParseString:pdu parse error");
        }
        return map;
    }

    public static Map pduParse(String sms) {
        HashMap<String, String> map = new HashMap<String, String>();
        String temp = "";
        int pos = 0;
        int state = 0;
        pos = 2;
        temp = sms.substring(0, pos);
        state = Integer.parseInt(temp, 16) * 2;
        pos = ParsePduString.isSubmitSms(sms.substring(pos + state, state + pos + 2)) ? pos + state + 4 : pos + state + 2;
        if (state == 0) {
            pos = 4;
            temp = sms.substring(pos, pos + 2);
            pos += 4;
        } else {
            temp = sms.substring(pos, pos + 2);
            pos += 4;
        }
        state = Integer.parseInt(temp, 16);
        if (state == 0) {
            int udlLength = 0;
            map.put("tpra", "");
            temp = sms.substring(pos += 2, pos + 2);
            temp = ParsePduString.getDateCode(temp);
            map.put("tppid", temp);
            temp = sms.substring(pos += 2, pos + 4);
            if (PDUdecoding.isData(temp)) {
                temp = sms.substring(pos, pos + 14);
                temp = PDUdecoding.getDataTime(temp);
                pos += 14;
            } else {
                temp = PDUdecoding.getCurrentTime();
                pos += 2;
            }
            map.put("tpdsc", temp);
            temp = sms.substring(pos, pos + 2);
            udlLength = Integer.parseInt(temp, 16);
            pos += 2;
            if (map.get("tppid").equals(sevenBit)) {
                if (udlLength == 0) {
                    map.put("tpudl", "");
                } else {
                    temp = sms.substring(pos, sms.length());
                    temp = PDUdecoding.decode7bit(temp, udlLength, "");
                    map.put("tpudl", temp);
                }
            } else if (map.get("tppid").equals(unicode)) {
                if (udlLength == 0) {
                    map.put("tpudl", "");
                } else {
                    temp = sms.substring(pos, sms.length());
                    temp = PDUdecoding.unicode2gb(temp);
                    map.put("tpudl", temp);
                }
            } else {
                map.put("tpudl", "");
            }
        } else {
            if (state % 2 != 0) {
                ++state;
            }
            temp = sms.substring(pos - 2, pos + state);
            int tel = pos + state;
            int pos2 = pos;
            pos = pos + 2 + state;
            temp = PDUdecoding.getTelphone(temp);
            map.put("tpra", temp);
            if (ParsePduString.reportstatus == 1) {
                temp = sms.substring(pos, pos + 4);
                if (PDUdecoding.isData(temp)) {
                    temp = sms.substring(pos - 2, pos + 14);
                    temp = PDUdecoding.getDataTime(temp);
                    pos += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    pos += 2;
                }
                map.put("tpdsc", temp);
                sms.substring(sms.length() - 2).equals(sevenBit);
                map.put("tpudl", temp);
                ParsePduString.reportstatus = 0;
            } else {
                temp = sms.substring(pos, pos + 2);
                pos += 2;
                temp = ParsePduString.getDateCode(temp);
                map.put("tppid", temp);
                if (!PDUdecoding.isData("" + map.get("tpra")) && !("" + map.get("tpra")).substring(0, 1).equals("+")) {
                    temp = sms.substring(pos2, tel);
                    Tools.logToControl("err", "**************************** temp=" + temp + "      pos=" + pos + " ^^^^^ tel=" + tel);
                    temp = PDUdecoding.decode7bit(temp, tel, "");
                    map.put("tpra", temp);
                }
                if (PDUdecoding.isData(temp = sms.substring(pos, pos + 4))) {
                    temp = sms.substring(pos, pos + 14);
                    temp = PDUdecoding.getDataTime(temp);
                    pos += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    pos += 2;
                }
                map.put("tpdsc", temp);
                temp = sms.substring(pos, pos + 2);
                pos += 2;
                state = Integer.parseInt(temp, 16);
                if (state != 0 && ParsePduString.longMessage == 1) {
                    map.put("longSMS", "0");
                }
                if (map.get("longSMS") != null) {
                    temp = sms.substring(pos, pos + 2);
                    if ("05".equals(temp)) {
                        temp = sms.substring(pos, pos + 12);
                        map.put("longSMS", temp);
                        temp = sms.substring(pos += 12);
                    } else {
                        temp = sms.substring(pos, pos + 14);
                        map.put("longSMS", temp);
                        temp = sms.substring(pos += 14);
                    }
                }
                if (map.get("tppid").equals(sevenBit)) {
                    if (state == 0) {
                        map.put("tpudl", "");
                    } else {
                        temp = sms.substring(pos, sms.length());
                        temp = PDUdecoding.decode7bit(temp, state, "");
                        map.put("tpudl", temp);
                    }
                } else if (map.get("tppid").equals(unicode)) {
                    if (state == 0) {
                        map.put("tpudl", "");
                    } else {
                        temp = sms.substring(pos, sms.length());
                        temp = PDUdecoding.unicode2gb(temp);
                        map.put("tpudl", temp);
                    }
                } else if (state == 0) {
                    map.put("tpudl", "");
                } else {
                    temp = sms.substring(pos, sms.length());
                    temp = PDUdecoding.unicode2gb(temp);
                    map.put("tpudl", temp);
                }
            }
        }
        return map;
    }

    private static Map pduCode(String sms) {
        HashMap<String, String> pduCode = new HashMap<String, String>();
        boolean c = false;
        String telFalge = "";
        int pos = 2;
        int state = 0;
        String temp = "";
        try {
            temp = sms.substring(pos, pos + 2);
            pos = ParsePduString.isSubmitSms(temp) ? (pos += 4) : (pos += 2);
            temp = sms.substring(pos, pos + 2);
            state = Integer.parseInt(temp, 16);
            if (state == 0) {
                pos = pos + 6 + state;
                pduCode.put("tpra", "");
                temp = sms.substring(pos, pos + 2);
                temp = ParsePduString.getDateCode(temp);
                pduCode.put("tppid", temp);
                temp = sms.substring(pos += 2, pos + 4);
                if (PDUdecoding.isData(temp)) {
                    temp = sms.substring(pos, pos + 14);
                    temp = PDUdecoding.getDataTime(temp);
                    pos += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    pos += 2;
                }
                pduCode.put("tpdsc", temp);
                Tools.logToControl("out", "GGGGGGGGG TEMP=" + temp + " psotion=" + pos);
            } else {
                if (state % 2 != 0) {
                    ++state;
                }
                temp = sms.substring(pos += 2, pos + 2);
                temp = sms.substring(pos, pos + state + 2);
                pos = pos + state + 4;
                temp = PDUdecoding.getTelphone(temp);
                pduCode.put("tpra", temp);
                temp = sms.substring(pos, pos + 2);
                temp = ParsePduString.getDateCode(temp);
                pduCode.put("tppid", temp);
                temp = sms.substring(pos += 2, pos + 4);
                if (PDUdecoding.isData(temp)) {
                    temp = sms.substring(pos, pos + 14);
                    temp = PDUdecoding.getDataTime(temp);
                    pos += 14;
                } else {
                    temp = PDUdecoding.getCurrentTime();
                    pos += 2;
                }
            }
            pduCode.put("tpdsc", temp);
            if (pduCode.get("tppid").equals(sevenBit)) {
                temp = sms.substring(pos, pos + 2);
                pos += 2;
                state = Integer.parseInt(temp, 16);
                if (state > 160) {
                    temp = sms.substring(pos - 2, pos);
                    pos -= 2;
                }
                Tools.logToControl("out", "ooxxxxxs temp=" + temp + " state=" + state);
                temp = sms.substring(pos, sms.length());
                temp = PDUdecoding.decode7bit(temp, state, "");
                pduCode.put("tpudl", temp);
            }
            if (pduCode.get("tppid").equals(unicode)) {
                temp = PDUdecoding.unicode2gb(sms.substring(pos += 2));
                pduCode.put("tpudl", temp);
            }
        }
        catch (Exception ex) {
            logger.info("PDUdecoding.pduCode():parse PDU error.");
            return new HashMap();
        }
        return pduCode;
    }

    public static Map analyticSMS(String sms) {
        Map map = PDUdecoding.pduStringParse(sms);
        return map;
    }

    public static void main(String[] arg) {
        String temp = "07813108705505F011000B815109572505F10008FF5E554A554A4E0055C44E865BB64EBA4EEC90FD88AB635555C47A9889E3813154C8554A4E3E529E516C7ECF5E3889C197625BF965B95F0F76844E0079CD65CF4E3B8981662F4E2A4E2A4E2A4E2A4E2A4E2A4E2A4E2A4E2A4E2A554A4E0079CD";
    }
}

