/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.pin;

import com.huawei.mobilePartner.business.device.DeviceService;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.data.comm.service.NetCommService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PinManage {
    DeviceService dev = DeviceService.getInstance();
    String devstr = Tools.checkNull(this.dev.getProductNetType());
    LogConfig log = Log.getLog(PinManage.class);
    NetCommService comm = null;
    HashMap map = null;
    private static PinManage pinManage;

    public static PinManage getInstance() {
        if (pinManage == null) {
            pinManage = new PinManage();
        }
        return pinManage;
    }

    public boolean activationPinEfficacy(HashMap map) {
        boolean returnflag = true;
        try {
            int btType = 5;
            String pszPinCode = Tools.checkNull(map.get("pszPinCode"));
            long pdwStatus = 0L;
            this.comm = NetCommService.getInstance();
            returnflag = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.srvEnablePin(pszPinCode) : this.comm.srvEnablePinByCDMA(pszPinCode);
        }
        catch (Exception ex) {
            returnflag = false;
            ex.printStackTrace();
            this.log.info("activationPinEfficacy   error:" + ex);
        }
        this.log.info("PinManage activationPinEfficacy=" + returnflag);
        return returnflag;
    }

    public boolean forbidPinEfficacy(HashMap map) {
        boolean returnflag = true;
        try {
            int btType = 5;
            String pszPinCode = Tools.checkNull(map.get("pszPinCode"));
            long pdwStatus = 0L;
            this.comm = NetCommService.getInstance();
            returnflag = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.srvDisablePin(pszPinCode) : this.comm.srvDisablePinByCDMA(pszPinCode);
        }
        catch (Exception ex) {
            returnflag = false;
            ex.printStackTrace();
            this.log.info("forbidPinEfficacy,error:" + ex);
        }
        this.log.info("PinManage forbidPinEfficacy=" + returnflag);
        return returnflag;
    }

    public boolean updatePin(HashMap map) {
        boolean returnflag = true;
        try {
            int btType = 5;
            String pszOldPinCode = Tools.checkNull(map.get("pszOldPinCode"));
            String pszNewPinCode = Tools.checkNull(map.get("pszNewPinCode"));
            long pdwStatus = 0L;
            this.comm = NetCommService.getInstance();
            returnflag = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.srvChangePin(pszOldPinCode, pszNewPinCode) : this.comm.srvChangePinByCDMA(pszOldPinCode, pszNewPinCode);
        }
        catch (Exception ex) {
            returnflag = false;
            ex.printStackTrace();
            this.log.info("updatePin,error: " + ex);
        }
        this.log.info("PinManage updatePin=" + returnflag);
        return returnflag;
    }

    public String pinEfficacy(HashMap map) {
        String returnflag = null;
        try {
            String pszPinCode = Tools.checkNull(map.get("pszPinCode"));
            this.comm = NetCommService.getInstance();
            returnflag = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.srvVerifyPin(pszPinCode) : this.comm.srvVerifyPinByCDMA(pszPinCode);
        }
        catch (Exception ex) {
            returnflag = PublicConfig.failure;
            ex.printStackTrace();
            this.log.info("PinEfficacy,error: " + ex);
        }
        this.log.info("PinManage PinEfficacy=" + returnflag);
        return returnflag;
    }

    public String usePuKUndoPin(HashMap map) {
        String returnflag = "";
        try {
            String pszPuk = Tools.checkNull(map.get("pszPuk"));
            String pszNewPinCode = Tools.checkNull(map.get("pszNewPinCode"));
            this.comm = NetCommService.getInstance();
            returnflag = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.srvUnblockPin(pszPuk, pszNewPinCode) : this.comm.srvUnblockPinByCDMA(pszPuk, pszNewPinCode);
        }
        catch (Exception ex) {
            returnflag = PublicConfig.failure;
            ex.printStackTrace();
            this.log.info("usePuKUndoPin,error: " + ex);
        }
        this.log.info("PinManage usePuKUndoPin=" + returnflag);
        return returnflag;
    }

    public String isPinEfficacy(HashMap map) {
        String returnflag = null;
        try {
            this.comm = NetCommService.getInstance();
            returnflag = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.IsPinEfficacyByWCDMA(map) : this.comm.IsPinEfficacyByCDMA(map);
        }
        catch (Exception ex) {
            returnflag = "0";
            ex.printStackTrace();
            this.log.info("IsPinEfficacy  error: " + ex.toString());
        }
        return returnflag;
    }

    public List menuShowStatus(HashMap m) throws Exception {
        List list = null;
        this.comm = NetCommService.getInstance();
        list = "WCDMA".equalsIgnoreCase(this.dev.getProductNetType()) ? this.comm.menuShowStatus(m) : this.comm.menuShowStatusByCDMA(m);
        return list;
    }

    public HashMap queryPinPukCount(HashMap m) throws Exception {
        this.map = new HashMap();
        this.comm = NetCommService.getInstance();
        this.map = this.comm.queryPinPukCount(m);
        return this.map;
    }

    public HashMap queryPwdLength(HashMap m) throws Exception {
        this.map = new HashMap();
        this.comm = NetCommService.getInstance();
        this.map = this.comm.queryPwdLength(m);
        return this.map;
    }

    public static void refreshMenuByPinStatus(String pin) {
        ArrayList<String> list = null;
        if (PublicConfig.pinForbid.equalsIgnoreCase(PublicConfig.PinStatus)) {
            list = new ArrayList<String>();
            list.add(PublicConfig.menuShowFlag);
            list.add(PublicConfig.menuHideFlag);
            list.add(PublicConfig.menuHideFlag);
            list.add(PublicConfig.menuHideFlag);
            list.add(PublicConfig.menuHideFlag);
        } else {
            list = new ArrayList();
            list.add(PublicConfig.menuHideFlag);
            list.add(PublicConfig.menuShowFlag);
            list.add(PublicConfig.menuHideFlag);
            list.add(PublicConfig.menuShowFlag);
            list.add(PublicConfig.menuHideFlag);
        }
        AppFrame appFrame = AppFrame.getAppFrameInit();
        appFrame.pinMenuItem.setEnabled(true);
        String menu0 = Tools.checkNull(list.get(0));
        if (menu0.equalsIgnoreCase(PublicConfig.menuHideFlag)) {
            appFrame.enpinverMenuItem.setEnabled(false);
        } else {
            appFrame.enpinverMenuItem.setEnabled(true);
        }
        appFrame.enpinverMenuItem.updateUI();
        String menu1 = Tools.checkNull(list.get(1));
        if (menu1.equalsIgnoreCase(PublicConfig.menuHideFlag)) {
            appFrame.dispinverMenuItem.setEnabled(false);
        } else {
            appFrame.dispinverMenuItem.setEnabled(true);
        }
        appFrame.dispinverMenuItem.updateUI();
        String menu2 = Tools.checkNull(list.get(3));
        if (menu2.equalsIgnoreCase(PublicConfig.menuHideFlag)) {
            appFrame.modifyPINMenuItem.setEnabled(false);
        } else {
            appFrame.modifyPINMenuItem.setEnabled(true);
        }
        appFrame.modifyPINMenuItem.updateUI();
        String menu3 = Tools.checkNull(list.get(2));
        if (menu3.equalsIgnoreCase(PublicConfig.menuHideFlag)) {
            appFrame.enterPINMenuItem.setEnabled(false);
        } else {
            appFrame.enterPINMenuItem.setEnabled(true);
        }
        appFrame.enterPINMenuItem.updateUI();
        String menu4 = Tools.checkNull(list.get(4));
        if (menu4.equalsIgnoreCase(PublicConfig.menuHideFlag)) {
            appFrame.unlockPINMenuItem.setEnabled(false);
        } else {
            appFrame.unlockPINMenuItem.setEnabled(true);
        }
        appFrame.unlockPINMenuItem.updateUI();
    }
}

