/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.network;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.service.NetCommService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;

public class CDMASelectNetWork {
    private static XMLTool netConfigXml = null;
    private static LanguageBean lb = null;
    static ImageIcon mn0 = null;
    static ImageIcon mn1;
    static ImageIcon mn2;
    static ImageIcon mn3;
    static ImageIcon mn4;
    static ImageIcon mn5;
    private static LogConfig log;

    static {
        log = Log.getLog(CDMASelectNetWork.class);
    }

    public CDMASelectNetWork() {
        if (AppFrame.frame != null && mn0 == null) {
            CustomizeBean cb = CustomizeInit.getCustomizeBean();
            lb = CustomizeInit.getLanguageBean();
            try {
                XMLTool.setImportExport(false);
                netConfigXml = new XMLTool("config/data/NetSettingConfig.xml");
            }
            catch (Exception e) {
                log.info("read NetSettingConfig.xml file fail : [" + e.toString() + "]");
            }
            String path = String.valueOf(XMLTool.getClassPath()) + "/config/images/";
            path = TextUtil.replaceStr1(path, "\\/", "/");
            path = TextUtil.replaceStr1(path, "\\", "/");
            log.info(path);
            mn0 = new ImageIcon(String.valueOf(path) + cb.getImages_statusBar_icon_singnal_0());
            mn1 = new ImageIcon(String.valueOf(path) + cb.getImages_statusBar_icon_singnal_1());
            mn2 = new ImageIcon(String.valueOf(path) + cb.getImages_statusBar_icon_singnal_2());
            mn3 = new ImageIcon(String.valueOf(path) + cb.getImages_statusBar_icon_singnal_3());
            mn4 = new ImageIcon(String.valueOf(path) + cb.getImages_statusBar_icon_singnal_4());
            mn5 = new ImageIcon(String.valueOf(path) + cb.getImages_statusBar_icon_singnal_5());
        }
    }

    public List getNetworkType() {
        List cdmaList = null;
        ArrayList<String> viewList = new ArrayList<String>();
        try {
            String xpath = "utpsdoc/group[@name=\"common\"]/module[@name=\"CDMA\"]/netselect/item";
            String[] strPropertiesName = new String[]{"act", "name", "langid"};
            cdmaList = netConfigXml.quertyNodePropertiesValueByPath(xpath, strPropertiesName);
            if (cdmaList == null) {
                log.info("Get CDMA List Value is null!");
                return viewList;
            }
            int i = 0;
            while (i < cdmaList.size()) {
                HashMap map = (HashMap)cdmaList.get(i);
                if (!map.get("act").toString().trim().equalsIgnoreCase("del")) {
                    if ("".equals(map.get("langid"))) {
                        viewList.add(map.get("name").toString());
                    } else {
                        if (map.get("langid").equals("tools_5_Network_CDMA_ONLY")) {
                            viewList.add("2," + lb.getTools_5_Network_CDMA_ONLY());
                        }
                        if (map.get("langid").equals("tools_5_Network_EVDO_ONLY")) {
                            viewList.add("4," + lb.getTools_5_Network_EVDO_ONLY());
                        }
                        if (map.get("langid").equals("tools_5_Network_HYBRID")) {
                            viewList.add("8," + lb.getTools_5_Network_HYBRID());
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.info("read NetSettingConfig.xml file fail : [" + e.toString() + "]");
        }
        return viewList;
    }

    public void initiativeChangeView(String info, String mode) {
        if (AppFrame.frame == null) {
            return;
        }
        AppFrame af = AppFrame.getAppFrameInit();
        int tempInfo = 0;
        try {
            tempInfo = Integer.parseInt(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (tempInfo) {
            case 0: {
                af.leftStatusLabel.setIcon(mn0);
                break;
            }
            case 20: {
                af.leftStatusLabel.setIcon(mn1);
                break;
            }
            case 40: {
                af.leftStatusLabel.setIcon(mn2);
                break;
            }
            case 60: {
                af.leftStatusLabel.setIcon(mn3);
                break;
            }
            case 80: {
                af.leftStatusLabel.setIcon(mn4);
                break;
            }
            case 99: {
                af.leftStatusLabel.setIcon(mn5);
                break;
            }
            default: {
                af.leftStatusLabel.setIcon(mn0);
            }
        }
        af.leftStatusLabel2.setText(mode);
    }

    public void CDMAReportChangeView(String reportInfo) {
        String strRssi = "";
        String strHRssi = "";
        switch (NetCommService.networkCDMA) {
            case 2: {
                strRssi = reportInfo.substring(reportInfo.indexOf("^RSSILVL:") + 9).trim();
                NetCommService.networkMode = "CDMA";
                this.initiativeChangeView(strRssi, NetCommService.networkMode);
                break;
            }
            case 4: {
                strHRssi = reportInfo.substring(reportInfo.indexOf("^HRSSILVL:") + 10).trim();
                NetCommService.networkMode = "EVDO";
                this.initiativeChangeView(strHRssi, NetCommService.networkMode);
                break;
            }
            case 8: {
                strRssi = reportInfo.substring(reportInfo.indexOf("^RSSILVL:") + 9, 2).trim();
                strHRssi = reportInfo.substring(reportInfo.indexOf("^HRSSILVL:") + 10, 2).trim();
                if (Integer.parseInt(strHRssi) == 0) {
                    NetCommService.networkMode = "CDMA";
                    this.initiativeChangeView(strRssi, NetCommService.networkMode);
                    break;
                }
                NetCommService.networkMode = "EVDO";
                this.initiativeChangeView(strRssi, NetCommService.networkMode);
            }
        }
    }
}

